package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnBucket</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnBucketProps cfnBucketProps = CfnBucketProps.builder()
 *         .bucketName("bucketName")
 *         .bundleId("bundleId")
 *         // the properties below are optional
 *         .accessRules(AccessRulesProperty.builder()
 *                 .allowPublicOverrides(false)
 *                 .objectAccess("objectAccess")
 *                 .build())
 *         .objectVersioning(false)
 *         .readOnlyAccessAccounts(List.of("readOnlyAccessAccounts"))
 *         .resourcesReceivingAccess(List.of("resourcesReceivingAccess"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:00.008Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnBucketProps")
@software.amazon.jsii.Jsii.Proxy(CfnBucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The bundle ID for the bucket (for example, <code>small_1_0</code> ).
     * <p>
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-bundleid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBundleId();

    /**
     * An object that describes the access rules for the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-accessrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-accessrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessRules() {
        return null;
    }

    /**
     * Indicates whether object versioning is enabled for the bucket.
     * <p>
     * The following options can be configured:
     * <p>
     * <ul>
     * <li><code>Enabled</code> - Object versioning is enabled.</li>
     * <li><code>Suspended</code> - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.</li>
     * <li><code>NeverEnabled</code> - Object versioning has never been enabled.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-objectversioning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-objectversioning</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getObjectVersioning() {
        return null;
    }

    /**
     * An array of AWS account IDs that have read-only access to the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-readonlyaccessaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-readonlyaccessaccounts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadOnlyAccessAccounts() {
        return null;
    }

    /**
     * An array of Lightsail instances that have access to the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-resourcesreceivingaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-resourcesreceivingaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesReceivingAccess() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-bucket.html#cfn-lightsail-bucket-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBucketProps> {
        java.lang.String bucketName;
        java.lang.String bundleId;
        java.lang.Object accessRules;
        java.lang.Object objectVersioning;
        java.util.List<java.lang.String> readOnlyAccessAccounts;
        java.util.List<java.lang.String> resourcesReceivingAccess;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnBucketProps#getBucketName}
         * @param bucketName The name of the bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getBundleId}
         * @param bundleId The bundle ID for the bucket (for example, <code>small_1_0</code> ). This parameter is required.
         *                 A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(java.lang.String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getAccessRules}
         * @param accessRules An object that describes the access rules for the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRules(software.amazon.awscdk.IResolvable accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getAccessRules}
         * @param accessRules An object that describes the access rules for the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRules(software.amazon.awscdk.services.lightsail.CfnBucket.AccessRulesProperty accessRules) {
            this.accessRules = accessRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getObjectVersioning}
         * @param objectVersioning Indicates whether object versioning is enabled for the bucket.
         *                         The following options can be configured:
         *                         <p>
         *                         <ul>
         *                         <li><code>Enabled</code> - Object versioning is enabled.</li>
         *                         <li><code>Suspended</code> - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.</li>
         *                         <li><code>NeverEnabled</code> - Object versioning has never been enabled.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersioning(java.lang.Boolean objectVersioning) {
            this.objectVersioning = objectVersioning;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getObjectVersioning}
         * @param objectVersioning Indicates whether object versioning is enabled for the bucket.
         *                         The following options can be configured:
         *                         <p>
         *                         <ul>
         *                         <li><code>Enabled</code> - Object versioning is enabled.</li>
         *                         <li><code>Suspended</code> - Object versioning was previously enabled but is currently suspended. Existing object versions are retained.</li>
         *                         <li><code>NeverEnabled</code> - Object versioning has never been enabled.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersioning(software.amazon.awscdk.IResolvable objectVersioning) {
            this.objectVersioning = objectVersioning;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getReadOnlyAccessAccounts}
         * @param readOnlyAccessAccounts An array of AWS account IDs that have read-only access to the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnlyAccessAccounts(java.util.List<java.lang.String> readOnlyAccessAccounts) {
            this.readOnlyAccessAccounts = readOnlyAccessAccounts;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getResourcesReceivingAccess}
         * @param resourcesReceivingAccess An array of Lightsail instances that have access to the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesReceivingAccess(java.util.List<java.lang.String> resourcesReceivingAccess) {
            this.resourcesReceivingAccess = resourcesReceivingAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnBucketProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBucketProps {
        private final java.lang.String bucketName;
        private final java.lang.String bundleId;
        private final java.lang.Object accessRules;
        private final java.lang.Object objectVersioning;
        private final java.util.List<java.lang.String> readOnlyAccessAccounts;
        private final java.util.List<java.lang.String> resourcesReceivingAccess;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bundleId = software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessRules = software.amazon.jsii.Kernel.get(this, "accessRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.objectVersioning = software.amazon.jsii.Kernel.get(this, "objectVersioning", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.readOnlyAccessAccounts = software.amazon.jsii.Kernel.get(this, "readOnlyAccessAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourcesReceivingAccess = software.amazon.jsii.Kernel.get(this, "resourcesReceivingAccess", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            this.bundleId = java.util.Objects.requireNonNull(builder.bundleId, "bundleId is required");
            this.accessRules = builder.accessRules;
            this.objectVersioning = builder.objectVersioning;
            this.readOnlyAccessAccounts = builder.readOnlyAccessAccounts;
            this.resourcesReceivingAccess = builder.resourcesReceivingAccess;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final java.lang.Object getAccessRules() {
            return this.accessRules;
        }

        @Override
        public final java.lang.Object getObjectVersioning() {
            return this.objectVersioning;
        }

        @Override
        public final java.util.List<java.lang.String> getReadOnlyAccessAccounts() {
            return this.readOnlyAccessAccounts;
        }

        @Override
        public final java.util.List<java.lang.String> getResourcesReceivingAccess() {
            return this.resourcesReceivingAccess;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("bundleId", om.valueToTree(this.getBundleId()));
            if (this.getAccessRules() != null) {
                data.set("accessRules", om.valueToTree(this.getAccessRules()));
            }
            if (this.getObjectVersioning() != null) {
                data.set("objectVersioning", om.valueToTree(this.getObjectVersioning()));
            }
            if (this.getReadOnlyAccessAccounts() != null) {
                data.set("readOnlyAccessAccounts", om.valueToTree(this.getReadOnlyAccessAccounts()));
            }
            if (this.getResourcesReceivingAccess() != null) {
                data.set("resourcesReceivingAccess", om.valueToTree(this.getResourcesReceivingAccess()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnBucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBucketProps.Jsii$Proxy that = (CfnBucketProps.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            if (!bundleId.equals(that.bundleId)) return false;
            if (this.accessRules != null ? !this.accessRules.equals(that.accessRules) : that.accessRules != null) return false;
            if (this.objectVersioning != null ? !this.objectVersioning.equals(that.objectVersioning) : that.objectVersioning != null) return false;
            if (this.readOnlyAccessAccounts != null ? !this.readOnlyAccessAccounts.equals(that.readOnlyAccessAccounts) : that.readOnlyAccessAccounts != null) return false;
            if (this.resourcesReceivingAccess != null ? !this.resourcesReceivingAccess.equals(that.resourcesReceivingAccess) : that.resourcesReceivingAccess != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.bundleId.hashCode());
            result = 31 * result + (this.accessRules != null ? this.accessRules.hashCode() : 0);
            result = 31 * result + (this.objectVersioning != null ? this.objectVersioning.hashCode() : 0);
            result = 31 * result + (this.readOnlyAccessAccounts != null ? this.readOnlyAccessAccounts.hashCode() : 0);
            result = 31 * result + (this.resourcesReceivingAccess != null ? this.resourcesReceivingAccess.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
