package software.amazon.awscdk.services.mediaconnect;

/**
 * The AWS::MediaConnect::Flow resource defines a connection between one or more video sources and one or more outputs.
 * <p>
 * For each flow, you specify the transport protocol to use, encryption information, and details for any outputs or entitlements that you want. AWS Elemental MediaConnect returns an ingest endpoint where you can send your live video as a single unicast stream. The service replicates and distributes the video to every output that you specify, whether inside or outside the AWS Cloud. You can also set up entitlements on a flow to allow other AWS accounts to access your content.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlow cfnFlow = CfnFlow.Builder.create(this, "MyCfnFlow")
 *         .name("name")
 *         .source(SourceProperty.builder()
 *                 .decryption(EncryptionProperty.builder()
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .algorithm("algorithm")
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .deviceId("deviceId")
 *                         .keyType("keyType")
 *                         .region("region")
 *                         .resourceId("resourceId")
 *                         .secretArn("secretArn")
 *                         .url("url")
 *                         .build())
 *                 .description("description")
 *                 .entitlementArn("entitlementArn")
 *                 .gatewayBridgeSource(GatewayBridgeSourceProperty.builder()
 *                         .bridgeArn("bridgeArn")
 *                         // the properties below are optional
 *                         .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                                 .vpcInterfaceName("vpcInterfaceName")
 *                                 .build())
 *                         .build())
 *                 .ingestIp("ingestIp")
 *                 .ingestPort(123)
 *                 .maxBitrate(123)
 *                 .maxLatency(123)
 *                 .maxSyncBuffer(123)
 *                 .mediaStreamSourceConfigurations(List.of(MediaStreamSourceConfigurationProperty.builder()
 *                         .encodingName("encodingName")
 *                         .mediaStreamName("mediaStreamName")
 *                         // the properties below are optional
 *                         .inputConfigurations(List.of(InputConfigurationProperty.builder()
 *                                 .inputPort(123)
 *                                 .interface(InterfaceProperty.builder()
 *                                         .name("name")
 *                                         .build())
 *                                 .build()))
 *                         .build()))
 *                 .minLatency(123)
 *                 .name("name")
 *                 .protocol("protocol")
 *                 .senderControlPort(123)
 *                 .senderIpAddress("senderIpAddress")
 *                 .sourceArn("sourceArn")
 *                 .sourceIngestPort("sourceIngestPort")
 *                 .sourceListenerAddress("sourceListenerAddress")
 *                 .sourceListenerPort(123)
 *                 .streamId("streamId")
 *                 .vpcInterfaceName("vpcInterfaceName")
 *                 .whitelistCidr("whitelistCidr")
 *                 .build())
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .maintenance(MaintenanceProperty.builder()
 *                 .maintenanceDay("maintenanceDay")
 *                 .maintenanceStartHour("maintenanceStartHour")
 *                 .build())
 *         .mediaStreams(List.of(MediaStreamProperty.builder()
 *                 .mediaStreamId(123)
 *                 .mediaStreamName("mediaStreamName")
 *                 .mediaStreamType("mediaStreamType")
 *                 // the properties below are optional
 *                 .attributes(MediaStreamAttributesProperty.builder()
 *                         .fmtp(FmtpProperty.builder()
 *                                 .channelOrder("channelOrder")
 *                                 .colorimetry("colorimetry")
 *                                 .exactFramerate("exactFramerate")
 *                                 .par("par")
 *                                 .range("range")
 *                                 .scanMode("scanMode")
 *                                 .tcs("tcs")
 *                                 .build())
 *                         .lang("lang")
 *                         .build())
 *                 .clockRate(123)
 *                 .description("description")
 *                 .fmt(123)
 *                 .videoFormat("videoFormat")
 *                 .build()))
 *         .sourceFailoverConfig(FailoverConfigProperty.builder()
 *                 .failoverMode("failoverMode")
 *                 .recoveryWindow(123)
 *                 .sourcePriority(SourcePriorityProperty.builder()
 *                         .primarySource("primarySource")
 *                         .build())
 *                 .state("state")
 *                 .build())
 *         .sourceMonitoringConfig(SourceMonitoringConfigProperty.builder()
 *                 .thumbnailState("thumbnailState")
 *                 .build())
 *         .vpcInterfaces(List.of(VpcInterfaceProperty.builder()
 *                 .name("name")
 *                 .roleArn("roleArn")
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .networkInterfaceIds(List.of("networkInterfaceIds"))
 *                 .networkInterfaceType("networkInterfaceType")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:00.232Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow")
public class CfnFlow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFlow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnFlow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The outgoing IP address that MediaConnect uses to send video from the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEgressIp() {
        return software.amazon.jsii.Kernel.get(this, "attrEgressIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone that the flow was created in.
     * <p>
     * These options are limited to the Availability Zones within the current AWS Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address that the flow listens on for incoming content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceIngestIp() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceIngestIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceSourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port that the flow listens on for incoming content.
     * <p>
     * If the protocol of the source is Zixi, the port must be set to 2088.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceSourceIngestPort() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceSourceIngestPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The settings for the source that you want to use for the new flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for the source that you want to use for the new flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * The settings for the source that you want to use for the new flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * The Availability Zone that you want to create the flow in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone that you want to create the flow in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The maintenance settings you want to use for the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenance() {
        return software.amazon.jsii.Kernel.get(this, "maintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The maintenance settings you want to use for the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenance(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenance", value);
    }

    /**
     * The maintenance settings you want to use for the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenance(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlow.MaintenanceProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenance", value);
    }

    /**
     * The media streams associated with the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMediaStreams() {
        return software.amazon.jsii.Kernel.get(this, "mediaStreams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The media streams associated with the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaStreams(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mediaStreams", value);
    }

    /**
     * The media streams associated with the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaStreams(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediaconnect.CfnFlow.MediaStreamProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnFlow.MediaStreamProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "mediaStreams", value);
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceFailoverConfig() {
        return software.amazon.jsii.Kernel.get(this, "sourceFailoverConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFailoverConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceFailoverConfig", value);
    }

    /**
     * The settings for source failover.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFailoverConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceFailoverConfig", value);
    }

    /**
     * The settings for source monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceMonitoringConfig() {
        return software.amazon.jsii.Kernel.get(this, "sourceMonitoringConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for source monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceMonitoringConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceMonitoringConfig", value);
    }

    /**
     * The settings for source monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceMonitoringConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceMonitoringConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceMonitoringConfig", value);
    }

    /**
     * The VPC interfaces that you added to this flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcInterfaces() {
        return software.amazon.jsii.Kernel.get(this, "vpcInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The VPC interfaces that you added to this flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcInterfaces(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcInterfaces", value);
    }

    /**
     * The VPC interfaces that you added to this flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcInterfaces(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.mediaconnect.CfnFlow.VpcInterfaceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnFlow.VpcInterfaceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "vpcInterfaces", value);
    }
    /**
     * Information about the encryption of the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .algorithm("algorithm")
     *         .constantInitializationVector("constantInitializationVector")
     *         .deviceId("deviceId")
     *         .keyType("keyType")
     *         .region("region")
     *         .resourceId("resourceId")
     *         .secretArn("secretArn")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
         * <p>
         * If you are using SPEKE or SRT-password encryption, this property must be left blank.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
         * <p>
         * This parameter is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-constantinitializationvector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-constantinitializationvector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-deviceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-deviceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceId() {
            return null;
        }

        /**
         * The type of key that is used for the encryption.
         * <p>
         * If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
         * <p>
         * Default: - "static-key"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyType() {
            return null;
        }

        /**
         * The AWS Region that the API Gateway proxy endpoint was created in.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * An identifier for the content.
         * <p>
         * The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
            return null;
        }

        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-encryption.html#cfn-mediaconnect-flow-encryption-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.String roleArn;
            java.lang.String algorithm;
            java.lang.String constantInitializationVector;
            java.lang.String deviceId;
            java.lang.String keyType;
            java.lang.String region;
            java.lang.String resourceId;
            java.lang.String secretArn;
            java.lang.String url;

            /**
             * Sets the value of {@link EncryptionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getAlgorithm}
             * @param algorithm The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
             *                  If you are using SPEKE or SRT-password encryption, this property must be left blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
             *                                     This parameter is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getDeviceId}
             * @param deviceId The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
             *                 This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceId(java.lang.String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getKeyType}
             * @param keyType The type of key that is used for the encryption.
             *                If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getRegion}
             * @param region The AWS Region that the API Gateway proxy endpoint was created in.
             *               This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getResourceId}
             * @param resourceId An identifier for the content.
             *                   The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSecretArn}
             * @param secretArn The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getUrl}
             * @param url The URL from the API Gateway proxy that you set up to talk to your key server.
             *            This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String algorithm;
            private final java.lang.String constantInitializationVector;
            private final java.lang.String deviceId;
            private final java.lang.String keyType;
            private final java.lang.String region;
            private final java.lang.String resourceId;
            private final java.lang.String secretArn;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceId = software.amazon.jsii.Kernel.get(this, "deviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.algorithm = builder.algorithm;
                this.constantInitializationVector = builder.constantInitializationVector;
                this.deviceId = builder.deviceId;
                this.keyType = builder.keyType;
                this.region = builder.region;
                this.resourceId = builder.resourceId;
                this.secretArn = builder.secretArn;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.String getDeviceId() {
                return this.deviceId;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getDeviceId() != null) {
                    data.set("deviceId", om.valueToTree(this.getDeviceId()));
                }
                if (this.getKeyType() != null) {
                    data.set("keyType", om.valueToTree(this.getKeyType()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                if (this.deviceId != null ? !this.deviceId.equals(that.deviceId) : that.deviceId != null) return false;
                if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.deviceId != null ? this.deviceId.hashCode() : 0);
                result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for source failover.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * FailoverConfigProperty failoverConfigProperty = FailoverConfigProperty.builder()
     *         .failoverMode("failoverMode")
     *         .recoveryWindow(123)
     *         .sourcePriority(SourcePriorityProperty.builder()
     *                 .primarySource("primarySource")
     *                 .build())
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.FailoverConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of failover you choose for this flow.
         * <p>
         * MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams. The string for this property must be entered as MERGE or FAILOVER. No other string entry is valid.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-failovermode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-failovermode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailoverMode() {
            return null;
        }

        /**
         * The size of the buffer (delay) that the service maintains.
         * <p>
         * A larger buffer means a longer delay in transmitting the stream, but more room for error correction. A smaller buffer means a shorter delay, but less room for error correction. You can choose a value from 100-500 ms. If you keep this field blank, the service uses the default value of 200 ms. This setting only applies when Failover Mode is set to MERGE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-recoverywindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-recoverywindow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryWindow() {
            return null;
        }

        /**
         * The priority you want to assign to a source.
         * <p>
         * You can have a primary stream and a backup stream or two equally prioritized streams. This setting only applies when Failover Mode is set to FAILOVER.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-sourcepriority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-sourcepriority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourcePriority() {
            return null;
        }

        /**
         * The state of source failover on the flow.
         * <p>
         * If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html#cfn-mediaconnect-flow-failoverconfig-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverConfigProperty> {
            java.lang.String failoverMode;
            java.lang.Number recoveryWindow;
            java.lang.Object sourcePriority;
            java.lang.String state;

            /**
             * Sets the value of {@link FailoverConfigProperty#getFailoverMode}
             * @param failoverMode The type of failover you choose for this flow.
             *                     MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams. The string for this property must be entered as MERGE or FAILOVER. No other string entry is valid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverMode(java.lang.String failoverMode) {
                this.failoverMode = failoverMode;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getRecoveryWindow}
             * @param recoveryWindow The size of the buffer (delay) that the service maintains.
             *                       A larger buffer means a longer delay in transmitting the stream, but more room for error correction. A smaller buffer means a shorter delay, but less room for error correction. You can choose a value from 100-500 ms. If you keep this field blank, the service uses the default value of 200 ms. This setting only applies when Failover Mode is set to MERGE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryWindow(java.lang.Number recoveryWindow) {
                this.recoveryWindow = recoveryWindow;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getSourcePriority}
             * @param sourcePriority The priority you want to assign to a source.
             *                       You can have a primary stream and a backup stream or two equally prioritized streams. This setting only applies when Failover Mode is set to FAILOVER.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePriority(software.amazon.awscdk.IResolvable sourcePriority) {
                this.sourcePriority = sourcePriority;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getSourcePriority}
             * @param sourcePriority The priority you want to assign to a source.
             *                       You can have a primary stream and a backup stream or two equally prioritized streams. This setting only applies when Failover Mode is set to FAILOVER.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePriority(software.amazon.awscdk.services.mediaconnect.CfnFlow.SourcePriorityProperty sourcePriority) {
                this.sourcePriority = sourcePriority;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConfigProperty#getState}
             * @param state The state of source failover on the flow.
             *              If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverConfigProperty {
            private final java.lang.String failoverMode;
            private final java.lang.Number recoveryWindow;
            private final java.lang.Object sourcePriority;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failoverMode = software.amazon.jsii.Kernel.get(this, "failoverMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recoveryWindow = software.amazon.jsii.Kernel.get(this, "recoveryWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sourcePriority = software.amazon.jsii.Kernel.get(this, "sourcePriority", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failoverMode = builder.failoverMode;
                this.recoveryWindow = builder.recoveryWindow;
                this.sourcePriority = builder.sourcePriority;
                this.state = builder.state;
            }

            @Override
            public final java.lang.String getFailoverMode() {
                return this.failoverMode;
            }

            @Override
            public final java.lang.Number getRecoveryWindow() {
                return this.recoveryWindow;
            }

            @Override
            public final java.lang.Object getSourcePriority() {
                return this.sourcePriority;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailoverMode() != null) {
                    data.set("failoverMode", om.valueToTree(this.getFailoverMode()));
                }
                if (this.getRecoveryWindow() != null) {
                    data.set("recoveryWindow", om.valueToTree(this.getRecoveryWindow()));
                }
                if (this.getSourcePriority() != null) {
                    data.set("sourcePriority", om.valueToTree(this.getSourcePriority()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.FailoverConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverConfigProperty.Jsii$Proxy that = (FailoverConfigProperty.Jsii$Proxy) o;

                if (this.failoverMode != null ? !this.failoverMode.equals(that.failoverMode) : that.failoverMode != null) return false;
                if (this.recoveryWindow != null ? !this.recoveryWindow.equals(that.recoveryWindow) : that.recoveryWindow != null) return false;
                if (this.sourcePriority != null ? !this.sourcePriority.equals(that.sourcePriority) : that.sourcePriority != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failoverMode != null ? this.failoverMode.hashCode() : 0;
                result = 31 * result + (this.recoveryWindow != null ? this.recoveryWindow.hashCode() : 0);
                result = 31 * result + (this.sourcePriority != null ? this.sourcePriority.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A set of parameters that define the media stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * FmtpProperty fmtpProperty = FmtpProperty.builder()
     *         .channelOrder("channelOrder")
     *         .colorimetry("colorimetry")
     *         .exactFramerate("exactFramerate")
     *         .par("par")
     *         .range("range")
     *         .scanMode("scanMode")
     *         .tcs("tcs")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.FmtpProperty")
    @software.amazon.jsii.Jsii.Proxy(FmtpProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FmtpProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format of the audio channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-channelorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-channelorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChannelOrder() {
            return null;
        }

        /**
         * The format used for the representation of color.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-colorimetry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-colorimetry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColorimetry() {
            return null;
        }

        /**
         * The frame rate for the video stream, in frames/second.
         * <p>
         * For example: 60000/1001.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-exactframerate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-exactframerate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExactFramerate() {
            return null;
        }

        /**
         * The pixel aspect ratio (PAR) of the video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-par">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-par</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPar() {
            return null;
        }

        /**
         * The encoding range of the video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRange() {
            return null;
        }

        /**
         * The type of compression that was used to smooth the video’s appearance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-scanmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-scanmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScanMode() {
            return null;
        }

        /**
         * The transfer characteristic system (TCS) that is used in the video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-tcs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-fmtp.html#cfn-mediaconnect-flow-fmtp-tcs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTcs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FmtpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FmtpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FmtpProperty> {
            java.lang.String channelOrder;
            java.lang.String colorimetry;
            java.lang.String exactFramerate;
            java.lang.String par;
            java.lang.String range;
            java.lang.String scanMode;
            java.lang.String tcs;

            /**
             * Sets the value of {@link FmtpProperty#getChannelOrder}
             * @param channelOrder The format of the audio channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelOrder(java.lang.String channelOrder) {
                this.channelOrder = channelOrder;
                return this;
            }

            /**
             * Sets the value of {@link FmtpProperty#getColorimetry}
             * @param colorimetry The format used for the representation of color.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorimetry(java.lang.String colorimetry) {
                this.colorimetry = colorimetry;
                return this;
            }

            /**
             * Sets the value of {@link FmtpProperty#getExactFramerate}
             * @param exactFramerate The frame rate for the video stream, in frames/second.
             *                       For example: 60000/1001.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exactFramerate(java.lang.String exactFramerate) {
                this.exactFramerate = exactFramerate;
                return this;
            }

            /**
             * Sets the value of {@link FmtpProperty#getPar}
             * @param par The pixel aspect ratio (PAR) of the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder par(java.lang.String par) {
                this.par = par;
                return this;
            }

            /**
             * Sets the value of {@link FmtpProperty#getRange}
             * @param range The encoding range of the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(java.lang.String range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link FmtpProperty#getScanMode}
             * @param scanMode The type of compression that was used to smooth the video’s appearance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scanMode(java.lang.String scanMode) {
                this.scanMode = scanMode;
                return this;
            }

            /**
             * Sets the value of {@link FmtpProperty#getTcs}
             * @param tcs The transfer characteristic system (TCS) that is used in the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcs(java.lang.String tcs) {
                this.tcs = tcs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FmtpProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FmtpProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FmtpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FmtpProperty {
            private final java.lang.String channelOrder;
            private final java.lang.String colorimetry;
            private final java.lang.String exactFramerate;
            private final java.lang.String par;
            private final java.lang.String range;
            private final java.lang.String scanMode;
            private final java.lang.String tcs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelOrder = software.amazon.jsii.Kernel.get(this, "channelOrder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.colorimetry = software.amazon.jsii.Kernel.get(this, "colorimetry", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exactFramerate = software.amazon.jsii.Kernel.get(this, "exactFramerate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.par = software.amazon.jsii.Kernel.get(this, "par", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scanMode = software.amazon.jsii.Kernel.get(this, "scanMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tcs = software.amazon.jsii.Kernel.get(this, "tcs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelOrder = builder.channelOrder;
                this.colorimetry = builder.colorimetry;
                this.exactFramerate = builder.exactFramerate;
                this.par = builder.par;
                this.range = builder.range;
                this.scanMode = builder.scanMode;
                this.tcs = builder.tcs;
            }

            @Override
            public final java.lang.String getChannelOrder() {
                return this.channelOrder;
            }

            @Override
            public final java.lang.String getColorimetry() {
                return this.colorimetry;
            }

            @Override
            public final java.lang.String getExactFramerate() {
                return this.exactFramerate;
            }

            @Override
            public final java.lang.String getPar() {
                return this.par;
            }

            @Override
            public final java.lang.String getRange() {
                return this.range;
            }

            @Override
            public final java.lang.String getScanMode() {
                return this.scanMode;
            }

            @Override
            public final java.lang.String getTcs() {
                return this.tcs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChannelOrder() != null) {
                    data.set("channelOrder", om.valueToTree(this.getChannelOrder()));
                }
                if (this.getColorimetry() != null) {
                    data.set("colorimetry", om.valueToTree(this.getColorimetry()));
                }
                if (this.getExactFramerate() != null) {
                    data.set("exactFramerate", om.valueToTree(this.getExactFramerate()));
                }
                if (this.getPar() != null) {
                    data.set("par", om.valueToTree(this.getPar()));
                }
                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }
                if (this.getScanMode() != null) {
                    data.set("scanMode", om.valueToTree(this.getScanMode()));
                }
                if (this.getTcs() != null) {
                    data.set("tcs", om.valueToTree(this.getTcs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.FmtpProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FmtpProperty.Jsii$Proxy that = (FmtpProperty.Jsii$Proxy) o;

                if (this.channelOrder != null ? !this.channelOrder.equals(that.channelOrder) : that.channelOrder != null) return false;
                if (this.colorimetry != null ? !this.colorimetry.equals(that.colorimetry) : that.colorimetry != null) return false;
                if (this.exactFramerate != null ? !this.exactFramerate.equals(that.exactFramerate) : that.exactFramerate != null) return false;
                if (this.par != null ? !this.par.equals(that.par) : that.par != null) return false;
                if (this.range != null ? !this.range.equals(that.range) : that.range != null) return false;
                if (this.scanMode != null ? !this.scanMode.equals(that.scanMode) : that.scanMode != null) return false;
                return this.tcs != null ? this.tcs.equals(that.tcs) : that.tcs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelOrder != null ? this.channelOrder.hashCode() : 0;
                result = 31 * result + (this.colorimetry != null ? this.colorimetry.hashCode() : 0);
                result = 31 * result + (this.exactFramerate != null ? this.exactFramerate.hashCode() : 0);
                result = 31 * result + (this.par != null ? this.par.hashCode() : 0);
                result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
                result = 31 * result + (this.scanMode != null ? this.scanMode.hashCode() : 0);
                result = 31 * result + (this.tcs != null ? this.tcs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * GatewayBridgeSourceProperty gatewayBridgeSourceProperty = GatewayBridgeSourceProperty.builder()
     *         .bridgeArn("bridgeArn")
     *         // the properties below are optional
     *         .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
     *                 .vpcInterfaceName("vpcInterfaceName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.GatewayBridgeSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayBridgeSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayBridgeSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the bridge feeding this flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html#cfn-mediaconnect-flow-gatewaybridgesource-bridgearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html#cfn-mediaconnect-flow-gatewaybridgesource-bridgearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBridgeArn();

        /**
         * The name of the VPC interface attachment to use for this bridge source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html#cfn-mediaconnect-flow-gatewaybridgesource-vpcinterfaceattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html#cfn-mediaconnect-flow-gatewaybridgesource-vpcinterfaceattachment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcInterfaceAttachment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayBridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayBridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayBridgeSourceProperty> {
            java.lang.String bridgeArn;
            java.lang.Object vpcInterfaceAttachment;

            /**
             * Sets the value of {@link GatewayBridgeSourceProperty#getBridgeArn}
             * @param bridgeArn The ARN of the bridge feeding this flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bridgeArn(java.lang.String bridgeArn) {
                this.bridgeArn = bridgeArn;
                return this;
            }

            /**
             * Sets the value of {@link GatewayBridgeSourceProperty#getVpcInterfaceAttachment}
             * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this bridge source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceAttachment(software.amazon.awscdk.IResolvable vpcInterfaceAttachment) {
                this.vpcInterfaceAttachment = vpcInterfaceAttachment;
                return this;
            }

            /**
             * Sets the value of {@link GatewayBridgeSourceProperty#getVpcInterfaceAttachment}
             * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this bridge source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceAttachment(software.amazon.awscdk.services.mediaconnect.CfnFlow.VpcInterfaceAttachmentProperty vpcInterfaceAttachment) {
                this.vpcInterfaceAttachment = vpcInterfaceAttachment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayBridgeSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayBridgeSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayBridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayBridgeSourceProperty {
            private final java.lang.String bridgeArn;
            private final java.lang.Object vpcInterfaceAttachment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bridgeArn = software.amazon.jsii.Kernel.get(this, "bridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcInterfaceAttachment = software.amazon.jsii.Kernel.get(this, "vpcInterfaceAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bridgeArn = java.util.Objects.requireNonNull(builder.bridgeArn, "bridgeArn is required");
                this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
            }

            @Override
            public final java.lang.String getBridgeArn() {
                return this.bridgeArn;
            }

            @Override
            public final java.lang.Object getVpcInterfaceAttachment() {
                return this.vpcInterfaceAttachment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bridgeArn", om.valueToTree(this.getBridgeArn()));
                if (this.getVpcInterfaceAttachment() != null) {
                    data.set("vpcInterfaceAttachment", om.valueToTree(this.getVpcInterfaceAttachment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.GatewayBridgeSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayBridgeSourceProperty.Jsii$Proxy that = (GatewayBridgeSourceProperty.Jsii$Proxy) o;

                if (!bridgeArn.equals(that.bridgeArn)) return false;
                return this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.equals(that.vpcInterfaceAttachment) : that.vpcInterfaceAttachment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bridgeArn.hashCode();
                result = 31 * result + (this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The transport parameters associated with an incoming media stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * InputConfigurationProperty inputConfigurationProperty = InputConfigurationProperty.builder()
     *         .inputPort(123)
     *         .interface(InterfaceProperty.builder()
     *                 .name("name")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-inputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-inputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.InputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port that the flow listens on for an incoming media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-inputconfiguration.html#cfn-mediaconnect-flow-inputconfiguration-inputport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-inputconfiguration.html#cfn-mediaconnect-flow-inputconfiguration-inputport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInputPort();

        /**
         * The VPC interface where the media stream comes in from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-inputconfiguration.html#cfn-mediaconnect-flow-inputconfiguration-interface">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-inputconfiguration.html#cfn-mediaconnect-flow-inputconfiguration-interface</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInterfaceValue();

        /**
         * @return a {@link Builder} of {@link InputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputConfigurationProperty> {
            java.lang.Number inputPort;
            java.lang.Object interfaceValue;

            /**
             * Sets the value of {@link InputConfigurationProperty#getInputPort}
             * @param inputPort The port that the flow listens on for an incoming media stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPort(java.lang.Number inputPort) {
                this.inputPort = inputPort;
                return this;
            }

            /**
             * Sets the value of {@link InputConfigurationProperty#getInterfaceValue}
             * @param interfaceValue The VPC interface where the media stream comes in from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceValue(software.amazon.awscdk.IResolvable interfaceValue) {
                this.interfaceValue = interfaceValue;
                return this;
            }

            /**
             * Sets the value of {@link InputConfigurationProperty#getInterfaceValue}
             * @param interfaceValue The VPC interface where the media stream comes in from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceValue(software.amazon.awscdk.services.mediaconnect.CfnFlow.InterfaceProperty interfaceValue) {
                this.interfaceValue = interfaceValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputConfigurationProperty {
            private final java.lang.Number inputPort;
            private final java.lang.Object interfaceValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputPort = software.amazon.jsii.Kernel.get(this, "inputPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interfaceValue = software.amazon.jsii.Kernel.get(this, "interface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputPort = java.util.Objects.requireNonNull(builder.inputPort, "inputPort is required");
                this.interfaceValue = java.util.Objects.requireNonNull(builder.interfaceValue, "interfaceValue is required");
            }

            @Override
            public final java.lang.Number getInputPort() {
                return this.inputPort;
            }

            @Override
            public final java.lang.Object getInterfaceValue() {
                return this.interfaceValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputPort", om.valueToTree(this.getInputPort()));
                data.set("interface", om.valueToTree(this.getInterfaceValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.InputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputConfigurationProperty.Jsii$Proxy that = (InputConfigurationProperty.Jsii$Proxy) o;

                if (!inputPort.equals(that.inputPort)) return false;
                return this.interfaceValue.equals(that.interfaceValue);
            }

            @Override
            public final int hashCode() {
                int result = this.inputPort.hashCode();
                result = 31 * result + (this.interfaceValue.hashCode());
                return result;
            }
        }
    }
    /**
     * The VPC interface that you want to use for the media stream associated with the output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * InterfaceProperty interfaceProperty = InterfaceProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-interface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-interface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.InterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(InterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the VPC interface that you want to use for the media stream associated with the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-interface.html#cfn-mediaconnect-flow-interface-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-interface.html#cfn-mediaconnect-flow-interface-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link InterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InterfaceProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link InterfaceProperty#getName}
             * @param name The name of the VPC interface that you want to use for the media stream associated with the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.InterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InterfaceProperty.Jsii$Proxy that = (InterfaceProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * The maintenance setting of a flow.
     * <p>
     * MediaConnect routinely performs maintenance on underlying systems for security, reliability, and operational performance. The maintenance activities include actions such as patching the operating system, updating drivers, or installing software and patches.
     * <p>
     * You can select the day and time that maintenance events occur. This is called a maintenance window and is used every time a maintenance event is required. To change the day and time, you can edit the maintenance window using <code>MaintenanceDay</code> and <code>MaintenanceStartHour</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MaintenanceProperty maintenanceProperty = MaintenanceProperty.builder()
     *         .maintenanceDay("maintenanceDay")
     *         .maintenanceStartHour("maintenanceStartHour")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-maintenance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-maintenance.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.MaintenanceProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A day of a week when the maintenance will happen.
         * <p>
         * Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-maintenance.html#cfn-mediaconnect-flow-maintenance-maintenanceday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-maintenance.html#cfn-mediaconnect-flow-maintenance-maintenanceday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMaintenanceDay();

        /**
         * UTC time when the maintenance will happen.
         * <p>
         * Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-maintenance.html#cfn-mediaconnect-flow-maintenance-maintenancestarthour">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-maintenance.html#cfn-mediaconnect-flow-maintenance-maintenancestarthour</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMaintenanceStartHour();

        /**
         * @return a {@link Builder} of {@link MaintenanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceProperty> {
            java.lang.String maintenanceDay;
            java.lang.String maintenanceStartHour;

            /**
             * Sets the value of {@link MaintenanceProperty#getMaintenanceDay}
             * @param maintenanceDay A day of a week when the maintenance will happen. This parameter is required.
             *                       Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceDay(java.lang.String maintenanceDay) {
                this.maintenanceDay = maintenanceDay;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceProperty#getMaintenanceStartHour}
             * @param maintenanceStartHour UTC time when the maintenance will happen. This parameter is required.
             *                             Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStartHour(java.lang.String maintenanceStartHour) {
                this.maintenanceStartHour = maintenanceStartHour;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceProperty {
            private final java.lang.String maintenanceDay;
            private final java.lang.String maintenanceStartHour;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maintenanceDay = software.amazon.jsii.Kernel.get(this, "maintenanceDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maintenanceStartHour = software.amazon.jsii.Kernel.get(this, "maintenanceStartHour", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maintenanceDay = java.util.Objects.requireNonNull(builder.maintenanceDay, "maintenanceDay is required");
                this.maintenanceStartHour = java.util.Objects.requireNonNull(builder.maintenanceStartHour, "maintenanceStartHour is required");
            }

            @Override
            public final java.lang.String getMaintenanceDay() {
                return this.maintenanceDay;
            }

            @Override
            public final java.lang.String getMaintenanceStartHour() {
                return this.maintenanceStartHour;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maintenanceDay", om.valueToTree(this.getMaintenanceDay()));
                data.set("maintenanceStartHour", om.valueToTree(this.getMaintenanceStartHour()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.MaintenanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceProperty.Jsii$Proxy that = (MaintenanceProperty.Jsii$Proxy) o;

                if (!maintenanceDay.equals(that.maintenanceDay)) return false;
                return this.maintenanceStartHour.equals(that.maintenanceStartHour);
            }

            @Override
            public final int hashCode() {
                int result = this.maintenanceDay.hashCode();
                result = 31 * result + (this.maintenanceStartHour.hashCode());
                return result;
            }
        }
    }
    /**
     * Attributes that are related to the media stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MediaStreamAttributesProperty mediaStreamAttributesProperty = MediaStreamAttributesProperty.builder()
     *         .fmtp(FmtpProperty.builder()
     *                 .channelOrder("channelOrder")
     *                 .colorimetry("colorimetry")
     *                 .exactFramerate("exactFramerate")
     *                 .par("par")
     *                 .range("range")
     *                 .scanMode("scanMode")
     *                 .tcs("tcs")
     *                 .build())
     *         .lang("lang")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.MediaStreamAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaStreamAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaStreamAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A set of parameters that define the media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamattributes.html#cfn-mediaconnect-flow-mediastreamattributes-fmtp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamattributes.html#cfn-mediaconnect-flow-mediastreamattributes-fmtp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFmtp() {
            return null;
        }

        /**
         * The audio language, in a format that is recognized by the receiver.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamattributes.html#cfn-mediaconnect-flow-mediastreamattributes-lang">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamattributes.html#cfn-mediaconnect-flow-mediastreamattributes-lang</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLang() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaStreamAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaStreamAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaStreamAttributesProperty> {
            java.lang.Object fmtp;
            java.lang.String lang;

            /**
             * Sets the value of {@link MediaStreamAttributesProperty#getFmtp}
             * @param fmtp A set of parameters that define the media stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fmtp(software.amazon.awscdk.IResolvable fmtp) {
                this.fmtp = fmtp;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamAttributesProperty#getFmtp}
             * @param fmtp A set of parameters that define the media stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fmtp(software.amazon.awscdk.services.mediaconnect.CfnFlow.FmtpProperty fmtp) {
                this.fmtp = fmtp;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamAttributesProperty#getLang}
             * @param lang The audio language, in a format that is recognized by the receiver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lang(java.lang.String lang) {
                this.lang = lang;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaStreamAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaStreamAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaStreamAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaStreamAttributesProperty {
            private final java.lang.Object fmtp;
            private final java.lang.String lang;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fmtp = software.amazon.jsii.Kernel.get(this, "fmtp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lang = software.amazon.jsii.Kernel.get(this, "lang", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fmtp = builder.fmtp;
                this.lang = builder.lang;
            }

            @Override
            public final java.lang.Object getFmtp() {
                return this.fmtp;
            }

            @Override
            public final java.lang.String getLang() {
                return this.lang;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFmtp() != null) {
                    data.set("fmtp", om.valueToTree(this.getFmtp()));
                }
                if (this.getLang() != null) {
                    data.set("lang", om.valueToTree(this.getLang()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.MediaStreamAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaStreamAttributesProperty.Jsii$Proxy that = (MediaStreamAttributesProperty.Jsii$Proxy) o;

                if (this.fmtp != null ? !this.fmtp.equals(that.fmtp) : that.fmtp != null) return false;
                return this.lang != null ? this.lang.equals(that.lang) : that.lang == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fmtp != null ? this.fmtp.hashCode() : 0;
                result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single track or stream of media that contains video, audio, or ancillary data.
     * <p>
     * After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MediaStreamProperty mediaStreamProperty = MediaStreamProperty.builder()
     *         .mediaStreamId(123)
     *         .mediaStreamName("mediaStreamName")
     *         .mediaStreamType("mediaStreamType")
     *         // the properties below are optional
     *         .attributes(MediaStreamAttributesProperty.builder()
     *                 .fmtp(FmtpProperty.builder()
     *                         .channelOrder("channelOrder")
     *                         .colorimetry("colorimetry")
     *                         .exactFramerate("exactFramerate")
     *                         .par("par")
     *                         .range("range")
     *                         .scanMode("scanMode")
     *                         .tcs("tcs")
     *                         .build())
     *                 .lang("lang")
     *                 .build())
     *         .clockRate(123)
     *         .description("description")
     *         .fmt(123)
     *         .videoFormat("videoFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.MediaStreamProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaStreamProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaStreamProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique identifier for the media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-mediastreamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-mediastreamid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMediaStreamId();

        /**
         * A name that helps you distinguish one media stream from another.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-mediastreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-mediastreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMediaStreamName();

        /**
         * The type of media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-mediastreamtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-mediastreamtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMediaStreamType();

        /**
         * Attributes that are related to the media stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-attributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The sample rate for the stream.
         * <p>
         * This value in measured in kHz.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-clockrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-clockrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getClockRate() {
            return null;
        }

        /**
         * A description that can help you quickly identify what your media stream is used for.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The format type number (sometimes referred to as RTP payload type) of the media stream.
         * <p>
         * MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-fmt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-fmt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFmt() {
            return null;
        }

        /**
         * The resolution of the video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-videoformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastream.html#cfn-mediaconnect-flow-mediastream-videoformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVideoFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaStreamProperty> {
            java.lang.Number mediaStreamId;
            java.lang.String mediaStreamName;
            java.lang.String mediaStreamType;
            java.lang.Object attributes;
            java.lang.Number clockRate;
            java.lang.String description;
            java.lang.Number fmt;
            java.lang.String videoFormat;

            /**
             * Sets the value of {@link MediaStreamProperty#getMediaStreamId}
             * @param mediaStreamId A unique identifier for the media stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamId(java.lang.Number mediaStreamId) {
                this.mediaStreamId = mediaStreamId;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getMediaStreamName}
             * @param mediaStreamName A name that helps you distinguish one media stream from another. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamName(java.lang.String mediaStreamName) {
                this.mediaStreamName = mediaStreamName;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getMediaStreamType}
             * @param mediaStreamType The type of media stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamType(java.lang.String mediaStreamType) {
                this.mediaStreamType = mediaStreamType;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getAttributes}
             * @param attributes Attributes that are related to the media stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getAttributes}
             * @param attributes Attributes that are related to the media stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.services.mediaconnect.CfnFlow.MediaStreamAttributesProperty attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getClockRate}
             * @param clockRate The sample rate for the stream.
             *                  This value in measured in kHz.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clockRate(java.lang.Number clockRate) {
                this.clockRate = clockRate;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getDescription}
             * @param description A description that can help you quickly identify what your media stream is used for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getFmt}
             * @param fmt The format type number (sometimes referred to as RTP payload type) of the media stream.
             *            MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fmt(java.lang.Number fmt) {
                this.fmt = fmt;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamProperty#getVideoFormat}
             * @param videoFormat The resolution of the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoFormat(java.lang.String videoFormat) {
                this.videoFormat = videoFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaStreamProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaStreamProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaStreamProperty {
            private final java.lang.Number mediaStreamId;
            private final java.lang.String mediaStreamName;
            private final java.lang.String mediaStreamType;
            private final java.lang.Object attributes;
            private final java.lang.Number clockRate;
            private final java.lang.String description;
            private final java.lang.Number fmt;
            private final java.lang.String videoFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mediaStreamId = software.amazon.jsii.Kernel.get(this, "mediaStreamId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mediaStreamName = software.amazon.jsii.Kernel.get(this, "mediaStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mediaStreamType = software.amazon.jsii.Kernel.get(this, "mediaStreamType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clockRate = software.amazon.jsii.Kernel.get(this, "clockRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fmt = software.amazon.jsii.Kernel.get(this, "fmt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.videoFormat = software.amazon.jsii.Kernel.get(this, "videoFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mediaStreamId = java.util.Objects.requireNonNull(builder.mediaStreamId, "mediaStreamId is required");
                this.mediaStreamName = java.util.Objects.requireNonNull(builder.mediaStreamName, "mediaStreamName is required");
                this.mediaStreamType = java.util.Objects.requireNonNull(builder.mediaStreamType, "mediaStreamType is required");
                this.attributes = builder.attributes;
                this.clockRate = builder.clockRate;
                this.description = builder.description;
                this.fmt = builder.fmt;
                this.videoFormat = builder.videoFormat;
            }

            @Override
            public final java.lang.Number getMediaStreamId() {
                return this.mediaStreamId;
            }

            @Override
            public final java.lang.String getMediaStreamName() {
                return this.mediaStreamName;
            }

            @Override
            public final java.lang.String getMediaStreamType() {
                return this.mediaStreamType;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.Number getClockRate() {
                return this.clockRate;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getFmt() {
                return this.fmt;
            }

            @Override
            public final java.lang.String getVideoFormat() {
                return this.videoFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mediaStreamId", om.valueToTree(this.getMediaStreamId()));
                data.set("mediaStreamName", om.valueToTree(this.getMediaStreamName()));
                data.set("mediaStreamType", om.valueToTree(this.getMediaStreamType()));
                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getClockRate() != null) {
                    data.set("clockRate", om.valueToTree(this.getClockRate()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFmt() != null) {
                    data.set("fmt", om.valueToTree(this.getFmt()));
                }
                if (this.getVideoFormat() != null) {
                    data.set("videoFormat", om.valueToTree(this.getVideoFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.MediaStreamProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaStreamProperty.Jsii$Proxy that = (MediaStreamProperty.Jsii$Proxy) o;

                if (!mediaStreamId.equals(that.mediaStreamId)) return false;
                if (!mediaStreamName.equals(that.mediaStreamName)) return false;
                if (!mediaStreamType.equals(that.mediaStreamType)) return false;
                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                if (this.clockRate != null ? !this.clockRate.equals(that.clockRate) : that.clockRate != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.fmt != null ? !this.fmt.equals(that.fmt) : that.fmt != null) return false;
                return this.videoFormat != null ? this.videoFormat.equals(that.videoFormat) : that.videoFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mediaStreamId.hashCode();
                result = 31 * result + (this.mediaStreamName.hashCode());
                result = 31 * result + (this.mediaStreamType.hashCode());
                result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
                result = 31 * result + (this.clockRate != null ? this.clockRate.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.fmt != null ? this.fmt.hashCode() : 0);
                result = 31 * result + (this.videoFormat != null ? this.videoFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The media stream that is associated with the source, and the parameters for that association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MediaStreamSourceConfigurationProperty mediaStreamSourceConfigurationProperty = MediaStreamSourceConfigurationProperty.builder()
     *         .encodingName("encodingName")
     *         .mediaStreamName("mediaStreamName")
     *         // the properties below are optional
     *         .inputConfigurations(List.of(InputConfigurationProperty.builder()
     *                 .inputPort(123)
     *                 .interface(InterfaceProperty.builder()
     *                         .name("name")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.MediaStreamSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaStreamSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaStreamSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format that was used to encode the data.
         * <p>
         * For ancillary data streams, set the encoding name to <code>smpte291</code> .
         * <p>
         * For audio streams, set the encoding name to <code>pcm</code> .
         * <p>
         * For video, 2110 streams, set the encoding name to <code>raw</code> .
         * <p>
         * For video, JPEG XS streams, set the encoding name to <code>jxsv</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html#cfn-mediaconnect-flow-mediastreamsourceconfiguration-encodingname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html#cfn-mediaconnect-flow-mediastreamsourceconfiguration-encodingname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncodingName();

        /**
         * A name that helps you distinguish one media stream from another.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html#cfn-mediaconnect-flow-mediastreamsourceconfiguration-mediastreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html#cfn-mediaconnect-flow-mediastreamsourceconfiguration-mediastreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMediaStreamName();

        /**
         * The media streams that you want to associate with the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html#cfn-mediaconnect-flow-mediastreamsourceconfiguration-inputconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-mediastreamsourceconfiguration.html#cfn-mediaconnect-flow-mediastreamsourceconfiguration-inputconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaStreamSourceConfigurationProperty> {
            java.lang.String encodingName;
            java.lang.String mediaStreamName;
            java.lang.Object inputConfigurations;

            /**
             * Sets the value of {@link MediaStreamSourceConfigurationProperty#getEncodingName}
             * @param encodingName The format that was used to encode the data. This parameter is required.
             *                     For ancillary data streams, set the encoding name to <code>smpte291</code> .
             *                     <p>
             *                     For audio streams, set the encoding name to <code>pcm</code> .
             *                     <p>
             *                     For video, 2110 streams, set the encoding name to <code>raw</code> .
             *                     <p>
             *                     For video, JPEG XS streams, set the encoding name to <code>jxsv</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingName(java.lang.String encodingName) {
                this.encodingName = encodingName;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamSourceConfigurationProperty#getMediaStreamName}
             * @param mediaStreamName A name that helps you distinguish one media stream from another. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamName(java.lang.String mediaStreamName) {
                this.mediaStreamName = mediaStreamName;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamSourceConfigurationProperty#getInputConfigurations}
             * @param inputConfigurations The media streams that you want to associate with the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputConfigurations(software.amazon.awscdk.IResolvable inputConfigurations) {
                this.inputConfigurations = inputConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link MediaStreamSourceConfigurationProperty#getInputConfigurations}
             * @param inputConfigurations The media streams that you want to associate with the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputConfigurations(java.util.List<? extends java.lang.Object> inputConfigurations) {
                this.inputConfigurations = inputConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaStreamSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaStreamSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaStreamSourceConfigurationProperty {
            private final java.lang.String encodingName;
            private final java.lang.String mediaStreamName;
            private final java.lang.Object inputConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encodingName = software.amazon.jsii.Kernel.get(this, "encodingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mediaStreamName = software.amazon.jsii.Kernel.get(this, "mediaStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputConfigurations = software.amazon.jsii.Kernel.get(this, "inputConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encodingName = java.util.Objects.requireNonNull(builder.encodingName, "encodingName is required");
                this.mediaStreamName = java.util.Objects.requireNonNull(builder.mediaStreamName, "mediaStreamName is required");
                this.inputConfigurations = builder.inputConfigurations;
            }

            @Override
            public final java.lang.String getEncodingName() {
                return this.encodingName;
            }

            @Override
            public final java.lang.String getMediaStreamName() {
                return this.mediaStreamName;
            }

            @Override
            public final java.lang.Object getInputConfigurations() {
                return this.inputConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encodingName", om.valueToTree(this.getEncodingName()));
                data.set("mediaStreamName", om.valueToTree(this.getMediaStreamName()));
                if (this.getInputConfigurations() != null) {
                    data.set("inputConfigurations", om.valueToTree(this.getInputConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.MediaStreamSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaStreamSourceConfigurationProperty.Jsii$Proxy that = (MediaStreamSourceConfigurationProperty.Jsii$Proxy) o;

                if (!encodingName.equals(that.encodingName)) return false;
                if (!mediaStreamName.equals(that.mediaStreamName)) return false;
                return this.inputConfigurations != null ? this.inputConfigurations.equals(that.inputConfigurations) : that.inputConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encodingName.hashCode();
                result = 31 * result + (this.mediaStreamName.hashCode());
                result = 31 * result + (this.inputConfigurations != null ? this.inputConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for source monitoring.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SourceMonitoringConfigProperty sourceMonitoringConfigProperty = SourceMonitoringConfigProperty.builder()
     *         .thumbnailState("thumbnailState")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcemonitoringconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcemonitoringconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.SourceMonitoringConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceMonitoringConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceMonitoringConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The state of thumbnail monitoring.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcemonitoringconfig.html#cfn-mediaconnect-flow-sourcemonitoringconfig-thumbnailstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcemonitoringconfig.html#cfn-mediaconnect-flow-sourcemonitoringconfig-thumbnailstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThumbnailState();

        /**
         * @return a {@link Builder} of {@link SourceMonitoringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceMonitoringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceMonitoringConfigProperty> {
            java.lang.String thumbnailState;

            /**
             * Sets the value of {@link SourceMonitoringConfigProperty#getThumbnailState}
             * @param thumbnailState The state of thumbnail monitoring. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thumbnailState(java.lang.String thumbnailState) {
                this.thumbnailState = thumbnailState;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceMonitoringConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceMonitoringConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceMonitoringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceMonitoringConfigProperty {
            private final java.lang.String thumbnailState;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.thumbnailState = software.amazon.jsii.Kernel.get(this, "thumbnailState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.thumbnailState = java.util.Objects.requireNonNull(builder.thumbnailState, "thumbnailState is required");
            }

            @Override
            public final java.lang.String getThumbnailState() {
                return this.thumbnailState;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("thumbnailState", om.valueToTree(this.getThumbnailState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.SourceMonitoringConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceMonitoringConfigProperty.Jsii$Proxy that = (SourceMonitoringConfigProperty.Jsii$Proxy) o;

                return this.thumbnailState.equals(that.thumbnailState);
            }

            @Override
            public final int hashCode() {
                int result = this.thumbnailState.hashCode();
                return result;
            }
        }
    }
    /**
     * The priority you want to assign to a source.
     * <p>
     * You can have a primary stream and a backup stream or two equally prioritized streams. This setting only applies when Failover Mode is set to FAILOVER.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SourcePriorityProperty sourcePriorityProperty = SourcePriorityProperty.builder()
     *         .primarySource("primarySource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcepriority.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcepriority.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.SourcePriorityProperty")
    @software.amazon.jsii.Jsii.Proxy(SourcePriorityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourcePriorityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the source you choose as the primary source for this flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcepriority.html#cfn-mediaconnect-flow-sourcepriority-primarysource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-sourcepriority.html#cfn-mediaconnect-flow-sourcepriority-primarysource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrimarySource();

        /**
         * @return a {@link Builder} of {@link SourcePriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourcePriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourcePriorityProperty> {
            java.lang.String primarySource;

            /**
             * Sets the value of {@link SourcePriorityProperty#getPrimarySource}
             * @param primarySource The name of the source you choose as the primary source for this flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primarySource(java.lang.String primarySource) {
                this.primarySource = primarySource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourcePriorityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourcePriorityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourcePriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourcePriorityProperty {
            private final java.lang.String primarySource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primarySource = software.amazon.jsii.Kernel.get(this, "primarySource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primarySource = java.util.Objects.requireNonNull(builder.primarySource, "primarySource is required");
            }

            @Override
            public final java.lang.String getPrimarySource() {
                return this.primarySource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("primarySource", om.valueToTree(this.getPrimarySource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.SourcePriorityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourcePriorityProperty.Jsii$Proxy that = (SourcePriorityProperty.Jsii$Proxy) o;

                return this.primarySource.equals(that.primarySource);
            }

            @Override
            public final int hashCode() {
                int result = this.primarySource.hashCode();
                return result;
            }
        }
    }
    /**
     * The details of the sources of the flow.
     * <p>
     * If you are creating a flow with a VPC source, you must first create the flow with a temporary standard source by doing the following:
     * <p>
     * <ul>
     * <li>Use CloudFormation to create a flow with a standard source that uses the flow’s public IP address.</li>
     * <li>Use CloudFormation to create the VPC interface to add to this flow. This can also be done as part of the previous step.</li>
     * <li>After CloudFormation has created the flow and the VPC interface, update the source to point to the VPC interface that you created.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .decryption(EncryptionProperty.builder()
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .algorithm("algorithm")
     *                 .constantInitializationVector("constantInitializationVector")
     *                 .deviceId("deviceId")
     *                 .keyType("keyType")
     *                 .region("region")
     *                 .resourceId("resourceId")
     *                 .secretArn("secretArn")
     *                 .url("url")
     *                 .build())
     *         .description("description")
     *         .entitlementArn("entitlementArn")
     *         .gatewayBridgeSource(GatewayBridgeSourceProperty.builder()
     *                 .bridgeArn("bridgeArn")
     *                 // the properties below are optional
     *                 .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
     *                         .vpcInterfaceName("vpcInterfaceName")
     *                         .build())
     *                 .build())
     *         .ingestIp("ingestIp")
     *         .ingestPort(123)
     *         .maxBitrate(123)
     *         .maxLatency(123)
     *         .maxSyncBuffer(123)
     *         .mediaStreamSourceConfigurations(List.of(MediaStreamSourceConfigurationProperty.builder()
     *                 .encodingName("encodingName")
     *                 .mediaStreamName("mediaStreamName")
     *                 // the properties below are optional
     *                 .inputConfigurations(List.of(InputConfigurationProperty.builder()
     *                         .inputPort(123)
     *                         .interface(InterfaceProperty.builder()
     *                                 .name("name")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .minLatency(123)
     *         .name("name")
     *         .protocol("protocol")
     *         .senderControlPort(123)
     *         .senderIpAddress("senderIpAddress")
     *         .sourceArn("sourceArn")
     *         .sourceIngestPort("sourceIngestPort")
     *         .sourceListenerAddress("sourceListenerAddress")
     *         .sourceListenerPort(123)
     *         .streamId("streamId")
     *         .vpcInterfaceName("vpcInterfaceName")
     *         .whitelistCidr("whitelistCidr")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of encryption that is used on the content ingested from the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-decryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-decryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecryption() {
            return null;
        }

        /**
         * A description of the source.
         * <p>
         * This description is not visible outside of the current AWS account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account.
         * <p>
         * The entitlement is set by the content originator and the ARN is generated as part of the originator’s flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-entitlementarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-entitlementarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntitlementArn() {
            return null;
        }

        /**
         * The source configuration for cloud flows receiving a stream from a bridge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-gatewaybridgesource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-gatewaybridgesource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGatewayBridgeSource() {
            return null;
        }

        /**
         * The IP address that the flow listens on for incoming content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIngestIp() {
            return null;
        }

        /**
         * The port that the flow listens on for incoming content.
         * <p>
         * If the protocol of the source is Zixi, the port must be set to 2088.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-ingestport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIngestPort() {
            return null;
        }

        /**
         * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBitrate() {
            return null;
        }

        /**
         * The maximum latency in milliseconds for a RIST or Zixi-based source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxlatency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLatency() {
            return null;
        }

        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxsyncbuffer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-maxsyncbuffer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSyncBuffer() {
            return null;
        }

        /**
         * The media stream that is associated with the source, and the parameters for that association.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-mediastreamsourceconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-mediastreamsourceconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMediaStreamSourceConfigurations() {
            return null;
        }

        /**
         * The minimum latency in milliseconds for SRT-based streams.
         * <p>
         * In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-minlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-minlatency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinLatency() {
            return null;
        }

        /**
         * The name of the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The protocol that is used by the source.
         * <p>
         * AWS CloudFormation does not currently support CDI or ST 2110 JPEG XS source protocols.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sendercontrolport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sendercontrolport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSenderControlPort() {
            return null;
        }

        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-senderipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-senderipaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSenderIpAddress() {
            return null;
        }

        /**
         * The ARN of the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
            return null;
        }

        /**
         * The port that the flow listens on for incoming content.
         * <p>
         * If the protocol of the source is Zixi, the port must be set to 2088.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourceingestport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourceingestport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceIngestPort() {
            return null;
        }

        /**
         * Source IP or domain name for SRT-caller protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcelisteneraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcelisteneraddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceListenerAddress() {
            return null;
        }

        /**
         * Source port for SRT-caller protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcelistenerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-sourcelistenerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSourceListenerPort() {
            return null;
        }

        /**
         * The stream ID that you want to use for the transport.
         * <p>
         * This parameter applies only to Zixi-based streams.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-streamid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
            return null;
        }

        /**
         * The name of the VPC interface that the source content comes from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-vpcinterfacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
            return null;
        }

        /**
         * The range of IP addresses that are allowed to contribute content to your source.
         * <p>
         * Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-whitelistcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html#cfn-mediaconnect-flow-source-whitelistcidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWhitelistCidr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.Object decryption;
            java.lang.String description;
            java.lang.String entitlementArn;
            java.lang.Object gatewayBridgeSource;
            java.lang.String ingestIp;
            java.lang.Number ingestPort;
            java.lang.Number maxBitrate;
            java.lang.Number maxLatency;
            java.lang.Number maxSyncBuffer;
            java.lang.Object mediaStreamSourceConfigurations;
            java.lang.Number minLatency;
            java.lang.String name;
            java.lang.String protocol;
            java.lang.Number senderControlPort;
            java.lang.String senderIpAddress;
            java.lang.String sourceArn;
            java.lang.String sourceIngestPort;
            java.lang.String sourceListenerAddress;
            java.lang.Number sourceListenerPort;
            java.lang.String streamId;
            java.lang.String vpcInterfaceName;
            java.lang.String whitelistCidr;

            /**
             * Sets the value of {@link SourceProperty#getDecryption}
             * @param decryption The type of encryption that is used on the content ingested from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryption(software.amazon.awscdk.IResolvable decryption) {
                this.decryption = decryption;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getDecryption}
             * @param decryption The type of encryption that is used on the content ingested from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryption(software.amazon.awscdk.services.mediaconnect.CfnFlow.EncryptionProperty decryption) {
                this.decryption = decryption;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getDescription}
             * @param description A description of the source.
             *                    This description is not visible outside of the current AWS account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getEntitlementArn}
             * @param entitlementArn The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account.
             *                       The entitlement is set by the content originator and the ARN is generated as part of the originator’s flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entitlementArn(java.lang.String entitlementArn) {
                this.entitlementArn = entitlementArn;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGatewayBridgeSource}
             * @param gatewayBridgeSource The source configuration for cloud flows receiving a stream from a bridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gatewayBridgeSource(software.amazon.awscdk.IResolvable gatewayBridgeSource) {
                this.gatewayBridgeSource = gatewayBridgeSource;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getGatewayBridgeSource}
             * @param gatewayBridgeSource The source configuration for cloud flows receiving a stream from a bridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gatewayBridgeSource(software.amazon.awscdk.services.mediaconnect.CfnFlow.GatewayBridgeSourceProperty gatewayBridgeSource) {
                this.gatewayBridgeSource = gatewayBridgeSource;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getIngestIp}
             * @param ingestIp The IP address that the flow listens on for incoming content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestIp(java.lang.String ingestIp) {
                this.ingestIp = ingestIp;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getIngestPort}
             * @param ingestPort The port that the flow listens on for incoming content.
             *                   If the protocol of the source is Zixi, the port must be set to 2088.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestPort(java.lang.Number ingestPort) {
                this.ingestPort = ingestPort;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMaxBitrate}
             * @param maxBitrate The maximum bitrate for RIST, RTP, and RTP-FEC streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxBitrate(java.lang.Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMaxLatency}
             * @param maxLatency The maximum latency in milliseconds for a RIST or Zixi-based source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLatency(java.lang.Number maxLatency) {
                this.maxLatency = maxLatency;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMaxSyncBuffer}
             * @param maxSyncBuffer The size of the buffer (in milliseconds) to use to sync incoming source data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSyncBuffer(java.lang.Number maxSyncBuffer) {
                this.maxSyncBuffer = maxSyncBuffer;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMediaStreamSourceConfigurations}
             * @param mediaStreamSourceConfigurations The media stream that is associated with the source, and the parameters for that association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamSourceConfigurations(software.amazon.awscdk.IResolvable mediaStreamSourceConfigurations) {
                this.mediaStreamSourceConfigurations = mediaStreamSourceConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMediaStreamSourceConfigurations}
             * @param mediaStreamSourceConfigurations The media stream that is associated with the source, and the parameters for that association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaStreamSourceConfigurations(java.util.List<? extends java.lang.Object> mediaStreamSourceConfigurations) {
                this.mediaStreamSourceConfigurations = mediaStreamSourceConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getMinLatency}
             * @param minLatency The minimum latency in milliseconds for SRT-based streams.
             *                   In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minLatency(java.lang.Number minLatency) {
                this.minLatency = minLatency;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getName}
             * @param name The name of the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getProtocol}
             * @param protocol The protocol that is used by the source.
             *                 AWS CloudFormation does not currently support CDI or ST 2110 JPEG XS source protocols.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSenderControlPort}
             * @param senderControlPort The port that the flow uses to send outbound requests to initiate connection with the sender.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder senderControlPort(java.lang.Number senderControlPort) {
                this.senderControlPort = senderControlPort;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSenderIpAddress}
             * @param senderIpAddress The IP address that the flow communicates with to initiate connection with the sender.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder senderIpAddress(java.lang.String senderIpAddress) {
                this.senderIpAddress = senderIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceArn}
             * @param sourceArn The ARN of the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceArn(java.lang.String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceIngestPort}
             * @param sourceIngestPort The port that the flow listens on for incoming content.
             *                         If the protocol of the source is Zixi, the port must be set to 2088.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIngestPort(java.lang.String sourceIngestPort) {
                this.sourceIngestPort = sourceIngestPort;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceListenerAddress}
             * @param sourceListenerAddress Source IP or domain name for SRT-caller protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceListenerAddress(java.lang.String sourceListenerAddress) {
                this.sourceListenerAddress = sourceListenerAddress;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSourceListenerPort}
             * @param sourceListenerPort Source port for SRT-caller protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceListenerPort(java.lang.Number sourceListenerPort) {
                this.sourceListenerPort = sourceListenerPort;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getStreamId}
             * @param streamId The stream ID that you want to use for the transport.
             *                 This parameter applies only to Zixi-based streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamId(java.lang.String streamId) {
                this.streamId = streamId;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getVpcInterfaceName}
             * @param vpcInterfaceName The name of the VPC interface that the source content comes from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getWhitelistCidr}
             * @param whitelistCidr The range of IP addresses that are allowed to contribute content to your source.
             *                      Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder whitelistCidr(java.lang.String whitelistCidr) {
                this.whitelistCidr = whitelistCidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.Object decryption;
            private final java.lang.String description;
            private final java.lang.String entitlementArn;
            private final java.lang.Object gatewayBridgeSource;
            private final java.lang.String ingestIp;
            private final java.lang.Number ingestPort;
            private final java.lang.Number maxBitrate;
            private final java.lang.Number maxLatency;
            private final java.lang.Number maxSyncBuffer;
            private final java.lang.Object mediaStreamSourceConfigurations;
            private final java.lang.Number minLatency;
            private final java.lang.String name;
            private final java.lang.String protocol;
            private final java.lang.Number senderControlPort;
            private final java.lang.String senderIpAddress;
            private final java.lang.String sourceArn;
            private final java.lang.String sourceIngestPort;
            private final java.lang.String sourceListenerAddress;
            private final java.lang.Number sourceListenerPort;
            private final java.lang.String streamId;
            private final java.lang.String vpcInterfaceName;
            private final java.lang.String whitelistCidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.decryption = software.amazon.jsii.Kernel.get(this, "decryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entitlementArn = software.amazon.jsii.Kernel.get(this, "entitlementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.gatewayBridgeSource = software.amazon.jsii.Kernel.get(this, "gatewayBridgeSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ingestIp = software.amazon.jsii.Kernel.get(this, "ingestIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ingestPort = software.amazon.jsii.Kernel.get(this, "ingestPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxBitrate = software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxLatency = software.amazon.jsii.Kernel.get(this, "maxLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxSyncBuffer = software.amazon.jsii.Kernel.get(this, "maxSyncBuffer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mediaStreamSourceConfigurations = software.amazon.jsii.Kernel.get(this, "mediaStreamSourceConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minLatency = software.amazon.jsii.Kernel.get(this, "minLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.senderControlPort = software.amazon.jsii.Kernel.get(this, "senderControlPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.senderIpAddress = software.amazon.jsii.Kernel.get(this, "senderIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceIngestPort = software.amazon.jsii.Kernel.get(this, "sourceIngestPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceListenerAddress = software.amazon.jsii.Kernel.get(this, "sourceListenerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceListenerPort = software.amazon.jsii.Kernel.get(this, "sourceListenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.streamId = software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.whitelistCidr = software.amazon.jsii.Kernel.get(this, "whitelistCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.decryption = builder.decryption;
                this.description = builder.description;
                this.entitlementArn = builder.entitlementArn;
                this.gatewayBridgeSource = builder.gatewayBridgeSource;
                this.ingestIp = builder.ingestIp;
                this.ingestPort = builder.ingestPort;
                this.maxBitrate = builder.maxBitrate;
                this.maxLatency = builder.maxLatency;
                this.maxSyncBuffer = builder.maxSyncBuffer;
                this.mediaStreamSourceConfigurations = builder.mediaStreamSourceConfigurations;
                this.minLatency = builder.minLatency;
                this.name = builder.name;
                this.protocol = builder.protocol;
                this.senderControlPort = builder.senderControlPort;
                this.senderIpAddress = builder.senderIpAddress;
                this.sourceArn = builder.sourceArn;
                this.sourceIngestPort = builder.sourceIngestPort;
                this.sourceListenerAddress = builder.sourceListenerAddress;
                this.sourceListenerPort = builder.sourceListenerPort;
                this.streamId = builder.streamId;
                this.vpcInterfaceName = builder.vpcInterfaceName;
                this.whitelistCidr = builder.whitelistCidr;
            }

            @Override
            public final java.lang.Object getDecryption() {
                return this.decryption;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getEntitlementArn() {
                return this.entitlementArn;
            }

            @Override
            public final java.lang.Object getGatewayBridgeSource() {
                return this.gatewayBridgeSource;
            }

            @Override
            public final java.lang.String getIngestIp() {
                return this.ingestIp;
            }

            @Override
            public final java.lang.Number getIngestPort() {
                return this.ingestPort;
            }

            @Override
            public final java.lang.Number getMaxBitrate() {
                return this.maxBitrate;
            }

            @Override
            public final java.lang.Number getMaxLatency() {
                return this.maxLatency;
            }

            @Override
            public final java.lang.Number getMaxSyncBuffer() {
                return this.maxSyncBuffer;
            }

            @Override
            public final java.lang.Object getMediaStreamSourceConfigurations() {
                return this.mediaStreamSourceConfigurations;
            }

            @Override
            public final java.lang.Number getMinLatency() {
                return this.minLatency;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getSenderControlPort() {
                return this.senderControlPort;
            }

            @Override
            public final java.lang.String getSenderIpAddress() {
                return this.senderIpAddress;
            }

            @Override
            public final java.lang.String getSourceArn() {
                return this.sourceArn;
            }

            @Override
            public final java.lang.String getSourceIngestPort() {
                return this.sourceIngestPort;
            }

            @Override
            public final java.lang.String getSourceListenerAddress() {
                return this.sourceListenerAddress;
            }

            @Override
            public final java.lang.Number getSourceListenerPort() {
                return this.sourceListenerPort;
            }

            @Override
            public final java.lang.String getStreamId() {
                return this.streamId;
            }

            @Override
            public final java.lang.String getVpcInterfaceName() {
                return this.vpcInterfaceName;
            }

            @Override
            public final java.lang.String getWhitelistCidr() {
                return this.whitelistCidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDecryption() != null) {
                    data.set("decryption", om.valueToTree(this.getDecryption()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getEntitlementArn() != null) {
                    data.set("entitlementArn", om.valueToTree(this.getEntitlementArn()));
                }
                if (this.getGatewayBridgeSource() != null) {
                    data.set("gatewayBridgeSource", om.valueToTree(this.getGatewayBridgeSource()));
                }
                if (this.getIngestIp() != null) {
                    data.set("ingestIp", om.valueToTree(this.getIngestIp()));
                }
                if (this.getIngestPort() != null) {
                    data.set("ingestPort", om.valueToTree(this.getIngestPort()));
                }
                if (this.getMaxBitrate() != null) {
                    data.set("maxBitrate", om.valueToTree(this.getMaxBitrate()));
                }
                if (this.getMaxLatency() != null) {
                    data.set("maxLatency", om.valueToTree(this.getMaxLatency()));
                }
                if (this.getMaxSyncBuffer() != null) {
                    data.set("maxSyncBuffer", om.valueToTree(this.getMaxSyncBuffer()));
                }
                if (this.getMediaStreamSourceConfigurations() != null) {
                    data.set("mediaStreamSourceConfigurations", om.valueToTree(this.getMediaStreamSourceConfigurations()));
                }
                if (this.getMinLatency() != null) {
                    data.set("minLatency", om.valueToTree(this.getMinLatency()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getSenderControlPort() != null) {
                    data.set("senderControlPort", om.valueToTree(this.getSenderControlPort()));
                }
                if (this.getSenderIpAddress() != null) {
                    data.set("senderIpAddress", om.valueToTree(this.getSenderIpAddress()));
                }
                if (this.getSourceArn() != null) {
                    data.set("sourceArn", om.valueToTree(this.getSourceArn()));
                }
                if (this.getSourceIngestPort() != null) {
                    data.set("sourceIngestPort", om.valueToTree(this.getSourceIngestPort()));
                }
                if (this.getSourceListenerAddress() != null) {
                    data.set("sourceListenerAddress", om.valueToTree(this.getSourceListenerAddress()));
                }
                if (this.getSourceListenerPort() != null) {
                    data.set("sourceListenerPort", om.valueToTree(this.getSourceListenerPort()));
                }
                if (this.getStreamId() != null) {
                    data.set("streamId", om.valueToTree(this.getStreamId()));
                }
                if (this.getVpcInterfaceName() != null) {
                    data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
                }
                if (this.getWhitelistCidr() != null) {
                    data.set("whitelistCidr", om.valueToTree(this.getWhitelistCidr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (this.decryption != null ? !this.decryption.equals(that.decryption) : that.decryption != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.entitlementArn != null ? !this.entitlementArn.equals(that.entitlementArn) : that.entitlementArn != null) return false;
                if (this.gatewayBridgeSource != null ? !this.gatewayBridgeSource.equals(that.gatewayBridgeSource) : that.gatewayBridgeSource != null) return false;
                if (this.ingestIp != null ? !this.ingestIp.equals(that.ingestIp) : that.ingestIp != null) return false;
                if (this.ingestPort != null ? !this.ingestPort.equals(that.ingestPort) : that.ingestPort != null) return false;
                if (this.maxBitrate != null ? !this.maxBitrate.equals(that.maxBitrate) : that.maxBitrate != null) return false;
                if (this.maxLatency != null ? !this.maxLatency.equals(that.maxLatency) : that.maxLatency != null) return false;
                if (this.maxSyncBuffer != null ? !this.maxSyncBuffer.equals(that.maxSyncBuffer) : that.maxSyncBuffer != null) return false;
                if (this.mediaStreamSourceConfigurations != null ? !this.mediaStreamSourceConfigurations.equals(that.mediaStreamSourceConfigurations) : that.mediaStreamSourceConfigurations != null) return false;
                if (this.minLatency != null ? !this.minLatency.equals(that.minLatency) : that.minLatency != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.senderControlPort != null ? !this.senderControlPort.equals(that.senderControlPort) : that.senderControlPort != null) return false;
                if (this.senderIpAddress != null ? !this.senderIpAddress.equals(that.senderIpAddress) : that.senderIpAddress != null) return false;
                if (this.sourceArn != null ? !this.sourceArn.equals(that.sourceArn) : that.sourceArn != null) return false;
                if (this.sourceIngestPort != null ? !this.sourceIngestPort.equals(that.sourceIngestPort) : that.sourceIngestPort != null) return false;
                if (this.sourceListenerAddress != null ? !this.sourceListenerAddress.equals(that.sourceListenerAddress) : that.sourceListenerAddress != null) return false;
                if (this.sourceListenerPort != null ? !this.sourceListenerPort.equals(that.sourceListenerPort) : that.sourceListenerPort != null) return false;
                if (this.streamId != null ? !this.streamId.equals(that.streamId) : that.streamId != null) return false;
                if (this.vpcInterfaceName != null ? !this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName != null) return false;
                return this.whitelistCidr != null ? this.whitelistCidr.equals(that.whitelistCidr) : that.whitelistCidr == null;
            }

            @Override
            public final int hashCode() {
                int result = this.decryption != null ? this.decryption.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.entitlementArn != null ? this.entitlementArn.hashCode() : 0);
                result = 31 * result + (this.gatewayBridgeSource != null ? this.gatewayBridgeSource.hashCode() : 0);
                result = 31 * result + (this.ingestIp != null ? this.ingestIp.hashCode() : 0);
                result = 31 * result + (this.ingestPort != null ? this.ingestPort.hashCode() : 0);
                result = 31 * result + (this.maxBitrate != null ? this.maxBitrate.hashCode() : 0);
                result = 31 * result + (this.maxLatency != null ? this.maxLatency.hashCode() : 0);
                result = 31 * result + (this.maxSyncBuffer != null ? this.maxSyncBuffer.hashCode() : 0);
                result = 31 * result + (this.mediaStreamSourceConfigurations != null ? this.mediaStreamSourceConfigurations.hashCode() : 0);
                result = 31 * result + (this.minLatency != null ? this.minLatency.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.senderControlPort != null ? this.senderControlPort.hashCode() : 0);
                result = 31 * result + (this.senderIpAddress != null ? this.senderIpAddress.hashCode() : 0);
                result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
                result = 31 * result + (this.sourceIngestPort != null ? this.sourceIngestPort.hashCode() : 0);
                result = 31 * result + (this.sourceListenerAddress != null ? this.sourceListenerAddress.hashCode() : 0);
                result = 31 * result + (this.sourceListenerPort != null ? this.sourceListenerPort.hashCode() : 0);
                result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
                result = 31 * result + (this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0);
                result = 31 * result + (this.whitelistCidr != null ? this.whitelistCidr.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The VPC interface that you want to send your output to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * VpcInterfaceAttachmentProperty vpcInterfaceAttachmentProperty = VpcInterfaceAttachmentProperty.builder()
     *         .vpcInterfaceName("vpcInterfaceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterfaceattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterfaceattachment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.VpcInterfaceAttachmentProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcInterfaceAttachmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcInterfaceAttachmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the VPC interface that you want to send your output to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterfaceattachment.html#cfn-mediaconnect-flow-vpcinterfaceattachment-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterfaceattachment.html#cfn-mediaconnect-flow-vpcinterfaceattachment-vpcinterfacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcInterfaceAttachmentProperty> {
            java.lang.String vpcInterfaceName;

            /**
             * Sets the value of {@link VpcInterfaceAttachmentProperty#getVpcInterfaceName}
             * @param vpcInterfaceName The name of the VPC interface that you want to send your output to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcInterfaceAttachmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcInterfaceAttachmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcInterfaceAttachmentProperty {
            private final java.lang.String vpcInterfaceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcInterfaceName = builder.vpcInterfaceName;
            }

            @Override
            public final java.lang.String getVpcInterfaceName() {
                return this.vpcInterfaceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcInterfaceName() != null) {
                    data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.VpcInterfaceAttachmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcInterfaceAttachmentProperty.Jsii$Proxy that = (VpcInterfaceAttachmentProperty.Jsii$Proxy) o;

                return this.vpcInterfaceName != null ? this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of a VPC interface.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * VpcInterfaceProperty vpcInterfaceProperty = VpcInterfaceProperty.builder()
     *         .name("name")
     *         .roleArn("roleArn")
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetId("subnetId")
     *         // the properties below are optional
     *         .networkInterfaceIds(List.of("networkInterfaceIds"))
     *         .networkInterfaceType("networkInterfaceType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlow.VpcInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name for the VPC interface.
         * <p>
         * This name must be unique within the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The ARN of the IAM role that you created when you set up MediaConnect as a trusted service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A virtual firewall to control inbound and outbound traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The subnet IDs that you specified for your VPC interface.
         * <p>
         * A subnet ID is a range of IP addresses in your VPC. When you create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC. When you create a subnet for your VPC, you specify the CIDR block for the subnet, which is a subset of the VPC CIDR block.
         * <p>
         * The subnets that you use across all VPC interfaces on the flow must be in the same Availability Zone as the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-subnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

        /**
         * The IDs of the network interfaces that MediaConnect created in your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-networkinterfaceids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-networkinterfaceids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNetworkInterfaceIds() {
            return null;
        }

        /**
         * The type of network interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-networkinterfacetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-vpcinterface.html#cfn-mediaconnect-flow-vpcinterface-networkinterfacetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcInterfaceProperty> {
            java.lang.String name;
            java.lang.String roleArn;
            java.util.List<java.lang.String> securityGroupIds;
            java.lang.String subnetId;
            java.util.List<java.lang.String> networkInterfaceIds;
            java.lang.String networkInterfaceType;

            /**
             * Sets the value of {@link VpcInterfaceProperty#getName}
             * @param name The name for the VPC interface. This parameter is required.
             *             This name must be unique within the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link VpcInterfaceProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that you created when you set up MediaConnect as a trusted service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link VpcInterfaceProperty#getSecurityGroupIds}
             * @param securityGroupIds A virtual firewall to control inbound and outbound traffic. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcInterfaceProperty#getSubnetId}
             * @param subnetId The subnet IDs that you specified for your VPC interface. This parameter is required.
             *                 A subnet ID is a range of IP addresses in your VPC. When you create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC. When you create a subnet for your VPC, you specify the CIDR block for the subnet, which is a subset of the VPC CIDR block.
             *                 <p>
             *                 The subnets that you use across all VPC interfaces on the flow must be in the same Availability Zone as the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link VpcInterfaceProperty#getNetworkInterfaceIds}
             * @param networkInterfaceIds The IDs of the network interfaces that MediaConnect created in your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceIds(java.util.List<java.lang.String> networkInterfaceIds) {
                this.networkInterfaceIds = networkInterfaceIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcInterfaceProperty#getNetworkInterfaceType}
             * @param networkInterfaceType The type of network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceType(java.lang.String networkInterfaceType) {
                this.networkInterfaceType = networkInterfaceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.String roleArn;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.lang.String subnetId;
            private final java.util.List<java.lang.String> networkInterfaceIds;
            private final java.lang.String networkInterfaceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkInterfaceIds = software.amazon.jsii.Kernel.get(this, "networkInterfaceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.networkInterfaceType = software.amazon.jsii.Kernel.get(this, "networkInterfaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
                this.networkInterfaceIds = builder.networkInterfaceIds;
                this.networkInterfaceType = builder.networkInterfaceType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.util.List<java.lang.String> getNetworkInterfaceIds() {
                return this.networkInterfaceIds;
            }

            @Override
            public final java.lang.String getNetworkInterfaceType() {
                return this.networkInterfaceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
                if (this.getNetworkInterfaceIds() != null) {
                    data.set("networkInterfaceIds", om.valueToTree(this.getNetworkInterfaceIds()));
                }
                if (this.getNetworkInterfaceType() != null) {
                    data.set("networkInterfaceType", om.valueToTree(this.getNetworkInterfaceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlow.VpcInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcInterfaceProperty.Jsii$Proxy that = (VpcInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                if (!subnetId.equals(that.subnetId)) return false;
                if (this.networkInterfaceIds != null ? !this.networkInterfaceIds.equals(that.networkInterfaceIds) : that.networkInterfaceIds != null) return false;
                return this.networkInterfaceType != null ? this.networkInterfaceType.equals(that.networkInterfaceType) : that.networkInterfaceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.securityGroupIds.hashCode());
                result = 31 * result + (this.subnetId.hashCode());
                result = 31 * result + (this.networkInterfaceIds != null ? this.networkInterfaceIds.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceType != null ? this.networkInterfaceType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnFlow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnFlow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnFlowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnFlowProps.Builder();
        }

        /**
         * The name of the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name</a>
         * @param name The name of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The settings for the source that you want to use for the new flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source</a>
         * @param source The settings for the source that you want to use for the new flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.IResolvable source) {
            this.props.source(source);
            return this;
        }
        /**
         * The settings for the source that you want to use for the new flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source</a>
         * @param source The settings for the source that you want to use for the new flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty source) {
            this.props.source(source);
            return this;
        }

        /**
         * The Availability Zone that you want to create the flow in.
         * <p>
         * These options are limited to the Availability Zones within the current AWS Region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone</a>
         * @param availabilityZone The Availability Zone that you want to create the flow in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The maintenance settings you want to use for the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-maintenance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-maintenance</a>
         * @param maintenance The maintenance settings you want to use for the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenance(final software.amazon.awscdk.IResolvable maintenance) {
            this.props.maintenance(maintenance);
            return this;
        }
        /**
         * The maintenance settings you want to use for the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-maintenance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-maintenance</a>
         * @param maintenance The maintenance settings you want to use for the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenance(final software.amazon.awscdk.services.mediaconnect.CfnFlow.MaintenanceProperty maintenance) {
            this.props.maintenance(maintenance);
            return this;
        }

        /**
         * The media streams associated with the flow.
         * <p>
         * You can associate any of these media streams with sources and outputs on the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-mediastreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-mediastreams</a>
         * @param mediaStreams The media streams associated with the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreams(final software.amazon.awscdk.IResolvable mediaStreams) {
            this.props.mediaStreams(mediaStreams);
            return this;
        }
        /**
         * The media streams associated with the flow.
         * <p>
         * You can associate any of these media streams with sources and outputs on the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-mediastreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-mediastreams</a>
         * @param mediaStreams The media streams associated with the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreams(final java.util.List<? extends java.lang.Object> mediaStreams) {
            this.props.mediaStreams(mediaStreams);
            return this;
        }

        /**
         * The settings for source failover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig</a>
         * @param sourceFailoverConfig The settings for source failover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(final software.amazon.awscdk.IResolvable sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }
        /**
         * The settings for source failover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig</a>
         * @param sourceFailoverConfig The settings for source failover. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(final software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }

        /**
         * The settings for source monitoring.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcemonitoringconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcemonitoringconfig</a>
         * @param sourceMonitoringConfig The settings for source monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMonitoringConfig(final software.amazon.awscdk.IResolvable sourceMonitoringConfig) {
            this.props.sourceMonitoringConfig(sourceMonitoringConfig);
            return this;
        }
        /**
         * The settings for source monitoring.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcemonitoringconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcemonitoringconfig</a>
         * @param sourceMonitoringConfig The settings for source monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMonitoringConfig(final software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceMonitoringConfigProperty sourceMonitoringConfig) {
            this.props.sourceMonitoringConfig(sourceMonitoringConfig);
            return this;
        }

        /**
         * The VPC interfaces that you added to this flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-vpcinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-vpcinterfaces</a>
         * @param vpcInterfaces The VPC interfaces that you added to this flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaces(final software.amazon.awscdk.IResolvable vpcInterfaces) {
            this.props.vpcInterfaces(vpcInterfaces);
            return this;
        }
        /**
         * The VPC interfaces that you added to this flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-vpcinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-vpcinterfaces</a>
         * @param vpcInterfaces The VPC interfaces that you added to this flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaces(final java.util.List<? extends java.lang.Object> vpcInterfaces) {
            this.props.vpcInterfaces(vpcInterfaces);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnFlow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnFlow build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnFlow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
