package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnFlow</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowProps cfnFlowProps = CfnFlowProps.builder()
 *         .name("name")
 *         .source(SourceProperty.builder()
 *                 .decryption(EncryptionProperty.builder()
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .algorithm("algorithm")
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .deviceId("deviceId")
 *                         .keyType("keyType")
 *                         .region("region")
 *                         .resourceId("resourceId")
 *                         .secretArn("secretArn")
 *                         .url("url")
 *                         .build())
 *                 .description("description")
 *                 .entitlementArn("entitlementArn")
 *                 .gatewayBridgeSource(GatewayBridgeSourceProperty.builder()
 *                         .bridgeArn("bridgeArn")
 *                         // the properties below are optional
 *                         .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                                 .vpcInterfaceName("vpcInterfaceName")
 *                                 .build())
 *                         .build())
 *                 .ingestIp("ingestIp")
 *                 .ingestPort(123)
 *                 .maxBitrate(123)
 *                 .maxLatency(123)
 *                 .maxSyncBuffer(123)
 *                 .mediaStreamSourceConfigurations(List.of(MediaStreamSourceConfigurationProperty.builder()
 *                         .encodingName("encodingName")
 *                         .mediaStreamName("mediaStreamName")
 *                         // the properties below are optional
 *                         .inputConfigurations(List.of(InputConfigurationProperty.builder()
 *                                 .inputPort(123)
 *                                 .interface(InterfaceProperty.builder()
 *                                         .name("name")
 *                                         .build())
 *                                 .build()))
 *                         .build()))
 *                 .minLatency(123)
 *                 .name("name")
 *                 .protocol("protocol")
 *                 .senderControlPort(123)
 *                 .senderIpAddress("senderIpAddress")
 *                 .sourceArn("sourceArn")
 *                 .sourceIngestPort("sourceIngestPort")
 *                 .sourceListenerAddress("sourceListenerAddress")
 *                 .sourceListenerPort(123)
 *                 .streamId("streamId")
 *                 .vpcInterfaceName("vpcInterfaceName")
 *                 .whitelistCidr("whitelistCidr")
 *                 .build())
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .maintenance(MaintenanceProperty.builder()
 *                 .maintenanceDay("maintenanceDay")
 *                 .maintenanceStartHour("maintenanceStartHour")
 *                 .build())
 *         .mediaStreams(List.of(MediaStreamProperty.builder()
 *                 .mediaStreamId(123)
 *                 .mediaStreamName("mediaStreamName")
 *                 .mediaStreamType("mediaStreamType")
 *                 // the properties below are optional
 *                 .attributes(MediaStreamAttributesProperty.builder()
 *                         .fmtp(FmtpProperty.builder()
 *                                 .channelOrder("channelOrder")
 *                                 .colorimetry("colorimetry")
 *                                 .exactFramerate("exactFramerate")
 *                                 .par("par")
 *                                 .range("range")
 *                                 .scanMode("scanMode")
 *                                 .tcs("tcs")
 *                                 .build())
 *                         .lang("lang")
 *                         .build())
 *                 .clockRate(123)
 *                 .description("description")
 *                 .fmt(123)
 *                 .videoFormat("videoFormat")
 *                 .build()))
 *         .sourceFailoverConfig(FailoverConfigProperty.builder()
 *                 .failoverMode("failoverMode")
 *                 .recoveryWindow(123)
 *                 .sourcePriority(SourcePriorityProperty.builder()
 *                         .primarySource("primarySource")
 *                         .build())
 *                 .state("state")
 *                 .build())
 *         .sourceMonitoringConfig(SourceMonitoringConfigProperty.builder()
 *                 .thumbnailState("thumbnailState")
 *                 .build())
 *         .vpcInterfaces(List.of(VpcInterfaceProperty.builder()
 *                 .name("name")
 *                 .roleArn("roleArn")
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .networkInterfaceIds(List.of("networkInterfaceIds"))
 *                 .networkInterfaceType("networkInterfaceType")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:00.261Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The settings for the source that you want to use for the new flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-source</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSource();

    /**
     * The Availability Zone that you want to create the flow in.
     * <p>
     * These options are limited to the Availability Zones within the current AWS Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The maintenance settings you want to use for the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-maintenance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-maintenance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenance() {
        return null;
    }

    /**
     * The media streams associated with the flow.
     * <p>
     * You can associate any of these media streams with sources and outputs on the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-mediastreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-mediastreams</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMediaStreams() {
        return null;
    }

    /**
     * The settings for source failover.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcefailoverconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceFailoverConfig() {
        return null;
    }

    /**
     * The settings for source monitoring.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcemonitoringconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-sourcemonitoringconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceMonitoringConfig() {
        return null;
    }

    /**
     * The VPC interfaces that you added to this flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-vpcinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html#cfn-mediaconnect-flow-vpcinterfaces</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcInterfaces() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowProps> {
        java.lang.String name;
        java.lang.Object source;
        java.lang.String availabilityZone;
        java.lang.Object maintenance;
        java.lang.Object mediaStreams;
        java.lang.Object sourceFailoverConfig;
        java.lang.Object sourceMonitoringConfig;
        java.lang.Object vpcInterfaces;

        /**
         * Sets the value of {@link CfnFlowProps#getName}
         * @param name The name of the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSource}
         * @param source The settings for the source that you want to use for the new flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.IResolvable source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSource}
         * @param source The settings for the source that you want to use for the new flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone that you want to create the flow in.
         *                         These options are limited to the Availability Zones within the current AWS Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getMaintenance}
         * @param maintenance The maintenance settings you want to use for the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenance(software.amazon.awscdk.IResolvable maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getMaintenance}
         * @param maintenance The maintenance settings you want to use for the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenance(software.amazon.awscdk.services.mediaconnect.CfnFlow.MaintenanceProperty maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getMediaStreams}
         * @param mediaStreams The media streams associated with the flow.
         *                     You can associate any of these media streams with sources and outputs on the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreams(software.amazon.awscdk.IResolvable mediaStreams) {
            this.mediaStreams = mediaStreams;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getMediaStreams}
         * @param mediaStreams The media streams associated with the flow.
         *                     You can associate any of these media streams with sources and outputs on the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreams(java.util.List<? extends java.lang.Object> mediaStreams) {
            this.mediaStreams = mediaStreams;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceFailoverConfig}
         * @param sourceFailoverConfig The settings for source failover.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(software.amazon.awscdk.IResolvable sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceFailoverConfig}
         * @param sourceFailoverConfig The settings for source failover.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceMonitoringConfig}
         * @param sourceMonitoringConfig The settings for source monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMonitoringConfig(software.amazon.awscdk.IResolvable sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceMonitoringConfig}
         * @param sourceMonitoringConfig The settings for source monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMonitoringConfig(software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceMonitoringConfigProperty sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getVpcInterfaces}
         * @param vpcInterfaces The VPC interfaces that you added to this flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaces(software.amazon.awscdk.IResolvable vpcInterfaces) {
            this.vpcInterfaces = vpcInterfaces;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getVpcInterfaces}
         * @param vpcInterfaces The VPC interfaces that you added to this flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaces(java.util.List<? extends java.lang.Object> vpcInterfaces) {
            this.vpcInterfaces = vpcInterfaces;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowProps {
        private final java.lang.String name;
        private final java.lang.Object source;
        private final java.lang.String availabilityZone;
        private final java.lang.Object maintenance;
        private final java.lang.Object mediaStreams;
        private final java.lang.Object sourceFailoverConfig;
        private final java.lang.Object sourceMonitoringConfig;
        private final java.lang.Object vpcInterfaces;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenance = software.amazon.jsii.Kernel.get(this, "maintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mediaStreams = software.amazon.jsii.Kernel.get(this, "mediaStreams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceFailoverConfig = software.amazon.jsii.Kernel.get(this, "sourceFailoverConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceMonitoringConfig = software.amazon.jsii.Kernel.get(this, "sourceMonitoringConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcInterfaces = software.amazon.jsii.Kernel.get(this, "vpcInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.availabilityZone = builder.availabilityZone;
            this.maintenance = builder.maintenance;
            this.mediaStreams = builder.mediaStreams;
            this.sourceFailoverConfig = builder.sourceFailoverConfig;
            this.sourceMonitoringConfig = builder.sourceMonitoringConfig;
            this.vpcInterfaces = builder.vpcInterfaces;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getMaintenance() {
            return this.maintenance;
        }

        @Override
        public final java.lang.Object getMediaStreams() {
            return this.mediaStreams;
        }

        @Override
        public final java.lang.Object getSourceFailoverConfig() {
            return this.sourceFailoverConfig;
        }

        @Override
        public final java.lang.Object getSourceMonitoringConfig() {
            return this.sourceMonitoringConfig;
        }

        @Override
        public final java.lang.Object getVpcInterfaces() {
            return this.vpcInterfaces;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getMaintenance() != null) {
                data.set("maintenance", om.valueToTree(this.getMaintenance()));
            }
            if (this.getMediaStreams() != null) {
                data.set("mediaStreams", om.valueToTree(this.getMediaStreams()));
            }
            if (this.getSourceFailoverConfig() != null) {
                data.set("sourceFailoverConfig", om.valueToTree(this.getSourceFailoverConfig()));
            }
            if (this.getSourceMonitoringConfig() != null) {
                data.set("sourceMonitoringConfig", om.valueToTree(this.getSourceMonitoringConfig()));
            }
            if (this.getVpcInterfaces() != null) {
                data.set("vpcInterfaces", om.valueToTree(this.getVpcInterfaces()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowProps.Jsii$Proxy that = (CfnFlowProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!source.equals(that.source)) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.maintenance != null ? !this.maintenance.equals(that.maintenance) : that.maintenance != null) return false;
            if (this.mediaStreams != null ? !this.mediaStreams.equals(that.mediaStreams) : that.mediaStreams != null) return false;
            if (this.sourceFailoverConfig != null ? !this.sourceFailoverConfig.equals(that.sourceFailoverConfig) : that.sourceFailoverConfig != null) return false;
            if (this.sourceMonitoringConfig != null ? !this.sourceMonitoringConfig.equals(that.sourceMonitoringConfig) : that.sourceMonitoringConfig != null) return false;
            return this.vpcInterfaces != null ? this.vpcInterfaces.equals(that.vpcInterfaces) : that.vpcInterfaces == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.maintenance != null ? this.maintenance.hashCode() : 0);
            result = 31 * result + (this.mediaStreams != null ? this.mediaStreams.hashCode() : 0);
            result = 31 * result + (this.sourceFailoverConfig != null ? this.sourceFailoverConfig.hashCode() : 0);
            result = 31 * result + (this.sourceMonitoringConfig != null ? this.sourceMonitoringConfig.hashCode() : 0);
            result = 31 * result + (this.vpcInterfaces != null ? this.vpcInterfaces.hashCode() : 0);
            return result;
        }
    }
}
