package software.amazon.awscdk.services.opensearchservice;

/**
 * Configures a custom domain endpoint for the Amazon OpenSearch Service domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_0)
 *         .customEndpoint(CustomEndpointOptions.builder()
 *                 .domainName("search.example.com")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:00.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CustomEndpointOptions")
@software.amazon.jsii.Jsii.Proxy(CustomEndpointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The custom domain name to assign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The certificate to use.
     * <p>
     * Default: - create a new one
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * The hosted zone in Route53 to create the CNAME record in.
     * <p>
     * Default: - do not create a CNAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomEndpointOptions> {
        java.lang.String domainName;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        software.amazon.awscdk.services.route53.IHostedZone hostedZone;

        /**
         * Sets the value of {@link CustomEndpointOptions#getDomainName}
         * @param domainName The custom domain name to assign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CustomEndpointOptions#getCertificate}
         * @param certificate The certificate to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link CustomEndpointOptions#getHostedZone}
         * @param hostedZone The hosted zone in Route53 to create the CNAME record in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomEndpointOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomEndpointOptions {
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.hostedZone = software.amazon.jsii.Kernel.get(this, "hostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.certificate = builder.certificate;
            this.hostedZone = builder.hostedZone;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getHostedZone() != null) {
                data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CustomEndpointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomEndpointOptions.Jsii$Proxy that = (CustomEndpointOptions.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            return this.hostedZone != null ? this.hostedZone.equals(that.hostedZone) : that.hostedZone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.hostedZone != null ? this.hostedZone.hashCode() : 0);
            return result;
        }
    }
}
