package software.amazon.awscdk.services.sam;

/**
 * Properties for defining a <code>CfnHttpApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sam.*;
 * Object authorizers;
 * Object definitionBody;
 * CfnHttpApiProps cfnHttpApiProps = CfnHttpApiProps.builder()
 *         .accessLogSetting(AccessLogSettingProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .auth(HttpApiAuthProperty.builder()
 *                 .authorizers(authorizers)
 *                 .defaultAuthorizer("defaultAuthorizer")
 *                 .build())
 *         .corsConfiguration(false)
 *         .defaultRouteSettings(RouteSettingsProperty.builder()
 *                 .dataTraceEnabled(false)
 *                 .detailedMetricsEnabled(false)
 *                 .loggingLevel("loggingLevel")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build())
 *         .definitionBody(definitionBody)
 *         .definitionUri("definitionUri")
 *         .description("description")
 *         .disableExecuteApiEndpoint(false)
 *         .domain(HttpApiDomainConfigurationProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .domainName("domainName")
 *                 // the properties below are optional
 *                 .basePath("basePath")
 *                 .endpointConfiguration("endpointConfiguration")
 *                 .mutualTlsAuthentication(MutualTlsAuthenticationProperty.builder()
 *                         .truststoreUri("truststoreUri")
 *                         .truststoreVersion(false)
 *                         .build())
 *                 .route53(Route53ConfigurationProperty.builder()
 *                         .distributedDomainName("distributedDomainName")
 *                         .evaluateTargetHealth(false)
 *                         .hostedZoneId("hostedZoneId")
 *                         .hostedZoneName("hostedZoneName")
 *                         .ipV6(false)
 *                         .build())
 *                 .securityPolicy("securityPolicy")
 *                 .build())
 *         .failOnWarnings(false)
 *         .routeSettings(RouteSettingsProperty.builder()
 *                 .dataTraceEnabled(false)
 *                 .detailedMetricsEnabled(false)
 *                 .loggingLevel("loggingLevel")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build())
 *         .stageName("stageName")
 *         .stageVariables(Map.of(
 *                 "stageVariablesKey", "stageVariables"))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.193Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sam.CfnHttpApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnHttpApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHttpApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-accesslogsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-accesslogsetting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-auth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-auth</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-corsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-corsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfiguration() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-defaultroutesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-defaultroutesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRouteSettings() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-definitionbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-definitionbody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionBody() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-definitionuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-definitionuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionUri() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-disableexecuteapiendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-disableexecuteapiendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableExecuteApiEndpoint() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomain() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-failonwarnings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-failonwarnings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFailOnWarnings() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-routesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-routesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRouteSettings() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-stagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-stagename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-stagevariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-stagevariables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariables() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-serverless-httpapi.html#cfn-serverless-httpapi-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHttpApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHttpApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHttpApiProps> {
        java.lang.Object accessLogSetting;
        java.lang.Object auth;
        java.lang.Object corsConfiguration;
        java.lang.Object defaultRouteSettings;
        java.lang.Object definitionBody;
        java.lang.Object definitionUri;
        java.lang.String description;
        java.lang.Object disableExecuteApiEndpoint;
        java.lang.Object domain;
        java.lang.Object failOnWarnings;
        java.lang.Object routeSettings;
        java.lang.String stageName;
        java.lang.Object stageVariables;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnHttpApiProps#getAccessLogSetting}
         * @param accessLogSetting the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(software.amazon.awscdk.IResolvable accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getAccessLogSetting}
         * @param accessLogSetting the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(software.amazon.awscdk.services.sam.CfnHttpApi.AccessLogSettingProperty accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getAuth}
         * @param auth the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(software.amazon.awscdk.IResolvable auth) {
            this.auth = auth;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getAuth}
         * @param auth the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiAuthProperty auth) {
            this.auth = auth;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getCorsConfiguration}
         * @param corsConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(java.lang.Boolean corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getCorsConfiguration}
         * @param corsConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(software.amazon.awscdk.IResolvable corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getCorsConfiguration}
         * @param corsConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsConfiguration(software.amazon.awscdk.services.sam.CfnHttpApi.CorsConfigurationObjectProperty corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDefaultRouteSettings}
         * @param defaultRouteSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(software.amazon.awscdk.IResolvable defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDefaultRouteSettings}
         * @param defaultRouteSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteSettings(software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDefinitionBody}
         * @param definitionBody the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionBody(java.lang.Object definitionBody) {
            this.definitionBody = definitionBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(java.lang.String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(software.amazon.awscdk.IResolvable definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(software.amazon.awscdk.services.sam.CfnHttpApi.S3LocationProperty definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDescription}
         * @param description the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(java.lang.Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(software.amazon.awscdk.IResolvable disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDomain}
         * @param domain the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(software.amazon.awscdk.IResolvable domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getDomain}
         * @param domain the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiDomainConfigurationProperty domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getFailOnWarnings}
         * @param failOnWarnings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getFailOnWarnings}
         * @param failOnWarnings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(software.amazon.awscdk.IResolvable failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getRouteSettings}
         * @param routeSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSettings(software.amazon.awscdk.IResolvable routeSettings) {
            this.routeSettings = routeSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getRouteSettings}
         * @param routeSettings the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSettings(software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty routeSettings) {
            this.routeSettings = routeSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getStageName}
         * @param stageName the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getStageVariables}
         * @param stageVariables the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(software.amazon.awscdk.IResolvable stageVariables) {
            this.stageVariables = stageVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getStageVariables}
         * @param stageVariables the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageVariables(java.util.Map<java.lang.String, java.lang.String> stageVariables) {
            this.stageVariables = stageVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnHttpApiProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHttpApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHttpApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHttpApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHttpApiProps {
        private final java.lang.Object accessLogSetting;
        private final java.lang.Object auth;
        private final java.lang.Object corsConfiguration;
        private final java.lang.Object defaultRouteSettings;
        private final java.lang.Object definitionBody;
        private final java.lang.Object definitionUri;
        private final java.lang.String description;
        private final java.lang.Object disableExecuteApiEndpoint;
        private final java.lang.Object domain;
        private final java.lang.Object failOnWarnings;
        private final java.lang.Object routeSettings;
        private final java.lang.String stageName;
        private final java.lang.Object stageVariables;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessLogSetting = software.amazon.jsii.Kernel.get(this, "accessLogSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.corsConfiguration = software.amazon.jsii.Kernel.get(this, "corsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultRouteSettings = software.amazon.jsii.Kernel.get(this, "defaultRouteSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionBody = software.amazon.jsii.Kernel.get(this, "definitionBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionUri = software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableExecuteApiEndpoint = software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.failOnWarnings = software.amazon.jsii.Kernel.get(this, "failOnWarnings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.routeSettings = software.amazon.jsii.Kernel.get(this, "routeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stageVariables = software.amazon.jsii.Kernel.get(this, "stageVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessLogSetting = builder.accessLogSetting;
            this.auth = builder.auth;
            this.corsConfiguration = builder.corsConfiguration;
            this.defaultRouteSettings = builder.defaultRouteSettings;
            this.definitionBody = builder.definitionBody;
            this.definitionUri = builder.definitionUri;
            this.description = builder.description;
            this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
            this.domain = builder.domain;
            this.failOnWarnings = builder.failOnWarnings;
            this.routeSettings = builder.routeSettings;
            this.stageName = builder.stageName;
            this.stageVariables = builder.stageVariables;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getAccessLogSetting() {
            return this.accessLogSetting;
        }

        @Override
        public final java.lang.Object getAuth() {
            return this.auth;
        }

        @Override
        public final java.lang.Object getCorsConfiguration() {
            return this.corsConfiguration;
        }

        @Override
        public final java.lang.Object getDefaultRouteSettings() {
            return this.defaultRouteSettings;
        }

        @Override
        public final java.lang.Object getDefinitionBody() {
            return this.definitionBody;
        }

        @Override
        public final java.lang.Object getDefinitionUri() {
            return this.definitionUri;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        @Override
        public final java.lang.Object getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.Object getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final java.lang.Object getRouteSettings() {
            return this.routeSettings;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.lang.Object getStageVariables() {
            return this.stageVariables;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessLogSetting() != null) {
                data.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
            }
            if (this.getAuth() != null) {
                data.set("auth", om.valueToTree(this.getAuth()));
            }
            if (this.getCorsConfiguration() != null) {
                data.set("corsConfiguration", om.valueToTree(this.getCorsConfiguration()));
            }
            if (this.getDefaultRouteSettings() != null) {
                data.set("defaultRouteSettings", om.valueToTree(this.getDefaultRouteSettings()));
            }
            if (this.getDefinitionBody() != null) {
                data.set("definitionBody", om.valueToTree(this.getDefinitionBody()));
            }
            if (this.getDefinitionUri() != null) {
                data.set("definitionUri", om.valueToTree(this.getDefinitionUri()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableExecuteApiEndpoint() != null) {
                data.set("disableExecuteApiEndpoint", om.valueToTree(this.getDisableExecuteApiEndpoint()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getFailOnWarnings() != null) {
                data.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getRouteSettings() != null) {
                data.set("routeSettings", om.valueToTree(this.getRouteSettings()));
            }
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getStageVariables() != null) {
                data.set("stageVariables", om.valueToTree(this.getStageVariables()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sam.CfnHttpApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHttpApiProps.Jsii$Proxy that = (CfnHttpApiProps.Jsii$Proxy) o;

            if (this.accessLogSetting != null ? !this.accessLogSetting.equals(that.accessLogSetting) : that.accessLogSetting != null) return false;
            if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
            if (this.corsConfiguration != null ? !this.corsConfiguration.equals(that.corsConfiguration) : that.corsConfiguration != null) return false;
            if (this.defaultRouteSettings != null ? !this.defaultRouteSettings.equals(that.defaultRouteSettings) : that.defaultRouteSettings != null) return false;
            if (this.definitionBody != null ? !this.definitionBody.equals(that.definitionBody) : that.definitionBody != null) return false;
            if (this.definitionUri != null ? !this.definitionUri.equals(that.definitionUri) : that.definitionUri != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableExecuteApiEndpoint != null ? !this.disableExecuteApiEndpoint.equals(that.disableExecuteApiEndpoint) : that.disableExecuteApiEndpoint != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.routeSettings != null ? !this.routeSettings.equals(that.routeSettings) : that.routeSettings != null) return false;
            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.stageVariables != null ? !this.stageVariables.equals(that.stageVariables) : that.stageVariables != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessLogSetting != null ? this.accessLogSetting.hashCode() : 0;
            result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
            result = 31 * result + (this.corsConfiguration != null ? this.corsConfiguration.hashCode() : 0);
            result = 31 * result + (this.defaultRouteSettings != null ? this.defaultRouteSettings.hashCode() : 0);
            result = 31 * result + (this.definitionBody != null ? this.definitionBody.hashCode() : 0);
            result = 31 * result + (this.definitionUri != null ? this.definitionUri.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableExecuteApiEndpoint != null ? this.disableExecuteApiEndpoint.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.routeSettings != null ? this.routeSettings.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            result = 31 * result + (this.stageVariables != null ? this.stageVariables.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
