package software.amazon.awscdk.services.ses;

/**
 * Construction properties for am AllowListReceiptFilter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AllowListReceiptFilter.Builder.create(this, "AllowList")
 *         .ips(List.of("10.0.0.0/16", "1.2.3.4/16"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.510Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.AllowListReceiptFilterProps")
@software.amazon.jsii.Jsii.Proxy(AllowListReceiptFilterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AllowListReceiptFilterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of ip addresses or ranges to allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIps();

    /**
     * @return a {@link Builder} of {@link AllowListReceiptFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AllowListReceiptFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AllowListReceiptFilterProps> {
        java.util.List<java.lang.String> ips;

        /**
         * Sets the value of {@link AllowListReceiptFilterProps#getIps}
         * @param ips A list of ip addresses or ranges to allow list. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ips(java.util.List<java.lang.String> ips) {
            this.ips = ips;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AllowListReceiptFilterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AllowListReceiptFilterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AllowListReceiptFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowListReceiptFilterProps {
        private final java.util.List<java.lang.String> ips;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ips = software.amazon.jsii.Kernel.get(this, "ips", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ips = java.util.Objects.requireNonNull(builder.ips, "ips is required");
        }

        @Override
        public final java.util.List<java.lang.String> getIps() {
            return this.ips;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ips", om.valueToTree(this.getIps()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.AllowListReceiptFilterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AllowListReceiptFilterProps.Jsii$Proxy that = (AllowListReceiptFilterProps.Jsii$Proxy) o;

            return this.ips.equals(that.ips);
        }

        @Override
        public final int hashCode() {
            int result = this.ips.hashCode();
            return result;
        }
    }
}
