package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnMailManagerRuleSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * Object drop;
 * CfnMailManagerRuleSetProps cfnMailManagerRuleSetProps = CfnMailManagerRuleSetProps.builder()
 *         .rules(List.of(RuleProperty.builder()
 *                 .actions(List.of(RuleActionProperty.builder()
 *                         .addHeader(AddHeaderActionProperty.builder()
 *                                 .headerName("headerName")
 *                                 .headerValue("headerValue")
 *                                 .build())
 *                         .archive(ArchiveActionProperty.builder()
 *                                 .targetArchive("targetArchive")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .deliverToMailbox(DeliverToMailboxActionProperty.builder()
 *                                 .mailboxArn("mailboxArn")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .drop(drop)
 *                         .relay(RelayActionProperty.builder()
 *                                 .relay("relay")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .mailFrom("mailFrom")
 *                                 .build())
 *                         .replaceRecipient(ReplaceRecipientActionProperty.builder()
 *                                 .replaceWith(List.of("replaceWith"))
 *                                 .build())
 *                         .send(SendActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .build())
 *                         .writeToS3(S3ActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .s3Bucket("s3Bucket")
 *                                 // the properties below are optional
 *                                 .actionFailurePolicy("actionFailurePolicy")
 *                                 .s3Prefix("s3Prefix")
 *                                 .s3SseKmsKeyId("s3SseKmsKeyId")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .conditions(List.of(RuleConditionProperty.builder()
 *                         .booleanExpression(RuleBooleanExpressionProperty.builder()
 *                                 .evaluate(RuleBooleanToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .build())
 *                         .dmarcExpression(RuleDmarcExpressionProperty.builder()
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .ipExpression(RuleIpExpressionProperty.builder()
 *                                 .evaluate(RuleIpToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .numberExpression(RuleNumberExpressionProperty.builder()
 *                                 .evaluate(RuleNumberToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .value(123)
 *                                 .build())
 *                         .stringExpression(RuleStringExpressionProperty.builder()
 *                                 .evaluate(RuleStringToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .mimeHeaderAttribute("mimeHeaderAttribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .verdictExpression(RuleVerdictExpressionProperty.builder()
 *                                 .evaluate(RuleVerdictToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build()))
 *                 .name("name")
 *                 .unless(List.of(RuleConditionProperty.builder()
 *                         .booleanExpression(RuleBooleanExpressionProperty.builder()
 *                                 .evaluate(RuleBooleanToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .build())
 *                         .dmarcExpression(RuleDmarcExpressionProperty.builder()
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .ipExpression(RuleIpExpressionProperty.builder()
 *                                 .evaluate(RuleIpToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .numberExpression(RuleNumberExpressionProperty.builder()
 *                                 .evaluate(RuleNumberToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .value(123)
 *                                 .build())
 *                         .stringExpression(RuleStringExpressionProperty.builder()
 *                                 .evaluate(RuleStringToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .mimeHeaderAttribute("mimeHeaderAttribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .verdictExpression(RuleVerdictExpressionProperty.builder()
 *                                 .evaluate(RuleVerdictToEvaluateProperty.builder()
 *                                         .analysis(AnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .ruleSetName("ruleSetName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerRuleSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnMailManagerRuleSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMailManagerRuleSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Conditional rules that are evaluated for determining actions on email.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRules();

    /**
     * A user-friendly name for the rule set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rulesetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-rulesetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleSetName() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagerruleset.html#cfn-ses-mailmanagerruleset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMailManagerRuleSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMailManagerRuleSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMailManagerRuleSetProps> {
        java.lang.Object rules;
        java.lang.String ruleSetName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMailManagerRuleSetProps#getRules}
         * @param rules Conditional rules that are evaluated for determining actions on email. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(software.amazon.awscdk.IResolvable rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRuleSetProps#getRules}
         * @param rules Conditional rules that are evaluated for determining actions on email. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(java.util.List<? extends java.lang.Object> rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRuleSetProps#getRuleSetName}
         * @param ruleSetName A user-friendly name for the rule set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(java.lang.String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerRuleSetProps#getTags}
         * @param tags The tags used to organize, track, or control access for the resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMailManagerRuleSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMailManagerRuleSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMailManagerRuleSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMailManagerRuleSetProps {
        private final java.lang.Object rules;
        private final java.lang.String ruleSetName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ruleSetName = software.amazon.jsii.Kernel.get(this, "ruleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            this.ruleSetName = builder.ruleSetName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getRules() {
            return this.rules;
        }

        @Override
        public final java.lang.String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rules", om.valueToTree(this.getRules()));
            if (this.getRuleSetName() != null) {
                data.set("ruleSetName", om.valueToTree(this.getRuleSetName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerRuleSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMailManagerRuleSetProps.Jsii$Proxy that = (CfnMailManagerRuleSetProps.Jsii$Proxy) o;

            if (!rules.equals(that.rules)) return false;
            if (this.ruleSetName != null ? !this.ruleSetName.equals(that.ruleSetName) : that.ruleSetName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.rules.hashCode();
            result = 31 * result + (this.ruleSetName != null ? this.ruleSetName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
