package software.amazon.awscdk.services.ses;

/**
 * Reasons for which recipient email addresses should be automatically added to your account's suppression list.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Duration;
 * IDedicatedIpPool myPool;
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .customTrackingRedirectDomain("track.cdk.dev")
 *         .suppressionReasons(SuppressionReasons.COMPLAINTS_ONLY)
 *         .tlsPolicy(ConfigurationSetTlsPolicy.REQUIRE)
 *         .dedicatedIpPool(myPool)
 *         // Specify maximum delivery time
 *         // This configuration can be useful in such cases as time-sensitive emails (like those containing a one-time-password),
 *         // transactional emails, and email that you want to ensure isn't delivered during non-business hours.
 *         .maxDeliveryDuration(Duration.minutes(10))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.623Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.SuppressionReasons")
public enum SuppressionReasons {
    /**
     * Bounces and complaints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCES_AND_COMPLAINTS,
    /**
     * Bounces only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCES_ONLY,
    /**
     * Complaints only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPLAINTS_ONLY,
}
