package software.amazon.awscdk.services.sns.subscriptions;

/**
 * Use an sms address as a subscription target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "Topic");
 * myTopic.addSubscription(new SmsSubscription("+15551231234"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.706Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns_subscriptions.SmsSubscription")
public class SmsSubscription extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sns.ITopicSubscription {

    protected SmsSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SmsSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param phoneNumber This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SmsSubscription(final @org.jetbrains.annotations.NotNull java.lang.String phoneNumber, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.subscriptions.SmsSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(phoneNumber, "phoneNumber is required"), props });
    }

    /**
     * @param phoneNumber This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SmsSubscription(final @org.jetbrains.annotations.NotNull java.lang.String phoneNumber) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(phoneNumber, "phoneNumber is required") });
    }

    /**
     * Returns a configuration used to subscribe to an SNS topic.
     * <p>
     * @param _topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.TopicSubscriptionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic _topic) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.TopicSubscriptionConfig.class), new Object[] { java.util.Objects.requireNonNull(_topic, "_topic is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.subscriptions.SmsSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.subscriptions.SmsSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param phoneNumber This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String phoneNumber) {
            return new Builder(phoneNumber);
        }

        private final java.lang.String phoneNumber;
        private software.amazon.awscdk.services.sns.subscriptions.SmsSubscriptionProps.Builder props;

        private Builder(final java.lang.String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        /**
         * Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        /**
         * The filter policy that is applied on the message body.
         * <p>
         * To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicyWithMessageBody(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.props().filterPolicyWithMessageBody(filterPolicyWithMessageBody);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sns.subscriptions.SmsSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.subscriptions.SmsSubscription build() {
            return new software.amazon.awscdk.services.sns.subscriptions.SmsSubscription(
                this.phoneNumber,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sns.subscriptions.SmsSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sns.subscriptions.SmsSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}
