package software.amazon.awscdk.services.sqs;

/**
 * The <code>AWS::SQS::Queue</code> resource creates an Amazon SQS standard or FIFO queue.
 * <p>
 * Keep the following caveats in mind:
 * <p>
 * <ul>
 * <li>If you don't specify the <code>FifoQueue</code> property, Amazon SQS creates a standard queue.</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-moving.html">Moving from a standard queue to a FIFO queue</a> in the <em>Amazon SQS Developer Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * <ul>
 * <li>If you don't provide a value for a property, the queue is created with the default value for the property.</li>
 * <li>If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.</li>
 * <li>To successfully create a new queue, you must provide a queue name that adheres to the <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html">limits related to queues</a> and is unique within the scope of your queues.</li>
 * </ul>
 * <p>
 * For more information about creating FIFO (first-in-first-out) queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/create-queue-cloudformation.html">Creating an Amazon SQS queue ( AWS CloudFormation )</a> in the <em>Amazon SQS Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sqs.*;
 * Object redriveAllowPolicy;
 * Object redrivePolicy;
 * CfnQueue cfnQueue = CfnQueue.Builder.create(this, "MyCfnQueue")
 *         .contentBasedDeduplication(false)
 *         .deduplicationScope("deduplicationScope")
 *         .delaySeconds(123)
 *         .fifoQueue(false)
 *         .fifoThroughputLimit("fifoThroughputLimit")
 *         .kmsDataKeyReusePeriodSeconds(123)
 *         .kmsMasterKeyId("kmsMasterKeyId")
 *         .maximumMessageSize(123)
 *         .messageRetentionPeriod(123)
 *         .queueName("queueName")
 *         .receiveMessageWaitTimeSeconds(123)
 *         .redriveAllowPolicy(redriveAllowPolicy)
 *         .redrivePolicy(redrivePolicy)
 *         .sqsManagedSseEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .visibilityTimeout(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.711Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.CfnQueue")
public class CfnQueue extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sqs.CfnQueue.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnQueue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.CfnQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnQueue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the queue.
     * <p>
     * For example: <code>arn:aws:sqs:us-east-2:123456789012:mystack-myqueue-15PG5C2FC1CW8</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the queue name.
     * <p>
     * For example: <code>mystack-myqueue-1VF9BKQH5BJVI</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrQueueName() {
        return software.amazon.jsii.Kernel.get(this, "attrQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the URLs of the queues from the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrQueueUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrQueueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentBasedDeduplication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "contentBasedDeduplication", value);
    }

    /**
     * For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentBasedDeduplication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contentBasedDeduplication", value);
    }

    /**
     * For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeduplicationScope() {
        return software.amazon.jsii.Kernel.get(this, "deduplicationScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeduplicationScope(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deduplicationScope", value);
    }

    /**
     * The time in seconds for which the delivery of all messages in the queue is delayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDelaySeconds() {
        return software.amazon.jsii.Kernel.get(this, "delaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The time in seconds for which the delivery of all messages in the queue is delayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDelaySeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "delaySeconds", value);
    }

    /**
     * If set to true, creates a FIFO queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFifoQueue() {
        return software.amazon.jsii.Kernel.get(this, "fifoQueue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If set to true, creates a FIFO queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoQueue(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "fifoQueue", value);
    }

    /**
     * If set to true, creates a FIFO queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoQueue(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fifoQueue", value);
    }

    /**
     * For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFifoThroughputLimit() {
        return software.amazon.jsii.Kernel.get(this, "fifoThroughputLimit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFifoThroughputLimit(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fifoThroughputLimit", value);
    }

    /**
     * The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getKmsDataKeyReusePeriodSeconds() {
        return software.amazon.jsii.Kernel.get(this, "kmsDataKeyReusePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsDataKeyReusePeriodSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "kmsDataKeyReusePeriodSeconds", value);
    }

    /**
     * The ID of an AWS Key Management Service (KMS) for Amazon SQS , or a custom KMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an AWS Key Management Service (KMS) for Amazon SQS , or a custom KMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsMasterKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsMasterKeyId", value);
    }

    /**
     * The limit of how many bytes that a message can contain before Amazon SQS rejects it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMessageSize() {
        return software.amazon.jsii.Kernel.get(this, "maximumMessageSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The limit of how many bytes that a message can contain before Amazon SQS rejects it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumMessageSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maximumMessageSize", value);
    }

    /**
     * The number of seconds that Amazon SQS retains a message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMessageRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "messageRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of seconds that Amazon SQS retains a message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMessageRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "messageRetentionPeriod", value);
    }

    /**
     * A name for the queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueueName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "queueName", value);
    }

    /**
     * Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getReceiveMessageWaitTimeSeconds() {
        return software.amazon.jsii.Kernel.get(this, "receiveMessageWaitTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReceiveMessageWaitTimeSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "receiveMessageWaitTimeSeconds", value);
    }

    /**
     * The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedriveAllowPolicy() {
        return software.amazon.jsii.Kernel.get(this, "redriveAllowPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedriveAllowPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "redriveAllowPolicy", value);
    }

    /**
     * The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedrivePolicy() {
        return software.amazon.jsii.Kernel.get(this, "redrivePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedrivePolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "redrivePolicy", value);
    }

    /**
     * Enables server-side queue encryption using SQS owned encryption keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSqsManagedSseEnabled() {
        return software.amazon.jsii.Kernel.get(this, "sqsManagedSseEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables server-side queue encryption using SQS owned encryption keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSqsManagedSseEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "sqsManagedSseEnabled", value);
    }

    /**
     * Enables server-side queue encryption using SQS owned encryption keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSqsManagedSseEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sqsManagedSseEnabled", value);
    }

    /**
     * The tags that you attach to this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags that you attach to this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The length of time during which a message will be unavailable after a message is delivered from the queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getVisibilityTimeout() {
        return software.amazon.jsii.Kernel.get(this, "visibilityTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The length of time during which a message will be unavailable after a message is delivered from the queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibilityTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "visibilityTimeout", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sqs.CfnQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sqs.CfnQueue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sqs.CfnQueueProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
         * <p>
         * During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message. For more information, see the <code>ContentBasedDeduplication</code> attribute for the <code>[CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html)</code> action in the <em>Amazon SQS API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-contentbaseddeduplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-contentbaseddeduplication</a>
         * @param contentBasedDeduplication For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final java.lang.Boolean contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }
        /**
         * For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
         * <p>
         * During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message. For more information, see the <code>ContentBasedDeduplication</code> attribute for the <code>[CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html)</code> action in the <em>Amazon SQS API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-contentbaseddeduplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-contentbaseddeduplication</a>
         * @param contentBasedDeduplication For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final software.amazon.awscdk.IResolvable contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }

        /**
         * For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
         * <p>
         * Valid values are <code>messageGroup</code> and <code>queue</code> .
         * <p>
         * To enable high throughput for a FIFO queue, set this attribute to <code>messageGroup</code> <em>and</em> set the <code>FifoThroughputLimit</code> attribute to <code>perMessageGroupId</code> . If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">High throughput for FIFO queues</a> and <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-deduplicationscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-deduplicationscope</a>
         * @param deduplicationScope For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deduplicationScope(final java.lang.String deduplicationScope) {
            this.props().deduplicationScope(deduplicationScope);
            return this;
        }

        /**
         * The time in seconds for which the delivery of all messages in the queue is delayed.
         * <p>
         * You can specify an integer value of <code>0</code> to <code>900</code> (15 minutes). The default value is <code>0</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-delayseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-delayseconds</a>
         * @param delaySeconds The time in seconds for which the delivery of all messages in the queue is delayed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delaySeconds(final java.lang.Number delaySeconds) {
            this.props().delaySeconds(delaySeconds);
            return this;
        }

        /**
         * If set to true, creates a FIFO queue.
         * <p>
         * If you don't specify this property, Amazon SQS creates a standard queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-fifo-queues.html">Amazon SQS FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-fifoqueue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-fifoqueue</a>
         * @param fifoQueue If set to true, creates a FIFO queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(final java.lang.Boolean fifoQueue) {
            this.props().fifoQueue(fifoQueue);
            return this;
        }
        /**
         * If set to true, creates a FIFO queue.
         * <p>
         * If you don't specify this property, Amazon SQS creates a standard queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-fifo-queues.html">Amazon SQS FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-fifoqueue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-fifoqueue</a>
         * @param fifoQueue If set to true, creates a FIFO queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(final software.amazon.awscdk.IResolvable fifoQueue) {
            this.props().fifoQueue(fifoQueue);
            return this;
        }

        /**
         * For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
         * <p>
         * Valid values are <code>perQueue</code> and <code>perMessageGroupId</code> .
         * <p>
         * To enable high throughput for a FIFO queue, set this attribute to <code>perMessageGroupId</code> <em>and</em> set the <code>DeduplicationScope</code> attribute to <code>messageGroup</code> . If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">High throughput for FIFO queues</a> and <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-fifothroughputlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-fifothroughputlimit</a>
         * @param fifoThroughputLimit For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoThroughputLimit(final java.lang.String fifoThroughputLimit) {
            this.props().fifoThroughputLimit(fifoThroughputLimit);
            return this;
        }

        /**
         * The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         * <p>
         * The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
         * <p>
         * <blockquote>
         * <p>
         * A shorter time period provides better security, but results in more calls to AWS KMS , which might incur charges after Free Tier. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">Encryption at rest</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-kmsdatakeyreuseperiodseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-kmsdatakeyreuseperiodseconds</a>
         * @param kmsDataKeyReusePeriodSeconds The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsDataKeyReusePeriodSeconds(final java.lang.Number kmsDataKeyReusePeriodSeconds) {
            this.props().kmsDataKeyReusePeriodSeconds(kmsDataKeyReusePeriodSeconds);
            return this;
        }

        /**
         * The ID of an AWS Key Management Service (KMS) for Amazon SQS , or a custom KMS.
         * <p>
         * To use the AWS managed KMS for Amazon SQS , specify a (default) alias ARN, alias name (for example <code>alias/aws/sqs</code> ), key ARN, or key ID. For more information, see the following:
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">Encryption at rest</a> in the <em>Amazon SQS Developer Guide</em></li>
         * <li><a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a> in the <em>Amazon SQS API Reference</em></li>
         * <li><a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">Request Parameters</a> in the <em>AWS Key Management Service API Reference</em></li>
         * <li>The Key Management Service (KMS) section of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/best-practices.html">Security best practices for AWS Key Management Service</a> in the <em>AWS Key Management Service Developer Guide</em></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-kmsmasterkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-kmsmasterkeyid</a>
         * @param kmsMasterKeyId The ID of an AWS Key Management Service (KMS) for Amazon SQS , or a custom KMS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(final java.lang.String kmsMasterKeyId) {
            this.props().kmsMasterKeyId(kmsMasterKeyId);
            return this;
        }

        /**
         * The limit of how many bytes that a message can contain before Amazon SQS rejects it.
         * <p>
         * You can specify an integer value from <code>1,024</code> bytes (1 KiB) to <code>262,144</code> bytes (256 KiB). The default value is <code>262,144</code> (256 KiB).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-maximummessagesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-maximummessagesize</a>
         * @param maximumMessageSize The limit of how many bytes that a message can contain before Amazon SQS rejects it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMessageSize(final java.lang.Number maximumMessageSize) {
            this.props().maximumMessageSize(maximumMessageSize);
            return this;
        }

        /**
         * The number of seconds that Amazon SQS retains a message.
         * <p>
         * You can specify an integer value from <code>60</code> seconds (1 minute) to <code>1,209,600</code> seconds (14 days). The default value is <code>345,600</code> seconds (4 days).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-messageretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-messageretentionperiod</a>
         * @param messageRetentionPeriod The number of seconds that Amazon SQS retains a message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionPeriod(final java.lang.Number messageRetentionPeriod) {
            this.props().messageRetentionPeriod(messageRetentionPeriod);
            return this;
        }

        /**
         * A name for the queue.
         * <p>
         * To create a FIFO queue, the name of your FIFO queue must end with the <code>.fifo</code> suffix. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-fifo-queues.html">Amazon SQS FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the queue name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-queuename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-queuename</a>
         * @param queueName A name for the queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(final java.lang.String queueName) {
            this.props().queueName(queueName);
            return this;
        }

        /**
         * Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available.
         * <p>
         * You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-short-and-long-polling.html#sqs-long-polling">Consuming messages using long polling</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-receivemessagewaittimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-receivemessagewaittimeseconds</a>
         * @param receiveMessageWaitTimeSeconds Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiveMessageWaitTimeSeconds(final java.lang.Number receiveMessageWaitTimeSeconds) {
            this.props().receiveMessageWaitTimeSeconds(receiveMessageWaitTimeSeconds);
            return this;
        }

        /**
         * The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
         * <p>
         * The parameters are as follows:
         * <p>
         * <ul>
         * <li><code>redrivePermission</code> : The permission type that defines which source queues can specify the current queue as the dead-letter queue. Valid values are:</li>
         * <li><code>allowAll</code> : (Default) Any source queues in this AWS account in the same Region can specify this queue as the dead-letter queue.</li>
         * <li><code>denyAll</code> : No source queues can specify this queue as the dead-letter queue.</li>
         * <li><code>byQueue</code> : Only queues specified by the <code>sourceQueueArns</code> parameter can specify this queue as the dead-letter queue.</li>
         * <li><code>sourceQueueArns</code> : The Amazon Resource Names (ARN)s of the source queues that can specify this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the <code>redrivePermission</code> parameter is set to <code>byQueue</code> . You can specify up to 10 source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter to <code>allowAll</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-redriveallowpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-redriveallowpolicy</a>
         * @param redriveAllowPolicy The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redriveAllowPolicy(final java.lang.Object redriveAllowPolicy) {
            this.props().redriveAllowPolicy(redriveAllowPolicy);
            return this;
        }

        /**
         * The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object.
         * <p>
         * The parameters are as follows:
         * <p>
         * <ul>
         * <li><code>deadLetterTargetArn</code> : The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</li>
         * <li><code>maxReceiveCount</code> : The number of times a message is received by a consumer of the source queue before being moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a standard queue must also be a standard queue.
         * <p>
         * </blockquote>
         * <p>
         * <em>JSON</em>
         * <p>
         * <code>{ "deadLetterTargetArn" : *String* , "maxReceiveCount" : *Integer* }</code>
         * <p>
         * <em>YAML</em>
         * <p>
         * <code>deadLetterTargetArn : *String*</code>
         * <p>
         * <code>maxReceiveCount : *Integer*</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-redrivepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-redrivepolicy</a>
         * @param redrivePolicy The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(final java.lang.Object redrivePolicy) {
            this.props().redrivePolicy(redrivePolicy);
            return this;
        }

        /**
         * Enables server-side queue encryption using SQS owned encryption keys.
         * <p>
         * Only one server-side encryption option is supported per queue (for example, <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html">SSE-KMS</a> or <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html">SSE-SQS</a> ). When <code>SqsManagedSseEnabled</code> is not defined, <code>SSE-SQS</code> encryption is enabled by default.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-sqsmanagedsseenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-sqsmanagedsseenabled</a>
         * @param sqsManagedSseEnabled Enables server-side queue encryption using SQS owned encryption keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsManagedSseEnabled(final java.lang.Boolean sqsManagedSseEnabled) {
            this.props().sqsManagedSseEnabled(sqsManagedSseEnabled);
            return this;
        }
        /**
         * Enables server-side queue encryption using SQS owned encryption keys.
         * <p>
         * Only one server-side encryption option is supported per queue (for example, <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html">SSE-KMS</a> or <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html">SSE-SQS</a> ). When <code>SqsManagedSseEnabled</code> is not defined, <code>SSE-SQS</code> encryption is enabled by default.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-sqsmanagedsseenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-sqsmanagedsseenabled</a>
         * @param sqsManagedSseEnabled Enables server-side queue encryption using SQS owned encryption keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsManagedSseEnabled(final software.amazon.awscdk.IResolvable sqsManagedSseEnabled) {
            this.props().sqsManagedSseEnabled(sqsManagedSseEnabled);
            return this;
        }

        /**
         * The tags that you attach to this queue.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-tags</a>
         * @param tags The tags that you attach to this queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The length of time during which a message will be unavailable after a message is delivered from the queue.
         * <p>
         * This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue.
         * <p>
         * Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
         * <p>
         * For more information about Amazon SQS queue visibility timeouts, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility timeout</a> in the <em>Amazon SQS Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-visibilitytimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sqs-queue.html#cfn-sqs-queue-visibilitytimeout</a>
         * @param visibilityTimeout The length of time during which a message will be unavailable after a message is delivered from the queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(final java.lang.Number visibilityTimeout) {
            this.props().visibilityTimeout(visibilityTimeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sqs.CfnQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sqs.CfnQueue build() {
            return new software.amazon.awscdk.services.sqs.CfnQueue(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sqs.CfnQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sqs.CfnQueueProps.Builder();
            }
            return this.props;
        }
    }
}
