package software.amazon.awscdk.services.stepfunctions;

/**
 * Represents a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> . An alias routes traffic to one or two versions of the same state machine.
 * <p>
 * You can create up to 100 aliases for each state machine.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * CfnStateMachineAlias cfnStateMachineAlias = CfnStateMachineAlias.Builder.create(this, "MyCfnStateMachineAlias")
 *         .deploymentPreference(DeploymentPreferenceProperty.builder()
 *                 .stateMachineVersionArn("stateMachineVersionArn")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .alarms(List.of("alarms"))
 *                 .interval(123)
 *                 .percentage(123)
 *                 .build())
 *         .description("description")
 *         .name("name")
 *         .routingConfiguration(List.of(RoutingConfigurationVersionProperty.builder()
 *                 .stateMachineVersionArn("stateMachineVersionArn")
 *                 .weight(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:05.901Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnStateMachineAlias")
public class CfnStateMachineAlias extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStateMachineAlias(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStateMachineAlias(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStateMachineAlias(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CfnStateMachineAliasProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStateMachineAlias(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the ARN of the state machine alias.
     * <p>
     * For example, <code>arn:aws:states:us-east-1:123456789012:stateMachine:myStateMachine:PROD</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The settings that enable gradual state machine deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentPreference() {
        return software.amazon.jsii.Kernel.get(this, "deploymentPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings that enable gradual state machine deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPreference", value);
    }

    /**
     * The settings that enable gradual state machine deployments.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias.DeploymentPreferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPreference", value);
    }

    /**
     * An optional description of the state machine alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description of the state machine alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the state machine alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the state machine alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The routing configuration of an alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRoutingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "routingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The routing configuration of an alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "routingConfiguration", value);
    }

    /**
     * The routing configuration of an alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingConfiguration(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias.RoutingConfigurationVersionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias.RoutingConfigurationVersionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "routingConfiguration", value);
    }
    /**
     * Enables gradual state machine deployments.
     * <p>
     * CloudFormation automatically shifts traffic from the version the alias currently points to, to a new state machine version that you specify.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * DeploymentPreferenceProperty deploymentPreferenceProperty = DeploymentPreferenceProperty.builder()
     *         .stateMachineVersionArn("stateMachineVersionArn")
     *         .type("type")
     *         // the properties below are optional
     *         .alarms(List.of("alarms"))
     *         .interval(123)
     *         .percentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnStateMachineAlias.DeploymentPreferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentPreferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentPreferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html"><code>AWS::StepFunctions::StateMachineVersion</code></a> resource that will be the final version to which the alias points to when the traffic shifting is complete.
         * <p>
         * While performing gradual deployments, you can only provide a single state machine version ARN. To explicitly set version weights in a CloudFormation template, use <code>RoutingConfiguration</code> instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateMachineVersionArn();

        /**
         * The type of deployment you want to perform. You can specify one of the following types:.
         * <p>
         * <ul>
         * <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
         * </ul>
         * <p>
         * For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any CloudWatch alarms are triggered.
         * <p>
         * <ul>
         * <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
         * <li><code>CANARY</code> - Shifts traffic in two increments.</li>
         * </ul>
         * <p>
         * In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A list of Amazon CloudWatch alarm names to be monitored during the deployment.
         * <p>
         * The deployment fails and rolls back if any of these alarms go into the <code>ALARM</code> state.
         * <p>
         * <blockquote>
         * <p>
         * Amazon CloudWatch considers nonexistent alarms to have an <code>OK</code> state. If you provide an invalid alarm name or provide the ARN of an alarm instead of its name, your deployment may not roll back correctly.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlarms() {
            return null;
        }

        /**
         * The time in minutes between each traffic shifting increment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The percentage of traffic to shift to the new version in each increment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPercentage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentPreferenceProperty> {
            java.lang.String stateMachineVersionArn;
            java.lang.String type;
            java.util.List<java.lang.String> alarms;
            java.lang.Number interval;
            java.lang.Number percentage;

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getStateMachineVersionArn}
             * @param stateMachineVersionArn The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html"><code>AWS::StepFunctions::StateMachineVersion</code></a> resource that will be the final version to which the alias points to when the traffic shifting is complete. This parameter is required.
             *                               While performing gradual deployments, you can only provide a single state machine version ARN. To explicitly set version weights in a CloudFormation template, use <code>RoutingConfiguration</code> instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMachineVersionArn(java.lang.String stateMachineVersionArn) {
                this.stateMachineVersionArn = stateMachineVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getType}
             * @param type The type of deployment you want to perform. You can specify one of the following types:. This parameter is required.
             *             <ul>
             *             <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
             *             </ul>
             *             <p>
             *             For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any CloudWatch alarms are triggered.
             *             <p>
             *             <ul>
             *             <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
             *             <li><code>CANARY</code> - Shifts traffic in two increments.</li>
             *             </ul>
             *             <p>
             *             In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getAlarms}
             * @param alarms A list of Amazon CloudWatch alarm names to be monitored during the deployment.
             *               The deployment fails and rolls back if any of these alarms go into the <code>ALARM</code> state.
             *               <p>
             *               <blockquote>
             *               <p>
             *               Amazon CloudWatch considers nonexistent alarms to have an <code>OK</code> state. If you provide an invalid alarm name or provide the ARN of an alarm instead of its name, your deployment may not roll back correctly.
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<java.lang.String> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getInterval}
             * @param interval The time in minutes between each traffic shifting increment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPreferenceProperty#getPercentage}
             * @param percentage The percentage of traffic to shift to the new version in each increment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentage(java.lang.Number percentage) {
                this.percentage = percentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentPreferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentPreferenceProperty {
            private final java.lang.String stateMachineVersionArn;
            private final java.lang.String type;
            private final java.util.List<java.lang.String> alarms;
            private final java.lang.Number interval;
            private final java.lang.Number percentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateMachineVersionArn = software.amazon.jsii.Kernel.get(this, "stateMachineVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.percentage = software.amazon.jsii.Kernel.get(this, "percentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateMachineVersionArn = java.util.Objects.requireNonNull(builder.stateMachineVersionArn, "stateMachineVersionArn is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.alarms = builder.alarms;
                this.interval = builder.interval;
                this.percentage = builder.percentage;
            }

            @Override
            public final java.lang.String getStateMachineVersionArn() {
                return this.stateMachineVersionArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getAlarms() {
                return this.alarms;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Number getPercentage() {
                return this.percentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateMachineVersionArn", om.valueToTree(this.getStateMachineVersionArn()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAlarms() != null) {
                    data.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getPercentage() != null) {
                    data.set("percentage", om.valueToTree(this.getPercentage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CfnStateMachineAlias.DeploymentPreferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentPreferenceProperty.Jsii$Proxy that = (DeploymentPreferenceProperty.Jsii$Proxy) o;

                if (!stateMachineVersionArn.equals(that.stateMachineVersionArn)) return false;
                if (!type.equals(that.type)) return false;
                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.percentage != null ? this.percentage.equals(that.percentage) : that.percentage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stateMachineVersionArn.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.alarms != null ? this.alarms.hashCode() : 0);
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.percentage != null ? this.percentage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The state machine version to which you want to route the execution traffic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * RoutingConfigurationVersionProperty routingConfigurationVersionProperty = RoutingConfigurationVersionProperty.builder()
     *         .stateMachineVersionArn("stateMachineVersionArn")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-routingconfigurationversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-routingconfigurationversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnStateMachineAlias.RoutingConfigurationVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingConfigurationVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingConfigurationVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
         * <p>
         * If you specify the ARN of a second version, it must belong to the same state machine as the first version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-routingconfigurationversion.html#cfn-stepfunctions-statemachinealias-routingconfigurationversion-statemachineversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-routingconfigurationversion.html#cfn-stepfunctions-statemachinealias-routingconfigurationversion-statemachineversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateMachineVersionArn();

        /**
         * The percentage of traffic you want to route to the state machine version.
         * <p>
         * The sum of the weights in the routing configuration must be equal to 100.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-routingconfigurationversion.html#cfn-stepfunctions-statemachinealias-routingconfigurationversion-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-routingconfigurationversion.html#cfn-stepfunctions-statemachinealias-routingconfigurationversion-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWeight();

        /**
         * @return a {@link Builder} of {@link RoutingConfigurationVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingConfigurationVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingConfigurationVersionProperty> {
            java.lang.String stateMachineVersionArn;
            java.lang.Number weight;

            /**
             * Sets the value of {@link RoutingConfigurationVersionProperty#getStateMachineVersionArn}
             * @param stateMachineVersionArn The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration. This parameter is required.
             *                               If you specify the ARN of a second version, it must belong to the same state machine as the first version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMachineVersionArn(java.lang.String stateMachineVersionArn) {
                this.stateMachineVersionArn = stateMachineVersionArn;
                return this;
            }

            /**
             * Sets the value of {@link RoutingConfigurationVersionProperty#getWeight}
             * @param weight The percentage of traffic you want to route to the state machine version. This parameter is required.
             *               The sum of the weights in the routing configuration must be equal to 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingConfigurationVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingConfigurationVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoutingConfigurationVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingConfigurationVersionProperty {
            private final java.lang.String stateMachineVersionArn;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stateMachineVersionArn = software.amazon.jsii.Kernel.get(this, "stateMachineVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stateMachineVersionArn = java.util.Objects.requireNonNull(builder.stateMachineVersionArn, "stateMachineVersionArn is required");
                this.weight = java.util.Objects.requireNonNull(builder.weight, "weight is required");
            }

            @Override
            public final java.lang.String getStateMachineVersionArn() {
                return this.stateMachineVersionArn;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("stateMachineVersionArn", om.valueToTree(this.getStateMachineVersionArn()));
                data.set("weight", om.valueToTree(this.getWeight()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CfnStateMachineAlias.RoutingConfigurationVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingConfigurationVersionProperty.Jsii$Proxy that = (RoutingConfigurationVersionProperty.Jsii$Proxy) o;

                if (!stateMachineVersionArn.equals(that.stateMachineVersionArn)) return false;
                return this.weight.equals(that.weight);
            }

            @Override
            public final int hashCode() {
                int result = this.stateMachineVersionArn.hashCode();
                result = 31 * result + (this.weight.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.stepfunctions.CfnStateMachineAliasProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The settings that enable gradual state machine deployments.
         * <p>
         * These settings include <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms">Alarms</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval">Interval</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage">Percentage</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn">StateMachineVersionArn</a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type">Type</a> .
         * <p>
         * CloudFormation automatically shifts traffic from the version an alias currently points to, to a new state machine version that you specify.
         * <p>
         * <blockquote>
         * <p>
         * <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         * <p>
         * </blockquote>
         * <p>
         * Based on the type of deployment you want to perform, you can specify one of the following settings:
         * <p>
         * <ul>
         * <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
         * </ul>
         * <p>
         * For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any Amazon CloudWatch alarms are triggered.
         * <p>
         * <ul>
         * <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
         * <li><code>CANARY</code> - Shifts traffic in two increments.</li>
         * </ul>
         * <p>
         * In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-deploymentpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-deploymentpreference</a>
         * @param deploymentPreference The settings that enable gradual state machine deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(final software.amazon.awscdk.IResolvable deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }
        /**
         * The settings that enable gradual state machine deployments.
         * <p>
         * These settings include <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-alarms">Alarms</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-interval">Interval</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-percentage">Percentage</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-statemachineversionarn">StateMachineVersionArn</a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stepfunctions-statemachinealias-deploymentpreference.html#cfn-stepfunctions-statemachinealias-deploymentpreference-type">Type</a> .
         * <p>
         * CloudFormation automatically shifts traffic from the version an alias currently points to, to a new state machine version that you specify.
         * <p>
         * <blockquote>
         * <p>
         * <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         * <p>
         * </blockquote>
         * <p>
         * Based on the type of deployment you want to perform, you can specify one of the following settings:
         * <p>
         * <ul>
         * <li><code>LINEAR</code> - Shifts traffic to the new version in equal increments with an equal number of minutes between each increment.</li>
         * </ul>
         * <p>
         * For example, if you specify the increment percent as <code>20</code> with an interval of <code>600</code> minutes, this deployment increases traffic by 20 percent every 600 minutes until the new version receives 100 percent of the traffic. This deployment immediately rolls back the new version if any Amazon CloudWatch alarms are triggered.
         * <p>
         * <ul>
         * <li><code>ALL_AT_ONCE</code> - Shifts 100 percent of traffic to the new version immediately. CloudFormation monitors the new version and rolls it back automatically to the previous version if any CloudWatch alarms are triggered.</li>
         * <li><code>CANARY</code> - Shifts traffic in two increments.</li>
         * </ul>
         * <p>
         * In the first increment, a small percentage of traffic, for example, 10 percent is shifted to the new version. In the second increment, before a specified time interval in seconds gets over, the remaining traffic is shifted to the new version. The shift to the new version for the remaining traffic takes place only if no CloudWatch alarms are triggered during the specified time interval.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-deploymentpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-deploymentpreference</a>
         * @param deploymentPreference The settings that enable gradual state machine deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPreference(final software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias.DeploymentPreferenceProperty deploymentPreference) {
            this.props().deploymentPreference(deploymentPreference);
            return this;
        }

        /**
         * An optional description of the state machine alias.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-description</a>
         * @param description An optional description of the state machine alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The name of the state machine alias.
         * <p>
         * If you don't provide a name, it uses an automatically generated name based on the logical ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-name</a>
         * @param name The name of the state machine alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The routing configuration of an alias.
         * <p>
         * Routing configuration splits <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> requests between one or two versions of the same state machine.
         * <p>
         * Use <code>RoutingConfiguration</code> if you want to explicitly set the alias <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_RoutingConfigurationListItem.html#StepFunctions-Type-RoutingConfigurationListItem-weight">weights</a> . Weight is the percentage of traffic you want to route to a state machine version.
         * <p>
         * <blockquote>
         * <p>
         * <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-routingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-routingconfiguration</a>
         * @param routingConfiguration The routing configuration of an alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfiguration(final software.amazon.awscdk.IResolvable routingConfiguration) {
            this.props().routingConfiguration(routingConfiguration);
            return this;
        }
        /**
         * The routing configuration of an alias.
         * <p>
         * Routing configuration splits <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> requests between one or two versions of the same state machine.
         * <p>
         * Use <code>RoutingConfiguration</code> if you want to explicitly set the alias <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_RoutingConfigurationListItem.html#StepFunctions-Type-RoutingConfigurationListItem-weight">weights</a> . Weight is the percentage of traffic you want to route to a state machine version.
         * <p>
         * <blockquote>
         * <p>
         * <code>RoutingConfiguration</code> and <code>DeploymentPreference</code> are mutually exclusive properties. You must define only one of these properties.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-routingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachinealias.html#cfn-stepfunctions-statemachinealias-routingconfiguration</a>
         * @param routingConfiguration The routing configuration of an alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingConfiguration(final java.util.List<? extends java.lang.Object> routingConfiguration) {
            this.props().routingConfiguration(routingConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias build() {
            return new software.amazon.awscdk.services.stepfunctions.CfnStateMachineAlias(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.CfnStateMachineAliasProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.CfnStateMachineAliasProps.Builder();
            }
            return this.props;
        }
    }
}
