package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for EmrCreateCluster.
 * <p>
 * See the RunJobFlow API for complete documentation on input parameters
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role clusterRole = Role.Builder.create(this, "ClusterRole")
 *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
 *         .build();
 * Role serviceRole = Role.Builder.create(this, "ServiceRole")
 *         .assumedBy(new ServicePrincipal("elasticmapreduce.amazonaws.com"))
 *         .build();
 * Role autoScalingRole = Role.Builder.create(this, "AutoScalingRole")
 *         .assumedBy(new ServicePrincipal("elasticmapreduce.amazonaws.com"))
 *         .build();
 * autoScalingRole.assumeRolePolicy.addStatements(
 * PolicyStatement.Builder.create()
 *         .effect(Effect.ALLOW)
 *         .principals(List.of(
 *             new ServicePrincipal("application-autoscaling.amazonaws.com")))
 *         .actions(List.of("sts:AssumeRole"))
 *         .build());
 * EmrCreateCluster.Builder.create(this, "Create Cluster")
 *         .instances(InstancesConfigProperty.builder().build())
 *         .clusterRole(clusterRole)
 *         .name(TaskInput.fromJsonPathAt("$.ClusterName").getValue())
 *         .serviceRole(serviceRole)
 *         .autoScalingRole(autoScalingRole)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.127Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateClusterProps")
@software.amazon.jsii.Jsii.Proxy(EmrCreateClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmrCreateClusterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty getInstances();

    /**
     * The Name of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A JSON string for selecting additional features.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalInfo() {
        return null;
    }

    /**
     * A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> getApplications() {
        return null;
    }

    /**
     * An IAM role for automatic scaling policies.
     * <p>
     * Default: - A role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
        return null;
    }

    /**
     * The amount of idle time after which the cluster automatically terminates.
     * <p>
     * You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).
     * <p>
     * Default: - No timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutoTerminationPolicyIdleTimeout() {
        return null;
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> getBootstrapActions() {
        return null;
    }

    /**
     * Also called instance profile and EC2 role.
     * <p>
     * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
     * <p>
     * This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
     * <p>
     * Default: - * A Role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getClusterRole() {
        return null;
    }

    /**
     * The list of configurations supplied for the EMR cluster you are creating.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
        return null;
    }

    /**
     * The ID of a custom Amazon EBS-backed Linux AMI.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return null;
    }

    /**
     * The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getEbsRootVolumeSize() {
        return null;
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty getKerberosAttributes() {
        return null;
    }

    /**
     * The location in Amazon S3 to write the log files of the job flow.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
        return null;
    }

    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseLabel() {
        return null;
    }

    /**
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * Default: - EMR selected default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior getScaleDownBehavior() {
        return null;
    }

    /**
     * The name of a security configuration to apply to the cluster.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
     * <p>
     * Default: - A role will be created that Amazon EMR service can assume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return null;
    }

    /**
     * Specifies the step concurrency level to allow multiple steps to run in parallel.
     * <p>
     * Requires EMR release label 5.28.0 or above.
     * Must be in range [1, 256].
     * <p>
     * Default: 1 - no step concurrency allowed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStepConcurrencyLevel() {
        return null;
    }

    /**
     * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVisibleToAllUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmrCreateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmrCreateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmrCreateClusterProps> {
        software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances;
        java.lang.String name;
        java.lang.String additionalInfo;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications;
        software.amazon.awscdk.services.iam.IRole autoScalingRole;
        software.amazon.awscdk.Duration autoTerminationPolicyIdleTimeout;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions;
        software.amazon.awscdk.services.iam.IRole clusterRole;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
        java.lang.String customAmiId;
        software.amazon.awscdk.Size ebsRootVolumeSize;
        software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes;
        java.lang.String logUri;
        java.lang.String releaseLabel;
        software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior;
        java.lang.String securityConfiguration;
        software.amazon.awscdk.services.iam.IRole serviceRole;
        java.lang.Number stepConcurrencyLevel;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Boolean visibleToAllUsers;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        java.lang.String inputPath;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        java.lang.String outputPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link EmrCreateClusterProps#getInstances}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getName}
         * @param name The Name of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getAdditionalInfo}
         * @param additionalInfo A JSON string for selecting additional features.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInfo(java.lang.String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getApplications}
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder applications(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications) {
            this.applications = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty>)applications;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getAutoScalingRole}
         * @param autoScalingRole An IAM role for automatic scaling policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingRole(software.amazon.awscdk.services.iam.IRole autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getAutoTerminationPolicyIdleTimeout}
         * @param autoTerminationPolicyIdleTimeout The amount of idle time after which the cluster automatically terminates.
         *                                         You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoTerminationPolicyIdleTimeout(software.amazon.awscdk.Duration autoTerminationPolicyIdleTimeout) {
            this.autoTerminationPolicyIdleTimeout = autoTerminationPolicyIdleTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getBootstrapActions}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder bootstrapActions(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions) {
            this.bootstrapActions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty>)bootstrapActions;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getClusterRole}
         * @param clusterRole Also called instance profile and EC2 role.
         *                    An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
         *                    <p>
         *                    This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterRole(software.amazon.awscdk.services.iam.IRole clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getConfigurations}
         * @param configurations The list of configurations supplied for the EMR cluster you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
            this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getCustomAmiId}
         * @param customAmiId The ID of a custom Amazon EBS-backed Linux AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAmiId(java.lang.String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getEbsRootVolumeSize}
         * @param ebsRootVolumeSize The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsRootVolumeSize(software.amazon.awscdk.Size ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getKerberosAttributes}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosAttributes(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getLogUri}
         * @param logUri The location in Amazon S3 to write the log files of the job flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logUri(java.lang.String logUri) {
            this.logUri = logUri;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getReleaseLabel}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(java.lang.String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getScaleDownBehavior}
         * @param scaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDownBehavior(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getSecurityConfiguration}
         * @param securityConfiguration The name of a security configuration to apply to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getServiceRole}
         * @param serviceRole The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getStepConcurrencyLevel}
         * @param stepConcurrencyLevel Specifies the step concurrency level to allow multiple steps to run in parallel.
         *                             Requires EMR release label 5.28.0 or above.
         *                             Must be in range [1, 256].
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepConcurrencyLevel(java.lang.Number stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getTags}
         * @param tags A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getVisibleToAllUsers}
         * @param visibleToAllUsers A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibleToAllUsers(java.lang.Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmrCreateClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmrCreateClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmrCreateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmrCreateClusterProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances;
        private final java.lang.String name;
        private final java.lang.String additionalInfo;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications;
        private final software.amazon.awscdk.services.iam.IRole autoScalingRole;
        private final software.amazon.awscdk.Duration autoTerminationPolicyIdleTimeout;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions;
        private final software.amazon.awscdk.services.iam.IRole clusterRole;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
        private final java.lang.String customAmiId;
        private final software.amazon.awscdk.Size ebsRootVolumeSize;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes;
        private final java.lang.String logUri;
        private final java.lang.String releaseLabel;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior;
        private final java.lang.String securityConfiguration;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;
        private final java.lang.Number stepConcurrencyLevel;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean visibleToAllUsers;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalInfo = software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applications = software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty.class)));
            this.autoScalingRole = software.amazon.jsii.Kernel.get(this, "autoScalingRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.autoTerminationPolicyIdleTimeout = software.amazon.jsii.Kernel.get(this, "autoTerminationPolicyIdleTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.bootstrapActions = software.amazon.jsii.Kernel.get(this, "bootstrapActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty.class)));
            this.clusterRole = software.amazon.jsii.Kernel.get(this, "clusterRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
            this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsRootVolumeSize = software.amazon.jsii.Kernel.get(this, "ebsRootVolumeSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.kerberosAttributes = software.amazon.jsii.Kernel.get(this, "kerberosAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty.class));
            this.logUri = software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseLabel = software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleDownBehavior = software.amazon.jsii.Kernel.get(this, "scaleDownBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior.class));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.stepConcurrencyLevel = software.amazon.jsii.Kernel.get(this, "stepConcurrencyLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.visibleToAllUsers = software.amazon.jsii.Kernel.get(this, "visibleToAllUsers", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instances = java.util.Objects.requireNonNull(builder.instances, "instances is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.additionalInfo = builder.additionalInfo;
            this.applications = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty>)builder.applications;
            this.autoScalingRole = builder.autoScalingRole;
            this.autoTerminationPolicyIdleTimeout = builder.autoTerminationPolicyIdleTimeout;
            this.bootstrapActions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty>)builder.bootstrapActions;
            this.clusterRole = builder.clusterRole;
            this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)builder.configurations;
            this.customAmiId = builder.customAmiId;
            this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
            this.kerberosAttributes = builder.kerberosAttributes;
            this.logUri = builder.logUri;
            this.releaseLabel = builder.releaseLabel;
            this.scaleDownBehavior = builder.scaleDownBehavior;
            this.securityConfiguration = builder.securityConfiguration;
            this.serviceRole = builder.serviceRole;
            this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
            this.tags = builder.tags;
            this.visibleToAllUsers = builder.visibleToAllUsers;
            this.comment = builder.comment;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.inputPath = builder.inputPath;
            this.integrationPattern = builder.integrationPattern;
            this.outputPath = builder.outputPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.stateName = builder.stateName;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty getInstances() {
            return this.instances;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> getApplications() {
            return this.applications;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutoTerminationPolicyIdleTimeout() {
            return this.autoTerminationPolicyIdleTimeout;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> getBootstrapActions() {
            return this.bootstrapActions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getClusterRole() {
            return this.clusterRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final java.lang.String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final software.amazon.awscdk.Size getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty getKerberosAttributes() {
            return this.kerberosAttributes;
        }

        @Override
        public final java.lang.String getLogUri() {
            return this.logUri;
        }

        @Override
        public final java.lang.String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final java.lang.Number getStepConcurrencyLevel() {
            return this.stepConcurrencyLevel;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instances", om.valueToTree(this.getInstances()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAdditionalInfo() != null) {
                data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
            }
            if (this.getApplications() != null) {
                data.set("applications", om.valueToTree(this.getApplications()));
            }
            if (this.getAutoScalingRole() != null) {
                data.set("autoScalingRole", om.valueToTree(this.getAutoScalingRole()));
            }
            if (this.getAutoTerminationPolicyIdleTimeout() != null) {
                data.set("autoTerminationPolicyIdleTimeout", om.valueToTree(this.getAutoTerminationPolicyIdleTimeout()));
            }
            if (this.getBootstrapActions() != null) {
                data.set("bootstrapActions", om.valueToTree(this.getBootstrapActions()));
            }
            if (this.getClusterRole() != null) {
                data.set("clusterRole", om.valueToTree(this.getClusterRole()));
            }
            if (this.getConfigurations() != null) {
                data.set("configurations", om.valueToTree(this.getConfigurations()));
            }
            if (this.getCustomAmiId() != null) {
                data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
            }
            if (this.getEbsRootVolumeSize() != null) {
                data.set("ebsRootVolumeSize", om.valueToTree(this.getEbsRootVolumeSize()));
            }
            if (this.getKerberosAttributes() != null) {
                data.set("kerberosAttributes", om.valueToTree(this.getKerberosAttributes()));
            }
            if (this.getLogUri() != null) {
                data.set("logUri", om.valueToTree(this.getLogUri()));
            }
            if (this.getReleaseLabel() != null) {
                data.set("releaseLabel", om.valueToTree(this.getReleaseLabel()));
            }
            if (this.getScaleDownBehavior() != null) {
                data.set("scaleDownBehavior", om.valueToTree(this.getScaleDownBehavior()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            if (this.getStepConcurrencyLevel() != null) {
                data.set("stepConcurrencyLevel", om.valueToTree(this.getStepConcurrencyLevel()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisibleToAllUsers() != null) {
                data.set("visibleToAllUsers", om.valueToTree(this.getVisibleToAllUsers()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EmrCreateClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmrCreateClusterProps.Jsii$Proxy that = (EmrCreateClusterProps.Jsii$Proxy) o;

            if (!instances.equals(that.instances)) return false;
            if (!name.equals(that.name)) return false;
            if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
            if (this.applications != null ? !this.applications.equals(that.applications) : that.applications != null) return false;
            if (this.autoScalingRole != null ? !this.autoScalingRole.equals(that.autoScalingRole) : that.autoScalingRole != null) return false;
            if (this.autoTerminationPolicyIdleTimeout != null ? !this.autoTerminationPolicyIdleTimeout.equals(that.autoTerminationPolicyIdleTimeout) : that.autoTerminationPolicyIdleTimeout != null) return false;
            if (this.bootstrapActions != null ? !this.bootstrapActions.equals(that.bootstrapActions) : that.bootstrapActions != null) return false;
            if (this.clusterRole != null ? !this.clusterRole.equals(that.clusterRole) : that.clusterRole != null) return false;
            if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
            if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
            if (this.ebsRootVolumeSize != null ? !this.ebsRootVolumeSize.equals(that.ebsRootVolumeSize) : that.ebsRootVolumeSize != null) return false;
            if (this.kerberosAttributes != null ? !this.kerberosAttributes.equals(that.kerberosAttributes) : that.kerberosAttributes != null) return false;
            if (this.logUri != null ? !this.logUri.equals(that.logUri) : that.logUri != null) return false;
            if (this.releaseLabel != null ? !this.releaseLabel.equals(that.releaseLabel) : that.releaseLabel != null) return false;
            if (this.scaleDownBehavior != null ? !this.scaleDownBehavior.equals(that.scaleDownBehavior) : that.scaleDownBehavior != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (this.stepConcurrencyLevel != null ? !this.stepConcurrencyLevel.equals(that.stepConcurrencyLevel) : that.stepConcurrencyLevel != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.visibleToAllUsers != null ? !this.visibleToAllUsers.equals(that.visibleToAllUsers) : that.visibleToAllUsers != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instances.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
            result = 31 * result + (this.applications != null ? this.applications.hashCode() : 0);
            result = 31 * result + (this.autoScalingRole != null ? this.autoScalingRole.hashCode() : 0);
            result = 31 * result + (this.autoTerminationPolicyIdleTimeout != null ? this.autoTerminationPolicyIdleTimeout.hashCode() : 0);
            result = 31 * result + (this.bootstrapActions != null ? this.bootstrapActions.hashCode() : 0);
            result = 31 * result + (this.clusterRole != null ? this.clusterRole.hashCode() : 0);
            result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
            result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
            result = 31 * result + (this.ebsRootVolumeSize != null ? this.ebsRootVolumeSize.hashCode() : 0);
            result = 31 * result + (this.kerberosAttributes != null ? this.kerberosAttributes.hashCode() : 0);
            result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
            result = 31 * result + (this.releaseLabel != null ? this.releaseLabel.hashCode() : 0);
            result = 31 * result + (this.scaleDownBehavior != null ? this.scaleDownBehavior.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.stepConcurrencyLevel != null ? this.stepConcurrencyLevel.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visibleToAllUsers != null ? this.visibleToAllUsers.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
