package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTrainingJob.Builder.create(this, "TrainSagemaker")
 *         .trainingJobName(JsonPath.stringAt("$.JobName"))
 *         .algorithmSpecification(AlgorithmSpecification.builder()
 *                 .algorithmName("BlazingText")
 *                 .trainingInputMode(InputMode.FILE)
 *                 .build())
 *         .inputDataConfig(List.of(Channel.builder()
 *                 .channelName("train")
 *                 .dataSource(DataSource.builder()
 *                         .s3DataSource(S3DataSource.builder()
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .s3Location(S3Location.fromJsonExpression("$.S3Bucket"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .outputDataConfig(OutputDataConfig.builder()
 *                 .s3OutputLocation(S3Location.fromBucket(Bucket.fromBucketName(this, "Bucket", "amzn-s3-demo-bucket"), "myoutputpath"))
 *                 .build())
 *         .resourceConfig(ResourceConfig.builder()
 *                 .instanceCount(1)
 *                 .instanceType(new InstanceType(JsonPath.stringAt("$.InstanceType")))
 *                 .volumeSize(Size.gibibytes(50))
 *                 .build()) // optional: default is 1 instance of EC2 `M4.XLarge` with `10GB` volume
 *         .stoppingCondition(StoppingCondition.builder()
 *                 .maxRuntime(Duration.hours(2))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.179Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ResourceConfig")
@software.amazon.jsii.Jsii.Proxy(ResourceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of ML compute instances to use.
     * <p>
     * Default: 1 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

    /**
     * ML compute instance type.
     * <p>
     * To provide an instance type from the task input, supply an instance type in the following way
     * where the value in the task input is an EC2 instance type prepended with "ml.":
     * <p>
     * <blockquote><pre>
     * new InstanceType(JsonPath.stringAt("$.path.to.instanceType"));
     * </pre></blockquote>
     * <p>
     * Default: ec2.InstanceType(ec2.InstanceClass.M4, ec2.InstanceType.XLARGE)
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceConfig.html#sagemaker-Type-ResourceConfig-InstanceType">https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceConfig.html#sagemaker-Type-ResourceConfig-InstanceType</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Size of the ML storage volume that you want to provision.
     * <p>
     * Default: 10 GB EBS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getVolumeSize();

    /**
     * KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
     * <p>
     * Default: - Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getVolumeEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceConfig> {
        java.lang.Number instanceCount;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.Size volumeSize;
        software.amazon.awscdk.services.kms.IKey volumeEncryptionKey;

        /**
         * Sets the value of {@link ResourceConfig#getInstanceCount}
         * @param instanceCount The number of ML compute instances to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCount(java.lang.Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getInstanceType}
         * @param instanceType ML compute instance type. This parameter is required.
         *                     To provide an instance type from the task input, supply an instance type in the following way
         *                     where the value in the task input is an EC2 instance type prepended with "ml.":
         *                     <p>
         *                     <blockquote><pre>
         *                     new InstanceType(JsonPath.stringAt("$.path.to.instanceType"));
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getVolumeSize}
         * @param volumeSize Size of the ML storage volume that you want to provision. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeSize(software.amazon.awscdk.Size volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getVolumeEncryptionKey}
         * @param volumeEncryptionKey KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeEncryptionKey(software.amazon.awscdk.services.kms.IKey volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceConfig {
        private final java.lang.Number instanceCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.Size volumeSize;
        private final software.amazon.awscdk.services.kms.IKey volumeEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.volumeEncryptionKey = software.amazon.jsii.Kernel.get(this, "volumeEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.volumeSize = java.util.Objects.requireNonNull(builder.volumeSize, "volumeSize is required");
            this.volumeEncryptionKey = builder.volumeEncryptionKey;
        }

        @Override
        public final java.lang.Number getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.Size getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
            if (this.getVolumeEncryptionKey() != null) {
                data.set("volumeEncryptionKey", om.valueToTree(this.getVolumeEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.ResourceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceConfig.Jsii$Proxy that = (ResourceConfig.Jsii$Proxy) o;

            if (!instanceCount.equals(that.instanceCount)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (!volumeSize.equals(that.volumeSize)) return false;
            return this.volumeEncryptionKey != null ? this.volumeEncryptionKey.equals(that.volumeEncryptionKey) : that.volumeEncryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceCount.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.volumeSize.hashCode());
            result = 31 * result + (this.volumeEncryptionKey != null ? this.volumeEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
