package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The information about the retry policy settings.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.scheduler.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * CfnScheduleGroup scheduleGroup;
 * Queue targetQueue;
 * Queue deadLetterQueue;
 * Role schedulerRole = Role.Builder.create(this, "SchedulerRole")
 *         .assumedBy(new ServicePrincipal("scheduler.amazonaws.com"))
 *         .build();
 * // To send the message to the queue
 * // This policy changes depending on the type of target.
 * schedulerRole.addToPrincipalPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("sqs:SendMessage"))
 *         .resources(List.of(targetQueue.getQueueArn()))
 *         .build());
 * EventBridgeSchedulerCreateScheduleTask createScheduleTask1 = EventBridgeSchedulerCreateScheduleTask.Builder.create(this, "createSchedule")
 *         .scheduleName("TestSchedule")
 *         .actionAfterCompletion(ActionAfterCompletion.NONE)
 *         .clientToken("testToken")
 *         .description("TestDescription")
 *         .startDate(new Date())
 *         .endDate(new Date(new Date().getTime() + 1000 * 60 * 60))
 *         .flexibleTimeWindow(Duration.minutes(5))
 *         .groupName(scheduleGroup.getRef())
 *         .kmsKey(key)
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .timezone("UTC")
 *         .enabled(true)
 *         .target(EventBridgeSchedulerTarget.Builder.create()
 *                 .arn(targetQueue.getQueueArn())
 *                 .role(schedulerRole)
 *                 .retryPolicy(RetryPolicy.builder()
 *                         .maximumRetryAttempts(2)
 *                         .maximumEventAge(Duration.minutes(5))
 *                         .build())
 *                 .deadLetterQueue(deadLetterQueue)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.180Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.RetryPolicy")
@software.amazon.jsii.Jsii.Proxy(RetryPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RetryPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum amount of time to continue to make retry attempts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getMaximumEventAge();

    /**
     * The maximum number of retry attempts to make before the request fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaximumRetryAttempts();

    /**
     * @return a {@link Builder} of {@link RetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RetryPolicy> {
        software.amazon.awscdk.Duration maximumEventAge;
        java.lang.Number maximumRetryAttempts;

        /**
         * Sets the value of {@link RetryPolicy#getMaximumEventAge}
         * @param maximumEventAge The maximum amount of time to continue to make retry attempts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumEventAge(software.amazon.awscdk.Duration maximumEventAge) {
            this.maximumEventAge = maximumEventAge;
            return this;
        }

        /**
         * Sets the value of {@link RetryPolicy#getMaximumRetryAttempts}
         * @param maximumRetryAttempts The maximum number of retry attempts to make before the request fails. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RetryPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RetryPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryPolicy {
        private final software.amazon.awscdk.Duration maximumEventAge;
        private final java.lang.Number maximumRetryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maximumEventAge = software.amazon.jsii.Kernel.get(this, "maximumEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maximumEventAge = java.util.Objects.requireNonNull(builder.maximumEventAge, "maximumEventAge is required");
            this.maximumRetryAttempts = java.util.Objects.requireNonNull(builder.maximumRetryAttempts, "maximumRetryAttempts is required");
        }

        @Override
        public final software.amazon.awscdk.Duration getMaximumEventAge() {
            return this.maximumEventAge;
        }

        @Override
        public final java.lang.Number getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maximumEventAge", om.valueToTree(this.getMaximumEventAge()));
            data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.RetryPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RetryPolicy.Jsii$Proxy that = (RetryPolicy.Jsii$Proxy) o;

            if (!maximumEventAge.equals(that.maximumEventAge)) return false;
            return this.maximumRetryAttempts.equals(that.maximumRetryAttempts);
        }

        @Override
        public final int hashCode() {
            int result = this.maximumEventAge.hashCode();
            result = 31 * result + (this.maximumRetryAttempts.hashCode());
            return result;
        }
    }
}
