package software.amazon.awscdk.services.synthetics;

/**
 * Runtime options for a canary.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_6_2)
 *         .memory(Size.mebibytes(1024))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.261Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        SYNTHETICS_NODEJS_PUPPETEER_3_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_4_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_4_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_5_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_5_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_5_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_5_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_5_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_5_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_6_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_6_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_6_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_6_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_6_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_6_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_7_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_7_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_8_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_8_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_9_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_9_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_9_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_9_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_4_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_4_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
    }

    /**
     * @param name The name of the runtime version. This parameter is required.
     * @param family The Lambda runtime family. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Runtime(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily family) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(family, "family is required") });
    }

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-3.5</code> includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 5.5.0 - Chromium version 92.0.4512.
     * <p>
     * New features:
     * <p>
     * <ul>
     * <li><strong>Updated dependencies</strong>: The only new features in this runtime are the updated dependencies.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_5;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-3.6</code> includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 5.5.0 - Chromium version 92.0.4512.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.6">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.6</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_6;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-3.7</code> includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 5.5.0 - Chromium version 92.0.4512.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Logging enhancement</strong>: The canary will upload logs to Amazon S3 even if it times out or crashes.</li>
     * <li><strong>Lambda layer size reduced</strong>: The size of the Lambda layer used for canaries is reduced by 34%.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.7">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.7</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_7;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-3.8</code> includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 10.1.0 - Chromium version 92.0.4512.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Profile cleanup</strong>: Chromium profiles are now cleaned up after each canary run.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.8">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.8</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_8;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-3.9</code> includes the following:.
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 14.x</li>
     * <li>Puppeteer-core version 5.5.0</li>
     * <li>Chromium version 92.0.4512</li>
     * </ul>
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Dependency upgrades</strong>: Upgrades some third-party dependency packages.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.9">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.9</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_9;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-4.0</code> includes the following: - Lambda runtime Node.js 16.x - Puppeteer-core version 5.5.0 - Chromium version 92.0.4512.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Dependency upgrades</strong>: The Node.js dependency is updated to 16.x.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-4.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-4.0</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_4_0;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-5.0</code> includes the following: - Lambda runtime Node.js 16.x - Puppeteer-core version 19.7.0 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Dependency upgrade</strong>: The Puppeteer-core version is updated to 19.7.0. The Chromium version is upgraded to 111.0.5563.146.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-5.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-5.0</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_5_0;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-5.1</code> includes the following: - Lambda runtime Node.js 16.x - Puppeteer-core version 19.7.0 - Chromium version 111.0.5563.146.
     * <p>
     * Bug fixes:
     * <p>
     * <ul>
     * <li><strong>Bug fix</strong>: This runtime fixes a bug in <code>syn-nodejs-puppeteer-5.0</code> where the HAR files created by the canaries were missing request headers.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-5.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-5.1</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_5_1;

    /**
     * <code>syn-nodejs-puppeteer-5.2</code> includes the following: - Lambda runtime Node.js 16.x - Puppeteer-core version 19.7.0 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated versions of the bundled libraries in Chromium</strong></li>
     * <li><strong>Bug fixes</strong></li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-5.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-5.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_5_2;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-6.0</code> includes the following: - Lambda runtime Node.js 18.x - Puppeteer-core version 19.7.0 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Dependency upgrade</strong>: The Node.js dependency is upgraded to 18.x.
     * Bug fixes:</li>
     * <li><strong>Bug fix</strong>: Clean up core dump generated when Chromium crashes during a canary run.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-6.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-6.0</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_6_0;

    /**
     * (deprecated) <code>syn-nodejs-puppeteer-6.1</code> includes the following: - Lambda runtime Node.js 18.x - Puppeteer-core version 19.7.0 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * * **Stability improvements**: Added auto-retry logic for handling intermittent Puppeteer launch errors.
     * * **Dependency upgrades**: Upgrades for some third-party dependency packages.
     * * **Canaries without Amazon S3 permissions**: Bug fixes, such that canaries that don't have any Amazon S3 permissions can still run. These canaries with no Amazon S3 permissions won't be able to upload screenshots or other artifacts to Amazon S3. For more information about permissions for canaries, see {@link https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_CanaryPermissions.html Required roles and permissions for canaries}.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-6.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-6.1</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest NodeJS Puppeteer runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_6_1;

    /**
     * <code>syn-nodejs-puppeteer-6.2</code> includes the following: - Lambda runtime Node.js 18.x - Puppeteer-core version 19.7.0 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated versions of the bundled libraries in Chromium</strong></li>
     * <li><strong>Ephemeral storage monitoring</strong>: This runtime adds ephemeral storage monitoring in customer accounts.</li>
     * <li><strong>Bug fixes</strong></li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-6.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-6.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_6_2;

    /**
     * <code>syn-nodejs-puppeteer-7.0</code> includes the following: - Lambda runtime Node.js 18.x - Puppeteer-core version 21.9.0 - Chromium version 121.0.6167.139.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated versions of the bundled libraries in Puppeteer and Chromium</strong>: The Puppeteer and Chromium dependencies are updated to new versions.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-7.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-7.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_7_0;

    /**
     * <code>syn-nodejs-puppeteer-8.0</code> includes the following: - Lambda runtime Node.js 20.x - Puppeteer-core version 22.10.0 - Chromium version 125.0.6422.112.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Support for two-factor authentication</strong></li>
     * <li><strong>Bug fixes</strong> for situations where some service clients were losing data in Node.js SDK V3 responses.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-8.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-8.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_8_0;

    /**
     * <code>syn-nodejs-puppeteer-9.0</code> includes the following: - Lambda runtime Node.js 20.x - Puppeteer-core version 22.12.1 - Chromium version 126.0.6478.126.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Bug fixes</strong> Bug fix to enable visual monitoring capabilities.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-9.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-9.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_9_0;

    /**
     * <code>syn-nodejs-puppeteer-9.1</code> includes the following: - Lambda runtime Node.js 20.x - Puppeteer-core version 22.12.1 - Chromium version 126.0.6478.126.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Bug fixes</strong> Bug fix related to date ranges and pending requests in HAR files.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-9.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-9.1</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_9_1;

    /**
     * (deprecated) <code>syn-python-selenium-1.0</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 83.0.4103.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.0</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python Selenium runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_1_0;

    /**
     * (deprecated) <code>syn-python-selenium-1.1</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 83.0.4103.0.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Custom handler function</strong>: You can now use a custom handler function for your canary scripts.</li>
     * <li><strong>Configuration options for adding metrics and step failure configurations</strong>: These options were already available in runtimes for Node.js canaries.</li>
     * <li><strong>Custom arguments in Chrome</strong>: You can now open a browser in incognito mode or pass in proxy server configuration.</li>
     * <li><strong>Cross-Region artifact buckets</strong>: A canary can store its artifacts in an Amazon S3 bucket in a different Region.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.1</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python Selenium runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_1_1;

    /**
     * (deprecated) <code>syn-python-selenium-1.2</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 92.0.4512.0.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated dependencies</strong>: The only new features in this runtime are the updated dependencies.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.2</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python Selenium runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_1_2;

    /**
     * (deprecated) <code>syn-python-selenium-1.3</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 92.0.4512.0.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>More precise timestamps</strong>: The start time and stop time of canary runs are now precise to the millisecond.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.3">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.3</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python Selenium runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_1_3;

    /**
     * (deprecated) <code>syn-python-selenium-2.0</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 4.10.0 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated dependencies</strong>: The Chromium and Selenium dependencies are updated to new versions.</li>
     * <li><strong>More precise timestamps</strong>: The start time and stop time of canary runs are now precise to the millisecond.</li>
     * </ul>
     * <p>
     * Bug fixes:
     * <p>
     * <ul>
     * <li><strong>Timestamp added</strong>: A timestamp has been added to canary logs.</li>
     * <li><strong>Session re-use</strong>: A bug was fixed so that canaries are now prevented from reusing the session from their previous canary run.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-2.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-2.0</a>
     * @deprecated Legacy runtime no longer supported by AWS Lambda. Migrate to the latest Python Selenium runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_2_0;

    /**
     * <code>syn-python-selenium-2.1</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 4.15.1 - Chromium version 111.0.5563.146.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated versions of the bundled libraries in Chromium</strong>: The Chromium and Selenium dependencies are updated to new versions.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-2.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-2.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_2_1;

    /**
     * <code>syn-python-selenium-3.0</code> includes the following: - Lambda runtime Python 3.8 - Selenium version 4.15.1 - Chromium version 121.0.6167.139.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated versions of the bundled libraries in Chromium</strong>: The Chromium dependency is updated to a new version.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-3.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-3.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_3_0;

    /**
     * <code>syn-python-selenium-4.0</code> includes the following: - Lambda runtime Python 3.9 - Selenium version 4.15.1 - Chromium version 126.0.6478.126.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Bug fixes</strong> for errors in HAR parser logging.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-4.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-4.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_4_0;

    /**
     * The Lambda runtime family.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.RuntimeFamily.class));
    }

    /**
     * The name of the runtime version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
