package software.amazon.awscdk.services.transfer;

/**
 * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes.
 * <p>
 * After creating a workflow, you can associate the workflow created with any transfer servers by specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code> operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * Object copyStepDetails;
 * Object customStepDetails;
 * Object deleteStepDetails;
 * Object tagStepDetails;
 * CfnWorkflow cfnWorkflow = CfnWorkflow.Builder.create(this, "MyCfnWorkflow")
 *         .steps(List.of(WorkflowStepProperty.builder()
 *                 .copyStepDetails(copyStepDetails)
 *                 .customStepDetails(customStepDetails)
 *                 .decryptStepDetails(DecryptStepDetailsProperty.builder()
 *                         .destinationFileLocation(InputFileLocationProperty.builder()
 *                                 .efsFileLocation(EfsInputFileLocationProperty.builder()
 *                                         .fileSystemId("fileSystemId")
 *                                         .path("path")
 *                                         .build())
 *                                 .s3FileLocation(S3InputFileLocationProperty.builder()
 *                                         .bucket("bucket")
 *                                         .key("key")
 *                                         .build())
 *                                 .build())
 *                         .type("type")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .overwriteExisting("overwriteExisting")
 *                         .sourceFileLocation("sourceFileLocation")
 *                         .build())
 *                 .deleteStepDetails(deleteStepDetails)
 *                 .tagStepDetails(tagStepDetails)
 *                 .type("type")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .onExceptionSteps(List.of(WorkflowStepProperty.builder()
 *                 .copyStepDetails(copyStepDetails)
 *                 .customStepDetails(customStepDetails)
 *                 .decryptStepDetails(DecryptStepDetailsProperty.builder()
 *                         .destinationFileLocation(InputFileLocationProperty.builder()
 *                                 .efsFileLocation(EfsInputFileLocationProperty.builder()
 *                                         .fileSystemId("fileSystemId")
 *                                         .path("path")
 *                                         .build())
 *                                 .s3FileLocation(S3InputFileLocationProperty.builder()
 *                                         .bucket("bucket")
 *                                         .key("key")
 *                                         .build())
 *                                 .build())
 *                         .type("type")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .overwriteExisting("overwriteExisting")
 *                         .sourceFileLocation("sourceFileLocation")
 *                         .build())
 *                 .deleteStepDetails(deleteStepDetails)
 *                 .tagStepDetails(tagStepDetails)
 *                 .type("type")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-27T16:51:06.339Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow")
public class CfnWorkflow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnWorkflow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkflow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnWorkflow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkflow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnWorkflowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Specifies the unique Amazon Resource Name (ARN) for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for a workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkflowId() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkflowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSteps() {
        return software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.transfer.CfnWorkflow.WorkflowStepProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.transfer.CfnWorkflow.WorkflowStepProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * Specifies the text description for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the text description for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnExceptionSteps() {
        return software.amazon.jsii.Kernel.get(this, "onExceptionSteps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnExceptionSteps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onExceptionSteps", value);
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnExceptionSteps(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.transfer.CfnWorkflow.WorkflowStepProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.transfer.CfnWorkflow.WorkflowStepProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "onExceptionSteps", value);
    }

    /**
     * Key-value pairs that can be used to group and search for workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to group and search for workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Details for a step that performs a file copy.
     * <p>
     * Consists of the following values:
     * <p>
     * <ul>
     * <li>A description</li>
     * <li>An Amazon S3 location for the destination of the file copy.</li>
     * <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * CopyStepDetailsProperty copyStepDetailsProperty = CopyStepDetailsProperty.builder()
     *         .destinationFileLocation(S3FileLocationProperty.builder()
     *                 .s3FileLocation(S3InputFileLocationProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .name("name")
     *         .overwriteExisting("overwriteExisting")
     *         .sourceFileLocation("sourceFileLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.CopyStepDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CopyStepDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CopyStepDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location for the file being copied.
         * <p>
         * Use <code>${Transfer:UserName}</code> or <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded date.
         * <p>
         * <ul>
         * <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to copy uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.</li>
         * <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to copy uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The system resolves <code>UploadDate</code> to a date format of <em>YYYY-MM-DD</em> , based on the date the file is uploaded in UTC.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-destinationfilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-destinationfilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationFileLocation() {
            return null;
        }

        /**
         * The name of the step, used as an identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .
         * <p>
         * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
         * <p>
         * <ul>
         * <li>If <code>OverwriteExisting</code> is <code>TRUE</code> , the existing file is replaced with the file being processed.</li>
         * <li>If <code>OverwriteExisting</code> is <code>FALSE</code> , nothing happens, and the workflow processing stops.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-overwriteexisting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-overwriteexisting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOverwriteExisting() {
            return null;
        }

        /**
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
         * <p>
         * <ul>
         * <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
         * <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-sourcefilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-copystepdetails.html#cfn-transfer-workflow-copystepdetails-sourcefilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceFileLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CopyStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CopyStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CopyStepDetailsProperty> {
            java.lang.Object destinationFileLocation;
            java.lang.String name;
            java.lang.String overwriteExisting;
            java.lang.String sourceFileLocation;

            /**
             * Sets the value of {@link CopyStepDetailsProperty#getDestinationFileLocation}
             * @param destinationFileLocation Specifies the location for the file being copied.
             *                                Use <code>${Transfer:UserName}</code> or <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded date.
             *                                <p>
             *                                <ul>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to copy uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.</li>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to copy uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.</li>
             *                                </ul>
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                The system resolves <code>UploadDate</code> to a date format of <em>YYYY-MM-DD</em> , based on the date the file is uploaded in UTC.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationFileLocation(software.amazon.awscdk.IResolvable destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link CopyStepDetailsProperty#getDestinationFileLocation}
             * @param destinationFileLocation Specifies the location for the file being copied.
             *                                Use <code>${Transfer:UserName}</code> or <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded date.
             *                                <p>
             *                                <ul>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to copy uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.</li>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to copy uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.</li>
             *                                </ul>
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                The system resolves <code>UploadDate</code> to a date format of <em>YYYY-MM-DD</em> , based on the date the file is uploaded in UTC.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationFileLocation(software.amazon.awscdk.services.transfer.CfnWorkflow.S3FileLocationProperty destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link CopyStepDetailsProperty#getName}
             * @param name The name of the step, used as an identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CopyStepDetailsProperty#getOverwriteExisting}
             * @param overwriteExisting A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .
             *                          If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
             *                          <p>
             *                          <ul>
             *                          <li>If <code>OverwriteExisting</code> is <code>TRUE</code> , the existing file is replaced with the file being processed.</li>
             *                          <li>If <code>OverwriteExisting</code> is <code>FALSE</code> , nothing happens, and the workflow processing stops.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteExisting(java.lang.String overwriteExisting) {
                this.overwriteExisting = overwriteExisting;
                return this;
            }

            /**
             * Sets the value of {@link CopyStepDetailsProperty#getSourceFileLocation}
             * @param sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
             *                           <ul>
             *                           <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
             *                           <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFileLocation(java.lang.String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CopyStepDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CopyStepDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CopyStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyStepDetailsProperty {
            private final java.lang.Object destinationFileLocation;
            private final java.lang.String name;
            private final java.lang.String overwriteExisting;
            private final java.lang.String sourceFileLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationFileLocation = software.amazon.jsii.Kernel.get(this, "destinationFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteExisting = software.amazon.jsii.Kernel.get(this, "overwriteExisting", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceFileLocation = software.amazon.jsii.Kernel.get(this, "sourceFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationFileLocation = builder.destinationFileLocation;
                this.name = builder.name;
                this.overwriteExisting = builder.overwriteExisting;
                this.sourceFileLocation = builder.sourceFileLocation;
            }

            @Override
            public final java.lang.Object getDestinationFileLocation() {
                return this.destinationFileLocation;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getOverwriteExisting() {
                return this.overwriteExisting;
            }

            @Override
            public final java.lang.String getSourceFileLocation() {
                return this.sourceFileLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationFileLocation() != null) {
                    data.set("destinationFileLocation", om.valueToTree(this.getDestinationFileLocation()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getOverwriteExisting() != null) {
                    data.set("overwriteExisting", om.valueToTree(this.getOverwriteExisting()));
                }
                if (this.getSourceFileLocation() != null) {
                    data.set("sourceFileLocation", om.valueToTree(this.getSourceFileLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.CopyStepDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CopyStepDetailsProperty.Jsii$Proxy that = (CopyStepDetailsProperty.Jsii$Proxy) o;

                if (this.destinationFileLocation != null ? !this.destinationFileLocation.equals(that.destinationFileLocation) : that.destinationFileLocation != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.overwriteExisting != null ? !this.overwriteExisting.equals(that.overwriteExisting) : that.overwriteExisting != null) return false;
                return this.sourceFileLocation != null ? this.sourceFileLocation.equals(that.sourceFileLocation) : that.sourceFileLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationFileLocation != null ? this.destinationFileLocation.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.overwriteExisting != null ? this.overwriteExisting.hashCode() : 0);
                result = 31 * result + (this.sourceFileLocation != null ? this.sourceFileLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for a step that invokes an AWS Lambda function.
     * <p>
     * Consists of the Lambda function's name, target, and timeout (in seconds).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * CustomStepDetailsProperty customStepDetailsProperty = CustomStepDetailsProperty.builder()
     *         .name("name")
     *         .sourceFileLocation("sourceFileLocation")
     *         .target("target")
     *         .timeoutSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.CustomStepDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomStepDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomStepDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the step, used as an identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
         * <p>
         * <ul>
         * <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
         * <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-sourcefilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-sourcefilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceFileLocation() {
            return null;
        }

        /**
         * The ARN for the Lambda function that is being called.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
            return null;
        }

        /**
         * Timeout, in seconds, for the step.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-timeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-customstepdetails.html#cfn-transfer-workflow-customstepdetails-timeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomStepDetailsProperty> {
            java.lang.String name;
            java.lang.String sourceFileLocation;
            java.lang.String target;
            java.lang.Number timeoutSeconds;

            /**
             * Sets the value of {@link CustomStepDetailsProperty#getName}
             * @param name The name of the step, used as an identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CustomStepDetailsProperty#getSourceFileLocation}
             * @param sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
             *                           <ul>
             *                           <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
             *                           <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFileLocation(java.lang.String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link CustomStepDetailsProperty#getTarget}
             * @param target The ARN for the Lambda function that is being called.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CustomStepDetailsProperty#getTimeoutSeconds}
             * @param timeoutSeconds Timeout, in seconds, for the step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutSeconds(java.lang.Number timeoutSeconds) {
                this.timeoutSeconds = timeoutSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomStepDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomStepDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomStepDetailsProperty {
            private final java.lang.String name;
            private final java.lang.String sourceFileLocation;
            private final java.lang.String target;
            private final java.lang.Number timeoutSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceFileLocation = software.amazon.jsii.Kernel.get(this, "sourceFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutSeconds = software.amazon.jsii.Kernel.get(this, "timeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.sourceFileLocation = builder.sourceFileLocation;
                this.target = builder.target;
                this.timeoutSeconds = builder.timeoutSeconds;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSourceFileLocation() {
                return this.sourceFileLocation;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Number getTimeoutSeconds() {
                return this.timeoutSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSourceFileLocation() != null) {
                    data.set("sourceFileLocation", om.valueToTree(this.getSourceFileLocation()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }
                if (this.getTimeoutSeconds() != null) {
                    data.set("timeoutSeconds", om.valueToTree(this.getTimeoutSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.CustomStepDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomStepDetailsProperty.Jsii$Proxy that = (CustomStepDetailsProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.sourceFileLocation != null ? !this.sourceFileLocation.equals(that.sourceFileLocation) : that.sourceFileLocation != null) return false;
                if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
                return this.timeoutSeconds != null ? this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.sourceFileLocation != null ? this.sourceFileLocation.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                result = 31 * result + (this.timeoutSeconds != null ? this.timeoutSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for a step that decrypts an encrypted file.
     * <p>
     * Consists of the following values:
     * <p>
     * <ul>
     * <li>A descriptive name</li>
     * <li>An Amazon S3 or Amazon Elastic File System (Amazon EFS) location for the source file to decrypt.</li>
     * <li>An S3 or Amazon EFS location for the destination of the file decryption.</li>
     * <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
     * <li>The type of encryption that's used. Currently, only PGP encryption is supported.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * DecryptStepDetailsProperty decryptStepDetailsProperty = DecryptStepDetailsProperty.builder()
     *         .destinationFileLocation(InputFileLocationProperty.builder()
     *                 .efsFileLocation(EfsInputFileLocationProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         .path("path")
     *                         .build())
     *                 .s3FileLocation(S3InputFileLocationProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .type("type")
     *         // the properties below are optional
     *         .name("name")
     *         .overwriteExisting("overwriteExisting")
     *         .sourceFileLocation("sourceFileLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.DecryptStepDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(DecryptStepDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecryptStepDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location for the file being decrypted.
         * <p>
         * Use <code>${Transfer:UserName}</code> or <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded date.
         * <p>
         * <ul>
         * <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.</li>
         * <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The system resolves <code>UploadDate</code> to a date format of <em>YYYY-MM-DD</em> , based on the date the file is uploaded in UTC.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-destinationfilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-destinationfilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationFileLocation();

        /**
         * The type of encryption used.
         * <p>
         * Currently, this value must be <code>PGP</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The name of the step, used as an identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .
         * <p>
         * If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
         * <p>
         * <ul>
         * <li>If <code>OverwriteExisting</code> is <code>TRUE</code> , the existing file is replaced with the file being processed.</li>
         * <li>If <code>OverwriteExisting</code> is <code>FALSE</code> , nothing happens, and the workflow processing stops.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-overwriteexisting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-overwriteexisting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOverwriteExisting() {
            return null;
        }

        /**
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
         * <p>
         * <ul>
         * <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
         * <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-sourcefilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-decryptstepdetails.html#cfn-transfer-workflow-decryptstepdetails-sourcefilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceFileLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DecryptStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecryptStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecryptStepDetailsProperty> {
            java.lang.Object destinationFileLocation;
            java.lang.String type;
            java.lang.String name;
            java.lang.String overwriteExisting;
            java.lang.String sourceFileLocation;

            /**
             * Sets the value of {@link DecryptStepDetailsProperty#getDestinationFileLocation}
             * @param destinationFileLocation Specifies the location for the file being decrypted. This parameter is required.
             *                                Use <code>${Transfer:UserName}</code> or <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded date.
             *                                <p>
             *                                <ul>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.</li>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.</li>
             *                                </ul>
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                The system resolves <code>UploadDate</code> to a date format of <em>YYYY-MM-DD</em> , based on the date the file is uploaded in UTC.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationFileLocation(software.amazon.awscdk.IResolvable destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link DecryptStepDetailsProperty#getDestinationFileLocation}
             * @param destinationFileLocation Specifies the location for the file being decrypted. This parameter is required.
             *                                Use <code>${Transfer:UserName}</code> or <code>${Transfer:UploadDate}</code> in this field to parametrize the destination prefix by username or uploaded date.
             *                                <p>
             *                                <ul>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UserName}</code> to decrypt uploaded files to an Amazon S3 bucket that is prefixed with the name of the Transfer Family user that uploaded the file.</li>
             *                                <li>Set the value of <code>DestinationFileLocation</code> to <code>${Transfer:UploadDate}</code> to decrypt uploaded files to an Amazon S3 bucket that is prefixed with the date of the upload.</li>
             *                                </ul>
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                The system resolves <code>UploadDate</code> to a date format of <em>YYYY-MM-DD</em> , based on the date the file is uploaded in UTC.
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationFileLocation(software.amazon.awscdk.services.transfer.CfnWorkflow.InputFileLocationProperty destinationFileLocation) {
                this.destinationFileLocation = destinationFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link DecryptStepDetailsProperty#getType}
             * @param type The type of encryption used. This parameter is required.
             *             Currently, this value must be <code>PGP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DecryptStepDetailsProperty#getName}
             * @param name The name of the step, used as an identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DecryptStepDetailsProperty#getOverwriteExisting}
             * @param overwriteExisting A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .
             *                          If the workflow is processing a file that has the same name as an existing file, the behavior is as follows:
             *                          <p>
             *                          <ul>
             *                          <li>If <code>OverwriteExisting</code> is <code>TRUE</code> , the existing file is replaced with the file being processed.</li>
             *                          <li>If <code>OverwriteExisting</code> is <code>FALSE</code> , nothing happens, and the workflow processing stops.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteExisting(java.lang.String overwriteExisting) {
                this.overwriteExisting = overwriteExisting;
                return this;
            }

            /**
             * Sets the value of {@link DecryptStepDetailsProperty#getSourceFileLocation}
             * @param sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
             *                           <ul>
             *                           <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
             *                           <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFileLocation(java.lang.String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecryptStepDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecryptStepDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecryptStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecryptStepDetailsProperty {
            private final java.lang.Object destinationFileLocation;
            private final java.lang.String type;
            private final java.lang.String name;
            private final java.lang.String overwriteExisting;
            private final java.lang.String sourceFileLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationFileLocation = software.amazon.jsii.Kernel.get(this, "destinationFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteExisting = software.amazon.jsii.Kernel.get(this, "overwriteExisting", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceFileLocation = software.amazon.jsii.Kernel.get(this, "sourceFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationFileLocation = java.util.Objects.requireNonNull(builder.destinationFileLocation, "destinationFileLocation is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.name = builder.name;
                this.overwriteExisting = builder.overwriteExisting;
                this.sourceFileLocation = builder.sourceFileLocation;
            }

            @Override
            public final java.lang.Object getDestinationFileLocation() {
                return this.destinationFileLocation;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getOverwriteExisting() {
                return this.overwriteExisting;
            }

            @Override
            public final java.lang.String getSourceFileLocation() {
                return this.sourceFileLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationFileLocation", om.valueToTree(this.getDestinationFileLocation()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getOverwriteExisting() != null) {
                    data.set("overwriteExisting", om.valueToTree(this.getOverwriteExisting()));
                }
                if (this.getSourceFileLocation() != null) {
                    data.set("sourceFileLocation", om.valueToTree(this.getSourceFileLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.DecryptStepDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecryptStepDetailsProperty.Jsii$Proxy that = (DecryptStepDetailsProperty.Jsii$Proxy) o;

                if (!destinationFileLocation.equals(that.destinationFileLocation)) return false;
                if (!type.equals(that.type)) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.overwriteExisting != null ? !this.overwriteExisting.equals(that.overwriteExisting) : that.overwriteExisting != null) return false;
                return this.sourceFileLocation != null ? this.sourceFileLocation.equals(that.sourceFileLocation) : that.sourceFileLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationFileLocation.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.overwriteExisting != null ? this.overwriteExisting.hashCode() : 0);
                result = 31 * result + (this.sourceFileLocation != null ? this.sourceFileLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains the name and file location for a file being deleted by a workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * DeleteStepDetailsProperty deleteStepDetailsProperty = DeleteStepDetailsProperty.builder()
     *         .name("name")
     *         .sourceFileLocation("sourceFileLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-deletestepdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-deletestepdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.DeleteStepDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeleteStepDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeleteStepDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the step, used as an identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-deletestepdetails.html#cfn-transfer-workflow-deletestepdetails-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-deletestepdetails.html#cfn-transfer-workflow-deletestepdetails-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
         * <p>
         * <ul>
         * <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
         * <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-deletestepdetails.html#cfn-transfer-workflow-deletestepdetails-sourcefilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-deletestepdetails.html#cfn-transfer-workflow-deletestepdetails-sourcefilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceFileLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeleteStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeleteStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeleteStepDetailsProperty> {
            java.lang.String name;
            java.lang.String sourceFileLocation;

            /**
             * Sets the value of {@link DeleteStepDetailsProperty#getName}
             * @param name The name of the step, used as an identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DeleteStepDetailsProperty#getSourceFileLocation}
             * @param sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
             *                           <ul>
             *                           <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
             *                           <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFileLocation(java.lang.String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeleteStepDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeleteStepDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeleteStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeleteStepDetailsProperty {
            private final java.lang.String name;
            private final java.lang.String sourceFileLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceFileLocation = software.amazon.jsii.Kernel.get(this, "sourceFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.sourceFileLocation = builder.sourceFileLocation;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSourceFileLocation() {
                return this.sourceFileLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSourceFileLocation() != null) {
                    data.set("sourceFileLocation", om.valueToTree(this.getSourceFileLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.DeleteStepDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeleteStepDetailsProperty.Jsii$Proxy that = (DeleteStepDetailsProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.sourceFileLocation != null ? this.sourceFileLocation.equals(that.sourceFileLocation) : that.sourceFileLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.sourceFileLocation != null ? this.sourceFileLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Amazon EFS identifier and the path for the file being used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * EfsInputFileLocationProperty efsInputFileLocationProperty = EfsInputFileLocationProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-efsinputfilelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-efsinputfilelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.EfsInputFileLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(EfsInputFileLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EfsInputFileLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the file system, assigned by Amazon EFS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-efsinputfilelocation.html#cfn-transfer-workflow-efsinputfilelocation-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-efsinputfilelocation.html#cfn-transfer-workflow-efsinputfilelocation-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemId() {
            return null;
        }

        /**
         * The pathname for the folder being used by a workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-efsinputfilelocation.html#cfn-transfer-workflow-efsinputfilelocation-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-efsinputfilelocation.html#cfn-transfer-workflow-efsinputfilelocation-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EfsInputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EfsInputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EfsInputFileLocationProperty> {
            java.lang.String fileSystemId;
            java.lang.String path;

            /**
             * Sets the value of {@link EfsInputFileLocationProperty#getFileSystemId}
             * @param fileSystemId The identifier of the file system, assigned by Amazon EFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link EfsInputFileLocationProperty#getPath}
             * @param path The pathname for the folder being used by a workflow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EfsInputFileLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EfsInputFileLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EfsInputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EfsInputFileLocationProperty {
            private final java.lang.String fileSystemId;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = builder.fileSystemId;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFileSystemId() != null) {
                    data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.EfsInputFileLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EfsInputFileLocationProperty.Jsii$Proxy that = (EfsInputFileLocationProperty.Jsii$Proxy) o;

                if (this.fileSystemId != null ? !this.fileSystemId.equals(that.fileSystemId) : that.fileSystemId != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId != null ? this.fileSystemId.hashCode() : 0;
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the location for the file that's being processed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * InputFileLocationProperty inputFileLocationProperty = InputFileLocationProperty.builder()
     *         .efsFileLocation(EfsInputFileLocationProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 .path("path")
     *                 .build())
     *         .s3FileLocation(S3InputFileLocationProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-inputfilelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-inputfilelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.InputFileLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(InputFileLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputFileLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the details for the Amazon Elastic File System (Amazon EFS) file that's being decrypted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-inputfilelocation.html#cfn-transfer-workflow-inputfilelocation-efsfilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-inputfilelocation.html#cfn-transfer-workflow-inputfilelocation-efsfilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsFileLocation() {
            return null;
        }

        /**
         * Specifies the details for the Amazon S3 file that's being copied or decrypted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-inputfilelocation.html#cfn-transfer-workflow-inputfilelocation-s3filelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-inputfilelocation.html#cfn-transfer-workflow-inputfilelocation-s3filelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3FileLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputFileLocationProperty> {
            java.lang.Object efsFileLocation;
            java.lang.Object s3FileLocation;

            /**
             * Sets the value of {@link InputFileLocationProperty#getEfsFileLocation}
             * @param efsFileLocation Specifies the details for the Amazon Elastic File System (Amazon EFS) file that's being decrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileLocation(software.amazon.awscdk.IResolvable efsFileLocation) {
                this.efsFileLocation = efsFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link InputFileLocationProperty#getEfsFileLocation}
             * @param efsFileLocation Specifies the details for the Amazon Elastic File System (Amazon EFS) file that's being decrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileLocation(software.amazon.awscdk.services.transfer.CfnWorkflow.EfsInputFileLocationProperty efsFileLocation) {
                this.efsFileLocation = efsFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link InputFileLocationProperty#getS3FileLocation}
             * @param s3FileLocation Specifies the details for the Amazon S3 file that's being copied or decrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3FileLocation(software.amazon.awscdk.IResolvable s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            /**
             * Sets the value of {@link InputFileLocationProperty#getS3FileLocation}
             * @param s3FileLocation Specifies the details for the Amazon S3 file that's being copied or decrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3FileLocation(software.amazon.awscdk.services.transfer.CfnWorkflow.S3InputFileLocationProperty s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputFileLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputFileLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputFileLocationProperty {
            private final java.lang.Object efsFileLocation;
            private final java.lang.Object s3FileLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efsFileLocation = software.amazon.jsii.Kernel.get(this, "efsFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3FileLocation = software.amazon.jsii.Kernel.get(this, "s3FileLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efsFileLocation = builder.efsFileLocation;
                this.s3FileLocation = builder.s3FileLocation;
            }

            @Override
            public final java.lang.Object getEfsFileLocation() {
                return this.efsFileLocation;
            }

            @Override
            public final java.lang.Object getS3FileLocation() {
                return this.s3FileLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfsFileLocation() != null) {
                    data.set("efsFileLocation", om.valueToTree(this.getEfsFileLocation()));
                }
                if (this.getS3FileLocation() != null) {
                    data.set("s3FileLocation", om.valueToTree(this.getS3FileLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.InputFileLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputFileLocationProperty.Jsii$Proxy that = (InputFileLocationProperty.Jsii$Proxy) o;

                if (this.efsFileLocation != null ? !this.efsFileLocation.equals(that.efsFileLocation) : that.efsFileLocation != null) return false;
                return this.s3FileLocation != null ? this.s3FileLocation.equals(that.s3FileLocation) : that.s3FileLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efsFileLocation != null ? this.efsFileLocation.hashCode() : 0;
                result = 31 * result + (this.s3FileLocation != null ? this.s3FileLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the S3 details for the file being used, such as bucket, ETag, and so forth.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * S3FileLocationProperty s3FileLocationProperty = S3FileLocationProperty.builder()
     *         .s3FileLocation(S3InputFileLocationProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3filelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3filelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.S3FileLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3FileLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3FileLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the details for the file location for the file that's being used in the workflow.
         * <p>
         * Only applicable if you are using Amazon S3 storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3filelocation.html#cfn-transfer-workflow-s3filelocation-s3filelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3filelocation.html#cfn-transfer-workflow-s3filelocation-s3filelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3FileLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3FileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3FileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3FileLocationProperty> {
            java.lang.Object s3FileLocation;

            /**
             * Sets the value of {@link S3FileLocationProperty#getS3FileLocation}
             * @param s3FileLocation Specifies the details for the file location for the file that's being used in the workflow.
             *                       Only applicable if you are using Amazon S3 storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3FileLocation(software.amazon.awscdk.IResolvable s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            /**
             * Sets the value of {@link S3FileLocationProperty#getS3FileLocation}
             * @param s3FileLocation Specifies the details for the file location for the file that's being used in the workflow.
             *                       Only applicable if you are using Amazon S3 storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3FileLocation(software.amazon.awscdk.services.transfer.CfnWorkflow.S3InputFileLocationProperty s3FileLocation) {
                this.s3FileLocation = s3FileLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3FileLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3FileLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3FileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3FileLocationProperty {
            private final java.lang.Object s3FileLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3FileLocation = software.amazon.jsii.Kernel.get(this, "s3FileLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3FileLocation = builder.s3FileLocation;
            }

            @Override
            public final java.lang.Object getS3FileLocation() {
                return this.s3FileLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3FileLocation() != null) {
                    data.set("s3FileLocation", om.valueToTree(this.getS3FileLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.S3FileLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3FileLocationProperty.Jsii$Proxy that = (S3FileLocationProperty.Jsii$Proxy) o;

                return this.s3FileLocation != null ? this.s3FileLocation.equals(that.s3FileLocation) : that.s3FileLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3FileLocation != null ? this.s3FileLocation.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the details for the Amazon S3 location for an input file to a workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * S3InputFileLocationProperty s3InputFileLocationProperty = S3InputFileLocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3inputfilelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3inputfilelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.S3InputFileLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3InputFileLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3InputFileLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the S3 bucket for the customer input file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3inputfilelocation.html#cfn-transfer-workflow-s3inputfilelocation-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3inputfilelocation.html#cfn-transfer-workflow-s3inputfilelocation-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The name assigned to the file when it was created in Amazon S3.
         * <p>
         * You use the object key to retrieve the object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3inputfilelocation.html#cfn-transfer-workflow-s3inputfilelocation-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3inputfilelocation.html#cfn-transfer-workflow-s3inputfilelocation-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3InputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3InputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3InputFileLocationProperty> {
            java.lang.String bucket;
            java.lang.String key;

            /**
             * Sets the value of {@link S3InputFileLocationProperty#getBucket}
             * @param bucket Specifies the S3 bucket for the customer input file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3InputFileLocationProperty#getKey}
             * @param key The name assigned to the file when it was created in Amazon S3.
             *            You use the object key to retrieve the object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3InputFileLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3InputFileLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3InputFileLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3InputFileLocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = builder.bucket;
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.S3InputFileLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3InputFileLocationProperty.Jsii$Proxy that = (S3InputFileLocationProperty.Jsii$Proxy) o;

                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket != null ? this.bucket.hashCode() : 0;
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * S3TagProperty s3TagProperty = S3TagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3tag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3tag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.S3TagProperty")
    @software.amazon.jsii.Jsii.Proxy(S3TagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3TagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name assigned to the tag that you create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3tag.html#cfn-transfer-workflow-s3tag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3tag.html#cfn-transfer-workflow-s3tag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value that corresponds to the key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3tag.html#cfn-transfer-workflow-s3tag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-s3tag.html#cfn-transfer-workflow-s3tag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link S3TagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3TagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3TagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link S3TagProperty#getKey}
             * @param key The name assigned to the tag that you create. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3TagProperty#getValue}
             * @param value The value that corresponds to the key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3TagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3TagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3TagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3TagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.S3TagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3TagProperty.Jsii$Proxy that = (S3TagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Details for a step that creates one or more tags.
     * <p>
     * You specify one or more tags. Each tag contains a key-value pair.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * TagStepDetailsProperty tagStepDetailsProperty = TagStepDetailsProperty.builder()
     *         .name("name")
     *         .sourceFileLocation("sourceFileLocation")
     *         .tags(List.of(S3TagProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.TagStepDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(TagStepDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagStepDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the step, used as an identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html#cfn-transfer-workflow-tagstepdetails-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html#cfn-transfer-workflow-tagstepdetails-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
         * <p>
         * <ul>
         * <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
         * <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html#cfn-transfer-workflow-tagstepdetails-sourcefilelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html#cfn-transfer-workflow-tagstepdetails-sourcefilelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceFileLocation() {
            return null;
        }

        /**
         * Array that contains from 1 to 10 key/value pairs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html#cfn-transfer-workflow-tagstepdetails-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-tagstepdetails.html#cfn-transfer-workflow-tagstepdetails-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagStepDetailsProperty> {
            java.lang.String name;
            java.lang.String sourceFileLocation;
            java.util.List<software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty> tags;

            /**
             * Sets the value of {@link TagStepDetailsProperty#getName}
             * @param name The name of the step, used as an identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TagStepDetailsProperty#getSourceFileLocation}
             * @param sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.
             *                           <ul>
             *                           <li>To use the previous file as the input, enter <code>${previous.file}</code> . In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</li>
             *                           <li>To use the originally uploaded file location as input for this step, enter <code>${original.file}</code> .</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFileLocation(java.lang.String sourceFileLocation) {
                this.sourceFileLocation = sourceFileLocation;
                return this;
            }

            /**
             * Sets the value of {@link TagStepDetailsProperty#getTags}
             * @param tags Array that contains from 1 to 10 key/value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagStepDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagStepDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagStepDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagStepDetailsProperty {
            private final java.lang.String name;
            private final java.lang.String sourceFileLocation;
            private final java.util.List<software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceFileLocation = software.amazon.jsii.Kernel.get(this, "sourceFileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.sourceFileLocation = builder.sourceFileLocation;
                this.tags = (java.util.List<software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty>)builder.tags;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSourceFileLocation() {
                return this.sourceFileLocation;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.transfer.CfnWorkflow.S3TagProperty> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSourceFileLocation() != null) {
                    data.set("sourceFileLocation", om.valueToTree(this.getSourceFileLocation()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.TagStepDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagStepDetailsProperty.Jsii$Proxy that = (TagStepDetailsProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.sourceFileLocation != null ? !this.sourceFileLocation.equals(that.sourceFileLocation) : that.sourceFileLocation != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.sourceFileLocation != null ? this.sourceFileLocation.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The basic building block of a workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * Object copyStepDetails;
     * Object customStepDetails;
     * Object deleteStepDetails;
     * Object tagStepDetails;
     * WorkflowStepProperty workflowStepProperty = WorkflowStepProperty.builder()
     *         .copyStepDetails(copyStepDetails)
     *         .customStepDetails(customStepDetails)
     *         .decryptStepDetails(DecryptStepDetailsProperty.builder()
     *                 .destinationFileLocation(InputFileLocationProperty.builder()
     *                         .efsFileLocation(EfsInputFileLocationProperty.builder()
     *                                 .fileSystemId("fileSystemId")
     *                                 .path("path")
     *                                 .build())
     *                         .s3FileLocation(S3InputFileLocationProperty.builder()
     *                                 .bucket("bucket")
     *                                 .key("key")
     *                                 .build())
     *                         .build())
     *                 .type("type")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .overwriteExisting("overwriteExisting")
     *                 .sourceFileLocation("sourceFileLocation")
     *                 .build())
     *         .deleteStepDetails(deleteStepDetails)
     *         .tagStepDetails(tagStepDetails)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnWorkflow.WorkflowStepProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowStepProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowStepProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details for a step that performs a file copy.
         * <p>
         * Consists of the following values:
         * <p>
         * <ul>
         * <li>A description</li>
         * <li>An Amazon S3 location for the destination of the file copy.</li>
         * <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-copystepdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-copystepdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyStepDetails() {
            return null;
        }

        /**
         * Details for a step that invokes an AWS Lambda function.
         * <p>
         * Consists of the Lambda function's name, target, and timeout (in seconds).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-customstepdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-customstepdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomStepDetails() {
            return null;
        }

        /**
         * Details for a step that decrypts an encrypted file.
         * <p>
         * Consists of the following values:
         * <p>
         * <ul>
         * <li>A descriptive name</li>
         * <li>An Amazon S3 or Amazon Elastic File System (Amazon EFS) location for the source file to decrypt.</li>
         * <li>An S3 or Amazon EFS location for the destination of the file decryption.</li>
         * <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
         * <li>The type of encryption that's used. Currently, only PGP encryption is supported.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-decryptstepdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-decryptstepdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecryptStepDetails() {
            return null;
        }

        /**
         * Details for a step that deletes the file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-deletestepdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-deletestepdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteStepDetails() {
            return null;
        }

        /**
         * Details for a step that creates one or more tags.
         * <p>
         * You specify one or more tags. Each tag contains a key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-tagstepdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-tagstepdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagStepDetails() {
            return null;
        }

        /**
         * Currently, the following step types are supported.
         * <p>
         * <ul>
         * <li><em><code>COPY</code></em> - Copy the file to another location.</li>
         * <li><em><code>CUSTOM</code></em> - Perform a custom step with an AWS Lambda function target.</li>
         * <li><em><code>DECRYPT</code></em> - Decrypt a file that was encrypted before it was uploaded.</li>
         * <li><em><code>DELETE</code></em> - Delete the file.</li>
         * <li><em><code>TAG</code></em> - Add a tag to the file.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-workflow-workflowstep.html#cfn-transfer-workflow-workflowstep-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkflowStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowStepProperty> {
            java.lang.Object copyStepDetails;
            java.lang.Object customStepDetails;
            java.lang.Object decryptStepDetails;
            java.lang.Object deleteStepDetails;
            java.lang.Object tagStepDetails;
            java.lang.String type;

            /**
             * Sets the value of {@link WorkflowStepProperty#getCopyStepDetails}
             * @param copyStepDetails Details for a step that performs a file copy.
             *                        Consists of the following values:
             *                        <p>
             *                        <ul>
             *                        <li>A description</li>
             *                        <li>An Amazon S3 location for the destination of the file copy.</li>
             *                        <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyStepDetails(java.lang.Object copyStepDetails) {
                this.copyStepDetails = copyStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getCustomStepDetails}
             * @param customStepDetails Details for a step that invokes an AWS Lambda function.
             *                          Consists of the Lambda function's name, target, and timeout (in seconds).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customStepDetails(java.lang.Object customStepDetails) {
                this.customStepDetails = customStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getDecryptStepDetails}
             * @param decryptStepDetails Details for a step that decrypts an encrypted file.
             *                           Consists of the following values:
             *                           <p>
             *                           <ul>
             *                           <li>A descriptive name</li>
             *                           <li>An Amazon S3 or Amazon Elastic File System (Amazon EFS) location for the source file to decrypt.</li>
             *                           <li>An S3 or Amazon EFS location for the destination of the file decryption.</li>
             *                           <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
             *                           <li>The type of encryption that's used. Currently, only PGP encryption is supported.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryptStepDetails(software.amazon.awscdk.IResolvable decryptStepDetails) {
                this.decryptStepDetails = decryptStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getDecryptStepDetails}
             * @param decryptStepDetails Details for a step that decrypts an encrypted file.
             *                           Consists of the following values:
             *                           <p>
             *                           <ul>
             *                           <li>A descriptive name</li>
             *                           <li>An Amazon S3 or Amazon Elastic File System (Amazon EFS) location for the source file to decrypt.</li>
             *                           <li>An S3 or Amazon EFS location for the destination of the file decryption.</li>
             *                           <li>A flag that indicates whether to overwrite an existing file of the same name. The default is <code>FALSE</code> .</li>
             *                           <li>The type of encryption that's used. Currently, only PGP encryption is supported.</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryptStepDetails(software.amazon.awscdk.services.transfer.CfnWorkflow.DecryptStepDetailsProperty decryptStepDetails) {
                this.decryptStepDetails = decryptStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getDeleteStepDetails}
             * @param deleteStepDetails Details for a step that deletes the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteStepDetails(java.lang.Object deleteStepDetails) {
                this.deleteStepDetails = deleteStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getTagStepDetails}
             * @param tagStepDetails Details for a step that creates one or more tags.
             *                       You specify one or more tags. Each tag contains a key-value pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagStepDetails(java.lang.Object tagStepDetails) {
                this.tagStepDetails = tagStepDetails;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowStepProperty#getType}
             * @param type Currently, the following step types are supported.
             *             <ul>
             *             <li><em><code>COPY</code></em> - Copy the file to another location.</li>
             *             <li><em><code>CUSTOM</code></em> - Perform a custom step with an AWS Lambda function target.</li>
             *             <li><em><code>DECRYPT</code></em> - Decrypt a file that was encrypted before it was uploaded.</li>
             *             <li><em><code>DELETE</code></em> - Delete the file.</li>
             *             <li><em><code>TAG</code></em> - Add a tag to the file.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowStepProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowStepProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowStepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowStepProperty {
            private final java.lang.Object copyStepDetails;
            private final java.lang.Object customStepDetails;
            private final java.lang.Object decryptStepDetails;
            private final java.lang.Object deleteStepDetails;
            private final java.lang.Object tagStepDetails;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyStepDetails = software.amazon.jsii.Kernel.get(this, "copyStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customStepDetails = software.amazon.jsii.Kernel.get(this, "customStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decryptStepDetails = software.amazon.jsii.Kernel.get(this, "decryptStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteStepDetails = software.amazon.jsii.Kernel.get(this, "deleteStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagStepDetails = software.amazon.jsii.Kernel.get(this, "tagStepDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyStepDetails = builder.copyStepDetails;
                this.customStepDetails = builder.customStepDetails;
                this.decryptStepDetails = builder.decryptStepDetails;
                this.deleteStepDetails = builder.deleteStepDetails;
                this.tagStepDetails = builder.tagStepDetails;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getCopyStepDetails() {
                return this.copyStepDetails;
            }

            @Override
            public final java.lang.Object getCustomStepDetails() {
                return this.customStepDetails;
            }

            @Override
            public final java.lang.Object getDecryptStepDetails() {
                return this.decryptStepDetails;
            }

            @Override
            public final java.lang.Object getDeleteStepDetails() {
                return this.deleteStepDetails;
            }

            @Override
            public final java.lang.Object getTagStepDetails() {
                return this.tagStepDetails;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyStepDetails() != null) {
                    data.set("copyStepDetails", om.valueToTree(this.getCopyStepDetails()));
                }
                if (this.getCustomStepDetails() != null) {
                    data.set("customStepDetails", om.valueToTree(this.getCustomStepDetails()));
                }
                if (this.getDecryptStepDetails() != null) {
                    data.set("decryptStepDetails", om.valueToTree(this.getDecryptStepDetails()));
                }
                if (this.getDeleteStepDetails() != null) {
                    data.set("deleteStepDetails", om.valueToTree(this.getDeleteStepDetails()));
                }
                if (this.getTagStepDetails() != null) {
                    data.set("tagStepDetails", om.valueToTree(this.getTagStepDetails()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnWorkflow.WorkflowStepProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowStepProperty.Jsii$Proxy that = (WorkflowStepProperty.Jsii$Proxy) o;

                if (this.copyStepDetails != null ? !this.copyStepDetails.equals(that.copyStepDetails) : that.copyStepDetails != null) return false;
                if (this.customStepDetails != null ? !this.customStepDetails.equals(that.customStepDetails) : that.customStepDetails != null) return false;
                if (this.decryptStepDetails != null ? !this.decryptStepDetails.equals(that.decryptStepDetails) : that.decryptStepDetails != null) return false;
                if (this.deleteStepDetails != null ? !this.deleteStepDetails.equals(that.deleteStepDetails) : that.deleteStepDetails != null) return false;
                if (this.tagStepDetails != null ? !this.tagStepDetails.equals(that.tagStepDetails) : that.tagStepDetails != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyStepDetails != null ? this.copyStepDetails.hashCode() : 0;
                result = 31 * result + (this.customStepDetails != null ? this.customStepDetails.hashCode() : 0);
                result = 31 * result + (this.decryptStepDetails != null ? this.decryptStepDetails.hashCode() : 0);
                result = 31 * result + (this.deleteStepDetails != null ? this.deleteStepDetails.hashCode() : 0);
                result = 31 * result + (this.tagStepDetails != null ? this.tagStepDetails.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnWorkflow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnWorkflow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnWorkflowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnWorkflowProps.Builder();
        }

        /**
         * Specifies the details for the steps that are in the specified workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-steps</a>
         * @param steps Specifies the details for the steps that are in the specified workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final software.amazon.awscdk.IResolvable steps) {
            this.props.steps(steps);
            return this;
        }
        /**
         * Specifies the details for the steps that are in the specified workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-steps</a>
         * @param steps Specifies the details for the steps that are in the specified workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final java.util.List<? extends java.lang.Object> steps) {
            this.props.steps(steps);
            return this;
        }

        /**
         * Specifies the text description for the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-description</a>
         * @param description Specifies the text description for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-onexceptionsteps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-onexceptionsteps</a>
         * @param onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExceptionSteps(final software.amazon.awscdk.IResolvable onExceptionSteps) {
            this.props.onExceptionSteps(onExceptionSteps);
            return this;
        }
        /**
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-onexceptionsteps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-onexceptionsteps</a>
         * @param onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExceptionSteps(final java.util.List<? extends java.lang.Object> onExceptionSteps) {
            this.props.onExceptionSteps(onExceptionSteps);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for workflows.
         * <p>
         * Tags are metadata attached to workflows for any purpose.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-workflow.html#cfn-transfer-workflow-tags</a>
         * @param tags Key-value pairs that can be used to group and search for workflows. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnWorkflow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnWorkflow build() {
            return new software.amazon.awscdk.services.transfer.CfnWorkflow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
