/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kafkaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.kafkaconnect.CfnCustomPlugin;
import software.amazon.awscdk.services.kafkaconnect.CfnCustomPluginProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnCustomPlugin")
public class CfnCustomPlugin
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCustomPlugin.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCustomPlugin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCustomPlugin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCustomPlugin(@NotNull Construct scope, @NotNull String id, @NotNull CfnCustomPluginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCustomPluginArn() {
        return (String)Kernel.get((Object)this, (String)"attrCustomPluginArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrFileDescription() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrFileDescription", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public Number getAttrRevision() {
        return (Number)Kernel.get((Object)this, (String)"attrRevision", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getContentType() {
        return (String)Kernel.get((Object)this, (String)"contentType", (NativeType)NativeType.forClass(String.class));
    }

    public void setContentType(@NotNull String value) {
        Kernel.set((Object)this, (String)"contentType", (Object)Objects.requireNonNull(value, "contentType is required"));
    }

    @NotNull
    public Object getLocation() {
        return Kernel.get((Object)this, (String)"location", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLocation(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"location", (Object)Objects.requireNonNull(value, "location is required"));
    }

    public void setLocation(@NotNull CustomPluginLocationProperty value) {
        Kernel.set((Object)this, (String)"location", (Object)Objects.requireNonNull(value, "location is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCustomPlugin> {
        private final Construct scope;
        private final String id;
        private final CfnCustomPluginProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCustomPluginProps.Builder();
        }

        public Builder contentType(String contentType) {
            this.props.contentType(contentType);
            return this;
        }

        public Builder location(IResolvable location) {
            this.props.location(location);
            return this;
        }

        public Builder location(CustomPluginLocationProperty location) {
            this.props.location(location);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCustomPlugin build() {
            return new CfnCustomPlugin(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnCustomPlugin.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getFileKey();

        @Nullable
        default public String getObjectVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucketArn;
            String fileKey;
            String objectVersion;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder fileKey(String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            public Builder objectVersion(String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnCustomPlugin.CustomPluginLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomPluginLocationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Location();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomPluginLocationProperty> {
            Object s3Location;

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public CustomPluginLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnCustomPlugin.CustomPluginFileDescriptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomPluginFileDescriptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFileMd5() {
            return null;
        }

        @Nullable
        default public Number getFileSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomPluginFileDescriptionProperty> {
            String fileMd5;
            Number fileSize;

            public Builder fileMd5(String fileMd5) {
                this.fileMd5 = fileMd5;
                return this;
            }

            public Builder fileSize(Number fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public CustomPluginFileDescriptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

