/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnCluster;
import software.amazon.awscdk.services.sagemaker.CfnClusterProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrClusterArn() {
        return (String)Kernel.get((Object)this, (String)"attrClusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrClusterStatus() {
        return (String)Kernel.get((Object)this, (String)"attrClusterStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrFailureMessage() {
        return (String)Kernel.get((Object)this, (String)"attrFailureMessage", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getInstanceGroups() {
        return Kernel.get((Object)this, (String)"instanceGroups", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstanceGroups(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"instanceGroups", (Object)Objects.requireNonNull(value, "instanceGroups is required"));
    }

    public void setInstanceGroups(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ClusterInstanceGroupProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterInstanceGroupProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"instanceGroups", Objects.requireNonNull(value, "instanceGroups is required"));
    }

    @Nullable
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@Nullable String value) {
        Kernel.set((Object)this, (String)"clusterName", (Object)value);
    }

    @Nullable
    public String getNodeRecovery() {
        return (String)Kernel.get((Object)this, (String)"nodeRecovery", (NativeType)NativeType.forClass(String.class));
    }

    public void setNodeRecovery(@Nullable String value) {
        Kernel.set((Object)this, (String)"nodeRecovery", (Object)value);
    }

    @Nullable
    public Object getOrchestrator() {
        return Kernel.get((Object)this, (String)"orchestrator", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOrchestrator(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"orchestrator", (Object)value);
    }

    public void setOrchestrator(@Nullable OrchestratorProperty value) {
        Kernel.set((Object)this, (String)"orchestrator", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public Object getVpcConfig() {
        return Kernel.get((Object)this, (String)"vpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterInstanceGroupProperty
    extends JsiiSerializable {
        @NotNull
        public String getExecutionRole();

        @NotNull
        public Number getInstanceCount();

        @NotNull
        public String getInstanceGroupName();

        @NotNull
        public String getInstanceType();

        @NotNull
        public Object getLifeCycleConfig();

        @Nullable
        default public Number getCurrentCount() {
            return null;
        }

        @Nullable
        default public Object getInstanceStorageConfigs() {
            return null;
        }

        @Nullable
        default public List<String> getOnStartDeepHealthChecks() {
            return null;
        }

        @Nullable
        default public Object getOverrideVpcConfig() {
            return null;
        }

        @Nullable
        default public Number getThreadsPerCore() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterInstanceGroupProperty> {
            String executionRole;
            Number instanceCount;
            String instanceGroupName;
            String instanceType;
            Object lifeCycleConfig;
            Number currentCount;
            Object instanceStorageConfigs;
            List<String> onStartDeepHealthChecks;
            Object overrideVpcConfig;
            Number threadsPerCore;

            public Builder executionRole(String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceGroupName(String instanceGroupName) {
                this.instanceGroupName = instanceGroupName;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder lifeCycleConfig(IResolvable lifeCycleConfig) {
                this.lifeCycleConfig = lifeCycleConfig;
                return this;
            }

            public Builder lifeCycleConfig(ClusterLifeCycleConfigProperty lifeCycleConfig) {
                this.lifeCycleConfig = lifeCycleConfig;
                return this;
            }

            public Builder currentCount(Number currentCount) {
                this.currentCount = currentCount;
                return this;
            }

            public Builder instanceStorageConfigs(IResolvable instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            public Builder instanceStorageConfigs(List<? extends Object> instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            public Builder onStartDeepHealthChecks(List<String> onStartDeepHealthChecks) {
                this.onStartDeepHealthChecks = onStartDeepHealthChecks;
                return this;
            }

            public Builder overrideVpcConfig(IResolvable overrideVpcConfig) {
                this.overrideVpcConfig = overrideVpcConfig;
                return this;
            }

            public Builder overrideVpcConfig(VpcConfigProperty overrideVpcConfig) {
                this.overrideVpcConfig = overrideVpcConfig;
                return this;
            }

            public Builder threadsPerCore(Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            public ClusterInstanceGroupProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder instanceGroups(IResolvable instanceGroups) {
            this.props.instanceGroups(instanceGroups);
            return this;
        }

        public Builder instanceGroups(List<? extends Object> instanceGroups) {
            this.props.instanceGroups(instanceGroups);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder nodeRecovery(String nodeRecovery) {
            this.props.nodeRecovery(nodeRecovery);
            return this;
        }

        public Builder orchestrator(IResolvable orchestrator) {
            this.props.orchestrator(orchestrator);
            return this;
        }

        public Builder orchestrator(OrchestratorProperty orchestrator) {
            this.props.orchestrator(orchestrator);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            List<String> securityGroupIds;
            List<String> subnets;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.OrchestratorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OrchestratorProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEks();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OrchestratorProperty> {
            Object eks;

            public Builder eks(IResolvable eks) {
                this.eks = eks;
                return this;
            }

            public Builder eks(ClusterOrchestratorEksConfigProperty eks) {
                this.eks = eks;
                return this;
            }

            public OrchestratorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterOrchestratorEksConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterOrchestratorEksConfigProperty> {
            String clusterArn;

            public Builder clusterArn(String clusterArn) {
                this.clusterArn = clusterArn;
                return this;
            }

            public ClusterOrchestratorEksConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterLifeCycleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterLifeCycleConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getOnCreate();

        @NotNull
        public String getSourceS3Uri();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterLifeCycleConfigProperty> {
            String onCreate;
            String sourceS3Uri;

            public Builder onCreate(String onCreate) {
                this.onCreate = onCreate;
                return this;
            }

            public Builder sourceS3Uri(String sourceS3Uri) {
                this.sourceS3Uri = sourceS3Uri;
                return this;
            }

            public ClusterLifeCycleConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterInstanceStorageConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEbsVolumeConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterInstanceStorageConfigProperty> {
            Object ebsVolumeConfig;

            public Builder ebsVolumeConfig(IResolvable ebsVolumeConfig) {
                this.ebsVolumeConfig = ebsVolumeConfig;
                return this;
            }

            public Builder ebsVolumeConfig(ClusterEbsVolumeConfigProperty ebsVolumeConfig) {
                this.ebsVolumeConfig = ebsVolumeConfig;
                return this;
            }

            public ClusterInstanceStorageConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterEbsVolumeConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getVolumeSizeInGb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterEbsVolumeConfigProperty> {
            Number volumeSizeInGb;

            public Builder volumeSizeInGb(Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            public ClusterEbsVolumeConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

