package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * The HTTP Proxy integration resource for HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * HttpLambdaAuthorizer authorizer = HttpLambdaAuthorizer.Builder.create("BooksAuthorizer", authHandler)
 *         .responseTypes(List.of(HttpLambdaResponseType.SIMPLE))
 *         .build();
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:13.650Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpUrlIntegration")
public class HttpUrlIntegration extends software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration {

    protected HttpUrlIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpUrlIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param url the URL to proxy to. This parameter is required.
     * @param props properties to configure the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpUrlIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String url, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(url, "url is required"), props });
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param url the URL to proxy to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpUrlIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String url) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * Bind this integration to the route.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         * @param url the URL to proxy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final java.lang.String url) {
            return new Builder(id, url);
        }

        private final java.lang.String id;
        private final java.lang.String url;
        private software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegrationProps.Builder props;

        private Builder(final java.lang.String id, final java.lang.String url) {
            this.id = id;
            this.url = url;
        }

        /**
         * The HTTP method that must be used to invoke the underlying HTTP proxy.
         * <p>
         * Default: HttpMethod.ANY
         * <p>
         * @return {@code this}
         * @param method The HTTP method that must be used to invoke the underlying HTTP proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(final software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.props().method(method);
            return this;
        }

        /**
         * Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * Default: undefined requests are sent to the backend unmodified
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props().parameterMapping(parameterMapping);
            return this;
        }

        /**
         * The maximum amount of time an integration will run before it returns without a response.
         * <p>
         * Must be between 50 milliseconds and 29 seconds.
         * <p>
         * Default: Duration.seconds(29)
         * <p>
         * @return {@code this}
         * @param timeout The maximum amount of time an integration will run before it returns without a response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration build() {
            return new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration(
                this.id,
                this.url,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
