package software.amazon.awscdk.cxapi;

/**
 * Properties of a discovered VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * VpcContextResponse vpcContextResponse = VpcContextResponse.builder()
 *         .availabilityZones(List.of("availabilityZones"))
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .isolatedSubnetIds(List.of("isolatedSubnetIds"))
 *         .isolatedSubnetNames(List.of("isolatedSubnetNames"))
 *         .isolatedSubnetRouteTableIds(List.of("isolatedSubnetRouteTableIds"))
 *         .ownerAccountId("ownerAccountId")
 *         .privateSubnetIds(List.of("privateSubnetIds"))
 *         .privateSubnetNames(List.of("privateSubnetNames"))
 *         .privateSubnetRouteTableIds(List.of("privateSubnetRouteTableIds"))
 *         .publicSubnetIds(List.of("publicSubnetIds"))
 *         .publicSubnetNames(List.of("publicSubnetNames"))
 *         .publicSubnetRouteTableIds(List.of("publicSubnetRouteTableIds"))
 *         .region("region")
 *         .subnetGroups(List.of(VpcSubnetGroup.builder()
 *                 .name("name")
 *                 .subnets(List.of(VpcSubnet.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .routeTableId("routeTableId")
 *                         .subnetId("subnetId")
 *                         // the properties below are optional
 *                         .cidr("cidr")
 *                         .build()))
 *                 .type(VpcSubnetGroupType.PUBLIC)
 *                 .build()))
 *         .vpcCidrBlock("vpcCidrBlock")
 *         .vpnGatewayId("vpnGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:28.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cx_api.VpcContextResponse")
@software.amazon.jsii.Jsii.Proxy(VpcContextResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcContextResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * AZs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones();

    /**
     * VPC id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * IDs of all isolated subnets.
     * <p>
     * Element count: #(availabilityZones) · #(isolatedGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIsolatedSubnetIds() {
        return null;
    }

    /**
     * Name of isolated subnet groups.
     * <p>
     * Element count: #(isolatedGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIsolatedSubnetNames() {
        return null;
    }

    /**
     * Route Table IDs of isolated subnet groups.
     * <p>
     * Element count: #(availabilityZones) · #(isolatedGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIsolatedSubnetRouteTableIds() {
        return null;
    }

    /**
     * The ID of the AWS account that owns the VPC.
     * <p>
     * Default: the account id of the parent stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerAccountId() {
        return null;
    }

    /**
     * IDs of all private subnets.
     * <p>
     * Element count: #(availabilityZones) · #(privateGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrivateSubnetIds() {
        return null;
    }

    /**
     * Name of private subnet groups.
     * <p>
     * Element count: #(privateGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrivateSubnetNames() {
        return null;
    }

    /**
     * Route Table IDs of private subnet groups.
     * <p>
     * Element count: #(availabilityZones) · #(privateGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrivateSubnetRouteTableIds() {
        return null;
    }

    /**
     * IDs of all public subnets.
     * <p>
     * Element count: #(availabilityZones) · #(publicGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicSubnetIds() {
        return null;
    }

    /**
     * Name of public subnet groups.
     * <p>
     * Element count: #(publicGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicSubnetNames() {
        return null;
    }

    /**
     * Route Table IDs of public subnet groups.
     * <p>
     * Element count: #(availabilityZones) · #(publicGroups)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPublicSubnetRouteTableIds() {
        return null;
    }

    /**
     * The region in which the VPC is in.
     * <p>
     * Default: - Region of the parent stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * The subnet groups discovered for the given VPC.
     * <p>
     * Unlike the above properties, this will include asymmetric subnets,
     * if the VPC has any.
     * This property will only be populated if <code>VpcContextQuery.returnAsymmetricSubnets</code>
     * is true.
     * <p>
     * Default: - no subnet groups will be returned unless `VpcContextQuery.returnAsymmetricSubnets` is true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.cxapi.VpcSubnetGroup> getSubnetGroups() {
        return null;
    }

    /**
     * VPC cidr.
     * <p>
     * Default: - CIDR information not available
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcCidrBlock() {
        return null;
    }

    /**
     * The VPN gateway ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcContextResponse> {
        java.util.List<java.lang.String> availabilityZones;
        java.lang.String vpcId;
        java.util.List<java.lang.String> isolatedSubnetIds;
        java.util.List<java.lang.String> isolatedSubnetNames;
        java.util.List<java.lang.String> isolatedSubnetRouteTableIds;
        java.lang.String ownerAccountId;
        java.util.List<java.lang.String> privateSubnetIds;
        java.util.List<java.lang.String> privateSubnetNames;
        java.util.List<java.lang.String> privateSubnetRouteTableIds;
        java.util.List<java.lang.String> publicSubnetIds;
        java.util.List<java.lang.String> publicSubnetNames;
        java.util.List<java.lang.String> publicSubnetRouteTableIds;
        java.lang.String region;
        java.util.List<software.amazon.awscdk.cxapi.VpcSubnetGroup> subnetGroups;
        java.lang.String vpcCidrBlock;
        java.lang.String vpnGatewayId;

        /**
         * Sets the value of {@link VpcContextResponse#getAvailabilityZones}
         * @param availabilityZones AZs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getVpcId}
         * @param vpcId VPC id. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getIsolatedSubnetIds}
         * @param isolatedSubnetIds IDs of all isolated subnets.
         *                          Element count: #(availabilityZones) · #(isolatedGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetIds(java.util.List<java.lang.String> isolatedSubnetIds) {
            this.isolatedSubnetIds = isolatedSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getIsolatedSubnetNames}
         * @param isolatedSubnetNames Name of isolated subnet groups.
         *                            Element count: #(isolatedGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetNames(java.util.List<java.lang.String> isolatedSubnetNames) {
            this.isolatedSubnetNames = isolatedSubnetNames;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getIsolatedSubnetRouteTableIds}
         * @param isolatedSubnetRouteTableIds Route Table IDs of isolated subnet groups.
         *                                    Element count: #(availabilityZones) · #(isolatedGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isolatedSubnetRouteTableIds(java.util.List<java.lang.String> isolatedSubnetRouteTableIds) {
            this.isolatedSubnetRouteTableIds = isolatedSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getOwnerAccountId}
         * @param ownerAccountId The ID of the AWS account that owns the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerAccountId(java.lang.String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getPrivateSubnetIds}
         * @param privateSubnetIds IDs of all private subnets.
         *                         Element count: #(availabilityZones) · #(privateGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetIds(java.util.List<java.lang.String> privateSubnetIds) {
            this.privateSubnetIds = privateSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getPrivateSubnetNames}
         * @param privateSubnetNames Name of private subnet groups.
         *                           Element count: #(privateGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetNames(java.util.List<java.lang.String> privateSubnetNames) {
            this.privateSubnetNames = privateSubnetNames;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getPrivateSubnetRouteTableIds}
         * @param privateSubnetRouteTableIds Route Table IDs of private subnet groups.
         *                                   Element count: #(availabilityZones) · #(privateGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateSubnetRouteTableIds(java.util.List<java.lang.String> privateSubnetRouteTableIds) {
            this.privateSubnetRouteTableIds = privateSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getPublicSubnetIds}
         * @param publicSubnetIds IDs of all public subnets.
         *                        Element count: #(availabilityZones) · #(publicGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetIds(java.util.List<java.lang.String> publicSubnetIds) {
            this.publicSubnetIds = publicSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getPublicSubnetNames}
         * @param publicSubnetNames Name of public subnet groups.
         *                          Element count: #(publicGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetNames(java.util.List<java.lang.String> publicSubnetNames) {
            this.publicSubnetNames = publicSubnetNames;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getPublicSubnetRouteTableIds}
         * @param publicSubnetRouteTableIds Route Table IDs of public subnet groups.
         *                                  Element count: #(availabilityZones) · #(publicGroups)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicSubnetRouteTableIds(java.util.List<java.lang.String> publicSubnetRouteTableIds) {
            this.publicSubnetRouteTableIds = publicSubnetRouteTableIds;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getRegion}
         * @param region The region in which the VPC is in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getSubnetGroups}
         * @param subnetGroups The subnet groups discovered for the given VPC.
         *                     Unlike the above properties, this will include asymmetric subnets,
         *                     if the VPC has any.
         *                     This property will only be populated if <code>VpcContextQuery.returnAsymmetricSubnets</code>
         *                     is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnetGroups(java.util.List<? extends software.amazon.awscdk.cxapi.VpcSubnetGroup> subnetGroups) {
            this.subnetGroups = (java.util.List<software.amazon.awscdk.cxapi.VpcSubnetGroup>)subnetGroups;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getVpcCidrBlock}
         * @param vpcCidrBlock VPC cidr.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcCidrBlock(java.lang.String vpcCidrBlock) {
            this.vpcCidrBlock = vpcCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextResponse#getVpnGatewayId}
         * @param vpnGatewayId The VPN gateway ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcContextResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcContextResponse build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcContextResponse {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.String vpcId;
        private final java.util.List<java.lang.String> isolatedSubnetIds;
        private final java.util.List<java.lang.String> isolatedSubnetNames;
        private final java.util.List<java.lang.String> isolatedSubnetRouteTableIds;
        private final java.lang.String ownerAccountId;
        private final java.util.List<java.lang.String> privateSubnetIds;
        private final java.util.List<java.lang.String> privateSubnetNames;
        private final java.util.List<java.lang.String> privateSubnetRouteTableIds;
        private final java.util.List<java.lang.String> publicSubnetIds;
        private final java.util.List<java.lang.String> publicSubnetNames;
        private final java.util.List<java.lang.String> publicSubnetRouteTableIds;
        private final java.lang.String region;
        private final java.util.List<software.amazon.awscdk.cxapi.VpcSubnetGroup> subnetGroups;
        private final java.lang.String vpcCidrBlock;
        private final java.lang.String vpnGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isolatedSubnetIds = software.amazon.jsii.Kernel.get(this, "isolatedSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.isolatedSubnetNames = software.amazon.jsii.Kernel.get(this, "isolatedSubnetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.isolatedSubnetRouteTableIds = software.amazon.jsii.Kernel.get(this, "isolatedSubnetRouteTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ownerAccountId = software.amazon.jsii.Kernel.get(this, "ownerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateSubnetIds = software.amazon.jsii.Kernel.get(this, "privateSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.privateSubnetNames = software.amazon.jsii.Kernel.get(this, "privateSubnetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.privateSubnetRouteTableIds = software.amazon.jsii.Kernel.get(this, "privateSubnetRouteTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.publicSubnetIds = software.amazon.jsii.Kernel.get(this, "publicSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.publicSubnetNames = software.amazon.jsii.Kernel.get(this, "publicSubnetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.publicSubnetRouteTableIds = software.amazon.jsii.Kernel.get(this, "publicSubnetRouteTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetGroups = software.amazon.jsii.Kernel.get(this, "subnetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.VpcSubnetGroup.class)));
            this.vpcCidrBlock = software.amazon.jsii.Kernel.get(this, "vpcCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnGatewayId = software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = java.util.Objects.requireNonNull(builder.availabilityZones, "availabilityZones is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.isolatedSubnetIds = builder.isolatedSubnetIds;
            this.isolatedSubnetNames = builder.isolatedSubnetNames;
            this.isolatedSubnetRouteTableIds = builder.isolatedSubnetRouteTableIds;
            this.ownerAccountId = builder.ownerAccountId;
            this.privateSubnetIds = builder.privateSubnetIds;
            this.privateSubnetNames = builder.privateSubnetNames;
            this.privateSubnetRouteTableIds = builder.privateSubnetRouteTableIds;
            this.publicSubnetIds = builder.publicSubnetIds;
            this.publicSubnetNames = builder.publicSubnetNames;
            this.publicSubnetRouteTableIds = builder.publicSubnetRouteTableIds;
            this.region = builder.region;
            this.subnetGroups = (java.util.List<software.amazon.awscdk.cxapi.VpcSubnetGroup>)builder.subnetGroups;
            this.vpcCidrBlock = builder.vpcCidrBlock;
            this.vpnGatewayId = builder.vpnGatewayId;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.util.List<java.lang.String> getIsolatedSubnetIds() {
            return this.isolatedSubnetIds;
        }

        @Override
        public final java.util.List<java.lang.String> getIsolatedSubnetNames() {
            return this.isolatedSubnetNames;
        }

        @Override
        public final java.util.List<java.lang.String> getIsolatedSubnetRouteTableIds() {
            return this.isolatedSubnetRouteTableIds;
        }

        @Override
        public final java.lang.String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        @Override
        public final java.util.List<java.lang.String> getPrivateSubnetIds() {
            return this.privateSubnetIds;
        }

        @Override
        public final java.util.List<java.lang.String> getPrivateSubnetNames() {
            return this.privateSubnetNames;
        }

        @Override
        public final java.util.List<java.lang.String> getPrivateSubnetRouteTableIds() {
            return this.privateSubnetRouteTableIds;
        }

        @Override
        public final java.util.List<java.lang.String> getPublicSubnetIds() {
            return this.publicSubnetIds;
        }

        @Override
        public final java.util.List<java.lang.String> getPublicSubnetNames() {
            return this.publicSubnetNames;
        }

        @Override
        public final java.util.List<java.lang.String> getPublicSubnetRouteTableIds() {
            return this.publicSubnetRouteTableIds;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cxapi.VpcSubnetGroup> getSubnetGroups() {
            return this.subnetGroups;
        }

        @Override
        public final java.lang.String getVpcCidrBlock() {
            return this.vpcCidrBlock;
        }

        @Override
        public final java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getIsolatedSubnetIds() != null) {
                data.set("isolatedSubnetIds", om.valueToTree(this.getIsolatedSubnetIds()));
            }
            if (this.getIsolatedSubnetNames() != null) {
                data.set("isolatedSubnetNames", om.valueToTree(this.getIsolatedSubnetNames()));
            }
            if (this.getIsolatedSubnetRouteTableIds() != null) {
                data.set("isolatedSubnetRouteTableIds", om.valueToTree(this.getIsolatedSubnetRouteTableIds()));
            }
            if (this.getOwnerAccountId() != null) {
                data.set("ownerAccountId", om.valueToTree(this.getOwnerAccountId()));
            }
            if (this.getPrivateSubnetIds() != null) {
                data.set("privateSubnetIds", om.valueToTree(this.getPrivateSubnetIds()));
            }
            if (this.getPrivateSubnetNames() != null) {
                data.set("privateSubnetNames", om.valueToTree(this.getPrivateSubnetNames()));
            }
            if (this.getPrivateSubnetRouteTableIds() != null) {
                data.set("privateSubnetRouteTableIds", om.valueToTree(this.getPrivateSubnetRouteTableIds()));
            }
            if (this.getPublicSubnetIds() != null) {
                data.set("publicSubnetIds", om.valueToTree(this.getPublicSubnetIds()));
            }
            if (this.getPublicSubnetNames() != null) {
                data.set("publicSubnetNames", om.valueToTree(this.getPublicSubnetNames()));
            }
            if (this.getPublicSubnetRouteTableIds() != null) {
                data.set("publicSubnetRouteTableIds", om.valueToTree(this.getPublicSubnetRouteTableIds()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSubnetGroups() != null) {
                data.set("subnetGroups", om.valueToTree(this.getSubnetGroups()));
            }
            if (this.getVpcCidrBlock() != null) {
                data.set("vpcCidrBlock", om.valueToTree(this.getVpcCidrBlock()));
            }
            if (this.getVpnGatewayId() != null) {
                data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cx_api.VpcContextResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcContextResponse.Jsii$Proxy that = (VpcContextResponse.Jsii$Proxy) o;

            if (!availabilityZones.equals(that.availabilityZones)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.isolatedSubnetIds != null ? !this.isolatedSubnetIds.equals(that.isolatedSubnetIds) : that.isolatedSubnetIds != null) return false;
            if (this.isolatedSubnetNames != null ? !this.isolatedSubnetNames.equals(that.isolatedSubnetNames) : that.isolatedSubnetNames != null) return false;
            if (this.isolatedSubnetRouteTableIds != null ? !this.isolatedSubnetRouteTableIds.equals(that.isolatedSubnetRouteTableIds) : that.isolatedSubnetRouteTableIds != null) return false;
            if (this.ownerAccountId != null ? !this.ownerAccountId.equals(that.ownerAccountId) : that.ownerAccountId != null) return false;
            if (this.privateSubnetIds != null ? !this.privateSubnetIds.equals(that.privateSubnetIds) : that.privateSubnetIds != null) return false;
            if (this.privateSubnetNames != null ? !this.privateSubnetNames.equals(that.privateSubnetNames) : that.privateSubnetNames != null) return false;
            if (this.privateSubnetRouteTableIds != null ? !this.privateSubnetRouteTableIds.equals(that.privateSubnetRouteTableIds) : that.privateSubnetRouteTableIds != null) return false;
            if (this.publicSubnetIds != null ? !this.publicSubnetIds.equals(that.publicSubnetIds) : that.publicSubnetIds != null) return false;
            if (this.publicSubnetNames != null ? !this.publicSubnetNames.equals(that.publicSubnetNames) : that.publicSubnetNames != null) return false;
            if (this.publicSubnetRouteTableIds != null ? !this.publicSubnetRouteTableIds.equals(that.publicSubnetRouteTableIds) : that.publicSubnetRouteTableIds != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.subnetGroups != null ? !this.subnetGroups.equals(that.subnetGroups) : that.subnetGroups != null) return false;
            if (this.vpcCidrBlock != null ? !this.vpcCidrBlock.equals(that.vpcCidrBlock) : that.vpcCidrBlock != null) return false;
            return this.vpnGatewayId != null ? this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZones.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.isolatedSubnetIds != null ? this.isolatedSubnetIds.hashCode() : 0);
            result = 31 * result + (this.isolatedSubnetNames != null ? this.isolatedSubnetNames.hashCode() : 0);
            result = 31 * result + (this.isolatedSubnetRouteTableIds != null ? this.isolatedSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.ownerAccountId != null ? this.ownerAccountId.hashCode() : 0);
            result = 31 * result + (this.privateSubnetIds != null ? this.privateSubnetIds.hashCode() : 0);
            result = 31 * result + (this.privateSubnetNames != null ? this.privateSubnetNames.hashCode() : 0);
            result = 31 * result + (this.privateSubnetRouteTableIds != null ? this.privateSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.publicSubnetIds != null ? this.publicSubnetIds.hashCode() : 0);
            result = 31 * result + (this.publicSubnetNames != null ? this.publicSubnetNames.hashCode() : 0);
            result = 31 * result + (this.publicSubnetRouteTableIds != null ? this.publicSubnetRouteTableIds.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.subnetGroups != null ? this.subnetGroups.hashCode() : 0);
            result = 31 * result + (this.vpcCidrBlock != null ? this.vpcCidrBlock.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            return result;
        }
    }
}
