package software.amazon.awscdk.services.apigatewayv2;

/**
 * Create a new API Gateway WebSocket API endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * Function messageHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendMessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:13.618Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketApi")
public class WebSocketApi extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IWebSocketApi, software.amazon.awscdk.services.apigatewayv2.IApi {

    protected WebSocketApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.WebSocketApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing WebSocket API into this CDK app.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi fromWebSocketApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.WebSocketApi.class, "fromWebSocketApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a new route.
     * <p>
     * @param routeKey This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRoute addRoute(final @org.jetbrains.annotations.NotNull java.lang.String routeKey, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRoute.class), new Object[] { java.util.Objects.requireNonNull(routeKey, "routeKey is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * Default: - The default behavior applies when no specific method, path, or stage is provided.
     * In this case, the ARN will cover all methods, all resources, and all stages of this API.
     * Specifically, if 'method' is not specified, it defaults to '*', representing all methods.
     * If 'path' is not specified, it defaults to '/*', representing all paths.
     * If 'stage' is not specified, it also defaults to '*', representing all stages.
     * <p>
     * @param method
     * @param path
     * @param stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String stage) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method, path, stage });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * Default: - The default behavior applies when no specific method, path, or stage is provided.
     * In this case, the ARN will cover all methods, all resources, and all stages of this API.
     * Specifically, if 'method' is not specified, it defaults to '*', representing all methods.
     * If 'path' is not specified, it defaults to '/*', representing all paths.
     * If 'stage' is not specified, it also defaults to '*', representing all stages.
     * <p>
     * @param method
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method, path });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * Default: - The default behavior applies when no specific method, path, or stage is provided.
     * In this case, the ARN will cover all methods, all resources, and all stages of this API.
     * Specifically, if 'method' is not specified, it defaults to '*', representing all methods.
     * If 'path' is not specified, it defaults to '/*', representing all paths.
     * If 'stage' is not specified, it also defaults to '*', representing all stages.
     * <p>
     * @param method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * Default: - The default behavior applies when no specific method, path, or stage is provided.
     * In this case, the ARN will cover all methods, all resources, and all stages of this API.
     * Specifically, if 'method' is not specified, it defaults to '*', representing all methods.
     * If 'path' is not specified, it defaults to '/*', representing all paths.
     * If 'stage' is not specified, it also defaults to '*', representing all stages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi() {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Grant access to the API Gateway management API for this WebSocket API to an IAM principal (Role/Group/User).
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantManageConnections(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantManageConnections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Return the given named metric for this Api Gateway.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Api Gateway.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The default endpoint for an API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of this API Gateway API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A human friendly name for this WebSocket API.
     * <p>
     * Note that this is different from <code>webSocketApiId</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWebSocketApiName() {
        return software.amazon.jsii.Kernel.get(this, "webSocketApiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.WebSocketApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.WebSocketApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigatewayv2.WebSocketApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An API key selection expression.
         * <p>
         * Providing this option will require an API Key be provided to access the API.
         * <p>
         * Default: - Key is not required to access these APIs
         * <p>
         * @return {@code this}
         * @param apiKeySelectionExpression An API key selection expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySelectionExpression(final software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression apiKeySelectionExpression) {
            this.props().apiKeySelectionExpression(apiKeySelectionExpression);
            return this;
        }

        /**
         * Name for the WebSocket API resource.
         * <p>
         * Default: - id of the WebSocketApi construct.
         * <p>
         * @return {@code this}
         * @param apiName Name for the WebSocket API resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(final java.lang.String apiName) {
            this.props().apiName(apiName);
            return this;
        }

        /**
         * Options to configure a '$connect' route.
         * <p>
         * Default: - no '$connect' route configured
         * <p>
         * @return {@code this}
         * @param connectRouteOptions Options to configure a '$connect' route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectRouteOptions(final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions connectRouteOptions) {
            this.props().connectRouteOptions(connectRouteOptions);
            return this;
        }

        /**
         * Options to configure a '$default' route.
         * <p>
         * Default: - no '$default' route configured
         * <p>
         * @return {@code this}
         * @param defaultRouteOptions Options to configure a '$default' route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteOptions(final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions defaultRouteOptions) {
            this.props().defaultRouteOptions(defaultRouteOptions);
            return this;
        }

        /**
         * The description of the API.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param description The description of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Options to configure a '$disconnect' route.
         * <p>
         * Default: - no '$disconnect' route configured
         * <p>
         * @return {@code this}
         * @param disconnectRouteOptions Options to configure a '$disconnect' route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disconnectRouteOptions(final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions disconnectRouteOptions) {
            this.props().disconnectRouteOptions(disconnectRouteOptions);
            return this;
        }

        /**
         * The route selection expression for the API.
         * <p>
         * Default: '$request.body.action'
         * <p>
         * @return {@code this}
         * @param routeSelectionExpression The route selection expression for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSelectionExpression(final java.lang.String routeSelectionExpression) {
            this.props().routeSelectionExpression(routeSelectionExpression);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.WebSocketApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.WebSocketApi build() {
            return new software.amazon.awscdk.services.apigatewayv2.WebSocketApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.WebSocketApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.WebSocketApiProps.Builder();
            }
            return this.props;
        }
    }
}
