package software.amazon.awscdk.services.appconfig;

/**
 * Defines an AWS Lambda validator.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * Function fn;
 * HostedConfiguration.Builder.create(this, "MyHostedConfiguration")
 *         .application(application)
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .validators(List.of(JsonSchemaValidator.fromFile("schema.json"), LambdaValidator.fromFunction(fn)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:13.744Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.LambdaValidator")
public abstract class LambdaValidator extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appconfig.IValidator {

    protected LambdaValidator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaValidator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected LambdaValidator() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Defines an AWS Lambda validator from a Lambda function.
     * <p>
     * This will call
     * <code>addPermission</code> to your function to grant AWS AppConfig permissions.
     * <p>
     * @param func The function that defines the validator. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.LambdaValidator fromFunction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Function func) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.LambdaValidator.class, "fromFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.LambdaValidator.class), new Object[] { java.util.Objects.requireNonNull(func, "func is required") });
    }

    /**
     * The content of the validator.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getContent();

    /**
     * The type of validator.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ValidatorType getType();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.LambdaValidator implements software.amazon.awscdk.services.appconfig.IValidator.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The content of the validator.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getContent() {
            return software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of validator.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ValidatorType getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ValidatorType.class));
        }
    }
}
