package software.amazon.awscdk.services.applicationautoscaling;

/**
 * An adjustment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * AdjustmentTier adjustmentTier = AdjustmentTier.builder()
 *         .adjustment(123)
 *         // the properties below are optional
 *         .lowerBound(123)
 *         .upperBound(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:13.852Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.AdjustmentTier")
@software.amazon.jsii.Jsii.Proxy(AdjustmentTier.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AdjustmentTier extends software.amazon.jsii.JsiiSerializable {

    /**
     * What number to adjust the capacity with.
     * <p>
     * The number is interpeted as an added capacity, a new fixed capacity or an
     * added percentage depending on the AdjustmentType value of the
     * StepScalingPolicy.
     * <p>
     * Can be positive or negative.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getAdjustment();

    /**
     * Lower bound where this scaling tier applies.
     * <p>
     * The scaling tier applies if the difference between the metric
     * value and its alarm threshold is higher than this value.
     * <p>
     * Default: -Infinity if this is the first tier, otherwise the upperBound of the previous tier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLowerBound() {
        return null;
    }

    /**
     * Upper bound where this scaling tier applies.
     * <p>
     * The scaling tier applies if the difference between the metric
     * value and its alarm threshold is lower than this value.
     * <p>
     * Default: +Infinity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUpperBound() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AdjustmentTier}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AdjustmentTier}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AdjustmentTier> {
        java.lang.Number adjustment;
        java.lang.Number lowerBound;
        java.lang.Number upperBound;

        /**
         * Sets the value of {@link AdjustmentTier#getAdjustment}
         * @param adjustment What number to adjust the capacity with. This parameter is required.
         *                   The number is interpeted as an added capacity, a new fixed capacity or an
         *                   added percentage depending on the AdjustmentType value of the
         *                   StepScalingPolicy.
         *                   <p>
         *                   Can be positive or negative.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustment(java.lang.Number adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        /**
         * Sets the value of {@link AdjustmentTier#getLowerBound}
         * @param lowerBound Lower bound where this scaling tier applies.
         *                   The scaling tier applies if the difference between the metric
         *                   value and its alarm threshold is higher than this value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowerBound(java.lang.Number lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        /**
         * Sets the value of {@link AdjustmentTier#getUpperBound}
         * @param upperBound Upper bound where this scaling tier applies.
         *                   The scaling tier applies if the difference between the metric
         *                   value and its alarm threshold is lower than this value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upperBound(java.lang.Number upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AdjustmentTier}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AdjustmentTier build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AdjustmentTier}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdjustmentTier {
        private final java.lang.Number adjustment;
        private final java.lang.Number lowerBound;
        private final java.lang.Number upperBound;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adjustment = software.amazon.jsii.Kernel.get(this, "adjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.lowerBound = software.amazon.jsii.Kernel.get(this, "lowerBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.upperBound = software.amazon.jsii.Kernel.get(this, "upperBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adjustment = java.util.Objects.requireNonNull(builder.adjustment, "adjustment is required");
            this.lowerBound = builder.lowerBound;
            this.upperBound = builder.upperBound;
        }

        @Override
        public final java.lang.Number getAdjustment() {
            return this.adjustment;
        }

        @Override
        public final java.lang.Number getLowerBound() {
            return this.lowerBound;
        }

        @Override
        public final java.lang.Number getUpperBound() {
            return this.upperBound;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("adjustment", om.valueToTree(this.getAdjustment()));
            if (this.getLowerBound() != null) {
                data.set("lowerBound", om.valueToTree(this.getLowerBound()));
            }
            if (this.getUpperBound() != null) {
                data.set("upperBound", om.valueToTree(this.getUpperBound()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.AdjustmentTier"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AdjustmentTier.Jsii$Proxy that = (AdjustmentTier.Jsii$Proxy) o;

            if (!adjustment.equals(that.adjustment)) return false;
            if (this.lowerBound != null ? !this.lowerBound.equals(that.lowerBound) : that.lowerBound != null) return false;
            return this.upperBound != null ? this.upperBound.equals(that.upperBound) : that.upperBound == null;
        }

        @Override
        public final int hashCode() {
            int result = this.adjustment.hashCode();
            result = 31 * result + (this.lowerBound != null ? this.lowerBound.hashCode() : 0);
            result = 31 * result + (this.upperBound != null ? this.upperBound.hashCode() : 0);
            return result;
        }
    }
}
