package software.amazon.awscdk.services.applicationautoscaling;

/**
 * The <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource specifies a resource that Application Auto Scaling can scale, such as an AWS::DynamoDB::Table or AWS::ECS::Service resource.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/getting-started.html">Getting started</a> in the <em>Application Auto Scaling User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * If the resource that you want Application Auto Scaling to scale is not yet created in your account, add a dependency on the resource when registering it as a scalable target using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn</a> attribute.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * CfnScalableTarget cfnScalableTarget = CfnScalableTarget.Builder.create(this, "MyCfnScalableTarget")
 *         .maxCapacity(123)
 *         .minCapacity(123)
 *         .resourceId("resourceId")
 *         .scalableDimension("scalableDimension")
 *         .serviceNamespace("serviceNamespace")
 *         // the properties below are optional
 *         .roleArn("roleArn")
 *         .scheduledActions(List.of(ScheduledActionProperty.builder()
 *                 .schedule("schedule")
 *                 .scheduledActionName("scheduledActionName")
 *                 // the properties below are optional
 *                 .endTime(new Date())
 *                 .scalableTargetAction(ScalableTargetActionProperty.builder()
 *                         .maxCapacity(123)
 *                         .minCapacity(123)
 *                         .build())
 *                 .startTime(new Date())
 *                 .timezone("timezone")
 *                 .build()))
 *         .suspendedState(SuspendedStateProperty.builder()
 *                 .dynamicScalingInSuspended(false)
 *                 .dynamicScalingOutSuspended(false)
 *                 .scheduledScalingSuspended(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:13.856Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget")
public class CfnScalableTarget extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScalableTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalableTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScalableTarget(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The maximum value that you plan to scale out to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum value that you plan to scale out to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCapacity(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxCapacity", java.util.Objects.requireNonNull(value, "maxCapacity is required"));
    }

    /**
     * The minimum value that you plan to scale in to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity() {
        return software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum value that you plan to scale in to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinCapacity(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minCapacity", java.util.Objects.requireNonNull(value, "minCapacity is required"));
    }

    /**
     * The identifier of the resource associated with the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the resource associated with the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * The scalable dimension associated with the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalableDimension() {
        return software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scalable dimension associated with the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalableDimension(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scalableDimension", java.util.Objects.requireNonNull(value, "scalableDimension is required"));
    }

    /**
     * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceNamespace() {
        return software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceNamespace(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceNamespace", java.util.Objects.requireNonNull(value, "serviceNamespace is required"));
    }

    /**
     * Specify the Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that allows Application Auto Scaling to modify the scalable target on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify the Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that allows Application Auto Scaling to modify the scalable target on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * The scheduled actions for the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScheduledActions() {
        return software.amazon.jsii.Kernel.get(this, "scheduledActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scheduled actions for the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scheduledActions", value);
    }

    /**
     * The scheduled actions for the scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.ScheduledActionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.ScheduledActionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "scheduledActions", value);
    }

    /**
     * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSuspendedState() {
        return software.amazon.jsii.Kernel.get(this, "suspendedState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuspendedState(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "suspendedState", value);
    }

    /**
     * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuspendedState(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.SuspendedStateProperty value) {
        software.amazon.jsii.Kernel.set(this, "suspendedState", value);
    }
    /**
     * <code>ScalableTargetAction</code> specifies the minimum and maximum capacity for the <code>ScalableTargetAction</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html">AWS::ApplicationAutoScaling::ScalableTarget ScheduledAction</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * ScalableTargetActionProperty scalableTargetActionProperty = ScalableTargetActionProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget.ScalableTargetActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalableTargetActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalableTargetActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-maxcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * The minimum capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-mincapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-mincapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalableTargetActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalableTargetActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalableTargetActionProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ScalableTargetActionProperty#getMaxCapacity}
             * @param maxCapacity The maximum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalableTargetActionProperty#getMinCapacity}
             * @param minCapacity The minimum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalableTargetActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalableTargetActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalableTargetActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalableTargetActionProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = builder.maxCapacity;
                this.minCapacity = builder.minCapacity;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getMinCapacity() != null) {
                    data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget.ScalableTargetActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalableTargetActionProperty.Jsii$Proxy that = (ScalableTargetActionProperty.Jsii$Proxy) o;

                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                return this.minCapacity != null ? this.minCapacity.equals(that.minCapacity) : that.minCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity != null ? this.maxCapacity.hashCode() : 0;
                result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>ScheduledAction</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html">AWS::ApplicationAutoScaling::ScalableTarget</a> resource that specifies a scheduled action for a scalable target.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html">Scheduled scaling</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * ScheduledActionProperty scheduledActionProperty = ScheduledActionProperty.builder()
     *         .schedule("schedule")
     *         .scheduledActionName("scheduledActionName")
     *         // the properties below are optional
     *         .endTime(new Date())
     *         .scalableTargetAction(ScalableTargetActionProperty.builder()
     *                 .maxCapacity(123)
     *                 .minCapacity(123)
     *                 .build())
     *         .startTime(new Date())
     *         .timezone("timezone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget.ScheduledActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schedule for this action. The following formats are supported:.
         * <p>
         * <ul>
         * <li>At expressions - " <code>at( *yyyy* - *mm* - *dd* T *hh* : *mm* : *ss* )</code> "</li>
         * <li>Rate expressions - " <code>rate( *value* *unit* )</code> "</li>
         * <li>Cron expressions - " <code>cron( *fields* )</code> "</li>
         * </ul>
         * <p>
         * At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
         * <p>
         * At and cron expressions use Universal Coordinated Time (UTC) by default.
         * <p>
         * The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
         * <p>
         * For rate expressions, <em>value</em> is a positive integer and <em>unit</em> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-schedule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchedule();

        /**
         * The name of the scheduled action.
         * <p>
         * This name must be unique among all other scheduled actions on the specified scalable target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scheduledactionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scheduledactionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduledActionName();

        /**
         * The date and time that the action is scheduled to end, in UTC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-endtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndTime() {
            return null;
        }

        /**
         * The new minimum and maximum capacity.
         * <p>
         * You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scalabletargetaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scalabletargetaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScalableTargetAction() {
            return null;
        }

        /**
         * The date and time that the action is scheduled to begin, in UTC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartTime() {
            return null;
        }

        /**
         * The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledActionProperty> {
            java.lang.String schedule;
            java.lang.String scheduledActionName;
            java.lang.Object endTime;
            java.lang.Object scalableTargetAction;
            java.lang.Object startTime;
            java.lang.String timezone;

            /**
             * Sets the value of {@link ScheduledActionProperty#getSchedule}
             * @param schedule The schedule for this action. The following formats are supported:. This parameter is required.
             *                 <ul>
             *                 <li>At expressions - " <code>at( *yyyy* - *mm* - *dd* T *hh* : *mm* : *ss* )</code> "</li>
             *                 <li>Rate expressions - " <code>rate( *value* *unit* )</code> "</li>
             *                 <li>Cron expressions - " <code>cron( *fields* )</code> "</li>
             *                 </ul>
             *                 <p>
             *                 At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
             *                 <p>
             *                 At and cron expressions use Universal Coordinated Time (UTC) by default.
             *                 <p>
             *                 The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
             *                 <p>
             *                 For rate expressions, <em>value</em> is a positive integer and <em>unit</em> is <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getScheduledActionName}
             * @param scheduledActionName The name of the scheduled action. This parameter is required.
             *                            This name must be unique among all other scheduled actions on the specified scalable target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledActionName(java.lang.String scheduledActionName) {
                this.scheduledActionName = scheduledActionName;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getEndTime}
             * @param endTime The date and time that the action is scheduled to end, in UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(software.amazon.awscdk.IResolvable endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getEndTime}
             * @param endTime The date and time that the action is scheduled to end, in UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.time.Instant endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getScalableTargetAction}
             * @param scalableTargetAction The new minimum and maximum capacity.
             *                             You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalableTargetAction(software.amazon.awscdk.IResolvable scalableTargetAction) {
                this.scalableTargetAction = scalableTargetAction;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getScalableTargetAction}
             * @param scalableTargetAction The new minimum and maximum capacity.
             *                             You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalableTargetAction(software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.ScalableTargetActionProperty scalableTargetAction) {
                this.scalableTargetAction = scalableTargetAction;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getStartTime}
             * @param startTime The date and time that the action is scheduled to begin, in UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.IResolvable startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getStartTime}
             * @param startTime The date and time that the action is scheduled to begin, in UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.time.Instant startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getTimezone}
             * @param timezone The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timezone(java.lang.String timezone) {
                this.timezone = timezone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduledActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledActionProperty {
            private final java.lang.String schedule;
            private final java.lang.String scheduledActionName;
            private final java.lang.Object endTime;
            private final java.lang.Object scalableTargetAction;
            private final java.lang.Object startTime;
            private final java.lang.String timezone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduledActionName = software.amazon.jsii.Kernel.get(this, "scheduledActionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scalableTargetAction = software.amazon.jsii.Kernel.get(this, "scalableTargetAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
                this.scheduledActionName = java.util.Objects.requireNonNull(builder.scheduledActionName, "scheduledActionName is required");
                this.endTime = builder.endTime;
                this.scalableTargetAction = builder.scalableTargetAction;
                this.startTime = builder.startTime;
                this.timezone = builder.timezone;
            }

            @Override
            public final java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.String getScheduledActionName() {
                return this.scheduledActionName;
            }

            @Override
            public final java.lang.Object getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.Object getScalableTargetAction() {
                return this.scalableTargetAction;
            }

            @Override
            public final java.lang.Object getStartTime() {
                return this.startTime;
            }

            @Override
            public final java.lang.String getTimezone() {
                return this.timezone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("schedule", om.valueToTree(this.getSchedule()));
                data.set("scheduledActionName", om.valueToTree(this.getScheduledActionName()));
                if (this.getEndTime() != null) {
                    data.set("endTime", om.valueToTree(this.getEndTime()));
                }
                if (this.getScalableTargetAction() != null) {
                    data.set("scalableTargetAction", om.valueToTree(this.getScalableTargetAction()));
                }
                if (this.getStartTime() != null) {
                    data.set("startTime", om.valueToTree(this.getStartTime()));
                }
                if (this.getTimezone() != null) {
                    data.set("timezone", om.valueToTree(this.getTimezone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget.ScheduledActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledActionProperty.Jsii$Proxy that = (ScheduledActionProperty.Jsii$Proxy) o;

                if (!schedule.equals(that.schedule)) return false;
                if (!scheduledActionName.equals(that.scheduledActionName)) return false;
                if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) return false;
                if (this.scalableTargetAction != null ? !this.scalableTargetAction.equals(that.scalableTargetAction) : that.scalableTargetAction != null) return false;
                if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) return false;
                return this.timezone != null ? this.timezone.equals(that.timezone) : that.timezone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schedule.hashCode();
                result = 31 * result + (this.scheduledActionName.hashCode());
                result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
                result = 31 * result + (this.scalableTargetAction != null ? this.scalableTargetAction.hashCode() : 0);
                result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
                result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>SuspendedState</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html">AWS::ApplicationAutoScaling::ScalableTarget</a> resource that specifies whether the scaling activities for a scalable target are in a suspended state.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html">Suspending and resuming scaling</a> in the <em>Application Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.applicationautoscaling.*;
     * SuspendedStateProperty suspendedStateProperty = SuspendedStateProperty.builder()
     *         .dynamicScalingInSuspended(false)
     *         .dynamicScalingOutSuspended(false)
     *         .scheduledScalingSuspended(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget.SuspendedStateProperty")
    @software.amazon.jsii.Jsii.Proxy(SuspendedStateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuspendedStateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether scale in by a target tracking scaling policy or a step scaling policy is suspended.
         * <p>
         * Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalinginsuspended">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalinginsuspended</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicScalingInSuspended() {
            return null;
        }

        /**
         * Whether scale out by a target tracking scaling policy or a step scaling policy is suspended.
         * <p>
         * Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalingoutsuspended">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalingoutsuspended</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicScalingOutSuspended() {
            return null;
        }

        /**
         * Whether scheduled scaling is suspended.
         * <p>
         * Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-scheduledscalingsuspended">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-scheduledscalingsuspended</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduledScalingSuspended() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuspendedStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuspendedStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuspendedStateProperty> {
            java.lang.Object dynamicScalingInSuspended;
            java.lang.Object dynamicScalingOutSuspended;
            java.lang.Object scheduledScalingSuspended;

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingInSuspended}
             * @param dynamicScalingInSuspended Whether scale in by a target tracking scaling policy or a step scaling policy is suspended.
             *                                  Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingInSuspended(java.lang.Boolean dynamicScalingInSuspended) {
                this.dynamicScalingInSuspended = dynamicScalingInSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingInSuspended}
             * @param dynamicScalingInSuspended Whether scale in by a target tracking scaling policy or a step scaling policy is suspended.
             *                                  Set the value to <code>true</code> if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingInSuspended(software.amazon.awscdk.IResolvable dynamicScalingInSuspended) {
                this.dynamicScalingInSuspended = dynamicScalingInSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingOutSuspended}
             * @param dynamicScalingOutSuspended Whether scale out by a target tracking scaling policy or a step scaling policy is suspended.
             *                                   Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingOutSuspended(java.lang.Boolean dynamicScalingOutSuspended) {
                this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingOutSuspended}
             * @param dynamicScalingOutSuspended Whether scale out by a target tracking scaling policy or a step scaling policy is suspended.
             *                                   Set the value to <code>true</code> if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingOutSuspended(software.amazon.awscdk.IResolvable dynamicScalingOutSuspended) {
                this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getScheduledScalingSuspended}
             * @param scheduledScalingSuspended Whether scheduled scaling is suspended.
             *                                  Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledScalingSuspended(java.lang.Boolean scheduledScalingSuspended) {
                this.scheduledScalingSuspended = scheduledScalingSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getScheduledScalingSuspended}
             * @param scheduledScalingSuspended Whether scheduled scaling is suspended.
             *                                  Set the value to <code>true</code> if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledScalingSuspended(software.amazon.awscdk.IResolvable scheduledScalingSuspended) {
                this.scheduledScalingSuspended = scheduledScalingSuspended;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuspendedStateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuspendedStateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuspendedStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuspendedStateProperty {
            private final java.lang.Object dynamicScalingInSuspended;
            private final java.lang.Object dynamicScalingOutSuspended;
            private final java.lang.Object scheduledScalingSuspended;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dynamicScalingInSuspended = software.amazon.jsii.Kernel.get(this, "dynamicScalingInSuspended", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamicScalingOutSuspended = software.amazon.jsii.Kernel.get(this, "dynamicScalingOutSuspended", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scheduledScalingSuspended = software.amazon.jsii.Kernel.get(this, "scheduledScalingSuspended", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dynamicScalingInSuspended = builder.dynamicScalingInSuspended;
                this.dynamicScalingOutSuspended = builder.dynamicScalingOutSuspended;
                this.scheduledScalingSuspended = builder.scheduledScalingSuspended;
            }

            @Override
            public final java.lang.Object getDynamicScalingInSuspended() {
                return this.dynamicScalingInSuspended;
            }

            @Override
            public final java.lang.Object getDynamicScalingOutSuspended() {
                return this.dynamicScalingOutSuspended;
            }

            @Override
            public final java.lang.Object getScheduledScalingSuspended() {
                return this.scheduledScalingSuspended;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDynamicScalingInSuspended() != null) {
                    data.set("dynamicScalingInSuspended", om.valueToTree(this.getDynamicScalingInSuspended()));
                }
                if (this.getDynamicScalingOutSuspended() != null) {
                    data.set("dynamicScalingOutSuspended", om.valueToTree(this.getDynamicScalingOutSuspended()));
                }
                if (this.getScheduledScalingSuspended() != null) {
                    data.set("scheduledScalingSuspended", om.valueToTree(this.getScheduledScalingSuspended()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalableTarget.SuspendedStateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuspendedStateProperty.Jsii$Proxy that = (SuspendedStateProperty.Jsii$Proxy) o;

                if (this.dynamicScalingInSuspended != null ? !this.dynamicScalingInSuspended.equals(that.dynamicScalingInSuspended) : that.dynamicScalingInSuspended != null) return false;
                if (this.dynamicScalingOutSuspended != null ? !this.dynamicScalingOutSuspended.equals(that.dynamicScalingOutSuspended) : that.dynamicScalingOutSuspended != null) return false;
                return this.scheduledScalingSuspended != null ? this.scheduledScalingSuspended.equals(that.scheduledScalingSuspended) : that.scheduledScalingSuspended == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dynamicScalingInSuspended != null ? this.dynamicScalingInSuspended.hashCode() : 0;
                result = 31 * result + (this.dynamicScalingOutSuspended != null ? this.dynamicScalingOutSuspended.hashCode() : 0);
                result = 31 * result + (this.scheduledScalingSuspended != null ? this.scheduledScalingSuspended.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps.Builder();
        }

        /**
         * The maximum value that you plan to scale out to.
         * <p>
         * When a scaling policy is in effect, Application Auto Scaling can scale out (expand) as needed to the maximum capacity limit in response to changing demand.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity</a>
         * @param maxCapacity The maximum value that you plan to scale out to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The minimum value that you plan to scale in to.
         * <p>
         * When a scaling policy is in effect, Application Auto Scaling can scale in (contract) as needed to the minimum capacity limit in response to changing demand.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity</a>
         * @param minCapacity The minimum value that you plan to scale in to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(final java.lang.Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        /**
         * The identifier of the resource associated with the scalable target.
         * <p>
         * This string consists of the resource type and unique identifier.
         * <p>
         * <ul>
         * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/my-cluster/my-service</code> .</li>
         * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
         * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
         * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
         * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
         * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
         * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
         * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
         * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
         * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
         * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
         * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
         * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
         * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
         * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
         * <li>SageMaker serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         * <li>SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier is the resource ID. Example: <code>inference-component/my-inference-component</code> .</li>
         * <li>Pool of WorkSpaces - The resource type is <code>workspacespool</code> and the unique identifier is the pool ID. Example: <code>workspacespool/wspool-123456</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid</a>
         * @param resourceId The identifier of the resource associated with the scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The scalable dimension associated with the scalable target.
         * <p>
         * This string consists of the service namespace, resource type, and scaling property.
         * <p>
         * <ul>
         * <li><code>ecs:service:DesiredCount</code> - The task count of an ECS service.</li>
         * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
         * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
         * <li><code>appstream:fleet:DesiredCapacity</code> - The capacity of an AppStream 2.0 fleet.</li>
         * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
         * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
         * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
         * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
         * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
         * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
         * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
         * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
         * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
         * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
         * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
         * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
         * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
         * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
         * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
         * <li><code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker serverless endpoint.</li>
         * <li><code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a SageMaker inference component.</li>
         * <li><code>workspaces:workspacespool:DesiredUserSessions</code> - The number of user sessions for the WorkSpaces in the pool.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension</a>
         * @param scalableDimension The scalable dimension associated with the scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(final java.lang.String scalableDimension) {
            this.props.scalableDimension(scalableDimension);
            return this;
        }

        /**
         * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace</a>
         * @param serviceNamespace The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(final java.lang.String serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        /**
         * Specify the Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that allows Application Auto Scaling to modify the scalable target on your behalf.
         * <p>
         * This can be either an IAM service role that Application Auto Scaling can assume to make calls to other AWS resources on your behalf, or a service-linked role for the specified service. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html">How Application Auto Scaling works with IAM</a> in the <em>Application Auto Scaling User Guide</em> .
         * <p>
         * To automatically create a service-linked role (recommended), specify the full ARN of the service-linked role in your stack template. To find the exact ARN of the service-linked role for your AWS or custom resource, see the <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-service-linked-roles.html">Service-linked roles</a> topic in the <em>Application Auto Scaling User Guide</em> . Look for the ARN in the table at the bottom of the page.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn</a>
         * @param roleArn Specify the Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that allows Application Auto Scaling to modify the scalable target on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The scheduled actions for the scalable target.
         * <p>
         * Duplicates aren't allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions</a>
         * @param scheduledActions The scheduled actions for the scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActions(final software.amazon.awscdk.IResolvable scheduledActions) {
            this.props.scheduledActions(scheduledActions);
            return this;
        }
        /**
         * The scheduled actions for the scalable target.
         * <p>
         * Duplicates aren't allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions</a>
         * @param scheduledActions The scheduled actions for the scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActions(final java.util.List<? extends java.lang.Object> scheduledActions) {
            this.props.scheduledActions(scheduledActions);
            return this;
        }

        /**
         * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
         * <p>
         * Setting the value of an attribute to <code>true</code> suspends the specified scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
         * <p>
         * <em>Suspension Outcomes</em>
         * <p>
         * <ul>
         * <li>For <code>DynamicScalingInSuspended</code> , while a suspension is in effect, all scale-in activities that are triggered by a scaling policy are suspended.</li>
         * <li>For <code>DynamicScalingOutSuspended</code> , while a suspension is in effect, all scale-out activities that are triggered by a scaling policy are suspended.</li>
         * <li>For <code>ScheduledScalingSuspended</code> , while a suspension is in effect, all scaling activities that involve scheduled actions are suspended.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate</a>
         * @param suspendedState An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendedState(final software.amazon.awscdk.IResolvable suspendedState) {
            this.props.suspendedState(suspendedState);
            return this;
        }
        /**
         * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling.
         * <p>
         * Setting the value of an attribute to <code>true</code> suspends the specified scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
         * <p>
         * <em>Suspension Outcomes</em>
         * <p>
         * <ul>
         * <li>For <code>DynamicScalingInSuspended</code> , while a suspension is in effect, all scale-in activities that are triggered by a scaling policy are suspended.</li>
         * <li>For <code>DynamicScalingOutSuspended</code> , while a suspension is in effect, all scale-out activities that are triggered by a scaling policy are suspended.</li>
         * <li>For <code>ScheduledScalingSuspended</code> , while a suspension is in effect, all scaling activities that involve scheduled actions are suspended.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate</a>
         * @param suspendedState An embedded object that contains attributes and attribute values that are used to suspend and resume automatic scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendedState(final software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.SuspendedStateProperty suspendedState) {
            this.props.suspendedState(suspendedState);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget build() {
            return new software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
