package software.amazon.awscdk.services.applicationsignals;

/**
 * Properties for defining a <code>CfnServiceLevelObjective</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationsignals.*;
 * CfnServiceLevelObjectiveProps cfnServiceLevelObjectiveProps = CfnServiceLevelObjectiveProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .burnRateConfigurations(List.of(BurnRateConfigurationProperty.builder()
 *                 .lookBackWindowMinutes(123)
 *                 .build()))
 *         .description("description")
 *         .goal(GoalProperty.builder()
 *                 .attainmentGoal(123)
 *                 .interval(IntervalProperty.builder()
 *                         .calendarInterval(CalendarIntervalProperty.builder()
 *                                 .duration(123)
 *                                 .durationUnit("durationUnit")
 *                                 .startTime(123)
 *                                 .build())
 *                         .rollingInterval(RollingIntervalProperty.builder()
 *                                 .duration(123)
 *                                 .durationUnit("durationUnit")
 *                                 .build())
 *                         .build())
 *                 .warningThreshold(123)
 *                 .build())
 *         .requestBasedSli(RequestBasedSliProperty.builder()
 *                 .requestBasedSliMetric(RequestBasedSliMetricProperty.builder()
 *                         .keyAttributes(Map.of(
 *                                 "keyAttributesKey", "keyAttributes"))
 *                         .metricType("metricType")
 *                         .monitoredRequestCountMetric(MonitoredRequestCountMetricProperty.builder()
 *                                 .badCountMetric(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .accountId("accountId")
 *                                         .expression("expression")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .period(123)
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .goodCountMetric(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .accountId("accountId")
 *                                         .expression("expression")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .period(123)
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .operationName("operationName")
 *                         .totalRequestCountMetric(List.of(MetricDataQueryProperty.builder()
 *                                 .id("id")
 *                                 // the properties below are optional
 *                                 .accountId("accountId")
 *                                 .expression("expression")
 *                                 .metricStat(MetricStatProperty.builder()
 *                                         .metric(MetricProperty.builder()
 *                                                 .dimensions(List.of(DimensionProperty.builder()
 *                                                         .name("name")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .metricName("metricName")
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .period(123)
 *                                         .stat("stat")
 *                                         // the properties below are optional
 *                                         .unit("unit")
 *                                         .build())
 *                                 .returnData(false)
 *                                 .build()))
 *                         .build())
 *                 // the properties below are optional
 *                 .comparisonOperator("comparisonOperator")
 *                 .metricThreshold(123)
 *                 .build())
 *         .sli(SliProperty.builder()
 *                 .comparisonOperator("comparisonOperator")
 *                 .metricThreshold(123)
 *                 .sliMetric(SliMetricProperty.builder()
 *                         .keyAttributes(Map.of(
 *                                 "keyAttributesKey", "keyAttributes"))
 *                         .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                                 .id("id")
 *                                 // the properties below are optional
 *                                 .accountId("accountId")
 *                                 .expression("expression")
 *                                 .metricStat(MetricStatProperty.builder()
 *                                         .metric(MetricProperty.builder()
 *                                                 .dimensions(List.of(DimensionProperty.builder()
 *                                                         .name("name")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .metricName("metricName")
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .period(123)
 *                                         .stat("stat")
 *                                         // the properties below are optional
 *                                         .unit("unit")
 *                                         .build())
 *                                 .returnData(false)
 *                                 .build()))
 *                         .metricType("metricType")
 *                         .operationName("operationName")
 *                         .periodSeconds(123)
 *                         .statistic("statistic")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:13.966Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjectiveProps")
@software.amazon.jsii.Jsii.Proxy(CfnServiceLevelObjectiveProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServiceLevelObjectiveProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for this SLO.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
     * <p>
     * The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-burnrateconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-burnrateconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBurnRateConfigurations() {
        return null;
    }

    /**
     * An optional description for this SLO.
     * <p>
     * Default: - "No description"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * This structure contains the attributes that determine the goal of an SLO.
     * <p>
     * This includes the time period for evaluation and the attainment threshold.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-goal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-goal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGoal() {
        return null;
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-requestbasedsli</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestBasedSli() {
        return null;
    }

    /**
     * A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-sli">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-sli</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSli() {
        return null;
    }

    /**
     * A list of key-value pairs to associate with the SLO.
     * <p>
     * You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationsignals-servicelevelobjective.html#cfn-applicationsignals-servicelevelobjective-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServiceLevelObjectiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServiceLevelObjectiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServiceLevelObjectiveProps> {
        java.lang.String name;
        java.lang.Object burnRateConfigurations;
        java.lang.String description;
        java.lang.Object goal;
        java.lang.Object requestBasedSli;
        java.lang.Object sli;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getName}
         * @param name A name for this SLO. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getBurnRateConfigurations}
         * @param burnRateConfigurations Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
         *                               The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder burnRateConfigurations(software.amazon.awscdk.IResolvable burnRateConfigurations) {
            this.burnRateConfigurations = burnRateConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getBurnRateConfigurations}
         * @param burnRateConfigurations Each object in this array defines the length of the look-back window used to calculate one burn rate metric for this SLO.
         *                               The burn rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder burnRateConfigurations(java.util.List<? extends java.lang.Object> burnRateConfigurations) {
            this.burnRateConfigurations = burnRateConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getDescription}
         * @param description An optional description for this SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getGoal}
         * @param goal This structure contains the attributes that determine the goal of an SLO.
         *             This includes the time period for evaluation and the attainment threshold.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder goal(software.amazon.awscdk.IResolvable goal) {
            this.goal = goal;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getGoal}
         * @param goal This structure contains the attributes that determine the goal of an SLO.
         *             This includes the time period for evaluation and the attainment threshold.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder goal(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.GoalProperty goal) {
            this.goal = goal;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getRequestBasedSli}
         * @param requestBasedSli A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBasedSli(software.amazon.awscdk.IResolvable requestBasedSli) {
            this.requestBasedSli = requestBasedSli;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getRequestBasedSli}
         * @param requestBasedSli A structure containing information about the performance metric that this SLO monitors, if this is a request-based SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBasedSli(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.RequestBasedSliProperty requestBasedSli) {
            this.requestBasedSli = requestBasedSli;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getSli}
         * @param sli A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sli(software.amazon.awscdk.IResolvable sli) {
            this.sli = sli;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getSli}
         * @param sli A structure containing information about the performance metric that this SLO monitors, if this is a period-based SLO.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sli(software.amazon.awscdk.services.applicationsignals.CfnServiceLevelObjective.SliProperty sli) {
            this.sli = sli;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceLevelObjectiveProps#getTags}
         * @param tags A list of key-value pairs to associate with the SLO.
         *             You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the cloudwatch:TagResource permission.
         *             <p>
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServiceLevelObjectiveProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServiceLevelObjectiveProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServiceLevelObjectiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServiceLevelObjectiveProps {
        private final java.lang.String name;
        private final java.lang.Object burnRateConfigurations;
        private final java.lang.String description;
        private final java.lang.Object goal;
        private final java.lang.Object requestBasedSli;
        private final java.lang.Object sli;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.burnRateConfigurations = software.amazon.jsii.Kernel.get(this, "burnRateConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.goal = software.amazon.jsii.Kernel.get(this, "goal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestBasedSli = software.amazon.jsii.Kernel.get(this, "requestBasedSli", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sli = software.amazon.jsii.Kernel.get(this, "sli", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.burnRateConfigurations = builder.burnRateConfigurations;
            this.description = builder.description;
            this.goal = builder.goal;
            this.requestBasedSli = builder.requestBasedSli;
            this.sli = builder.sli;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getBurnRateConfigurations() {
            return this.burnRateConfigurations;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getGoal() {
            return this.goal;
        }

        @Override
        public final java.lang.Object getRequestBasedSli() {
            return this.requestBasedSli;
        }

        @Override
        public final java.lang.Object getSli() {
            return this.sli;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getBurnRateConfigurations() != null) {
                data.set("burnRateConfigurations", om.valueToTree(this.getBurnRateConfigurations()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGoal() != null) {
                data.set("goal", om.valueToTree(this.getGoal()));
            }
            if (this.getRequestBasedSli() != null) {
                data.set("requestBasedSli", om.valueToTree(this.getRequestBasedSli()));
            }
            if (this.getSli() != null) {
                data.set("sli", om.valueToTree(this.getSli()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationsignals.CfnServiceLevelObjectiveProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServiceLevelObjectiveProps.Jsii$Proxy that = (CfnServiceLevelObjectiveProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.burnRateConfigurations != null ? !this.burnRateConfigurations.equals(that.burnRateConfigurations) : that.burnRateConfigurations != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.goal != null ? !this.goal.equals(that.goal) : that.goal != null) return false;
            if (this.requestBasedSli != null ? !this.requestBasedSli.equals(that.requestBasedSli) : that.requestBasedSli != null) return false;
            if (this.sli != null ? !this.sli.equals(that.sli) : that.sli != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.burnRateConfigurations != null ? this.burnRateConfigurations.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
            result = 31 * result + (this.requestBasedSli != null ? this.requestBasedSli.hashCode() : 0);
            result = 31 * result + (this.sli != null ? this.sli.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
