package software.amazon.awscdk.services.appmesh;

/**
 * Properties to define a new GatewayRoute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * GatewayRouteSpec gatewayRouteSpec;
 * VirtualGateway virtualGateway;
 * GatewayRouteProps gatewayRouteProps = GatewayRouteProps.builder()
 *         .routeSpec(gatewayRouteSpec)
 *         .virtualGateway(virtualGateway)
 *         // the properties below are optional
 *         .gatewayRouteName("gatewayRouteName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:14.104Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GatewayRouteProps")
@software.amazon.jsii.Jsii.Proxy(GatewayRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayRouteProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appmesh.GatewayRouteBaseProps {

    /**
     * The VirtualGateway this GatewayRoute is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway getVirtualGateway();

    /**
     * @return a {@link Builder} of {@link GatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteProps> {
        software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway;
        software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec;
        java.lang.String gatewayRouteName;

        /**
         * Sets the value of {@link GatewayRouteProps#getVirtualGateway}
         * @param virtualGateway The VirtualGateway this GatewayRoute is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGateway(software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway) {
            this.virtualGateway = virtualGateway;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteProps#getRouteSpec}
         * @param routeSpec What protocol the route uses. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSpec(software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec) {
            this.routeSpec = routeSpec;
            return this;
        }

        /**
         * Sets the value of {@link GatewayRouteProps#getGatewayRouteName}
         * @param gatewayRouteName The name of the GatewayRoute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayRouteName(java.lang.String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteProps {
        private final software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway;
        private final software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec;
        private final java.lang.String gatewayRouteName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.virtualGateway = software.amazon.jsii.Kernel.get(this, "virtualGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class));
            this.routeSpec = software.amazon.jsii.Kernel.get(this, "routeSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteSpec.class));
            this.gatewayRouteName = software.amazon.jsii.Kernel.get(this, "gatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.virtualGateway = java.util.Objects.requireNonNull(builder.virtualGateway, "virtualGateway is required");
            this.routeSpec = java.util.Objects.requireNonNull(builder.routeSpec, "routeSpec is required");
            this.gatewayRouteName = builder.gatewayRouteName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IVirtualGateway getVirtualGateway() {
            return this.virtualGateway;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.GatewayRouteSpec getRouteSpec() {
            return this.routeSpec;
        }

        @Override
        public final java.lang.String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("virtualGateway", om.valueToTree(this.getVirtualGateway()));
            data.set("routeSpec", om.valueToTree(this.getRouteSpec()));
            if (this.getGatewayRouteName() != null) {
                data.set("gatewayRouteName", om.valueToTree(this.getGatewayRouteName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GatewayRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayRouteProps.Jsii$Proxy that = (GatewayRouteProps.Jsii$Proxy) o;

            if (!virtualGateway.equals(that.virtualGateway)) return false;
            if (!routeSpec.equals(that.routeSpec)) return false;
            return this.gatewayRouteName != null ? this.gatewayRouteName.equals(that.gatewayRouteName) : that.gatewayRouteName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.virtualGateway.hashCode();
            result = 31 * result + (this.routeSpec.hashCode());
            result = 31 * result + (this.gatewayRouteName != null ? this.gatewayRouteName.hashCode() : 0);
            return result;
        }
    }
}
