package software.amazon.awscdk.services.apprunner;

/**
 * Specify an AWS App Runner service by using the <code>AWS::AppRunner::Service</code> resource in an AWS CloudFormation template.
 * <p>
 * The <code>AWS::AppRunner::Service</code> resource is an AWS App Runner resource type that specifies an App Runner service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * CfnService cfnService = CfnService.Builder.create(this, "MyCfnService")
 *         .sourceConfiguration(SourceConfigurationProperty.builder()
 *                 .authenticationConfiguration(AuthenticationConfigurationProperty.builder()
 *                         .accessRoleArn("accessRoleArn")
 *                         .connectionArn("connectionArn")
 *                         .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .codeRepository(CodeRepositoryProperty.builder()
 *                         .repositoryUrl("repositoryUrl")
 *                         .sourceCodeVersion(SourceCodeVersionProperty.builder()
 *                                 .type("type")
 *                                 .value("value")
 *                                 .build())
 *                         // the properties below are optional
 *                         .codeConfiguration(CodeConfigurationProperty.builder()
 *                                 .configurationSource("configurationSource")
 *                                 // the properties below are optional
 *                                 .codeConfigurationValues(CodeConfigurationValuesProperty.builder()
 *                                         .runtime("runtime")
 *                                         // the properties below are optional
 *                                         .buildCommand("buildCommand")
 *                                         .port("port")
 *                                         .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .startCommand("startCommand")
 *                                         .build())
 *                                 .build())
 *                         .sourceDirectory("sourceDirectory")
 *                         .build())
 *                 .imageRepository(ImageRepositoryProperty.builder()
 *                         .imageIdentifier("imageIdentifier")
 *                         .imageRepositoryType("imageRepositoryType")
 *                         // the properties below are optional
 *                         .imageConfiguration(ImageConfigurationProperty.builder()
 *                                 .port("port")
 *                                 .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .startCommand("startCommand")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .autoScalingConfigurationArn("autoScalingConfigurationArn")
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .kmsKey("kmsKey")
 *                 .build())
 *         .healthCheckConfiguration(HealthCheckConfigurationProperty.builder()
 *                 .healthyThreshold(123)
 *                 .interval(123)
 *                 .path("path")
 *                 .protocol("protocol")
 *                 .timeout(123)
 *                 .unhealthyThreshold(123)
 *                 .build())
 *         .instanceConfiguration(InstanceConfigurationProperty.builder()
 *                 .cpu("cpu")
 *                 .instanceRoleArn("instanceRoleArn")
 *                 .memory("memory")
 *                 .build())
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .egressConfiguration(EgressConfigurationProperty.builder()
 *                         .egressType("egressType")
 *                         // the properties below are optional
 *                         .vpcConnectorArn("vpcConnectorArn")
 *                         .build())
 *                 .ingressConfiguration(IngressConfigurationProperty.builder()
 *                         .isPubliclyAccessible(false)
 *                         .build())
 *                 .ipAddressType("ipAddressType")
 *                 .build())
 *         .observabilityConfiguration(ServiceObservabilityConfigurationProperty.builder()
 *                 .observabilityEnabled(false)
 *                 // the properties below are optional
 *                 .observabilityConfigurationArn("observabilityConfigurationArn")
 *                 .build())
 *         .serviceName("serviceName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:14.194Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService")
public class CfnService extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apprunner.CfnService.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.CfnServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID that App Runner generated for this service.
     * <p>
     * It's unique within the AWS Region .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceId() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A subdomain URL that App Runner generated for this service.
     * <p>
     * You can use this URL to access your service web application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current state of the App Runner service. These particular values mean the following.
     * <p>
     * <ul>
     * <li><code>CREATE_FAILED</code> – The service failed to create. The failed service isn't usable, and still counts towards your service quota. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and rebuild your service using <code>UpdateService</code> .</li>
     * <li><code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The source to deploy to the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The source to deploy to the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", java.util.Objects.requireNonNull(value, "sourceConfiguration is required"));
    }

    /**
     * The source to deploy to the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceConfiguration", java.util.Objects.requireNonNull(value, "sourceConfiguration is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingConfigurationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingConfigurationArn", value);
    }

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfiguration", value);
    }

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.EncryptionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionConfiguration", value);
    }

    /**
     * The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfiguration", value);
    }

    /**
     * The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.HealthCheckConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfiguration", value);
    }

    /**
     * The runtime configuration of instances (scaling units) of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "instanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The runtime configuration of instances (scaling units) of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceConfiguration", value);
    }

    /**
     * The runtime configuration of instances (scaling units) of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.InstanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceConfiguration", value);
    }

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The observability configuration of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getObservabilityConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "observabilityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The observability configuration of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObservabilityConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "observabilityConfiguration", value);
    }

    /**
     * The observability configuration of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObservabilityConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CfnService.ServiceObservabilityConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "observabilityConfiguration", value);
    }

    /**
     * A name for the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the App Runner service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceName", value);
    }

    /**
     * An optional list of metadata items that you can associate with the App Runner service resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional list of metadata items that you can associate with the App Runner service resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes resources needed to authenticate access to some source repositories.
     * <p>
     * The specific resource depends on the repository provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * AuthenticationConfigurationProperty authenticationConfigurationProperty = AuthenticationConfigurationProperty.builder()
     *         .accessRoleArn("accessRoleArn")
     *         .connectionArn("connectionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.AuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository.
         * <p>
         * It's required for ECR image repositories (but not for ECR Public repositories).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-accessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-accessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessRoleArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository.
         * <p>
         * It's required for GitHub code repositories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-connectionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-authenticationconfiguration.html#cfn-apprunner-service-authenticationconfiguration-connectionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticationConfigurationProperty> {
            java.lang.String accessRoleArn;
            java.lang.String connectionArn;

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getAccessRoleArn}
             * @param accessRoleArn The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository.
             *                      It's required for ECR image repositories (but not for ECR Public repositories).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessRoleArn(java.lang.String accessRoleArn) {
                this.accessRoleArn = accessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getConnectionArn}
             * @param connectionArn The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository.
             *                      It's required for GitHub code repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionArn(java.lang.String connectionArn) {
                this.connectionArn = connectionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticationConfigurationProperty {
            private final java.lang.String accessRoleArn;
            private final java.lang.String connectionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessRoleArn = software.amazon.jsii.Kernel.get(this, "accessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessRoleArn = builder.accessRoleArn;
                this.connectionArn = builder.connectionArn;
            }

            @Override
            public final java.lang.String getAccessRoleArn() {
                return this.accessRoleArn;
            }

            @Override
            public final java.lang.String getConnectionArn() {
                return this.connectionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessRoleArn() != null) {
                    data.set("accessRoleArn", om.valueToTree(this.getAccessRoleArn()));
                }
                if (this.getConnectionArn() != null) {
                    data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.AuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticationConfigurationProperty.Jsii$Proxy that = (AuthenticationConfigurationProperty.Jsii$Proxy) o;

                if (this.accessRoleArn != null ? !this.accessRoleArn.equals(that.accessRoleArn) : that.accessRoleArn != null) return false;
                return this.connectionArn != null ? this.connectionArn.equals(that.connectionArn) : that.connectionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessRoleArn != null ? this.accessRoleArn.hashCode() : 0;
                result = 31 * result + (this.connectionArn != null ? this.connectionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration that AWS App Runner uses to build and run an App Runner service from a source code repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * CodeConfigurationProperty codeConfigurationProperty = CodeConfigurationProperty.builder()
     *         .configurationSource("configurationSource")
     *         // the properties below are optional
     *         .codeConfigurationValues(CodeConfigurationValuesProperty.builder()
     *                 .runtime("runtime")
     *                 // the properties below are optional
     *                 .buildCommand("buildCommand")
     *                 .port("port")
     *                 .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .startCommand("startCommand")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the App Runner configuration. Values are interpreted as follows:.
         * <p>
         * <ul>
         * <li><code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code> .</li>
         * <li><code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-configurationsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-configurationsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConfigurationSource();

        /**
         * The basic configuration for building and running the App Runner service.
         * <p>
         * Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-codeconfigurationvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfiguration.html#cfn-apprunner-service-codeconfiguration-codeconfigurationvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeConfigurationValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeConfigurationProperty> {
            java.lang.String configurationSource;
            java.lang.Object codeConfigurationValues;

            /**
             * Sets the value of {@link CodeConfigurationProperty#getConfigurationSource}
             * @param configurationSource The source of the App Runner configuration. Values are interpreted as follows:. This parameter is required.
             *                            <ul>
             *                            <li><code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code> .</li>
             *                            <li><code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationSource(java.lang.String configurationSource) {
                this.configurationSource = configurationSource;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationProperty#getCodeConfigurationValues}
             * @param codeConfigurationValues The basic configuration for building and running the App Runner service.
             *                                Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfigurationValues(software.amazon.awscdk.IResolvable codeConfigurationValues) {
                this.codeConfigurationValues = codeConfigurationValues;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationProperty#getCodeConfigurationValues}
             * @param codeConfigurationValues The basic configuration for building and running the App Runner service.
             *                                Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfigurationValues(software.amazon.awscdk.services.apprunner.CfnService.CodeConfigurationValuesProperty codeConfigurationValues) {
                this.codeConfigurationValues = codeConfigurationValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfigurationProperty {
            private final java.lang.String configurationSource;
            private final java.lang.Object codeConfigurationValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationSource = software.amazon.jsii.Kernel.get(this, "configurationSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codeConfigurationValues = software.amazon.jsii.Kernel.get(this, "codeConfigurationValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationSource = java.util.Objects.requireNonNull(builder.configurationSource, "configurationSource is required");
                this.codeConfigurationValues = builder.codeConfigurationValues;
            }

            @Override
            public final java.lang.String getConfigurationSource() {
                return this.configurationSource;
            }

            @Override
            public final java.lang.Object getCodeConfigurationValues() {
                return this.codeConfigurationValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("configurationSource", om.valueToTree(this.getConfigurationSource()));
                if (this.getCodeConfigurationValues() != null) {
                    data.set("codeConfigurationValues", om.valueToTree(this.getCodeConfigurationValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeConfigurationProperty.Jsii$Proxy that = (CodeConfigurationProperty.Jsii$Proxy) o;

                if (!configurationSource.equals(that.configurationSource)) return false;
                return this.codeConfigurationValues != null ? this.codeConfigurationValues.equals(that.codeConfigurationValues) : that.codeConfigurationValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationSource.hashCode();
                result = 31 * result + (this.codeConfigurationValues != null ? this.codeConfigurationValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the basic configuration needed for building and running an AWS App Runner service.
     * <p>
     * This type doesn't support the full set of possible configuration options. Fur full configuration capabilities, use a <code>apprunner.yaml</code> file in the source code repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * CodeConfigurationValuesProperty codeConfigurationValuesProperty = CodeConfigurationValuesProperty.builder()
     *         .runtime("runtime")
     *         // the properties below are optional
     *         .buildCommand("buildCommand")
     *         .port("port")
     *         .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .startCommand("startCommand")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeConfigurationValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeConfigurationValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A runtime environment type for building and running an App Runner service.
         * <p>
         * It represents a programming language runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRuntime();

        /**
         * The command App Runner runs to build your application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-buildcommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-buildcommand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuildCommand() {
            return null;
        }

        /**
         * The port that your application listens to in the container.
         * <p>
         * Default: <code>8080</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable.
         * <p>
         * The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>If the AWS Systems Manager Parameter Store parameter exists in the same AWS Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.</li>
         * <li>Currently, cross account referencing of AWS Systems Manager Parameter Store parameter is not supported.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtimeenvironmentsecrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtimeenvironmentsecrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeEnvironmentSecrets() {
            return null;
        }

        /**
         * The environment variables that are available to your running AWS App Runner service.
         * <p>
         * An array of key-value pairs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtimeenvironmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtimeenvironmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeEnvironmentVariables() {
            return null;
        }

        /**
         * The command App Runner runs to start your application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-startcommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-startcommand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartCommand() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeConfigurationValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeConfigurationValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeConfigurationValuesProperty> {
            java.lang.String runtime;
            java.lang.String buildCommand;
            java.lang.String port;
            java.lang.Object runtimeEnvironmentSecrets;
            java.lang.Object runtimeEnvironmentVariables;
            java.lang.String startCommand;

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntime}
             * @param runtime A runtime environment type for building and running an App Runner service. This parameter is required.
             *                It represents a programming language runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtime(java.lang.String runtime) {
                this.runtime = runtime;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getBuildCommand}
             * @param buildCommand The command App Runner runs to build your application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buildCommand(java.lang.String buildCommand) {
                this.buildCommand = buildCommand;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getPort}
             * @param port The port that your application listens to in the container.
             *             Default: <code>8080</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntimeEnvironmentSecrets}
             * @param runtimeEnvironmentSecrets An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable.
             *                                  The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  <ul>
             *                                  <li>If the AWS Systems Manager Parameter Store parameter exists in the same AWS Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.</li>
             *                                  <li>Currently, cross account referencing of AWS Systems Manager Parameter Store parameter is not supported.</li>
             *                                  </ul>
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentSecrets(software.amazon.awscdk.IResolvable runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntimeEnvironmentSecrets}
             * @param runtimeEnvironmentSecrets An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable.
             *                                  The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  <ul>
             *                                  <li>If the AWS Systems Manager Parameter Store parameter exists in the same AWS Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.</li>
             *                                  <li>Currently, cross account referencing of AWS Systems Manager Parameter Store parameter is not supported.</li>
             *                                  </ul>
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentSecrets(java.util.List<? extends java.lang.Object> runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables The environment variables that are available to your running AWS App Runner service.
             *                                    An array of key-value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(software.amazon.awscdk.IResolvable runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables The environment variables that are available to your running AWS App Runner service.
             *                                    An array of key-value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(java.util.List<? extends java.lang.Object> runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link CodeConfigurationValuesProperty#getStartCommand}
             * @param startCommand The command App Runner runs to start your application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startCommand(java.lang.String startCommand) {
                this.startCommand = startCommand;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeConfigurationValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeConfigurationValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeConfigurationValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfigurationValuesProperty {
            private final java.lang.String runtime;
            private final java.lang.String buildCommand;
            private final java.lang.String port;
            private final java.lang.Object runtimeEnvironmentSecrets;
            private final java.lang.Object runtimeEnvironmentVariables;
            private final java.lang.String startCommand;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.buildCommand = software.amazon.jsii.Kernel.get(this, "buildCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtimeEnvironmentSecrets = software.amazon.jsii.Kernel.get(this, "runtimeEnvironmentSecrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runtimeEnvironmentVariables = software.amazon.jsii.Kernel.get(this, "runtimeEnvironmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startCommand = software.amazon.jsii.Kernel.get(this, "startCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.runtime = java.util.Objects.requireNonNull(builder.runtime, "runtime is required");
                this.buildCommand = builder.buildCommand;
                this.port = builder.port;
                this.runtimeEnvironmentSecrets = builder.runtimeEnvironmentSecrets;
                this.runtimeEnvironmentVariables = builder.runtimeEnvironmentVariables;
                this.startCommand = builder.startCommand;
            }

            @Override
            public final java.lang.String getRuntime() {
                return this.runtime;
            }

            @Override
            public final java.lang.String getBuildCommand() {
                return this.buildCommand;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getRuntimeEnvironmentSecrets() {
                return this.runtimeEnvironmentSecrets;
            }

            @Override
            public final java.lang.Object getRuntimeEnvironmentVariables() {
                return this.runtimeEnvironmentVariables;
            }

            @Override
            public final java.lang.String getStartCommand() {
                return this.startCommand;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("runtime", om.valueToTree(this.getRuntime()));
                if (this.getBuildCommand() != null) {
                    data.set("buildCommand", om.valueToTree(this.getBuildCommand()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRuntimeEnvironmentSecrets() != null) {
                    data.set("runtimeEnvironmentSecrets", om.valueToTree(this.getRuntimeEnvironmentSecrets()));
                }
                if (this.getRuntimeEnvironmentVariables() != null) {
                    data.set("runtimeEnvironmentVariables", om.valueToTree(this.getRuntimeEnvironmentVariables()));
                }
                if (this.getStartCommand() != null) {
                    data.set("startCommand", om.valueToTree(this.getStartCommand()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeConfigurationValuesProperty.Jsii$Proxy that = (CodeConfigurationValuesProperty.Jsii$Proxy) o;

                if (!runtime.equals(that.runtime)) return false;
                if (this.buildCommand != null ? !this.buildCommand.equals(that.buildCommand) : that.buildCommand != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.runtimeEnvironmentSecrets != null ? !this.runtimeEnvironmentSecrets.equals(that.runtimeEnvironmentSecrets) : that.runtimeEnvironmentSecrets != null) return false;
                if (this.runtimeEnvironmentVariables != null ? !this.runtimeEnvironmentVariables.equals(that.runtimeEnvironmentVariables) : that.runtimeEnvironmentVariables != null) return false;
                return this.startCommand != null ? this.startCommand.equals(that.startCommand) : that.startCommand == null;
            }

            @Override
            public final int hashCode() {
                int result = this.runtime.hashCode();
                result = 31 * result + (this.buildCommand != null ? this.buildCommand.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.runtimeEnvironmentSecrets != null ? this.runtimeEnvironmentSecrets.hashCode() : 0);
                result = 31 * result + (this.runtimeEnvironmentVariables != null ? this.runtimeEnvironmentVariables.hashCode() : 0);
                result = 31 * result + (this.startCommand != null ? this.startCommand.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a source code repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * CodeRepositoryProperty codeRepositoryProperty = CodeRepositoryProperty.builder()
     *         .repositoryUrl("repositoryUrl")
     *         .sourceCodeVersion(SourceCodeVersionProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build())
     *         // the properties below are optional
     *         .codeConfiguration(CodeConfigurationProperty.builder()
     *                 .configurationSource("configurationSource")
     *                 // the properties below are optional
     *                 .codeConfigurationValues(CodeConfigurationValuesProperty.builder()
     *                         .runtime("runtime")
     *                         // the properties below are optional
     *                         .buildCommand("buildCommand")
     *                         .port("port")
     *                         .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .startCommand("startCommand")
     *                         .build())
     *                 .build())
     *         .sourceDirectory("sourceDirectory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the repository that contains the source code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-repositoryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-repositoryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

        /**
         * The version that should be used within the source code repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-sourcecodeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-sourcecodeversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceCodeVersion();

        /**
         * Configuration for building and running the service from a source code repository.
         * <p>
         * <blockquote>
         * <p>
         * <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-codeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-codeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeConfiguration() {
            return null;
        }

        /**
         * The path of the directory that stores source code and configuration files.
         * <p>
         * The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-sourcedirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-coderepository.html#cfn-apprunner-service-coderepository-sourcedirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            java.lang.String repositoryUrl;
            java.lang.Object sourceCodeVersion;
            java.lang.Object codeConfiguration;
            java.lang.String sourceDirectory;

            /**
             * Sets the value of {@link CodeRepositoryProperty#getRepositoryUrl}
             * @param repositoryUrl The location of the repository that contains the source code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryUrl(java.lang.String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getSourceCodeVersion}
             * @param sourceCodeVersion The version that should be used within the source code repository. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceCodeVersion(software.amazon.awscdk.IResolvable sourceCodeVersion) {
                this.sourceCodeVersion = sourceCodeVersion;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getSourceCodeVersion}
             * @param sourceCodeVersion The version that should be used within the source code repository. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceCodeVersion(software.amazon.awscdk.services.apprunner.CfnService.SourceCodeVersionProperty sourceCodeVersion) {
                this.sourceCodeVersion = sourceCodeVersion;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getCodeConfiguration}
             * @param codeConfiguration Configuration for building and running the service from a source code repository.
             *                          <blockquote>
             *                          <p>
             *                          <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfiguration(software.amazon.awscdk.IResolvable codeConfiguration) {
                this.codeConfiguration = codeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getCodeConfiguration}
             * @param codeConfiguration Configuration for building and running the service from a source code repository.
             *                          <blockquote>
             *                          <p>
             *                          <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeConfiguration(software.amazon.awscdk.services.apprunner.CfnService.CodeConfigurationProperty codeConfiguration) {
                this.codeConfiguration = codeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CodeRepositoryProperty#getSourceDirectory}
             * @param sourceDirectory The path of the directory that stores source code and configuration files.
             *                        The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceDirectory(java.lang.String sourceDirectory) {
                this.sourceDirectory = sourceDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryProperty {
            private final java.lang.String repositoryUrl;
            private final java.lang.Object sourceCodeVersion;
            private final java.lang.Object codeConfiguration;
            private final java.lang.String sourceDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceCodeVersion = software.amazon.jsii.Kernel.get(this, "sourceCodeVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeConfiguration = software.amazon.jsii.Kernel.get(this, "codeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceDirectory = software.amazon.jsii.Kernel.get(this, "sourceDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryUrl = java.util.Objects.requireNonNull(builder.repositoryUrl, "repositoryUrl is required");
                this.sourceCodeVersion = java.util.Objects.requireNonNull(builder.sourceCodeVersion, "sourceCodeVersion is required");
                this.codeConfiguration = builder.codeConfiguration;
                this.sourceDirectory = builder.sourceDirectory;
            }

            @Override
            public final java.lang.String getRepositoryUrl() {
                return this.repositoryUrl;
            }

            @Override
            public final java.lang.Object getSourceCodeVersion() {
                return this.sourceCodeVersion;
            }

            @Override
            public final java.lang.Object getCodeConfiguration() {
                return this.codeConfiguration;
            }

            @Override
            public final java.lang.String getSourceDirectory() {
                return this.sourceDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));
                data.set("sourceCodeVersion", om.valueToTree(this.getSourceCodeVersion()));
                if (this.getCodeConfiguration() != null) {
                    data.set("codeConfiguration", om.valueToTree(this.getCodeConfiguration()));
                }
                if (this.getSourceDirectory() != null) {
                    data.set("sourceDirectory", om.valueToTree(this.getSourceDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.CodeRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeRepositoryProperty.Jsii$Proxy that = (CodeRepositoryProperty.Jsii$Proxy) o;

                if (!repositoryUrl.equals(that.repositoryUrl)) return false;
                if (!sourceCodeVersion.equals(that.sourceCodeVersion)) return false;
                if (this.codeConfiguration != null ? !this.codeConfiguration.equals(that.codeConfiguration) : that.codeConfiguration != null) return false;
                return this.sourceDirectory != null ? this.sourceDirectory.equals(that.sourceDirectory) : that.sourceDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryUrl.hashCode();
                result = 31 * result + (this.sourceCodeVersion.hashCode());
                result = 31 * result + (this.codeConfiguration != null ? this.codeConfiguration.hashCode() : 0);
                result = 31 * result + (this.sourceDirectory != null ? this.sourceDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes configuration settings related to outbound network traffic of an AWS App Runner service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * EgressConfigurationProperty egressConfigurationProperty = EgressConfigurationProperty.builder()
     *         .egressType("egressType")
     *         // the properties below are optional
     *         .vpcConnectorArn("vpcConnectorArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-egressconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-egressconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.EgressConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EgressConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EgressConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of egress configuration.
         * <p>
         * Set to <code>DEFAULT</code> for access to resources hosted on public networks.
         * <p>
         * Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-egressconfiguration.html#cfn-apprunner-service-egressconfiguration-egresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-egressconfiguration.html#cfn-apprunner-service-egressconfiguration-egresstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEgressType();

        /**
         * The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service.
         * <p>
         * Only valid when <code>EgressType = VPC</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-egressconfiguration.html#cfn-apprunner-service-egressconfiguration-vpcconnectorarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-egressconfiguration.html#cfn-apprunner-service-egressconfiguration-vpcconnectorarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcConnectorArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EgressConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EgressConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EgressConfigurationProperty> {
            java.lang.String egressType;
            java.lang.String vpcConnectorArn;

            /**
             * Sets the value of {@link EgressConfigurationProperty#getEgressType}
             * @param egressType The type of egress configuration. This parameter is required.
             *                   Set to <code>DEFAULT</code> for access to resources hosted on public networks.
             *                   <p>
             *                   Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egressType(java.lang.String egressType) {
                this.egressType = egressType;
                return this;
            }

            /**
             * Sets the value of {@link EgressConfigurationProperty#getVpcConnectorArn}
             * @param vpcConnectorArn The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service.
             *                        Only valid when <code>EgressType = VPC</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConnectorArn(java.lang.String vpcConnectorArn) {
                this.vpcConnectorArn = vpcConnectorArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EgressConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EgressConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EgressConfigurationProperty {
            private final java.lang.String egressType;
            private final java.lang.String vpcConnectorArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.egressType = software.amazon.jsii.Kernel.get(this, "egressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConnectorArn = software.amazon.jsii.Kernel.get(this, "vpcConnectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.egressType = java.util.Objects.requireNonNull(builder.egressType, "egressType is required");
                this.vpcConnectorArn = builder.vpcConnectorArn;
            }

            @Override
            public final java.lang.String getEgressType() {
                return this.egressType;
            }

            @Override
            public final java.lang.String getVpcConnectorArn() {
                return this.vpcConnectorArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("egressType", om.valueToTree(this.getEgressType()));
                if (this.getVpcConnectorArn() != null) {
                    data.set("vpcConnectorArn", om.valueToTree(this.getVpcConnectorArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.EgressConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EgressConfigurationProperty.Jsii$Proxy that = (EgressConfigurationProperty.Jsii$Proxy) o;

                if (!egressType.equals(that.egressType)) return false;
                return this.vpcConnectorArn != null ? this.vpcConnectorArn.equals(that.vpcConnectorArn) : that.vpcConnectorArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.egressType.hashCode();
                result = 31 * result + (this.vpcConnectorArn != null ? this.vpcConnectorArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a custom encryption key that AWS App Runner uses to encrypt copies of the source repository and service logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the KMS key that's used for encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html#cfn-apprunner-service-encryptionconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-encryptionconfiguration.html#cfn-apprunner-service-encryptionconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsKey();

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey The ARN of the KMS key that's used for encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKey = java.util.Objects.requireNonNull(builder.kmsKey, "kmsKey is required");
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsKey", om.valueToTree(this.getKmsKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKey.equals(that.kmsKey);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKey.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the settings for the health check that AWS App Runner performs to monitor the health of a service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * HealthCheckConfigurationProperty healthCheckConfigurationProperty = HealthCheckConfigurationProperty.builder()
     *         .healthyThreshold(123)
     *         .interval(123)
     *         .path("path")
     *         .protocol("protocol")
     *         .timeout(123)
     *         .unhealthyThreshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.HealthCheckConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
         * <p>
         * Default: <code>1</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-healthythreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-healthythreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThreshold() {
            return null;
        }

        /**
         * The time interval, in seconds, between health checks.
         * <p>
         * Default: <code>5</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The URL that health check requests are sent to.
         * <p>
         * <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code> .
         * <p>
         * Default: <code>"/"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The IP protocol that App Runner uses to perform health checks for your service.
         * <p>
         * If you set <code>Protocol</code> to <code>HTTP</code> , App Runner sends health check requests to the HTTP path specified by <code>Path</code> .
         * <p>
         * Default: <code>TCP</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The time, in seconds, to wait for a health check response before deciding it failed.
         * <p>
         * Default: <code>2</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
         * <p>
         * Default: <code>5</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-unhealthythreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-healthcheckconfiguration.html#cfn-apprunner-service-healthcheckconfiguration-unhealthythreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckConfigurationProperty> {
            java.lang.Number healthyThreshold;
            java.lang.Number interval;
            java.lang.String path;
            java.lang.String protocol;
            java.lang.Number timeout;
            java.lang.Number unhealthyThreshold;

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getHealthyThreshold}
             * @param healthyThreshold The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
             *                         Default: <code>1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthyThreshold(java.lang.Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getInterval}
             * @param interval The time interval, in seconds, between health checks.
             *                 Default: <code>5</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getPath}
             * @param path The URL that health check requests are sent to.
             *             <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code> .
             *             <p>
             *             Default: <code>"/"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getProtocol}
             * @param protocol The IP protocol that App Runner uses to perform health checks for your service.
             *                 If you set <code>Protocol</code> to <code>HTTP</code> , App Runner sends health check requests to the HTTP path specified by <code>Path</code> .
             *                 <p>
             *                 Default: <code>TCP</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getTimeout}
             * @param timeout The time, in seconds, to wait for a health check response before deciding it failed.
             *                Default: <code>2</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigurationProperty#getUnhealthyThreshold}
             * @param unhealthyThreshold The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
             *                           Default: <code>5</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unhealthyThreshold(java.lang.Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckConfigurationProperty {
            private final java.lang.Number healthyThreshold;
            private final java.lang.Number interval;
            private final java.lang.String path;
            private final java.lang.String protocol;
            private final java.lang.Number timeout;
            private final java.lang.Number unhealthyThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = software.amazon.jsii.Kernel.get(this, "healthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unhealthyThreshold = software.amazon.jsii.Kernel.get(this, "unhealthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = builder.healthyThreshold;
                this.interval = builder.interval;
                this.path = builder.path;
                this.protocol = builder.protocol;
                this.timeout = builder.timeout;
                this.unhealthyThreshold = builder.unhealthyThreshold;
            }

            @Override
            public final java.lang.Number getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            public final java.lang.Number getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHealthyThreshold() != null) {
                    data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }
                if (this.getUnhealthyThreshold() != null) {
                    data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.HealthCheckConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckConfigurationProperty.Jsii$Proxy that = (HealthCheckConfigurationProperty.Jsii$Proxy) o;

                if (this.healthyThreshold != null ? !this.healthyThreshold.equals(that.healthyThreshold) : that.healthyThreshold != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
                return this.unhealthyThreshold != null ? this.unhealthyThreshold.equals(that.unhealthyThreshold) : that.unhealthyThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthyThreshold != null ? this.healthyThreshold.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                result = 31 * result + (this.unhealthyThreshold != null ? this.unhealthyThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration that AWS App Runner uses to run an App Runner service using an image pulled from a source image repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * ImageConfigurationProperty imageConfigurationProperty = ImageConfigurationProperty.builder()
     *         .port("port")
     *         .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .startCommand("startCommand")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.ImageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port that your application listens to in the container.
         * <p>
         * Default: <code>8080</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable.
         * <p>
         * The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>If the AWS Systems Manager Parameter Store parameter exists in the same AWS Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.</li>
         * <li>Currently, cross account referencing of AWS Systems Manager Parameter Store parameter is not supported.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-runtimeenvironmentsecrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-runtimeenvironmentsecrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeEnvironmentSecrets() {
            return null;
        }

        /**
         * Environment variables that are available to your running App Runner service.
         * <p>
         * An array of key-value pairs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-runtimeenvironmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-runtimeenvironmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeEnvironmentVariables() {
            return null;
        }

        /**
         * An optional command that App Runner runs to start the application in the source image.
         * <p>
         * If specified, this command overrides the Docker image’s default start command.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-startcommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-startcommand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartCommand() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageConfigurationProperty> {
            java.lang.String port;
            java.lang.Object runtimeEnvironmentSecrets;
            java.lang.Object runtimeEnvironmentVariables;
            java.lang.String startCommand;

            /**
             * Sets the value of {@link ImageConfigurationProperty#getPort}
             * @param port The port that your application listens to in the container.
             *             Default: <code>8080</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getRuntimeEnvironmentSecrets}
             * @param runtimeEnvironmentSecrets An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable.
             *                                  The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  <ul>
             *                                  <li>If the AWS Systems Manager Parameter Store parameter exists in the same AWS Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.</li>
             *                                  <li>Currently, cross account referencing of AWS Systems Manager Parameter Store parameter is not supported.</li>
             *                                  </ul>
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentSecrets(software.amazon.awscdk.IResolvable runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getRuntimeEnvironmentSecrets}
             * @param runtimeEnvironmentSecrets An array of key-value pairs representing the secrets and parameters that get referenced to your service as an environment variable.
             *                                  The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  <ul>
             *                                  <li>If the AWS Systems Manager Parameter Store parameter exists in the same AWS Region as the service that you're launching, you can use either the full ARN or name of the secret. If the parameter exists in a different Region, then the full ARN must be specified.</li>
             *                                  <li>Currently, cross account referencing of AWS Systems Manager Parameter Store parameter is not supported.</li>
             *                                  </ul>
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentSecrets(java.util.List<? extends java.lang.Object> runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables Environment variables that are available to your running App Runner service.
             *                                    An array of key-value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(software.amazon.awscdk.IResolvable runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getRuntimeEnvironmentVariables}
             * @param runtimeEnvironmentVariables Environment variables that are available to your running App Runner service.
             *                                    An array of key-value pairs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runtimeEnvironmentVariables(java.util.List<? extends java.lang.Object> runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ImageConfigurationProperty#getStartCommand}
             * @param startCommand An optional command that App Runner runs to start the application in the source image.
             *                     If specified, this command overrides the Docker image’s default start command.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startCommand(java.lang.String startCommand) {
                this.startCommand = startCommand;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageConfigurationProperty {
            private final java.lang.String port;
            private final java.lang.Object runtimeEnvironmentSecrets;
            private final java.lang.Object runtimeEnvironmentVariables;
            private final java.lang.String startCommand;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runtimeEnvironmentSecrets = software.amazon.jsii.Kernel.get(this, "runtimeEnvironmentSecrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runtimeEnvironmentVariables = software.amazon.jsii.Kernel.get(this, "runtimeEnvironmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startCommand = software.amazon.jsii.Kernel.get(this, "startCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = builder.port;
                this.runtimeEnvironmentSecrets = builder.runtimeEnvironmentSecrets;
                this.runtimeEnvironmentVariables = builder.runtimeEnvironmentVariables;
                this.startCommand = builder.startCommand;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getRuntimeEnvironmentSecrets() {
                return this.runtimeEnvironmentSecrets;
            }

            @Override
            public final java.lang.Object getRuntimeEnvironmentVariables() {
                return this.runtimeEnvironmentVariables;
            }

            @Override
            public final java.lang.String getStartCommand() {
                return this.startCommand;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRuntimeEnvironmentSecrets() != null) {
                    data.set("runtimeEnvironmentSecrets", om.valueToTree(this.getRuntimeEnvironmentSecrets()));
                }
                if (this.getRuntimeEnvironmentVariables() != null) {
                    data.set("runtimeEnvironmentVariables", om.valueToTree(this.getRuntimeEnvironmentVariables()));
                }
                if (this.getStartCommand() != null) {
                    data.set("startCommand", om.valueToTree(this.getStartCommand()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.ImageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageConfigurationProperty.Jsii$Proxy that = (ImageConfigurationProperty.Jsii$Proxy) o;

                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.runtimeEnvironmentSecrets != null ? !this.runtimeEnvironmentSecrets.equals(that.runtimeEnvironmentSecrets) : that.runtimeEnvironmentSecrets != null) return false;
                if (this.runtimeEnvironmentVariables != null ? !this.runtimeEnvironmentVariables.equals(that.runtimeEnvironmentVariables) : that.runtimeEnvironmentVariables != null) return false;
                return this.startCommand != null ? this.startCommand.equals(that.startCommand) : that.startCommand == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port != null ? this.port.hashCode() : 0;
                result = 31 * result + (this.runtimeEnvironmentSecrets != null ? this.runtimeEnvironmentSecrets.hashCode() : 0);
                result = 31 * result + (this.runtimeEnvironmentVariables != null ? this.runtimeEnvironmentVariables.hashCode() : 0);
                result = 31 * result + (this.startCommand != null ? this.startCommand.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a source image repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * ImageRepositoryProperty imageRepositoryProperty = ImageRepositoryProperty.builder()
     *         .imageIdentifier("imageIdentifier")
     *         .imageRepositoryType("imageRepositoryType")
     *         // the properties below are optional
     *         .imageConfiguration(ImageConfigurationProperty.builder()
     *                 .port("port")
     *                 .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .startCommand("startCommand")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.ImageRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of an image.
         * <p>
         * For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <em>Amazon ECR User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageIdentifier();

        /**
         * The type of the image repository.
         * <p>
         * This reflects the repository provider and whether the repository is private or public.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imagerepositorytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imagerepositorytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageRepositoryType();

        /**
         * Configuration for running the identified image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imagerepository.html#cfn-apprunner-service-imagerepository-imageconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageRepositoryProperty> {
            java.lang.String imageIdentifier;
            java.lang.String imageRepositoryType;
            java.lang.Object imageConfiguration;

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageIdentifier}
             * @param imageIdentifier The identifier of an image. This parameter is required.
             *                        For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <em>Amazon ECR User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageIdentifier(java.lang.String imageIdentifier) {
                this.imageIdentifier = imageIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageRepositoryType}
             * @param imageRepositoryType The type of the image repository. This parameter is required.
             *                            This reflects the repository provider and whether the repository is private or public.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageRepositoryType(java.lang.String imageRepositoryType) {
                this.imageRepositoryType = imageRepositoryType;
                return this;
            }

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageConfiguration}
             * @param imageConfiguration Configuration for running the identified image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageConfiguration(software.amazon.awscdk.IResolvable imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ImageRepositoryProperty#getImageConfiguration}
             * @param imageConfiguration Configuration for running the identified image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageConfiguration(software.amazon.awscdk.services.apprunner.CfnService.ImageConfigurationProperty imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageRepositoryProperty {
            private final java.lang.String imageIdentifier;
            private final java.lang.String imageRepositoryType;
            private final java.lang.Object imageConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageIdentifier = software.amazon.jsii.Kernel.get(this, "imageIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageRepositoryType = software.amazon.jsii.Kernel.get(this, "imageRepositoryType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageIdentifier = java.util.Objects.requireNonNull(builder.imageIdentifier, "imageIdentifier is required");
                this.imageRepositoryType = java.util.Objects.requireNonNull(builder.imageRepositoryType, "imageRepositoryType is required");
                this.imageConfiguration = builder.imageConfiguration;
            }

            @Override
            public final java.lang.String getImageIdentifier() {
                return this.imageIdentifier;
            }

            @Override
            public final java.lang.String getImageRepositoryType() {
                return this.imageRepositoryType;
            }

            @Override
            public final java.lang.Object getImageConfiguration() {
                return this.imageConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageIdentifier", om.valueToTree(this.getImageIdentifier()));
                data.set("imageRepositoryType", om.valueToTree(this.getImageRepositoryType()));
                if (this.getImageConfiguration() != null) {
                    data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.ImageRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageRepositoryProperty.Jsii$Proxy that = (ImageRepositoryProperty.Jsii$Proxy) o;

                if (!imageIdentifier.equals(that.imageIdentifier)) return false;
                if (!imageRepositoryType.equals(that.imageRepositoryType)) return false;
                return this.imageConfiguration != null ? this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageIdentifier.hashCode();
                result = 31 * result + (this.imageRepositoryType.hashCode());
                result = 31 * result + (this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Network configuration settings for inbound network traffic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * IngressConfigurationProperty ingressConfigurationProperty = IngressConfigurationProperty.builder()
     *         .isPubliclyAccessible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-ingressconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-ingressconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.IngressConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether your App Runner service is publicly accessible.
         * <p>
         * To make the service publicly accessible set it to <code>True</code> . To make the service privately accessible, from only within an Amazon VPC set it to <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-ingressconfiguration.html#cfn-apprunner-service-ingressconfiguration-ispubliclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-ingressconfiguration.html#cfn-apprunner-service-ingressconfiguration-ispubliclyaccessible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsPubliclyAccessible();

        /**
         * @return a {@link Builder} of {@link IngressConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressConfigurationProperty> {
            java.lang.Object isPubliclyAccessible;

            /**
             * Sets the value of {@link IngressConfigurationProperty#getIsPubliclyAccessible}
             * @param isPubliclyAccessible Specifies whether your App Runner service is publicly accessible. This parameter is required.
             *                             To make the service publicly accessible set it to <code>True</code> . To make the service privately accessible, from only within an Amazon VPC set it to <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isPubliclyAccessible(java.lang.Boolean isPubliclyAccessible) {
                this.isPubliclyAccessible = isPubliclyAccessible;
                return this;
            }

            /**
             * Sets the value of {@link IngressConfigurationProperty#getIsPubliclyAccessible}
             * @param isPubliclyAccessible Specifies whether your App Runner service is publicly accessible. This parameter is required.
             *                             To make the service publicly accessible set it to <code>True</code> . To make the service privately accessible, from only within an Amazon VPC set it to <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isPubliclyAccessible(software.amazon.awscdk.IResolvable isPubliclyAccessible) {
                this.isPubliclyAccessible = isPubliclyAccessible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressConfigurationProperty {
            private final java.lang.Object isPubliclyAccessible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isPubliclyAccessible = software.amazon.jsii.Kernel.get(this, "isPubliclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isPubliclyAccessible = java.util.Objects.requireNonNull(builder.isPubliclyAccessible, "isPubliclyAccessible is required");
            }

            @Override
            public final java.lang.Object getIsPubliclyAccessible() {
                return this.isPubliclyAccessible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isPubliclyAccessible", om.valueToTree(this.getIsPubliclyAccessible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.IngressConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressConfigurationProperty.Jsii$Proxy that = (IngressConfigurationProperty.Jsii$Proxy) o;

                return this.isPubliclyAccessible.equals(that.isPubliclyAccessible);
            }

            @Override
            public final int hashCode() {
                int result = this.isPubliclyAccessible.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes the runtime configuration of an AWS App Runner service instance (scaling unit).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * InstanceConfigurationProperty instanceConfigurationProperty = InstanceConfigurationProperty.builder()
     *         .cpu("cpu")
     *         .instanceRoleArn("instanceRoleArn")
     *         .memory("memory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.InstanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of CPU units reserved for each instance of your App Runner service.
         * <p>
         * Default: <code>1 vCPU</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service.
         * <p>
         * These are permissions that your code needs when it calls any AWS APIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-instancerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-instancerolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceRoleArn() {
            return null;
        }

        /**
         * The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
         * <p>
         * Default: <code>2 GB</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceConfigurationProperty> {
            java.lang.String cpu;
            java.lang.String instanceRoleArn;
            java.lang.String memory;

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getCpu}
             * @param cpu The number of CPU units reserved for each instance of your App Runner service.
             *            Default: <code>1 vCPU</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getInstanceRoleArn}
             * @param instanceRoleArn The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service.
             *                        These are permissions that your code needs when it calls any AWS APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRoleArn(java.lang.String instanceRoleArn) {
                this.instanceRoleArn = instanceRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link InstanceConfigurationProperty#getMemory}
             * @param memory The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
             *               Default: <code>2 GB</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceConfigurationProperty {
            private final java.lang.String cpu;
            private final java.lang.String instanceRoleArn;
            private final java.lang.String memory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRoleArn = software.amazon.jsii.Kernel.get(this, "instanceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = builder.cpu;
                this.instanceRoleArn = builder.instanceRoleArn;
                this.memory = builder.memory;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getInstanceRoleArn() {
                return this.instanceRoleArn;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getInstanceRoleArn() != null) {
                    data.set("instanceRoleArn", om.valueToTree(this.getInstanceRoleArn()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.InstanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceConfigurationProperty.Jsii$Proxy that = (InstanceConfigurationProperty.Jsii$Proxy) o;

                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.instanceRoleArn != null ? !this.instanceRoleArn.equals(that.instanceRoleArn) : that.instanceRoleArn != null) return false;
                return this.memory != null ? this.memory.equals(that.memory) : that.memory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu != null ? this.cpu.hashCode() : 0;
                result = 31 * result + (this.instanceRoleArn != null ? this.instanceRoleArn.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a key-value pair, which is a string-to-string mapping.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * KeyValuePairProperty keyValuePairProperty = KeyValuePairProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.KeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key name string to map to a value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value string to which the key name is mapped.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-keyvaluepair.html#cfn-apprunner-service-keyvaluepair-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyValuePairProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link KeyValuePairProperty#getName}
             * @param name The key name string to map to a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link KeyValuePairProperty#getValue}
             * @param value The value string to which the key name is mapped.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyValuePairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValuePairProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.KeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyValuePairProperty.Jsii$Proxy that = (KeyValuePairProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes configuration settings related to network traffic of an AWS App Runner service.
     * <p>
     * Consists of embedded objects for each configurable network feature.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .egressConfiguration(EgressConfigurationProperty.builder()
     *                 .egressType("egressType")
     *                 // the properties below are optional
     *                 .vpcConnectorArn("vpcConnectorArn")
     *                 .build())
     *         .ingressConfiguration(IngressConfigurationProperty.builder()
     *                 .isPubliclyAccessible(false)
     *                 .build())
     *         .ipAddressType("ipAddressType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Network configuration settings for outbound message traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html#cfn-apprunner-service-networkconfiguration-egressconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html#cfn-apprunner-service-networkconfiguration-egressconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEgressConfiguration() {
            return null;
        }

        /**
         * Network configuration settings for inbound message traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html#cfn-apprunner-service-networkconfiguration-ingressconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html#cfn-apprunner-service-networkconfiguration-ingressconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIngressConfiguration() {
            return null;
        }

        /**
         * App Runner provides you with the option to choose between <em>Internet Protocol version 4 (IPv4)</em> and <em>dual stack</em> (IPv4 and IPv6) for your incoming public network configuration.
         * <p>
         * This is an optional parameter. If you do not specify an <code>IpAddressType</code> , it defaults to select IPv4.
         * <p>
         * <blockquote>
         * <p>
         * Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic originating from IPv6 endpoint.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html#cfn-apprunner-service-networkconfiguration-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-networkconfiguration.html#cfn-apprunner-service-networkconfiguration-ipaddresstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.Object egressConfiguration;
            java.lang.Object ingressConfiguration;
            java.lang.String ipAddressType;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getEgressConfiguration}
             * @param egressConfiguration Network configuration settings for outbound message traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egressConfiguration(software.amazon.awscdk.IResolvable egressConfiguration) {
                this.egressConfiguration = egressConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getEgressConfiguration}
             * @param egressConfiguration Network configuration settings for outbound message traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egressConfiguration(software.amazon.awscdk.services.apprunner.CfnService.EgressConfigurationProperty egressConfiguration) {
                this.egressConfiguration = egressConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getIngressConfiguration}
             * @param ingressConfiguration Network configuration settings for inbound message traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressConfiguration(software.amazon.awscdk.IResolvable ingressConfiguration) {
                this.ingressConfiguration = ingressConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getIngressConfiguration}
             * @param ingressConfiguration Network configuration settings for inbound message traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressConfiguration(software.amazon.awscdk.services.apprunner.CfnService.IngressConfigurationProperty ingressConfiguration) {
                this.ingressConfiguration = ingressConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getIpAddressType}
             * @param ipAddressType App Runner provides you with the option to choose between <em>Internet Protocol version 4 (IPv4)</em> and <em>dual stack</em> (IPv4 and IPv6) for your incoming public network configuration.
             *                      This is an optional parameter. If you do not specify an <code>IpAddressType</code> , it defaults to select IPv4.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      Currently, App Runner supports dual stack for only Public endpoint. Only IPv4 is supported for Private endpoint. If you update a service that's using dual-stack Public endpoint to a Private endpoint, your App Runner service will default to support only IPv4 for Private endpoint and fail to receive traffic originating from IPv6 endpoint.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddressType(java.lang.String ipAddressType) {
                this.ipAddressType = ipAddressType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object egressConfiguration;
            private final java.lang.Object ingressConfiguration;
            private final java.lang.String ipAddressType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.egressConfiguration = software.amazon.jsii.Kernel.get(this, "egressConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ingressConfiguration = software.amazon.jsii.Kernel.get(this, "ingressConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.egressConfiguration = builder.egressConfiguration;
                this.ingressConfiguration = builder.ingressConfiguration;
                this.ipAddressType = builder.ipAddressType;
            }

            @Override
            public final java.lang.Object getEgressConfiguration() {
                return this.egressConfiguration;
            }

            @Override
            public final java.lang.Object getIngressConfiguration() {
                return this.ingressConfiguration;
            }

            @Override
            public final java.lang.String getIpAddressType() {
                return this.ipAddressType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEgressConfiguration() != null) {
                    data.set("egressConfiguration", om.valueToTree(this.getEgressConfiguration()));
                }
                if (this.getIngressConfiguration() != null) {
                    data.set("ingressConfiguration", om.valueToTree(this.getIngressConfiguration()));
                }
                if (this.getIpAddressType() != null) {
                    data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (this.egressConfiguration != null ? !this.egressConfiguration.equals(that.egressConfiguration) : that.egressConfiguration != null) return false;
                if (this.ingressConfiguration != null ? !this.ingressConfiguration.equals(that.ingressConfiguration) : that.ingressConfiguration != null) return false;
                return this.ipAddressType != null ? this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.egressConfiguration != null ? this.egressConfiguration.hashCode() : 0;
                result = 31 * result + (this.ingressConfiguration != null ? this.ingressConfiguration.hashCode() : 0);
                result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the observability configuration of an AWS App Runner service.
     * <p>
     * These are additional observability features, like tracing, that you choose to enable. They're configured in a separate resource that you associate with your service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * ServiceObservabilityConfigurationProperty serviceObservabilityConfigurationProperty = ServiceObservabilityConfigurationProperty.builder()
     *         .observabilityEnabled(false)
     *         // the properties below are optional
     *         .observabilityConfigurationArn("observabilityConfigurationArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-serviceobservabilityconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-serviceobservabilityconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.ServiceObservabilityConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceObservabilityConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceObservabilityConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When <code>true</code> , an observability configuration resource is associated with the service, and an <code>ObservabilityConfigurationArn</code> is specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-serviceobservabilityconfiguration.html#cfn-apprunner-service-serviceobservabilityconfiguration-observabilityenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-serviceobservabilityconfiguration.html#cfn-apprunner-service-serviceobservabilityconfiguration-observabilityenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getObservabilityEnabled();

        /**
         * The Amazon Resource Name (ARN) of the observability configuration that is associated with the service.
         * <p>
         * Specified only when <code>ObservabilityEnabled</code> is <code>true</code> .
         * <p>
         * Specify an ARN with a name and a revision number to associate that revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3</code>
         * <p>
         * Specify just the name to associate the latest revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-serviceobservabilityconfiguration.html#cfn-apprunner-service-serviceobservabilityconfiguration-observabilityconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-serviceobservabilityconfiguration.html#cfn-apprunner-service-serviceobservabilityconfiguration-observabilityconfigurationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObservabilityConfigurationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceObservabilityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceObservabilityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceObservabilityConfigurationProperty> {
            java.lang.Object observabilityEnabled;
            java.lang.String observabilityConfigurationArn;

            /**
             * Sets the value of {@link ServiceObservabilityConfigurationProperty#getObservabilityEnabled}
             * @param observabilityEnabled When <code>true</code> , an observability configuration resource is associated with the service, and an <code>ObservabilityConfigurationArn</code> is specified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder observabilityEnabled(java.lang.Boolean observabilityEnabled) {
                this.observabilityEnabled = observabilityEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ServiceObservabilityConfigurationProperty#getObservabilityEnabled}
             * @param observabilityEnabled When <code>true</code> , an observability configuration resource is associated with the service, and an <code>ObservabilityConfigurationArn</code> is specified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder observabilityEnabled(software.amazon.awscdk.IResolvable observabilityEnabled) {
                this.observabilityEnabled = observabilityEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ServiceObservabilityConfigurationProperty#getObservabilityConfigurationArn}
             * @param observabilityConfigurationArn The Amazon Resource Name (ARN) of the observability configuration that is associated with the service.
             *                                      Specified only when <code>ObservabilityEnabled</code> is <code>true</code> .
             *                                      <p>
             *                                      Specify an ARN with a name and a revision number to associate that revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3</code>
             *                                      <p>
             *                                      Specify just the name to associate the latest revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder observabilityConfigurationArn(java.lang.String observabilityConfigurationArn) {
                this.observabilityConfigurationArn = observabilityConfigurationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceObservabilityConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceObservabilityConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceObservabilityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceObservabilityConfigurationProperty {
            private final java.lang.Object observabilityEnabled;
            private final java.lang.String observabilityConfigurationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.observabilityEnabled = software.amazon.jsii.Kernel.get(this, "observabilityEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.observabilityConfigurationArn = software.amazon.jsii.Kernel.get(this, "observabilityConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.observabilityEnabled = java.util.Objects.requireNonNull(builder.observabilityEnabled, "observabilityEnabled is required");
                this.observabilityConfigurationArn = builder.observabilityConfigurationArn;
            }

            @Override
            public final java.lang.Object getObservabilityEnabled() {
                return this.observabilityEnabled;
            }

            @Override
            public final java.lang.String getObservabilityConfigurationArn() {
                return this.observabilityConfigurationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("observabilityEnabled", om.valueToTree(this.getObservabilityEnabled()));
                if (this.getObservabilityConfigurationArn() != null) {
                    data.set("observabilityConfigurationArn", om.valueToTree(this.getObservabilityConfigurationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.ServiceObservabilityConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceObservabilityConfigurationProperty.Jsii$Proxy that = (ServiceObservabilityConfigurationProperty.Jsii$Proxy) o;

                if (!observabilityEnabled.equals(that.observabilityEnabled)) return false;
                return this.observabilityConfigurationArn != null ? this.observabilityConfigurationArn.equals(that.observabilityConfigurationArn) : that.observabilityConfigurationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.observabilityEnabled.hashCode();
                result = 31 * result + (this.observabilityConfigurationArn != null ? this.observabilityConfigurationArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies a version of code that AWS App Runner refers to within a source code repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * SourceCodeVersionProperty sourceCodeVersionProperty = SourceCodeVersionProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.SourceCodeVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceCodeVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceCodeVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of version identifier.
         * <p>
         * For a git-based repository, branches represent versions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A source code version.
         * <p>
         * For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourcecodeversion.html#cfn-apprunner-service-sourcecodeversion-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SourceCodeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceCodeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceCodeVersionProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link SourceCodeVersionProperty#getType}
             * @param type The type of version identifier. This parameter is required.
             *             For a git-based repository, branches represent versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceCodeVersionProperty#getValue}
             * @param value A source code version. This parameter is required.
             *              For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceCodeVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceCodeVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceCodeVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceCodeVersionProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.SourceCodeVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceCodeVersionProperty.Jsii$Proxy that = (SourceCodeVersionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the source deployed to an AWS App Runner service.
     * <p>
     * It can be a code or an image repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apprunner.*;
     * SourceConfigurationProperty sourceConfigurationProperty = SourceConfigurationProperty.builder()
     *         .authenticationConfiguration(AuthenticationConfigurationProperty.builder()
     *                 .accessRoleArn("accessRoleArn")
     *                 .connectionArn("connectionArn")
     *                 .build())
     *         .autoDeploymentsEnabled(false)
     *         .codeRepository(CodeRepositoryProperty.builder()
     *                 .repositoryUrl("repositoryUrl")
     *                 .sourceCodeVersion(SourceCodeVersionProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build())
     *                 // the properties below are optional
     *                 .codeConfiguration(CodeConfigurationProperty.builder()
     *                         .configurationSource("configurationSource")
     *                         // the properties below are optional
     *                         .codeConfigurationValues(CodeConfigurationValuesProperty.builder()
     *                                 .runtime("runtime")
     *                                 // the properties below are optional
     *                                 .buildCommand("buildCommand")
     *                                 .port("port")
     *                                 .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .startCommand("startCommand")
     *                                 .build())
     *                         .build())
     *                 .sourceDirectory("sourceDirectory")
     *                 .build())
     *         .imageRepository(ImageRepositoryProperty.builder()
     *                 .imageIdentifier("imageIdentifier")
     *                 .imageRepositoryType("imageRepositoryType")
     *                 // the properties below are optional
     *                 .imageConfiguration(ImageConfigurationProperty.builder()
     *                         .port("port")
     *                         .runtimeEnvironmentSecrets(List.of(KeyValuePairProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .runtimeEnvironmentVariables(List.of(KeyValuePairProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .startCommand("startCommand")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnService.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the resources that are needed to authenticate access to some source repositories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-authenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-authenticationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationConfiguration() {
            return null;
        }

        /**
         * If <code>true</code> , continuous integration from the source repository is enabled for the App Runner service.
         * <p>
         * Each repository change (including any source code commit or new image version) starts a deployment.
         * <p>
         * Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an AWS account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-autodeploymentsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-autodeploymentsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoDeploymentsEnabled() {
            return null;
        }

        /**
         * The description of a source code repository.
         * <p>
         * You must provide either this member or <code>ImageRepository</code> (but not both).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-coderepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-coderepository</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeRepository() {
            return null;
        }

        /**
         * The description of a source image repository.
         * <p>
         * You must provide either this member or <code>CodeRepository</code> (but not both).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-imagerepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-sourceconfiguration.html#cfn-apprunner-service-sourceconfiguration-imagerepository</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageRepository() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            java.lang.Object authenticationConfiguration;
            java.lang.Object autoDeploymentsEnabled;
            java.lang.Object codeRepository;
            java.lang.Object imageRepository;

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration Describes the resources that are needed to authenticate access to some source repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration Describes the resources that are needed to authenticate access to some source repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.apprunner.CfnService.AuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAutoDeploymentsEnabled}
             * @param autoDeploymentsEnabled If <code>true</code> , continuous integration from the source repository is enabled for the App Runner service.
             *                               Each repository change (including any source code commit or new image version) starts a deployment.
             *                               <p>
             *                               Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an AWS account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoDeploymentsEnabled(java.lang.Boolean autoDeploymentsEnabled) {
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getAutoDeploymentsEnabled}
             * @param autoDeploymentsEnabled If <code>true</code> , continuous integration from the source repository is enabled for the App Runner service.
             *                               Each repository change (including any source code commit or new image version) starts a deployment.
             *                               <p>
             *                               Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an AWS account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoDeploymentsEnabled(software.amazon.awscdk.IResolvable autoDeploymentsEnabled) {
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getCodeRepository}
             * @param codeRepository The description of a source code repository.
             *                       You must provide either this member or <code>ImageRepository</code> (but not both).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepository(software.amazon.awscdk.IResolvable codeRepository) {
                this.codeRepository = codeRepository;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getCodeRepository}
             * @param codeRepository The description of a source code repository.
             *                       You must provide either this member or <code>ImageRepository</code> (but not both).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepository(software.amazon.awscdk.services.apprunner.CfnService.CodeRepositoryProperty codeRepository) {
                this.codeRepository = codeRepository;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getImageRepository}
             * @param imageRepository The description of a source image repository.
             *                        You must provide either this member or <code>CodeRepository</code> (but not both).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageRepository(software.amazon.awscdk.IResolvable imageRepository) {
                this.imageRepository = imageRepository;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getImageRepository}
             * @param imageRepository The description of a source image repository.
             *                        You must provide either this member or <code>CodeRepository</code> (but not both).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageRepository(software.amazon.awscdk.services.apprunner.CfnService.ImageRepositoryProperty imageRepository) {
                this.imageRepository = imageRepository;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigurationProperty {
            private final java.lang.Object authenticationConfiguration;
            private final java.lang.Object autoDeploymentsEnabled;
            private final java.lang.Object codeRepository;
            private final java.lang.Object imageRepository;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoDeploymentsEnabled = software.amazon.jsii.Kernel.get(this, "autoDeploymentsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeRepository = software.amazon.jsii.Kernel.get(this, "codeRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageRepository = software.amazon.jsii.Kernel.get(this, "imageRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationConfiguration = builder.authenticationConfiguration;
                this.autoDeploymentsEnabled = builder.autoDeploymentsEnabled;
                this.codeRepository = builder.codeRepository;
                this.imageRepository = builder.imageRepository;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.lang.Object getAutoDeploymentsEnabled() {
                return this.autoDeploymentsEnabled;
            }

            @Override
            public final java.lang.Object getCodeRepository() {
                return this.codeRepository;
            }

            @Override
            public final java.lang.Object getImageRepository() {
                return this.imageRepository;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthenticationConfiguration() != null) {
                    data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                }
                if (this.getAutoDeploymentsEnabled() != null) {
                    data.set("autoDeploymentsEnabled", om.valueToTree(this.getAutoDeploymentsEnabled()));
                }
                if (this.getCodeRepository() != null) {
                    data.set("codeRepository", om.valueToTree(this.getCodeRepository()));
                }
                if (this.getImageRepository() != null) {
                    data.set("imageRepository", om.valueToTree(this.getImageRepository()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apprunner.CfnService.SourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigurationProperty.Jsii$Proxy that = (SourceConfigurationProperty.Jsii$Proxy) o;

                if (this.authenticationConfiguration != null ? !this.authenticationConfiguration.equals(that.authenticationConfiguration) : that.authenticationConfiguration != null) return false;
                if (this.autoDeploymentsEnabled != null ? !this.autoDeploymentsEnabled.equals(that.autoDeploymentsEnabled) : that.autoDeploymentsEnabled != null) return false;
                if (this.codeRepository != null ? !this.codeRepository.equals(that.codeRepository) : that.codeRepository != null) return false;
                return this.imageRepository != null ? this.imageRepository.equals(that.imageRepository) : that.imageRepository == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationConfiguration != null ? this.authenticationConfiguration.hashCode() : 0;
                result = 31 * result + (this.autoDeploymentsEnabled != null ? this.autoDeploymentsEnabled.hashCode() : 0);
                result = 31 * result + (this.codeRepository != null ? this.codeRepository.hashCode() : 0);
                result = 31 * result + (this.imageRepository != null ? this.imageRepository.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apprunner.CfnService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.CfnService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apprunner.CfnServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apprunner.CfnServiceProps.Builder();
        }

        /**
         * The source to deploy to the App Runner service.
         * <p>
         * It can be a code or an image repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration</a>
         * @param sourceConfiguration The source to deploy to the App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }
        /**
         * The source to deploy to the App Runner service.
         * <p>
         * It can be a code or an image repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-sourceconfiguration</a>
         * @param sourceConfiguration The source to deploy to the App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.
         * <p>
         * If not provided, App Runner associates the latest revision of a default auto scaling configuration.
         * <p>
         * Specify an ARN with a name and a revision number to associate that revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3</code>
         * <p>
         * Specify just the name to associate the latest revision. For example: <code>arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-autoscalingconfigurationarn</a>
         * @param autoScalingConfigurationArn The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingConfigurationArn(final java.lang.String autoScalingConfigurationArn) {
            this.props.autoScalingConfigurationArn(autoScalingConfigurationArn);
            return this;
        }

        /**
         * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
         * <p>
         * By default, App Runner uses an AWS managed key .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration</a>
         * @param encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(final software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }
        /**
         * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs.
         * <p>
         * By default, App Runner uses an AWS managed key .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-encryptionconfiguration</a>
         * @param encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.EncryptionConfigurationProperty encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        /**
         * The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration</a>
         * @param healthCheckConfiguration The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfiguration(final software.amazon.awscdk.IResolvable healthCheckConfiguration) {
            this.props.healthCheckConfiguration(healthCheckConfiguration);
            return this;
        }
        /**
         * The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-healthcheckconfiguration</a>
         * @param healthCheckConfiguration The settings for the health check that AWS App Runner performs to monitor the health of the App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.HealthCheckConfigurationProperty healthCheckConfiguration) {
            this.props.healthCheckConfiguration(healthCheckConfiguration);
            return this;
        }

        /**
         * The runtime configuration of instances (scaling units) of your service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration</a>
         * @param instanceConfiguration The runtime configuration of instances (scaling units) of your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(final software.amazon.awscdk.IResolvable instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }
        /**
         * The runtime configuration of instances (scaling units) of your service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-instanceconfiguration</a>
         * @param instanceConfiguration The runtime configuration of instances (scaling units) of your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.InstanceConfigurationProperty instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }

        /**
         * Configuration settings related to network traffic of the web application that the App Runner service runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-networkconfiguration</a>
         * @param networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * Configuration settings related to network traffic of the web application that the App Runner service runs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-networkconfiguration</a>
         * @param networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * The observability configuration of your service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-observabilityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-observabilityconfiguration</a>
         * @param observabilityConfiguration The observability configuration of your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder observabilityConfiguration(final software.amazon.awscdk.IResolvable observabilityConfiguration) {
            this.props.observabilityConfiguration(observabilityConfiguration);
            return this;
        }
        /**
         * The observability configuration of your service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-observabilityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-observabilityconfiguration</a>
         * @param observabilityConfiguration The observability configuration of your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder observabilityConfiguration(final software.amazon.awscdk.services.apprunner.CfnService.ServiceObservabilityConfigurationProperty observabilityConfiguration) {
            this.props.observabilityConfiguration(observabilityConfiguration);
            return this;
        }

        /**
         * A name for the App Runner service.
         * <p>
         * It must be unique across all the running App Runner services in your AWS account in the AWS Region .
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a name for your service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-servicename</a>
         * @param serviceName A name for the App Runner service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * An optional list of metadata items that you can associate with the App Runner service resource.
         * <p>
         * A tag is a key-value pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apprunner-service.html#cfn-apprunner-service-tags</a>
         * @param tags An optional list of metadata items that you can associate with the App Runner service resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apprunner.CfnService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apprunner.CfnService build() {
            return new software.amazon.awscdk.services.apprunner.CfnService(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
