package software.amazon.awscdk.services.appsync;

/**
 * Factory class for DynamoDB key conditions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * KeyCondition keyCondition = KeyCondition.beginsWith("keyName", "arg");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:14.391Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.KeyCondition")
public class KeyCondition extends software.amazon.jsii.JsiiObject {

    protected KeyCondition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KeyCondition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Condition (k, arg).
     * <p>
     * True if the key attribute k begins with the Query argument.
     * <p>
     * @param keyName This parameter is required.
     * @param arg This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition beginsWith(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "beginsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg, "arg is required") });
    }

    /**
     * Condition k BETWEEN arg1 AND arg2, true if k &gt;= arg1 and k &lt;= arg2.
     * <p>
     * @param keyName This parameter is required.
     * @param arg1 This parameter is required.
     * @param arg2 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition between(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg1, final @org.jetbrains.annotations.NotNull java.lang.String arg2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "between", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg1, "arg1 is required"), java.util.Objects.requireNonNull(arg2, "arg2 is required") });
    }

    /**
     * Condition k = arg, true if the key attribute k is equal to the Query argument.
     * <p>
     * @param keyName This parameter is required.
     * @param arg This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition eq(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "eq", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg, "arg is required") });
    }

    /**
     * Condition k &gt;= arg, true if the key attribute k is greater or equal to the Query argument.
     * <p>
     * @param keyName This parameter is required.
     * @param arg This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition ge(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "ge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg, "arg is required") });
    }

    /**
     * Condition k &gt; arg, true if the key attribute k is greater than the the Query argument.
     * <p>
     * @param keyName This parameter is required.
     * @param arg This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition gt(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "gt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg, "arg is required") });
    }

    /**
     * Condition k &lt;= arg, true if the key attribute k is less than or equal to the Query argument.
     * <p>
     * @param keyName This parameter is required.
     * @param arg This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition le(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "le", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg, "arg is required") });
    }

    /**
     * Condition k &lt; arg, true if the key attribute k is less than the Query argument.
     * <p>
     * @param keyName This parameter is required.
     * @param arg This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition lt(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String arg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.KeyCondition.class, "lt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(arg, "arg is required") });
    }

    /**
     * Conjunction between two conditions.
     * <p>
     * @param keyCond This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition and(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition keyCond) {
        return software.amazon.jsii.Kernel.call(this, "and", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.KeyCondition.class), new Object[] { java.util.Objects.requireNonNull(keyCond, "keyCond is required") });
    }

    /**
     * Renders the key condition to a VTL string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String renderTemplate() {
        return software.amazon.jsii.Kernel.call(this, "renderTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
