package software.amazon.awscdk.services.bedrock;

/**
 * Creates a prompt in your prompt library that you can add to a flow.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Prompt management in Amazon Bedrock</a> , <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt using Prompt management</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows.html">Prompt flows in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnPrompt cfnPrompt = CfnPrompt.Builder.create(this, "MyCfnPrompt")
 *         .name("name")
 *         // the properties below are optional
 *         .customerEncryptionKeyArn("customerEncryptionKeyArn")
 *         .defaultVariant("defaultVariant")
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .variants(List.of(PromptVariantProperty.builder()
 *                 .name("name")
 *                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
 *                         .text(TextPromptTemplateConfigurationProperty.builder()
 *                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .text("text")
 *                                 .textS3Location(TextS3LocationProperty.builder()
 *                                         .bucket("bucket")
 *                                         .key("key")
 *                                         // the properties below are optional
 *                                         .version("version")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .templateType("templateType")
 *                 // the properties below are optional
 *                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
 *                         .text(PromptModelInferenceConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .stopSequences(List.of("stopSequences"))
 *                                 .temperature(123)
 *                                 .topP(123)
 *                                 .build())
 *                         .build())
 *                 .modelId("modelId")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.122Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt")
public class CfnPrompt extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnPrompt(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPrompt(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnPrompt.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPrompt(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnPromptProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the prompt or the prompt version (if you specified a version in the request).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the prompt was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the prompt was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the prompt that this summary applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomerEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "customerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerEncryptionKeyArn", value);
    }

    /**
     * The name of the default variant for the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultVariant() {
        return software.amazon.jsii.Kernel.get(this, "defaultVariant", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the default variant for the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultVariant(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultVariant", value);
    }

    /**
     * The description of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * A list of objects, each containing details about a variant of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVariants() {
        return software.amazon.jsii.Kernel.get(this, "variants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of objects, each containing details about a variant of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariants(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "variants", value);
    }

    /**
     * A list of objects, each containing details about a variant of the prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariants(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.bedrock.CfnPrompt.PromptVariantProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrock.CfnPrompt.PromptVariantProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "variants", value);
    }
    /**
     * Contains inference configurations for the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptInferenceConfigurationProperty promptInferenceConfigurationProperty = PromptInferenceConfigurationProperty.builder()
     *         .text(PromptModelInferenceConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .stopSequences(List.of("stopSequences"))
     *                 .temperature(123)
     *                 .topP(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.PromptInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptInferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptInferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains inference configurations for a text prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinferenceconfiguration.html#cfn-bedrock-prompt-promptinferenceconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinferenceconfiguration.html#cfn-bedrock-prompt-promptinferenceconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getText();

        /**
         * @return a {@link Builder} of {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptInferenceConfigurationProperty> {
            java.lang.Object text;

            /**
             * Sets the value of {@link PromptInferenceConfigurationProperty#getText}
             * @param text Contains inference configurations for a text prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link PromptInferenceConfigurationProperty#getText}
             * @param text Contains inference configurations for a text prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.bedrock.CfnPrompt.PromptModelInferenceConfigurationProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptInferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptInferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptInferenceConfigurationProperty {
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.PromptInferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptInferenceConfigurationProperty.Jsii$Proxy that = (PromptInferenceConfigurationProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about a variable in the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptInputVariableProperty promptInputVariableProperty = PromptInputVariableProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinputvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinputvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.PromptInputVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptInputVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptInputVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinputvariable.html#cfn-bedrock-prompt-promptinputvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptinputvariable.html#cfn-bedrock-prompt-promptinputvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptInputVariableProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link PromptInputVariableProperty#getName}
             * @param name The name of the variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptInputVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptInputVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptInputVariableProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.PromptInputVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptInputVariableProperty.Jsii$Proxy that = (PromptInputVariableProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains inference configurations related to model inference for a prompt.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/inference-parameters.html">Inference parameters</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptModelInferenceConfigurationProperty promptModelInferenceConfigurationProperty = PromptModelInferenceConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .stopSequences(List.of("stopSequences"))
     *         .temperature(123)
     *         .topP(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.PromptModelInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptModelInferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptModelInferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens to return in the response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTokens() {
            return null;
        }

        /**
         * A list of strings that define sequences after which the model will stop generating.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-stopsequences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-stopsequences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStopSequences() {
            return null;
        }

        /**
         * Controls the randomness of the response.
         * <p>
         * Choose a lower value for more predictable outputs and a higher value for more surprising outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-temperature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-temperature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTemperature() {
            return null;
        }

        /**
         * The percentage of most-likely candidates that the model considers for the next token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-topp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptmodelinferenceconfiguration.html#cfn-bedrock-prompt-promptmodelinferenceconfiguration-topp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopP() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptModelInferenceConfigurationProperty> {
            java.lang.Number maxTokens;
            java.util.List<java.lang.String> stopSequences;
            java.lang.Number temperature;
            java.lang.Number topP;

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens to return in the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getStopSequences}
             * @param stopSequences A list of strings that define sequences after which the model will stop generating.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopSequences(java.util.List<java.lang.String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getTemperature}
             * @param temperature Controls the randomness of the response.
             *                    Choose a lower value for more predictable outputs and a higher value for more surprising outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temperature(java.lang.Number temperature) {
                this.temperature = temperature;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getTopP}
             * @param topP The percentage of most-likely candidates that the model considers for the next token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topP(java.lang.Number topP) {
                this.topP = topP;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptModelInferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptModelInferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptModelInferenceConfigurationProperty {
            private final java.lang.Number maxTokens;
            private final java.util.List<java.lang.String> stopSequences;
            private final java.lang.Number temperature;
            private final java.lang.Number topP;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stopSequences = software.amazon.jsii.Kernel.get(this, "stopSequences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.temperature = software.amazon.jsii.Kernel.get(this, "temperature", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topP = software.amazon.jsii.Kernel.get(this, "topP", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = builder.maxTokens;
                this.stopSequences = builder.stopSequences;
                this.temperature = builder.temperature;
                this.topP = builder.topP;
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            public final java.util.List<java.lang.String> getStopSequences() {
                return this.stopSequences;
            }

            @Override
            public final java.lang.Number getTemperature() {
                return this.temperature;
            }

            @Override
            public final java.lang.Number getTopP() {
                return this.topP;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxTokens() != null) {
                    data.set("maxTokens", om.valueToTree(this.getMaxTokens()));
                }
                if (this.getStopSequences() != null) {
                    data.set("stopSequences", om.valueToTree(this.getStopSequences()));
                }
                if (this.getTemperature() != null) {
                    data.set("temperature", om.valueToTree(this.getTemperature()));
                }
                if (this.getTopP() != null) {
                    data.set("topP", om.valueToTree(this.getTopP()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.PromptModelInferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptModelInferenceConfigurationProperty.Jsii$Proxy that = (PromptModelInferenceConfigurationProperty.Jsii$Proxy) o;

                if (this.maxTokens != null ? !this.maxTokens.equals(that.maxTokens) : that.maxTokens != null) return false;
                if (this.stopSequences != null ? !this.stopSequences.equals(that.stopSequences) : that.stopSequences != null) return false;
                if (this.temperature != null ? !this.temperature.equals(that.temperature) : that.temperature != null) return false;
                return this.topP != null ? this.topP.equals(that.topP) : that.topP == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens != null ? this.maxTokens.hashCode() : 0;
                result = 31 * result + (this.stopSequences != null ? this.stopSequences.hashCode() : 0);
                result = 31 * result + (this.temperature != null ? this.temperature.hashCode() : 0);
                result = 31 * result + (this.topP != null ? this.topP.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the message for a prompt.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Construct and store reusable prompts with Prompt management in Amazon Bedrock</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptTemplateConfigurationProperty promptTemplateConfigurationProperty = PromptTemplateConfigurationProperty.builder()
     *         .text(TextPromptTemplateConfigurationProperty.builder()
     *                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .text("text")
     *                 .textS3Location(TextS3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         // the properties below are optional
     *                         .version("version")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-prompttemplateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-prompttemplateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.PromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the text in a message for a prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-prompttemplateconfiguration.html#cfn-bedrock-prompt-prompttemplateconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-prompttemplateconfiguration.html#cfn-bedrock-prompt-prompttemplateconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getText();

        /**
         * @return a {@link Builder} of {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptTemplateConfigurationProperty> {
            java.lang.Object text;

            /**
             * Sets the value of {@link PromptTemplateConfigurationProperty#getText}
             * @param text Contains configurations for the text in a message for a prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link PromptTemplateConfigurationProperty#getText}
             * @param text Contains configurations for the text in a message for a prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.bedrock.CfnPrompt.TextPromptTemplateConfigurationProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptTemplateConfigurationProperty {
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.PromptTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptTemplateConfigurationProperty.Jsii$Proxy that = (PromptTemplateConfigurationProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details about a variant of the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptVariantProperty promptVariantProperty = PromptVariantProperty.builder()
     *         .name("name")
     *         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .text("text")
     *                         .textS3Location(TextS3LocationProperty.builder()
     *                                 .bucket("bucket")
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .version("version")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .templateType("templateType")
     *         // the properties below are optional
     *         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .stopSequences(List.of("stopSequences"))
     *                         .temperature(123)
     *                         .topP(123)
     *                         .build())
     *                 .build())
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.PromptVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the prompt variant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Contains configurations for the prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-templateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-templateconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTemplateConfiguration();

        /**
         * The type of prompt template to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-templatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-templatetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemplateType();

        /**
         * Contains inference configurations for the prompt variant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-inferenceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-inferenceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfiguration() {
            return null;
        }

        /**
         * The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> with which to run inference on the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-promptvariant.html#cfn-bedrock-prompt-promptvariant-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptVariantProperty> {
            java.lang.String name;
            java.lang.Object templateConfiguration;
            java.lang.String templateType;
            java.lang.Object inferenceConfiguration;
            java.lang.String modelId;

            /**
             * Sets the value of {@link PromptVariantProperty#getName}
             * @param name The name of the prompt variant. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link PromptVariantProperty#getTemplateConfiguration}
             * @param templateConfiguration Contains configurations for the prompt template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptVariantProperty#getTemplateConfiguration}
             * @param templateConfiguration Contains configurations for the prompt template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.services.bedrock.CfnPrompt.PromptTemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptVariantProperty#getTemplateType}
             * @param templateType The type of prompt template to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateType(java.lang.String templateType) {
                this.templateType = templateType;
                return this;
            }

            /**
             * Sets the value of {@link PromptVariantProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt variant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptVariantProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt variant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.services.bedrock.CfnPrompt.PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptVariantProperty#getModelId}
             * @param modelId The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> with which to run inference on the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptVariantProperty {
            private final java.lang.String name;
            private final java.lang.Object templateConfiguration;
            private final java.lang.String templateType;
            private final java.lang.Object inferenceConfiguration;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateConfiguration = software.amazon.jsii.Kernel.get(this, "templateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.templateType = software.amazon.jsii.Kernel.get(this, "templateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceConfiguration = software.amazon.jsii.Kernel.get(this, "inferenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.templateConfiguration = java.util.Objects.requireNonNull(builder.templateConfiguration, "templateConfiguration is required");
                this.templateType = java.util.Objects.requireNonNull(builder.templateType, "templateType is required");
                this.inferenceConfiguration = builder.inferenceConfiguration;
                this.modelId = builder.modelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTemplateConfiguration() {
                return this.templateConfiguration;
            }

            @Override
            public final java.lang.String getTemplateType() {
                return this.templateType;
            }

            @Override
            public final java.lang.Object getInferenceConfiguration() {
                return this.inferenceConfiguration;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("templateConfiguration", om.valueToTree(this.getTemplateConfiguration()));
                data.set("templateType", om.valueToTree(this.getTemplateType()));
                if (this.getInferenceConfiguration() != null) {
                    data.set("inferenceConfiguration", om.valueToTree(this.getInferenceConfiguration()));
                }
                if (this.getModelId() != null) {
                    data.set("modelId", om.valueToTree(this.getModelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.PromptVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptVariantProperty.Jsii$Proxy that = (PromptVariantProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!templateConfiguration.equals(that.templateConfiguration)) return false;
                if (!templateType.equals(that.templateType)) return false;
                if (this.inferenceConfiguration != null ? !this.inferenceConfiguration.equals(that.inferenceConfiguration) : that.inferenceConfiguration != null) return false;
                return this.modelId != null ? this.modelId.equals(that.modelId) : that.modelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.templateConfiguration.hashCode());
                result = 31 * result + (this.templateType.hashCode());
                result = 31 * result + (this.inferenceConfiguration != null ? this.inferenceConfiguration.hashCode() : 0);
                result = 31 * result + (this.modelId != null ? this.modelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a text prompt template.
     * <p>
     * To include a variable, enclose a word in double curly braces as in <code>{{variable}}</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TextPromptTemplateConfigurationProperty textPromptTemplateConfigurationProperty = TextPromptTemplateConfigurationProperty.builder()
     *         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .text("text")
     *         .textS3Location(TextS3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 // the properties below are optional
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.TextPromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextPromptTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextPromptTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of the variables in the prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html#cfn-bedrock-prompt-textprompttemplateconfiguration-inputvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html#cfn-bedrock-prompt-textprompttemplateconfiguration-inputvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputVariables() {
            return null;
        }

        /**
         * The message for the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html#cfn-bedrock-prompt-textprompttemplateconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html#cfn-bedrock-prompt-textprompttemplateconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * The Amazon S3 location of the prompt text.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html#cfn-bedrock-prompt-textprompttemplateconfiguration-texts3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-textprompttemplateconfiguration.html#cfn-bedrock-prompt-textprompttemplateconfiguration-texts3location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTextS3Location() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextPromptTemplateConfigurationProperty> {
            java.lang.Object inputVariables;
            java.lang.String text;
            java.lang.Object textS3Location;

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getInputVariables}
             * @param inputVariables An array of the variables in the prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputVariables(software.amazon.awscdk.IResolvable inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getInputVariables}
             * @param inputVariables An array of the variables in the prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputVariables(java.util.List<? extends java.lang.Object> inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getText}
             * @param text The message for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getTextS3Location}
             * @param textS3Location The Amazon S3 location of the prompt text.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textS3Location(software.amazon.awscdk.IResolvable textS3Location) {
                this.textS3Location = textS3Location;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getTextS3Location}
             * @param textS3Location The Amazon S3 location of the prompt text.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textS3Location(software.amazon.awscdk.services.bedrock.CfnPrompt.TextS3LocationProperty textS3Location) {
                this.textS3Location = textS3Location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextPromptTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextPromptTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextPromptTemplateConfigurationProperty {
            private final java.lang.Object inputVariables;
            private final java.lang.String text;
            private final java.lang.Object textS3Location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputVariables = software.amazon.jsii.Kernel.get(this, "inputVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textS3Location = software.amazon.jsii.Kernel.get(this, "textS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputVariables = builder.inputVariables;
                this.text = builder.text;
                this.textS3Location = builder.textS3Location;
            }

            @Override
            public final java.lang.Object getInputVariables() {
                return this.inputVariables;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.Object getTextS3Location() {
                return this.textS3Location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputVariables() != null) {
                    data.set("inputVariables", om.valueToTree(this.getInputVariables()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }
                if (this.getTextS3Location() != null) {
                    data.set("textS3Location", om.valueToTree(this.getTextS3Location()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.TextPromptTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextPromptTemplateConfigurationProperty.Jsii$Proxy that = (TextPromptTemplateConfigurationProperty.Jsii$Proxy) o;

                if (this.inputVariables != null ? !this.inputVariables.equals(that.inputVariables) : that.inputVariables != null) return false;
                if (this.text != null ? !this.text.equals(that.text) : that.text != null) return false;
                return this.textS3Location != null ? this.textS3Location.equals(that.textS3Location) : that.textS3Location == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputVariables != null ? this.inputVariables.hashCode() : 0;
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                result = 31 * result + (this.textS3Location != null ? this.textS3Location.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 location of the prompt text.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TextS3LocationProperty textS3LocationProperty = TextS3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnPrompt.TextS3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextS3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextS3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket containing the prompt text.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html#cfn-bedrock-prompt-texts3location-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html#cfn-bedrock-prompt-texts3location-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The object key for the Amazon S3 location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html#cfn-bedrock-prompt-texts3location-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html#cfn-bedrock-prompt-texts3location-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The version of the Amazon S3 location to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html#cfn-bedrock-prompt-texts3location-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-prompt-texts3location.html#cfn-bedrock-prompt-texts3location-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TextS3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextS3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextS3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.String version;

            /**
             * Sets the value of {@link TextS3LocationProperty#getBucket}
             * @param bucket The Amazon S3 bucket containing the prompt text. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link TextS3LocationProperty#getKey}
             * @param key The object key for the Amazon S3 location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TextS3LocationProperty#getVersion}
             * @param version The version of the Amazon S3 location to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextS3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextS3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextS3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextS3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnPrompt.TextS3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextS3LocationProperty.Jsii$Proxy that = (TextS3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnPrompt}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnPrompt> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnPromptProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnPromptProps.Builder();
        }

        /**
         * The name of the prompt.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-name</a>
         * @param name The name of the prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-customerencryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-customerencryptionkeyarn</a>
         * @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryptionKeyArn(final java.lang.String customerEncryptionKeyArn) {
            this.props.customerEncryptionKeyArn(customerEncryptionKeyArn);
            return this;
        }

        /**
         * The name of the default variant for the prompt.
         * <p>
         * This value must match the <code>name</code> field in the relevant <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html">PromptVariant</a> object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-defaultvariant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-defaultvariant</a>
         * @param defaultVariant The name of the default variant for the prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultVariant(final java.lang.String defaultVariant) {
            this.props.defaultVariant(defaultVariant);
            return this;
        }

        /**
         * The description of the prompt.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-description</a>
         * @param description The description of the prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-tags</a>
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A list of objects, each containing details about a variant of the prompt.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-variants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-variants</a>
         * @param variants A list of objects, each containing details about a variant of the prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(final software.amazon.awscdk.IResolvable variants) {
            this.props.variants(variants);
            return this;
        }
        /**
         * A list of objects, each containing details about a variant of the prompt.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-variants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-prompt.html#cfn-bedrock-prompt-variants</a>
         * @param variants A list of objects, each containing details about a variant of the prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(final java.util.List<? extends java.lang.Object> variants) {
            this.props.variants(variants);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnPrompt}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnPrompt build() {
            return new software.amazon.awscdk.services.bedrock.CfnPrompt(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
