package software.amazon.awscdk.services.billingconductor;

/**
 * Properties for defining a <code>CfnBillingGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnBillingGroupProps cfnBillingGroupProps = CfnBillingGroupProps.builder()
 *         .accountGrouping(AccountGroupingProperty.builder()
 *                 .linkedAccountIds(List.of("linkedAccountIds"))
 *                 // the properties below are optional
 *                 .autoAssociate(false)
 *                 .build())
 *         .computationPreference(ComputationPreferenceProperty.builder()
 *                 .pricingPlanArn("pricingPlanArn")
 *                 .build())
 *         .name("name")
 *         .primaryAccountId("primaryAccountId")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.136Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_billingconductor.CfnBillingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnBillingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBillingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of accounts that will be under the billing group.
     * <p>
     * The set of accounts resemble the linked accounts in a consolidated billing family.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-accountgrouping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-accountgrouping</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAccountGrouping();

    /**
     * The preferences and settings that will be used to compute the AWS charges for a billing group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-computationpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-computationpreference</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputationPreference();

    /**
     * The billing group's name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The account ID that serves as the main account in a billing group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-primaryaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-primaryaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrimaryAccountId();

    /**
     * The description of the billing group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values that are attached to a billing group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-billinggroup.html#cfn-billingconductor-billinggroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBillingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBillingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBillingGroupProps> {
        java.lang.Object accountGrouping;
        java.lang.Object computationPreference;
        java.lang.String name;
        java.lang.String primaryAccountId;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnBillingGroupProps#getAccountGrouping}
         * @param accountGrouping The set of accounts that will be under the billing group. This parameter is required.
         *                        The set of accounts resemble the linked accounts in a consolidated billing family.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountGrouping(software.amazon.awscdk.IResolvable accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getAccountGrouping}
         * @param accountGrouping The set of accounts that will be under the billing group. This parameter is required.
         *                        The set of accounts resemble the linked accounts in a consolidated billing family.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountGrouping(software.amazon.awscdk.services.billingconductor.CfnBillingGroup.AccountGroupingProperty accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getComputationPreference}
         * @param computationPreference The preferences and settings that will be used to compute the AWS charges for a billing group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationPreference(software.amazon.awscdk.IResolvable computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getComputationPreference}
         * @param computationPreference The preferences and settings that will be used to compute the AWS charges for a billing group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationPreference(software.amazon.awscdk.services.billingconductor.CfnBillingGroup.ComputationPreferenceProperty computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getName}
         * @param name The billing group's name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getPrimaryAccountId}
         * @param primaryAccountId The account ID that serves as the main account in a billing group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryAccountId(java.lang.String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getDescription}
         * @param description The description of the billing group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getTags}
         * @param tags A map that contains tag keys and tag values that are attached to a billing group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBillingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBillingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBillingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBillingGroupProps {
        private final java.lang.Object accountGrouping;
        private final java.lang.Object computationPreference;
        private final java.lang.String name;
        private final java.lang.String primaryAccountId;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountGrouping = software.amazon.jsii.Kernel.get(this, "accountGrouping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computationPreference = software.amazon.jsii.Kernel.get(this, "computationPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.primaryAccountId = software.amazon.jsii.Kernel.get(this, "primaryAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountGrouping = java.util.Objects.requireNonNull(builder.accountGrouping, "accountGrouping is required");
            this.computationPreference = java.util.Objects.requireNonNull(builder.computationPreference, "computationPreference is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.primaryAccountId = java.util.Objects.requireNonNull(builder.primaryAccountId, "primaryAccountId is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAccountGrouping() {
            return this.accountGrouping;
        }

        @Override
        public final java.lang.Object getComputationPreference() {
            return this.computationPreference;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPrimaryAccountId() {
            return this.primaryAccountId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountGrouping", om.valueToTree(this.getAccountGrouping()));
            data.set("computationPreference", om.valueToTree(this.getComputationPreference()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("primaryAccountId", om.valueToTree(this.getPrimaryAccountId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_billingconductor.CfnBillingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBillingGroupProps.Jsii$Proxy that = (CfnBillingGroupProps.Jsii$Proxy) o;

            if (!accountGrouping.equals(that.accountGrouping)) return false;
            if (!computationPreference.equals(that.computationPreference)) return false;
            if (!name.equals(that.name)) return false;
            if (!primaryAccountId.equals(that.primaryAccountId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountGrouping.hashCode();
            result = 31 * result + (this.computationPreference.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.primaryAccountId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
