package software.amazon.awscdk.services.cleanrooms;

/**
 * Properties for defining a <code>CfnCollaboration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnCollaborationProps cfnCollaborationProps = CfnCollaborationProps.builder()
 *         .creatorDisplayName("creatorDisplayName")
 *         .creatorMemberAbilities(List.of("creatorMemberAbilities"))
 *         .description("description")
 *         .members(List.of(MemberSpecificationProperty.builder()
 *                 .accountId("accountId")
 *                 .displayName("displayName")
 *                 .memberAbilities(List.of("memberAbilities"))
 *                 // the properties below are optional
 *                 .paymentConfiguration(PaymentConfigurationProperty.builder()
 *                         .queryCompute(QueryComputePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .name("name")
 *         .queryLogStatus("queryLogStatus")
 *         // the properties below are optional
 *         .analyticsEngine("analyticsEngine")
 *         .creatorPaymentConfiguration(PaymentConfigurationProperty.builder()
 *                 .queryCompute(QueryComputePaymentConfigProperty.builder()
 *                         .isResponsible(false)
 *                         .build())
 *                 .build())
 *         .dataEncryptionMetadata(DataEncryptionMetadataProperty.builder()
 *                 .allowCleartext(false)
 *                 .allowDuplicates(false)
 *                 .allowJoinsOnColumnsWithDifferentNames(false)
 *                 .preserveNulls(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.253Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaborationProps")
@software.amazon.jsii.Jsii.Proxy(CfnCollaborationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCollaborationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A display name of the collaboration creator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCreatorDisplayName();

    /**
     * The abilities granted to the collaboration creator.
     * <p>
     * <em>Allowed values</em> <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreatorMemberAbilities();

    /**
     * A description of the collaboration provided by the collaboration owner.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * A list of initial members, not including the creator.
     * <p>
     * This list is immutable.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMembers();

    /**
     * A human-readable identifier provided by the collaboration owner.
     * <p>
     * Display names are not unique.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryLogStatus();

    /**
     * The analytics engine for the collaboration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-analyticsengine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-analyticsengine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAnalyticsEngine() {
        return null;
    }

    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCreatorPaymentConfiguration() {
        return null;
    }

    /**
     * The settings for client-side encryption for cryptographic computing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataEncryptionMetadata() {
        return null;
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCollaborationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCollaborationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCollaborationProps> {
        java.lang.String creatorDisplayName;
        java.util.List<java.lang.String> creatorMemberAbilities;
        java.lang.String description;
        java.lang.Object members;
        java.lang.String name;
        java.lang.String queryLogStatus;
        java.lang.String analyticsEngine;
        java.lang.Object creatorPaymentConfiguration;
        java.lang.Object dataEncryptionMetadata;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorDisplayName}
         * @param creatorDisplayName A display name of the collaboration creator. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorDisplayName(java.lang.String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorMemberAbilities}
         * @param creatorMemberAbilities The abilities granted to the collaboration creator. This parameter is required.
         *                               <em>Allowed values</em> <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMemberAbilities(java.util.List<java.lang.String> creatorMemberAbilities) {
            this.creatorMemberAbilities = creatorMemberAbilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getDescription}
         * @param description A description of the collaboration provided by the collaboration owner. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getMembers}
         * @param members A list of initial members, not including the creator. This parameter is required.
         *                This list is immutable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(software.amazon.awscdk.IResolvable members) {
            this.members = members;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getMembers}
         * @param members A list of initial members, not including the creator. This parameter is required.
         *                This list is immutable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(java.util.List<? extends java.lang.Object> members) {
            this.members = members;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getName}
         * @param name A human-readable identifier provided by the collaboration owner. This parameter is required.
         *             Display names are not unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getQueryLogStatus}
         * @param queryLogStatus An indicator as to whether query logging has been enabled or disabled for the collaboration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogStatus(java.lang.String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getAnalyticsEngine}
         * @param analyticsEngine The analytics engine for the collaboration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsEngine(java.lang.String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorPaymentConfiguration}
         * @param creatorPaymentConfiguration An object representing the collaboration member's payment responsibilities set by the collaboration creator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorPaymentConfiguration(software.amazon.awscdk.IResolvable creatorPaymentConfiguration) {
            this.creatorPaymentConfiguration = creatorPaymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getCreatorPaymentConfiguration}
         * @param creatorPaymentConfiguration An object representing the collaboration member's payment responsibilities set by the collaboration creator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorPaymentConfiguration(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.PaymentConfigurationProperty creatorPaymentConfiguration) {
            this.creatorPaymentConfiguration = creatorPaymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getDataEncryptionMetadata}
         * @param dataEncryptionMetadata The settings for client-side encryption for cryptographic computing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataEncryptionMetadata(software.amazon.awscdk.IResolvable dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getDataEncryptionMetadata}
         * @param dataEncryptionMetadata The settings for client-side encryption for cryptographic computing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataEncryptionMetadata(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnCollaborationProps#getTags}
         * @param tags An optional label that you can assign to a resource when you create it.
         *             Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCollaborationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCollaborationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCollaborationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCollaborationProps {
        private final java.lang.String creatorDisplayName;
        private final java.util.List<java.lang.String> creatorMemberAbilities;
        private final java.lang.String description;
        private final java.lang.Object members;
        private final java.lang.String name;
        private final java.lang.String queryLogStatus;
        private final java.lang.String analyticsEngine;
        private final java.lang.Object creatorPaymentConfiguration;
        private final java.lang.Object dataEncryptionMetadata;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.creatorDisplayName = software.amazon.jsii.Kernel.get(this, "creatorDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.creatorMemberAbilities = software.amazon.jsii.Kernel.get(this, "creatorMemberAbilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.members = software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogStatus = software.amazon.jsii.Kernel.get(this, "queryLogStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.analyticsEngine = software.amazon.jsii.Kernel.get(this, "analyticsEngine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.creatorPaymentConfiguration = software.amazon.jsii.Kernel.get(this, "creatorPaymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataEncryptionMetadata = software.amazon.jsii.Kernel.get(this, "dataEncryptionMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.creatorDisplayName = java.util.Objects.requireNonNull(builder.creatorDisplayName, "creatorDisplayName is required");
            this.creatorMemberAbilities = java.util.Objects.requireNonNull(builder.creatorMemberAbilities, "creatorMemberAbilities is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.members = java.util.Objects.requireNonNull(builder.members, "members is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.queryLogStatus = java.util.Objects.requireNonNull(builder.queryLogStatus, "queryLogStatus is required");
            this.analyticsEngine = builder.analyticsEngine;
            this.creatorPaymentConfiguration = builder.creatorPaymentConfiguration;
            this.dataEncryptionMetadata = builder.dataEncryptionMetadata;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCreatorDisplayName() {
            return this.creatorDisplayName;
        }

        @Override
        public final java.util.List<java.lang.String> getCreatorMemberAbilities() {
            return this.creatorMemberAbilities;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getMembers() {
            return this.members;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        @Override
        public final java.lang.String getAnalyticsEngine() {
            return this.analyticsEngine;
        }

        @Override
        public final java.lang.Object getCreatorPaymentConfiguration() {
            return this.creatorPaymentConfiguration;
        }

        @Override
        public final java.lang.Object getDataEncryptionMetadata() {
            return this.dataEncryptionMetadata;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("creatorDisplayName", om.valueToTree(this.getCreatorDisplayName()));
            data.set("creatorMemberAbilities", om.valueToTree(this.getCreatorMemberAbilities()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("members", om.valueToTree(this.getMembers()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("queryLogStatus", om.valueToTree(this.getQueryLogStatus()));
            if (this.getAnalyticsEngine() != null) {
                data.set("analyticsEngine", om.valueToTree(this.getAnalyticsEngine()));
            }
            if (this.getCreatorPaymentConfiguration() != null) {
                data.set("creatorPaymentConfiguration", om.valueToTree(this.getCreatorPaymentConfiguration()));
            }
            if (this.getDataEncryptionMetadata() != null) {
                data.set("dataEncryptionMetadata", om.valueToTree(this.getDataEncryptionMetadata()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaborationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCollaborationProps.Jsii$Proxy that = (CfnCollaborationProps.Jsii$Proxy) o;

            if (!creatorDisplayName.equals(that.creatorDisplayName)) return false;
            if (!creatorMemberAbilities.equals(that.creatorMemberAbilities)) return false;
            if (!description.equals(that.description)) return false;
            if (!members.equals(that.members)) return false;
            if (!name.equals(that.name)) return false;
            if (!queryLogStatus.equals(that.queryLogStatus)) return false;
            if (this.analyticsEngine != null ? !this.analyticsEngine.equals(that.analyticsEngine) : that.analyticsEngine != null) return false;
            if (this.creatorPaymentConfiguration != null ? !this.creatorPaymentConfiguration.equals(that.creatorPaymentConfiguration) : that.creatorPaymentConfiguration != null) return false;
            if (this.dataEncryptionMetadata != null ? !this.dataEncryptionMetadata.equals(that.dataEncryptionMetadata) : that.dataEncryptionMetadata != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.creatorDisplayName.hashCode();
            result = 31 * result + (this.creatorMemberAbilities.hashCode());
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.members.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.queryLogStatus.hashCode());
            result = 31 * result + (this.analyticsEngine != null ? this.analyticsEngine.hashCode() : 0);
            result = 31 * result + (this.creatorPaymentConfiguration != null ? this.creatorPaymentConfiguration.hashCode() : 0);
            result = 31 * result + (this.dataEncryptionMetadata != null ? this.dataEncryptionMetadata.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
