package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnDistribution</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnDistributionProps cfnDistributionProps = CfnDistributionProps.builder()
 *         .distributionConfig(DistributionConfigProperty.builder()
 *                 .defaultCacheBehavior(DefaultCacheBehaviorProperty.builder()
 *                         .targetOriginId("targetOriginId")
 *                         .viewerProtocolPolicy("viewerProtocolPolicy")
 *                         // the properties below are optional
 *                         .allowedMethods(List.of("allowedMethods"))
 *                         .cachedMethods(List.of("cachedMethods"))
 *                         .cachePolicyId("cachePolicyId")
 *                         .compress(false)
 *                         .defaultTtl(123)
 *                         .fieldLevelEncryptionId("fieldLevelEncryptionId")
 *                         .forwardedValues(ForwardedValuesProperty.builder()
 *                                 .queryString(false)
 *                                 // the properties below are optional
 *                                 .cookies(CookiesProperty.builder()
 *                                         .forward("forward")
 *                                         // the properties below are optional
 *                                         .whitelistedNames(List.of("whitelistedNames"))
 *                                         .build())
 *                                 .headers(List.of("headers"))
 *                                 .queryStringCacheKeys(List.of("queryStringCacheKeys"))
 *                                 .build())
 *                         .functionAssociations(List.of(FunctionAssociationProperty.builder()
 *                                 .eventType("eventType")
 *                                 .functionArn("functionArn")
 *                                 .build()))
 *                         .lambdaFunctionAssociations(List.of(LambdaFunctionAssociationProperty.builder()
 *                                 .eventType("eventType")
 *                                 .includeBody(false)
 *                                 .lambdaFunctionArn("lambdaFunctionArn")
 *                                 .build()))
 *                         .maxTtl(123)
 *                         .minTtl(123)
 *                         .originRequestPolicyId("originRequestPolicyId")
 *                         .realtimeLogConfigArn("realtimeLogConfigArn")
 *                         .responseHeadersPolicyId("responseHeadersPolicyId")
 *                         .smoothStreaming(false)
 *                         .trustedKeyGroups(List.of("trustedKeyGroups"))
 *                         .trustedSigners(List.of("trustedSigners"))
 *                         .build())
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .aliases(List.of("aliases"))
 *                 .cacheBehaviors(List.of(CacheBehaviorProperty.builder()
 *                         .pathPattern("pathPattern")
 *                         .targetOriginId("targetOriginId")
 *                         .viewerProtocolPolicy("viewerProtocolPolicy")
 *                         // the properties below are optional
 *                         .allowedMethods(List.of("allowedMethods"))
 *                         .cachedMethods(List.of("cachedMethods"))
 *                         .cachePolicyId("cachePolicyId")
 *                         .compress(false)
 *                         .defaultTtl(123)
 *                         .fieldLevelEncryptionId("fieldLevelEncryptionId")
 *                         .forwardedValues(ForwardedValuesProperty.builder()
 *                                 .queryString(false)
 *                                 // the properties below are optional
 *                                 .cookies(CookiesProperty.builder()
 *                                         .forward("forward")
 *                                         // the properties below are optional
 *                                         .whitelistedNames(List.of("whitelistedNames"))
 *                                         .build())
 *                                 .headers(List.of("headers"))
 *                                 .queryStringCacheKeys(List.of("queryStringCacheKeys"))
 *                                 .build())
 *                         .functionAssociations(List.of(FunctionAssociationProperty.builder()
 *                                 .eventType("eventType")
 *                                 .functionArn("functionArn")
 *                                 .build()))
 *                         .lambdaFunctionAssociations(List.of(LambdaFunctionAssociationProperty.builder()
 *                                 .eventType("eventType")
 *                                 .includeBody(false)
 *                                 .lambdaFunctionArn("lambdaFunctionArn")
 *                                 .build()))
 *                         .maxTtl(123)
 *                         .minTtl(123)
 *                         .originRequestPolicyId("originRequestPolicyId")
 *                         .realtimeLogConfigArn("realtimeLogConfigArn")
 *                         .responseHeadersPolicyId("responseHeadersPolicyId")
 *                         .smoothStreaming(false)
 *                         .trustedKeyGroups(List.of("trustedKeyGroups"))
 *                         .trustedSigners(List.of("trustedSigners"))
 *                         .build()))
 *                 .cnamEs(List.of("cnamEs"))
 *                 .comment("comment")
 *                 .continuousDeploymentPolicyId("continuousDeploymentPolicyId")
 *                 .customErrorResponses(List.of(CustomErrorResponseProperty.builder()
 *                         .errorCode(123)
 *                         // the properties below are optional
 *                         .errorCachingMinTtl(123)
 *                         .responseCode(123)
 *                         .responsePagePath("responsePagePath")
 *                         .build()))
 *                 .customOrigin(LegacyCustomOriginProperty.builder()
 *                         .dnsName("dnsName")
 *                         .originProtocolPolicy("originProtocolPolicy")
 *                         .originSslProtocols(List.of("originSslProtocols"))
 *                         // the properties below are optional
 *                         .httpPort(123)
 *                         .httpsPort(123)
 *                         .build())
 *                 .defaultRootObject("defaultRootObject")
 *                 .httpVersion("httpVersion")
 *                 .ipv6Enabled(false)
 *                 .logging(LoggingProperty.builder()
 *                         .bucket("bucket")
 *                         // the properties below are optional
 *                         .includeCookies(false)
 *                         .prefix("prefix")
 *                         .build())
 *                 .originGroups(OriginGroupsProperty.builder()
 *                         .quantity(123)
 *                         // the properties below are optional
 *                         .items(List.of(OriginGroupProperty.builder()
 *                                 .failoverCriteria(OriginGroupFailoverCriteriaProperty.builder()
 *                                         .statusCodes(StatusCodesProperty.builder()
 *                                                 .items(List.of(123))
 *                                                 .quantity(123)
 *                                                 .build())
 *                                         .build())
 *                                 .id("id")
 *                                 .members(OriginGroupMembersProperty.builder()
 *                                         .items(List.of(OriginGroupMemberProperty.builder()
 *                                                 .originId("originId")
 *                                                 .build()))
 *                                         .quantity(123)
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .origins(List.of(OriginProperty.builder()
 *                         .domainName("domainName")
 *                         .id("id")
 *                         // the properties below are optional
 *                         .connectionAttempts(123)
 *                         .connectionTimeout(123)
 *                         .customOriginConfig(CustomOriginConfigProperty.builder()
 *                                 .originProtocolPolicy("originProtocolPolicy")
 *                                 // the properties below are optional
 *                                 .httpPort(123)
 *                                 .httpsPort(123)
 *                                 .originKeepaliveTimeout(123)
 *                                 .originReadTimeout(123)
 *                                 .originSslProtocols(List.of("originSslProtocols"))
 *                                 .build())
 *                         .originAccessControlId("originAccessControlId")
 *                         .originCustomHeaders(List.of(OriginCustomHeaderProperty.builder()
 *                                 .headerName("headerName")
 *                                 .headerValue("headerValue")
 *                                 .build()))
 *                         .originPath("originPath")
 *                         .originShield(OriginShieldProperty.builder()
 *                                 .enabled(false)
 *                                 .originShieldRegion("originShieldRegion")
 *                                 .build())
 *                         .s3OriginConfig(S3OriginConfigProperty.builder()
 *                                 .originAccessIdentity("originAccessIdentity")
 *                                 .build())
 *                         .build()))
 *                 .priceClass("priceClass")
 *                 .restrictions(RestrictionsProperty.builder()
 *                         .geoRestriction(GeoRestrictionProperty.builder()
 *                                 .restrictionType("restrictionType")
 *                                 // the properties below are optional
 *                                 .locations(List.of("locations"))
 *                                 .build())
 *                         .build())
 *                 .s3Origin(LegacyS3OriginProperty.builder()
 *                         .dnsName("dnsName")
 *                         // the properties below are optional
 *                         .originAccessIdentity("originAccessIdentity")
 *                         .build())
 *                 .staging(false)
 *                 .viewerCertificate(ViewerCertificateProperty.builder()
 *                         .acmCertificateArn("acmCertificateArn")
 *                         .cloudFrontDefaultCertificate(false)
 *                         .iamCertificateId("iamCertificateId")
 *                         .minimumProtocolVersion("minimumProtocolVersion")
 *                         .sslSupportMethod("sslSupportMethod")
 *                         .build())
 *                 .webAclId("webAclId")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.463Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionProps")
@software.amazon.jsii.Jsii.Proxy(CfnDistributionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDistributionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The distribution's configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDistributionConfig();

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDistributionProps> {
        java.lang.Object distributionConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDistributionProps#getDistributionConfig}
         * @param distributionConfig The distribution's configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(software.amazon.awscdk.IResolvable distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getDistributionConfig}
         * @param distributionConfig The distribution's configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getTags}
         * @param tags A complex type that contains zero or more <code>Tag</code> elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDistributionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDistributionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDistributionProps {
        private final java.lang.Object distributionConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.distributionConfig = software.amazon.jsii.Kernel.get(this, "distributionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.distributionConfig = java.util.Objects.requireNonNull(builder.distributionConfig, "distributionConfig is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDistributionConfig() {
            return this.distributionConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("distributionConfig", om.valueToTree(this.getDistributionConfig()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDistributionProps.Jsii$Proxy that = (CfnDistributionProps.Jsii$Proxy) o;

            if (!distributionConfig.equals(that.distributionConfig)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.distributionConfig.hashCode();
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
