package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creating a custom origin request policy for a Distribution -- all parameters optional
 * S3Origin bucketOrigin;
 * OriginRequestPolicy myOriginRequestPolicy = OriginRequestPolicy.Builder.create(this, "OriginRequestPolicy")
 *         .originRequestPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .cookieBehavior(OriginRequestCookieBehavior.none())
 *         .headerBehavior(OriginRequestHeaderBehavior.all("CloudFront-Is-Android-Viewer"))
 *         .queryStringBehavior(OriginRequestQueryStringBehavior.allowList("username"))
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .originRequestPolicy(myOriginRequestPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.552Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginRequestQueryStringBehavior")
public class OriginRequestQueryStringBehavior extends software.amazon.jsii.JsiiObject {

    protected OriginRequestQueryStringBehavior(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OriginRequestQueryStringBehavior(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * All query strings in viewer requests are included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class));
    }

    /**
     * Only the provided <code>queryStrings</code> are included in requests that CloudFront sends to the origin.
     * <p>
     * @param queryStrings This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior allowList(final @org.jetbrains.annotations.NotNull java.lang.String... queryStrings) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class, "allowList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class), java.util.Arrays.<Object>stream(queryStrings).toArray(Object[]::new));
    }

    /**
     * All query strings except the provided <code>queryStrings</code> are included in requests that CloudFront sends to the origin.
     * <p>
     * @param queryStrings This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior denyList(final @org.jetbrains.annotations.NotNull java.lang.String... queryStrings) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class, "denyList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class), java.util.Arrays.<Object>stream(queryStrings).toArray(Object[]::new));
    }

    /**
     * Query strings in viewer requests are not included in requests that CloudFront sends to the origin.
     * <p>
     * Any query strings that are listed in a CachePolicy are still included in origin requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginRequestQueryStringBehavior.class));
    }

    /**
     * The behavior of query strings -- allow all, none, or only an allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The query strings to allow, if the behavior is an allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStrings() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "queryStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
