package software.amazon.awscdk.services.cloudtrail;

/**
 * Properties for defining a <code>CfnDashboard</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnDashboardProps cfnDashboardProps = CfnDashboardProps.builder()
 *         .name("name")
 *         .refreshSchedule(RefreshScheduleProperty.builder()
 *                 .frequency(FrequencyProperty.builder()
 *                         .unit("unit")
 *                         .value(123)
 *                         .build())
 *                 .status("status")
 *                 .timeOfDay("timeOfDay")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .widgets(List.of(WidgetProperty.builder()
 *                 .queryStatement("queryStatement")
 *                 // the properties below are optional
 *                 .queryParameters(List.of("queryParameters"))
 *                 .viewProperties(Map.of(
 *                         "viewPropertiesKey", "viewProperties"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.619Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnDashboardProps")
@software.amazon.jsii.Jsii.Proxy(CfnDashboardProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDashboardProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Configures the automatic refresh schedule for the dashboard.
     * <p>
     * Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-refreshschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-refreshschedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRefreshSchedule() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Indicates whether the dashboard is protected from termination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-terminationprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-terminationprotectionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return null;
    }

    /**
     * List of widgets on the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-widgets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-dashboard.html#cfn-cloudtrail-dashboard-widgets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWidgets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDashboardProps> {
        java.lang.String name;
        java.lang.Object refreshSchedule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object terminationProtectionEnabled;
        java.lang.Object widgets;

        /**
         * Sets the value of {@link CfnDashboardProps#getName}
         * @param name The name of the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getRefreshSchedule}
         * @param refreshSchedule Configures the automatic refresh schedule for the dashboard.
         *                        Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshSchedule(software.amazon.awscdk.IResolvable refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getRefreshSchedule}
         * @param refreshSchedule Configures the automatic refresh schedule for the dashboard.
         *                        Includes the frequency unit (DAYS or HOURS) and value, as well as the status (ENABLED or DISABLED) of the refresh schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshSchedule(software.amazon.awscdk.services.cloudtrail.CfnDashboard.RefreshScheduleProperty refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled Indicates whether the dashboard is protected from termination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(java.lang.Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getTerminationProtectionEnabled}
         * @param terminationProtectionEnabled Indicates whether the dashboard is protected from termination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(software.amazon.awscdk.IResolvable terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getWidgets}
         * @param widgets List of widgets on the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder widgets(software.amazon.awscdk.IResolvable widgets) {
            this.widgets = widgets;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getWidgets}
         * @param widgets List of widgets on the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder widgets(java.util.List<? extends java.lang.Object> widgets) {
            this.widgets = widgets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDashboardProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDashboardProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDashboardProps {
        private final java.lang.String name;
        private final java.lang.Object refreshSchedule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object terminationProtectionEnabled;
        private final java.lang.Object widgets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.refreshSchedule = software.amazon.jsii.Kernel.get(this, "refreshSchedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.terminationProtectionEnabled = software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.widgets = software.amazon.jsii.Kernel.get(this, "widgets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = builder.name;
            this.refreshSchedule = builder.refreshSchedule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
            this.widgets = builder.widgets;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRefreshSchedule() {
            return this.refreshSchedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        @Override
        public final java.lang.Object getWidgets() {
            return this.widgets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRefreshSchedule() != null) {
                data.set("refreshSchedule", om.valueToTree(this.getRefreshSchedule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtectionEnabled() != null) {
                data.set("terminationProtectionEnabled", om.valueToTree(this.getTerminationProtectionEnabled()));
            }
            if (this.getWidgets() != null) {
                data.set("widgets", om.valueToTree(this.getWidgets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnDashboardProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDashboardProps.Jsii$Proxy that = (CfnDashboardProps.Jsii$Proxy) o;

            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.refreshSchedule != null ? !this.refreshSchedule.equals(that.refreshSchedule) : that.refreshSchedule != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.terminationProtectionEnabled != null ? !this.terminationProtectionEnabled.equals(that.terminationProtectionEnabled) : that.terminationProtectionEnabled != null) return false;
            return this.widgets != null ? this.widgets.equals(that.widgets) : that.widgets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.refreshSchedule != null ? this.refreshSchedule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtectionEnabled != null ? this.terminationProtectionEnabled.hashCode() : 0);
            result = 31 * result + (this.widgets != null ? this.widgets.hashCode() : 0);
            return result;
        }
    }
}
