package software.amazon.awscdk.services.cloudwatch;

/**
 * Display query results from Logs Insights.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(LogQueryWidget.Builder.create()
 *         .logGroupNames(List.of("my-log-group"))
 *         .view(LogQueryVisualizationType.TABLE)
 *         // The lines will be automatically combined using '\n|'.
 *         .queryLines(List.of("fields &#64;message", "filter &#64;message like /Error/"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.744Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.LogQueryWidget")
public class LogQueryWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected LogQueryWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogQueryWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LogQueryWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.LogQueryWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.LogQueryWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.LogQueryWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.LogQueryWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.LogQueryWidgetProps.Builder();
        }

        /**
         * Names of log groups to query.
         * <p>
         * @return {@code this}
         * @param logGroupNames Names of log groups to query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupNames(final java.util.List<java.lang.String> logGroupNames) {
            this.props.logGroupNames(logGroupNames);
            return this;
        }

        /**
         * Height of the widget.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * A sequence of lines to use to build the query.
         * <p>
         * The query will be built by joining the lines together using <code>\n|</code>.
         * <p>
         * Default: - Exactly one of `queryString`, `queryLines` is required.
         * <p>
         * @return {@code this}
         * @param queryLines A sequence of lines to use to build the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLines(final java.util.List<java.lang.String> queryLines) {
            this.props.queryLines(queryLines);
            return this;
        }

        /**
         * Full query string for log insights.
         * <p>
         * Be sure to prepend every new line with a newline and pipe character
         * (<code>\n|</code>).
         * <p>
         * Default: - Exactly one of `queryString`, `queryLines` is required.
         * <p>
         * @return {@code this}
         * @param queryString Full query string for log insights. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(final java.lang.String queryString) {
            this.props.queryString(queryString);
            return this;
        }

        /**
         * The region the metrics of this widget should be taken from.
         * <p>
         * Default: Current region
         * <p>
         * @return {@code this}
         * @param region The region the metrics of this widget should be taken from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Title for the widget.
         * <p>
         * Default: No title
         * <p>
         * @return {@code this}
         * @param title Title for the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * The type of view to use.
         * <p>
         * Default: LogQueryVisualizationType.TABLE
         * <p>
         * @return {@code this}
         * @param view The type of view to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder view(final software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType view) {
            this.props.view(view);
            return this;
        }

        /**
         * Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.LogQueryWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.LogQueryWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.LogQueryWidget(
                this.props.build()
            );
        }
    }
}
