package software.amazon.awscdk.services.codebuild;

/**
 * The options when creating a CodeBuild Docker build image using <code>LinuxBuildImage.fromDockerRegistry</code>, <code>WindowsBuildImage.fromDockerRegistry</code>, or <code>MacBuildImage.fromDockerRegistry</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * .environment(BuildEnvironment.builder()
 *         .buildImage(LinuxBuildImage.fromDockerRegistry("my-registry/my-repo", DockerImageOptions.builder()
 *                 .secretsManagerCredentials(secrets)
 *                 .build()))
 *         .build())
 * .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:15.880Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.DockerImageOptions")
@software.amazon.jsii.Jsii.Proxy(DockerImageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The credentials, stored in Secrets Manager, used for accessing the repository holding the image, if the repository is private.
     * <p>
     * Default: no credentials will be used (we assume the repository is public)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DockerImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageOptions> {
        software.amazon.awscdk.services.secretsmanager.ISecret secretsManagerCredentials;

        /**
         * Sets the value of {@link DockerImageOptions#getSecretsManagerCredentials}
         * @param secretsManagerCredentials The credentials, stored in Secrets Manager, used for accessing the repository holding the image, if the repository is private.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretsManagerCredentials(software.amazon.awscdk.services.secretsmanager.ISecret secretsManagerCredentials) {
            this.secretsManagerCredentials = secretsManagerCredentials;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerImageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageOptions {
        private final software.amazon.awscdk.services.secretsmanager.ISecret secretsManagerCredentials;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secretsManagerCredentials = software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secretsManagerCredentials = builder.secretsManagerCredentials;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
            return this.secretsManagerCredentials;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getSecretsManagerCredentials() != null) {
                data.set("secretsManagerCredentials", om.valueToTree(this.getSecretsManagerCredentials()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.DockerImageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageOptions.Jsii$Proxy that = (DockerImageOptions.Jsii$Proxy) o;

            return this.secretsManagerCredentials != null ? this.secretsManagerCredentials.equals(that.secretsManagerCredentials) : that.secretsManagerCredentials == null;
        }

        @Override
        public final int hashCode() {
            int result = this.secretsManagerCredentials != null ? this.secretsManagerCredentials.hashCode() : 0;
            return result;
        }
    }
}
