package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for <code>TimeBasedCanaryTrafficRouting</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaDeploymentConfig config = LambdaDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .trafficRouting(TimeBasedCanaryTrafficRouting.Builder.create()
 *                 .interval(Duration.minutes(15))
 *                 .percentage(5)
 *                 .build())
 *         .deploymentConfigName("MyDeploymentConfig")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:16.044Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.TimeBasedCanaryTrafficRoutingProps")
@software.amazon.jsii.Jsii.Proxy(TimeBasedCanaryTrafficRoutingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TimeBasedCanaryTrafficRoutingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.BaseTrafficShiftingConfigProps {

    /**
     * @return a {@link Builder} of {@link TimeBasedCanaryTrafficRoutingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TimeBasedCanaryTrafficRoutingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TimeBasedCanaryTrafficRoutingProps> {
        software.amazon.awscdk.Duration interval;
        java.lang.Number percentage;

        /**
         * Sets the value of {@link TimeBasedCanaryTrafficRoutingProps#getInterval}
         * @param interval The amount of time between traffic shifts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(software.amazon.awscdk.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link TimeBasedCanaryTrafficRoutingProps#getPercentage}
         * @param percentage The percentage to increase traffic on each traffic shift. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder percentage(java.lang.Number percentage) {
            this.percentage = percentage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TimeBasedCanaryTrafficRoutingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TimeBasedCanaryTrafficRoutingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TimeBasedCanaryTrafficRoutingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeBasedCanaryTrafficRoutingProps {
        private final software.amazon.awscdk.Duration interval;
        private final java.lang.Number percentage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.percentage = software.amazon.jsii.Kernel.get(this, "percentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
            this.percentage = java.util.Objects.requireNonNull(builder.percentage, "percentage is required");
        }

        @Override
        public final software.amazon.awscdk.Duration getInterval() {
            return this.interval;
        }

        @Override
        public final java.lang.Number getPercentage() {
            return this.percentage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("interval", om.valueToTree(this.getInterval()));
            data.set("percentage", om.valueToTree(this.getPercentage()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.TimeBasedCanaryTrafficRoutingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TimeBasedCanaryTrafficRoutingProps.Jsii$Proxy that = (TimeBasedCanaryTrafficRoutingProps.Jsii$Proxy) o;

            if (!interval.equals(that.interval)) return false;
            return this.percentage.equals(that.percentage);
        }

        @Override
        public final int hashCode() {
            int result = this.interval.hashCode();
            result = 31 * result + (this.percentage.hashCode());
            return result;
        }
    }
}
