package software.amazon.awscdk.services.cognito;

/**
 * The user pool trigger version of the request that Amazon Cognito sends to your Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool;
 * Function preTokenGenerationFn;
 * userpool.addTrigger(UserPoolOperation.PRE_TOKEN_GENERATION_CONFIG, preTokenGenerationFn, LambdaVersion.V2_0);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:16.401Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.LambdaVersion")
public enum LambdaVersion {
    /**
     * V1_0 trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V1_0,
    /**
     * V2_0 trigger.
     * <p>
     * This is supported only for PRE_TOKEN_GENERATION trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V2_0,
}
