package software.amazon.awscdk.services.connectcampaignsv2;

/**
 * Definition of AWS::ConnectCampaignsV2::Campaign Resource Type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaignsv2.*;
 * Object agentlessConfig;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .channelSubtypeConfig(ChannelSubtypeConfigProperty.builder()
 *                 .email(EmailChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
 *                                 .connectSourceEmailAddress("connectSourceEmailAddress")
 *                                 .wisdomTemplateArn("wisdomTemplateArn")
 *                                 // the properties below are optional
 *                                 .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
 *                                 .build())
 *                         .outboundMode(EmailOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .build())
 *                 .sms(SmsChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
 *                                 .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
 *                                 .wisdomTemplateArn("wisdomTemplateArn")
 *                                 .build())
 *                         .outboundMode(SmsOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .build())
 *                 .telephony(TelephonyChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
 *                                 .connectContactFlowId("connectContactFlowId")
 *                                 // the properties below are optional
 *                                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
 *                                         .enableAnswerMachineDetection(false)
 *                                         // the properties below are optional
 *                                         .awaitAnswerMachinePrompt(false)
 *                                         .build())
 *                                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
 *                                 .build())
 *                         .outboundMode(TelephonyOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .predictiveConfig(PredictiveConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .build())
 *                                 .progressiveConfig(ProgressiveConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .connectQueueId("connectQueueId")
 *                         .build())
 *                 .build())
 *         .connectInstanceId("connectInstanceId")
 *         .name("name")
 *         // the properties below are optional
 *         .communicationLimitsOverride(CommunicationLimitsConfigProperty.builder()
 *                 .allChannelsSubtypes(CommunicationLimitsProperty.builder()
 *                         .communicationLimitList(List.of(CommunicationLimitProperty.builder()
 *                                 .frequency(123)
 *                                 .maxCountPerRecipient(123)
 *                                 .unit("unit")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .communicationTimeConfig(CommunicationTimeConfigProperty.builder()
 *                 .localTimeZoneConfig(LocalTimeZoneConfigProperty.builder()
 *                         .defaultTimeZone("defaultTimeZone")
 *                         .localTimeZoneDetection(List.of("localTimeZoneDetection"))
 *                         .build())
 *                 // the properties below are optional
 *                 .email(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .sms(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .telephony(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .connectCampaignFlowArn("connectCampaignFlowArn")
 *         .schedule(ScheduleProperty.builder()
 *                 .endTime("endTime")
 *                 .startTime("startTime")
 *                 // the properties below are optional
 *                 .refreshFrequency("refreshFrequency")
 *                 .build())
 *         .source(SourceProperty.builder()
 *                 .customerProfilesSegmentArn("customerProfilesSegmentArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:16.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaignsv2.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Amazon Connect Campaign Arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The possible types of channel subtype config parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getChannelSubtypeConfig() {
        return software.amazon.jsii.Kernel.get(this, "channelSubtypeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The possible types of channel subtype config parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelSubtypeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "channelSubtypeConfig", java.util.Objects.requireNonNull(value, "channelSubtypeConfig is required"));
    }

    /**
     * The possible types of channel subtype config parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelSubtypeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "channelSubtypeConfig", java.util.Objects.requireNonNull(value, "channelSubtypeConfig is required"));
    }

    /**
     * Amazon Connect Instance Id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "connectInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Connect Instance Id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectInstanceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectInstanceId", java.util.Objects.requireNonNull(value, "connectInstanceId is required"));
    }

    /**
     * Campaign name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Campaign name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Communication limits config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationLimitsOverride() {
        return software.amazon.jsii.Kernel.get(this, "communicationLimitsOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Communication limits config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationLimitsOverride(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "communicationLimitsOverride", value);
    }

    /**
     * Communication limits config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationLimitsOverride(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "communicationLimitsOverride", value);
    }

    /**
     * Campaign communication time config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationTimeConfig() {
        return software.amazon.jsii.Kernel.get(this, "communicationTimeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Campaign communication time config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationTimeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "communicationTimeConfig", value);
    }

    /**
     * Campaign communication time config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCommunicationTimeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "communicationTimeConfig", value);
    }

    /**
     * Arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectCampaignFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "connectCampaignFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectCampaignFlowArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectCampaignFlowArn", value);
    }

    /**
     * Campaign schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Campaign schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * Campaign schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The possible types of channel config parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The possible types of channel config parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "source", value);
    }

    /**
     * The possible types of channel config parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "source", value);
    }

    /**
     * One or more tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The configuration used for answering machine detection during outbound calls.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * AnswerMachineDetectionConfigProperty answerMachineDetectionConfigProperty = AnswerMachineDetectionConfigProperty.builder()
     *         .enableAnswerMachineDetection(false)
     *         // the properties below are optional
     *         .awaitAnswerMachinePrompt(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.AnswerMachineDetectionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AnswerMachineDetectionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnswerMachineDetectionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Flag to decided whether outbound calls should have answering machine detection enabled or not.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-enableanswermachinedetection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-enableanswermachinedetection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableAnswerMachineDetection();

        /**
         * Enables detection of prompts (e.g., beep after after a voicemail greeting).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-awaitanswermachineprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-answermachinedetectionconfig.html#cfn-connectcampaignsv2-campaign-answermachinedetectionconfig-awaitanswermachineprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwaitAnswerMachinePrompt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnswerMachineDetectionConfigProperty> {
            java.lang.Object enableAnswerMachineDetection;
            java.lang.Object awaitAnswerMachinePrompt;

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getEnableAnswerMachineDetection}
             * @param enableAnswerMachineDetection Flag to decided whether outbound calls should have answering machine detection enabled or not. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAnswerMachineDetection(java.lang.Boolean enableAnswerMachineDetection) {
                this.enableAnswerMachineDetection = enableAnswerMachineDetection;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getEnableAnswerMachineDetection}
             * @param enableAnswerMachineDetection Flag to decided whether outbound calls should have answering machine detection enabled or not. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAnswerMachineDetection(software.amazon.awscdk.IResolvable enableAnswerMachineDetection) {
                this.enableAnswerMachineDetection = enableAnswerMachineDetection;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getAwaitAnswerMachinePrompt}
             * @param awaitAnswerMachinePrompt Enables detection of prompts (e.g., beep after after a voicemail greeting).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awaitAnswerMachinePrompt(java.lang.Boolean awaitAnswerMachinePrompt) {
                this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getAwaitAnswerMachinePrompt}
             * @param awaitAnswerMachinePrompt Enables detection of prompts (e.g., beep after after a voicemail greeting).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awaitAnswerMachinePrompt(software.amazon.awscdk.IResolvable awaitAnswerMachinePrompt) {
                this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnswerMachineDetectionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnswerMachineDetectionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnswerMachineDetectionConfigProperty {
            private final java.lang.Object enableAnswerMachineDetection;
            private final java.lang.Object awaitAnswerMachinePrompt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableAnswerMachineDetection = software.amazon.jsii.Kernel.get(this, "enableAnswerMachineDetection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awaitAnswerMachinePrompt = software.amazon.jsii.Kernel.get(this, "awaitAnswerMachinePrompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableAnswerMachineDetection = java.util.Objects.requireNonNull(builder.enableAnswerMachineDetection, "enableAnswerMachineDetection is required");
                this.awaitAnswerMachinePrompt = builder.awaitAnswerMachinePrompt;
            }

            @Override
            public final java.lang.Object getEnableAnswerMachineDetection() {
                return this.enableAnswerMachineDetection;
            }

            @Override
            public final java.lang.Object getAwaitAnswerMachinePrompt() {
                return this.awaitAnswerMachinePrompt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableAnswerMachineDetection", om.valueToTree(this.getEnableAnswerMachineDetection()));
                if (this.getAwaitAnswerMachinePrompt() != null) {
                    data.set("awaitAnswerMachinePrompt", om.valueToTree(this.getAwaitAnswerMachinePrompt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.AnswerMachineDetectionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnswerMachineDetectionConfigProperty.Jsii$Proxy that = (AnswerMachineDetectionConfigProperty.Jsii$Proxy) o;

                if (!enableAnswerMachineDetection.equals(that.enableAnswerMachineDetection)) return false;
                return this.awaitAnswerMachinePrompt != null ? this.awaitAnswerMachinePrompt.equals(that.awaitAnswerMachinePrompt) : that.awaitAnswerMachinePrompt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableAnswerMachineDetection.hashCode();
                result = 31 * result + (this.awaitAnswerMachinePrompt != null ? this.awaitAnswerMachinePrompt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The possible types of channel subtype config parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * ChannelSubtypeConfigProperty channelSubtypeConfigProperty = ChannelSubtypeConfigProperty.builder()
     *         .email(EmailChannelSubtypeConfigProperty.builder()
     *                 .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
     *                         .connectSourceEmailAddress("connectSourceEmailAddress")
     *                         .wisdomTemplateArn("wisdomTemplateArn")
     *                         // the properties below are optional
     *                         .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
     *                         .build())
     *                 .outboundMode(EmailOutboundModeProperty.builder()
     *                         .agentlessConfig(agentlessConfig)
     *                         .build())
     *                 // the properties below are optional
     *                 .capacity(123)
     *                 .build())
     *         .sms(SmsChannelSubtypeConfigProperty.builder()
     *                 .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
     *                         .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
     *                         .wisdomTemplateArn("wisdomTemplateArn")
     *                         .build())
     *                 .outboundMode(SmsOutboundModeProperty.builder()
     *                         .agentlessConfig(agentlessConfig)
     *                         .build())
     *                 // the properties below are optional
     *                 .capacity(123)
     *                 .build())
     *         .telephony(TelephonyChannelSubtypeConfigProperty.builder()
     *                 .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
     *                         .connectContactFlowId("connectContactFlowId")
     *                         // the properties below are optional
     *                         .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                                 .enableAnswerMachineDetection(false)
     *                                 // the properties below are optional
     *                                 .awaitAnswerMachinePrompt(false)
     *                                 .build())
     *                         .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *                         .build())
     *                 .outboundMode(TelephonyOutboundModeProperty.builder()
     *                         .agentlessConfig(agentlessConfig)
     *                         .predictiveConfig(PredictiveConfigProperty.builder()
     *                                 .bandwidthAllocation(123)
     *                                 .build())
     *                         .progressiveConfig(ProgressiveConfigProperty.builder()
     *                                 .bandwidthAllocation(123)
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .capacity(123)
     *                 .connectQueueId("connectQueueId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Email Channel Subtype config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-email</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmail() {
            return null;
        }

        /**
         * SMS Channel Subtype config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-sms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-sms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSms() {
            return null;
        }

        /**
         * Telephony Channel Subtype config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-telephony">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-channelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig-telephony</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTelephony() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelSubtypeConfigProperty> {
            java.lang.Object email;
            java.lang.Object sms;
            java.lang.Object telephony;

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getEmail}
             * @param email Email Channel Subtype config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.IResolvable email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getEmail}
             * @param email Email Channel Subtype config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EmailChannelSubtypeConfigProperty email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getSms}
             * @param sms SMS Channel Subtype config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.IResolvable sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getSms}
             * @param sms SMS Channel Subtype config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SmsChannelSubtypeConfigProperty sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getTelephony}
             * @param telephony Telephony Channel Subtype config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.IResolvable telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Sets the value of {@link ChannelSubtypeConfigProperty#getTelephony}
             * @param telephony Telephony Channel Subtype config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TelephonyChannelSubtypeConfigProperty telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelSubtypeConfigProperty {
            private final java.lang.Object email;
            private final java.lang.Object sms;
            private final java.lang.Object telephony;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.telephony = software.amazon.jsii.Kernel.get(this, "telephony", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.email = builder.email;
                this.sms = builder.sms;
                this.telephony = builder.telephony;
            }

            @Override
            public final java.lang.Object getEmail() {
                return this.email;
            }

            @Override
            public final java.lang.Object getSms() {
                return this.sms;
            }

            @Override
            public final java.lang.Object getTelephony() {
                return this.telephony;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }
                if (this.getSms() != null) {
                    data.set("sms", om.valueToTree(this.getSms()));
                }
                if (this.getTelephony() != null) {
                    data.set("telephony", om.valueToTree(this.getTelephony()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelSubtypeConfigProperty.Jsii$Proxy that = (ChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
                if (this.sms != null ? !this.sms.equals(that.sms) : that.sms != null) return false;
                return this.telephony != null ? this.telephony.equals(that.telephony) : that.telephony == null;
            }

            @Override
            public final int hashCode() {
                int result = this.email != null ? this.email.hashCode() : 0;
                result = 31 * result + (this.sms != null ? this.sms.hashCode() : 0);
                result = 31 * result + (this.telephony != null ? this.telephony.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Communication Limit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationLimitProperty communicationLimitProperty = CommunicationLimitProperty.builder()
     *         .frequency(123)
     *         .maxCountPerRecipient(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationLimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationLimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-frequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-frequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFrequency();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-maxcountperrecipient">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-maxcountperrecipient</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCountPerRecipient();

        /**
         * The communication limit time unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimit.html#cfn-connectcampaignsv2-campaign-communicationlimit-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * @return a {@link Builder} of {@link CommunicationLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationLimitProperty> {
            java.lang.Number frequency;
            java.lang.Number maxCountPerRecipient;
            java.lang.String unit;

            /**
             * Sets the value of {@link CommunicationLimitProperty#getFrequency}
             * @param frequency the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(java.lang.Number frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitProperty#getMaxCountPerRecipient}
             * @param maxCountPerRecipient the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCountPerRecipient(java.lang.Number maxCountPerRecipient) {
                this.maxCountPerRecipient = maxCountPerRecipient;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitProperty#getUnit}
             * @param unit The communication limit time unit. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationLimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationLimitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationLimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationLimitProperty {
            private final java.lang.Number frequency;
            private final java.lang.Number maxCountPerRecipient;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxCountPerRecipient = software.amazon.jsii.Kernel.get(this, "maxCountPerRecipient", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequency = java.util.Objects.requireNonNull(builder.frequency, "frequency is required");
                this.maxCountPerRecipient = java.util.Objects.requireNonNull(builder.maxCountPerRecipient, "maxCountPerRecipient is required");
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
            }

            @Override
            public final java.lang.Number getFrequency() {
                return this.frequency;
            }

            @Override
            public final java.lang.Number getMaxCountPerRecipient() {
                return this.maxCountPerRecipient;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frequency", om.valueToTree(this.getFrequency()));
                data.set("maxCountPerRecipient", om.valueToTree(this.getMaxCountPerRecipient()));
                data.set("unit", om.valueToTree(this.getUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationLimitProperty.Jsii$Proxy that = (CommunicationLimitProperty.Jsii$Proxy) o;

                if (!frequency.equals(that.frequency)) return false;
                if (!maxCountPerRecipient.equals(that.maxCountPerRecipient)) return false;
                return this.unit.equals(that.unit);
            }

            @Override
            public final int hashCode() {
                int result = this.frequency.hashCode();
                result = 31 * result + (this.maxCountPerRecipient.hashCode());
                result = 31 * result + (this.unit.hashCode());
                return result;
            }
        }
    }
    /**
     * Communication limits config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationLimitsConfigProperty communicationLimitsConfigProperty = CommunicationLimitsConfigProperty.builder()
     *         .allChannelsSubtypes(CommunicationLimitsProperty.builder()
     *                 .communicationLimitList(List.of(CommunicationLimitProperty.builder()
     *                         .frequency(123)
     *                         .maxCountPerRecipient(123)
     *                         .unit("unit")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationLimitsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationLimitsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Communication limits.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html#cfn-connectcampaignsv2-campaign-communicationlimitsconfig-allchannelssubtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimitsconfig.html#cfn-connectcampaignsv2-campaign-communicationlimitsconfig-allchannelssubtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllChannelsSubtypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CommunicationLimitsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationLimitsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationLimitsConfigProperty> {
            java.lang.Object allChannelsSubtypes;

            /**
             * Sets the value of {@link CommunicationLimitsConfigProperty#getAllChannelsSubtypes}
             * @param allChannelsSubtypes Communication limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allChannelsSubtypes(software.amazon.awscdk.IResolvable allChannelsSubtypes) {
                this.allChannelsSubtypes = allChannelsSubtypes;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitsConfigProperty#getAllChannelsSubtypes}
             * @param allChannelsSubtypes Communication limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allChannelsSubtypes(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsProperty allChannelsSubtypes) {
                this.allChannelsSubtypes = allChannelsSubtypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationLimitsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationLimitsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationLimitsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationLimitsConfigProperty {
            private final java.lang.Object allChannelsSubtypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allChannelsSubtypes = software.amazon.jsii.Kernel.get(this, "allChannelsSubtypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allChannelsSubtypes = builder.allChannelsSubtypes;
            }

            @Override
            public final java.lang.Object getAllChannelsSubtypes() {
                return this.allChannelsSubtypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllChannelsSubtypes() != null) {
                    data.set("allChannelsSubtypes", om.valueToTree(this.getAllChannelsSubtypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationLimitsConfigProperty.Jsii$Proxy that = (CommunicationLimitsConfigProperty.Jsii$Proxy) o;

                return this.allChannelsSubtypes != null ? this.allChannelsSubtypes.equals(that.allChannelsSubtypes) : that.allChannelsSubtypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allChannelsSubtypes != null ? this.allChannelsSubtypes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Communication limits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationLimitsProperty communicationLimitsProperty = CommunicationLimitsProperty.builder()
     *         .communicationLimitList(List.of(CommunicationLimitProperty.builder()
     *                 .frequency(123)
     *                 .maxCountPerRecipient(123)
     *                 .unit("unit")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of communication limit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html#cfn-connectcampaignsv2-campaign-communicationlimits-communicationlimitlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationlimits.html#cfn-connectcampaignsv2-campaign-communicationlimits-communicationlimitlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationLimitList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CommunicationLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationLimitsProperty> {
            java.lang.Object communicationLimitList;

            /**
             * Sets the value of {@link CommunicationLimitsProperty#getCommunicationLimitList}
             * @param communicationLimitList List of communication limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder communicationLimitList(software.amazon.awscdk.IResolvable communicationLimitList) {
                this.communicationLimitList = communicationLimitList;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationLimitsProperty#getCommunicationLimitList}
             * @param communicationLimitList List of communication limit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder communicationLimitList(java.util.List<? extends java.lang.Object> communicationLimitList) {
                this.communicationLimitList = communicationLimitList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationLimitsProperty {
            private final java.lang.Object communicationLimitList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.communicationLimitList = software.amazon.jsii.Kernel.get(this, "communicationLimitList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.communicationLimitList = builder.communicationLimitList;
            }

            @Override
            public final java.lang.Object getCommunicationLimitList() {
                return this.communicationLimitList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommunicationLimitList() != null) {
                    data.set("communicationLimitList", om.valueToTree(this.getCommunicationLimitList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationLimitsProperty.Jsii$Proxy that = (CommunicationLimitsProperty.Jsii$Proxy) o;

                return this.communicationLimitList != null ? this.communicationLimitList.equals(that.communicationLimitList) : that.communicationLimitList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.communicationLimitList != null ? this.communicationLimitList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Campaign communication time config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * CommunicationTimeConfigProperty communicationTimeConfigProperty = CommunicationTimeConfigProperty.builder()
     *         .localTimeZoneConfig(LocalTimeZoneConfigProperty.builder()
     *                 .defaultTimeZone("defaultTimeZone")
     *                 .localTimeZoneDetection(List.of("localTimeZoneDetection"))
     *                 .build())
     *         // the properties below are optional
     *         .email(TimeWindowProperty.builder()
     *                 .openHours(OpenHoursProperty.builder()
     *                         .dailyHours(List.of(DailyHourProperty.builder()
     *                                 .key("key")
     *                                 .value(List.of(TimeRangeProperty.builder()
     *                                         .endTime("endTime")
     *                                         .startTime("startTime")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                                 .endDate("endDate")
     *                                 .startDate("startDate")
     *                                 // the properties below are optional
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .sms(TimeWindowProperty.builder()
     *                 .openHours(OpenHoursProperty.builder()
     *                         .dailyHours(List.of(DailyHourProperty.builder()
     *                                 .key("key")
     *                                 .value(List.of(TimeRangeProperty.builder()
     *                                         .endTime("endTime")
     *                                         .startTime("startTime")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                                 .endDate("endDate")
     *                                 .startDate("startDate")
     *                                 // the properties below are optional
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .telephony(TimeWindowProperty.builder()
     *                 .openHours(OpenHoursProperty.builder()
     *                         .dailyHours(List.of(DailyHourProperty.builder()
     *                                 .key("key")
     *                                 .value(List.of(TimeRangeProperty.builder()
     *                                         .endTime("endTime")
     *                                         .startTime("startTime")
     *                                         .build()))
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                                 .endDate("endDate")
     *                                 .startDate("startDate")
     *                                 // the properties below are optional
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CommunicationTimeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CommunicationTimeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Local time zone config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-localtimezoneconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-localtimezoneconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLocalTimeZoneConfig();

        /**
         * Time window config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-email</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmail() {
            return null;
        }

        /**
         * Time window config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-sms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-sms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSms() {
            return null;
        }

        /**
         * Time window config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-telephony">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-communicationtimeconfig.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig-telephony</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTelephony() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CommunicationTimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CommunicationTimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CommunicationTimeConfigProperty> {
            java.lang.Object localTimeZoneConfig;
            java.lang.Object email;
            java.lang.Object sms;
            java.lang.Object telephony;

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getLocalTimeZoneConfig}
             * @param localTimeZoneConfig Local time zone config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localTimeZoneConfig(software.amazon.awscdk.IResolvable localTimeZoneConfig) {
                this.localTimeZoneConfig = localTimeZoneConfig;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getLocalTimeZoneConfig}
             * @param localTimeZoneConfig Local time zone config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localTimeZoneConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.LocalTimeZoneConfigProperty localTimeZoneConfig) {
                this.localTimeZoneConfig = localTimeZoneConfig;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getEmail}
             * @param email Time window config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.IResolvable email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getEmail}
             * @param email Time window config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TimeWindowProperty email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getSms}
             * @param sms Time window config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.IResolvable sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getSms}
             * @param sms Time window config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TimeWindowProperty sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getTelephony}
             * @param telephony Time window config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.IResolvable telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Sets the value of {@link CommunicationTimeConfigProperty#getTelephony}
             * @param telephony Time window config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder telephony(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TimeWindowProperty telephony) {
                this.telephony = telephony;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CommunicationTimeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CommunicationTimeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CommunicationTimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommunicationTimeConfigProperty {
            private final java.lang.Object localTimeZoneConfig;
            private final java.lang.Object email;
            private final java.lang.Object sms;
            private final java.lang.Object telephony;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localTimeZoneConfig = software.amazon.jsii.Kernel.get(this, "localTimeZoneConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.telephony = software.amazon.jsii.Kernel.get(this, "telephony", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localTimeZoneConfig = java.util.Objects.requireNonNull(builder.localTimeZoneConfig, "localTimeZoneConfig is required");
                this.email = builder.email;
                this.sms = builder.sms;
                this.telephony = builder.telephony;
            }

            @Override
            public final java.lang.Object getLocalTimeZoneConfig() {
                return this.localTimeZoneConfig;
            }

            @Override
            public final java.lang.Object getEmail() {
                return this.email;
            }

            @Override
            public final java.lang.Object getSms() {
                return this.sms;
            }

            @Override
            public final java.lang.Object getTelephony() {
                return this.telephony;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localTimeZoneConfig", om.valueToTree(this.getLocalTimeZoneConfig()));
                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }
                if (this.getSms() != null) {
                    data.set("sms", om.valueToTree(this.getSms()));
                }
                if (this.getTelephony() != null) {
                    data.set("telephony", om.valueToTree(this.getTelephony()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CommunicationTimeConfigProperty.Jsii$Proxy that = (CommunicationTimeConfigProperty.Jsii$Proxy) o;

                if (!localTimeZoneConfig.equals(that.localTimeZoneConfig)) return false;
                if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
                if (this.sms != null ? !this.sms.equals(that.sms) : that.sms != null) return false;
                return this.telephony != null ? this.telephony.equals(that.telephony) : that.telephony == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localTimeZoneConfig.hashCode();
                result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
                result = 31 * result + (this.sms != null ? this.sms.hashCode() : 0);
                result = 31 * result + (this.telephony != null ? this.telephony.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Daily Hour.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * DailyHourProperty dailyHourProperty = DailyHourProperty.builder()
     *         .key("key")
     *         .value(List.of(TimeRangeProperty.builder()
     *                 .endTime("endTime")
     *                 .startTime("startTime")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.DailyHourProperty")
    @software.amazon.jsii.Jsii.Proxy(DailyHourProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DailyHourProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Day of week.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * List of time range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-dailyhour.html#cfn-connectcampaignsv2-campaign-dailyhour-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DailyHourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DailyHourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DailyHourProperty> {
            java.lang.String key;
            java.lang.Object value;

            /**
             * Sets the value of {@link DailyHourProperty#getKey}
             * @param key Day of week.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link DailyHourProperty#getValue}
             * @param value List of time range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DailyHourProperty#getValue}
             * @param value List of time range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.util.List<? extends java.lang.Object> value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DailyHourProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DailyHourProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DailyHourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DailyHourProperty {
            private final java.lang.String key;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.DailyHourProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DailyHourProperty.Jsii$Proxy that = (DailyHourProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Email Channel Subtype config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * EmailChannelSubtypeConfigProperty emailChannelSubtypeConfigProperty = EmailChannelSubtypeConfigProperty.builder()
     *         .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
     *                 .connectSourceEmailAddress("connectSourceEmailAddress")
     *                 .wisdomTemplateArn("wisdomTemplateArn")
     *                 // the properties below are optional
     *                 .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
     *                 .build())
     *         .outboundMode(EmailOutboundModeProperty.builder()
     *                 .agentlessConfig(agentlessConfig)
     *                 .build())
     *         // the properties below are optional
     *         .capacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Default SMS outbound config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-defaultoutboundconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-defaultoutboundconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultOutboundConfig();

        /**
         * Email Outbound Mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-outboundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-outboundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundMode();

        /**
         * Allocates outbound capacity for the specific channel of this campaign between multiple active campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailchannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-emailchannelsubtypeconfig-capacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailChannelSubtypeConfigProperty> {
            java.lang.Object defaultOutboundConfig;
            java.lang.Object outboundMode;
            java.lang.Number capacity;

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig Default SMS outbound config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.IResolvable defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig Default SMS outbound config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EmailOutboundConfigProperty defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode Email Outbound Mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.IResolvable outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode Email Outbound Mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.EmailOutboundModeProperty outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link EmailChannelSubtypeConfigProperty#getCapacity}
             * @param capacity Allocates outbound capacity for the specific channel of this campaign between multiple active campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacity(java.lang.Number capacity) {
                this.capacity = capacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailChannelSubtypeConfigProperty {
            private final java.lang.Object defaultOutboundConfig;
            private final java.lang.Object outboundMode;
            private final java.lang.Number capacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultOutboundConfig = software.amazon.jsii.Kernel.get(this, "defaultOutboundConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundMode = software.amazon.jsii.Kernel.get(this, "outboundMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultOutboundConfig = java.util.Objects.requireNonNull(builder.defaultOutboundConfig, "defaultOutboundConfig is required");
                this.outboundMode = java.util.Objects.requireNonNull(builder.outboundMode, "outboundMode is required");
                this.capacity = builder.capacity;
            }

            @Override
            public final java.lang.Object getDefaultOutboundConfig() {
                return this.defaultOutboundConfig;
            }

            @Override
            public final java.lang.Object getOutboundMode() {
                return this.outboundMode;
            }

            @Override
            public final java.lang.Number getCapacity() {
                return this.capacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultOutboundConfig", om.valueToTree(this.getDefaultOutboundConfig()));
                data.set("outboundMode", om.valueToTree(this.getOutboundMode()));
                if (this.getCapacity() != null) {
                    data.set("capacity", om.valueToTree(this.getCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailChannelSubtypeConfigProperty.Jsii$Proxy that = (EmailChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (!defaultOutboundConfig.equals(that.defaultOutboundConfig)) return false;
                if (!outboundMode.equals(that.outboundMode)) return false;
                return this.capacity != null ? this.capacity.equals(that.capacity) : that.capacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultOutboundConfig.hashCode();
                result = 31 * result + (this.outboundMode.hashCode());
                result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Default SMS outbound config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * EmailOutboundConfigProperty emailOutboundConfigProperty = EmailOutboundConfigProperty.builder()
     *         .connectSourceEmailAddress("connectSourceEmailAddress")
     *         .wisdomTemplateArn("wisdomTemplateArn")
     *         // the properties below are optional
     *         .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailOutboundConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailOutboundConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Email address used for Email messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-connectsourceemailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-connectsourceemailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectSourceEmailAddress();

        /**
         * Arn.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-wisdomtemplatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-wisdomtemplatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWisdomTemplateArn();

        /**
         * The name of the source email address display name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-sourceemailaddressdisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundconfig.html#cfn-connectcampaignsv2-campaign-emailoutboundconfig-sourceemailaddressdisplayname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceEmailAddressDisplayName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailOutboundConfigProperty> {
            java.lang.String connectSourceEmailAddress;
            java.lang.String wisdomTemplateArn;
            java.lang.String sourceEmailAddressDisplayName;

            /**
             * Sets the value of {@link EmailOutboundConfigProperty#getConnectSourceEmailAddress}
             * @param connectSourceEmailAddress Email address used for Email messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourceEmailAddress(java.lang.String connectSourceEmailAddress) {
                this.connectSourceEmailAddress = connectSourceEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link EmailOutboundConfigProperty#getWisdomTemplateArn}
             * @param wisdomTemplateArn Arn. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wisdomTemplateArn(java.lang.String wisdomTemplateArn) {
                this.wisdomTemplateArn = wisdomTemplateArn;
                return this;
            }

            /**
             * Sets the value of {@link EmailOutboundConfigProperty#getSourceEmailAddressDisplayName}
             * @param sourceEmailAddressDisplayName The name of the source email address display name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceEmailAddressDisplayName(java.lang.String sourceEmailAddressDisplayName) {
                this.sourceEmailAddressDisplayName = sourceEmailAddressDisplayName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailOutboundConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailOutboundConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailOutboundConfigProperty {
            private final java.lang.String connectSourceEmailAddress;
            private final java.lang.String wisdomTemplateArn;
            private final java.lang.String sourceEmailAddressDisplayName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectSourceEmailAddress = software.amazon.jsii.Kernel.get(this, "connectSourceEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.wisdomTemplateArn = software.amazon.jsii.Kernel.get(this, "wisdomTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceEmailAddressDisplayName = software.amazon.jsii.Kernel.get(this, "sourceEmailAddressDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectSourceEmailAddress = java.util.Objects.requireNonNull(builder.connectSourceEmailAddress, "connectSourceEmailAddress is required");
                this.wisdomTemplateArn = java.util.Objects.requireNonNull(builder.wisdomTemplateArn, "wisdomTemplateArn is required");
                this.sourceEmailAddressDisplayName = builder.sourceEmailAddressDisplayName;
            }

            @Override
            public final java.lang.String getConnectSourceEmailAddress() {
                return this.connectSourceEmailAddress;
            }

            @Override
            public final java.lang.String getWisdomTemplateArn() {
                return this.wisdomTemplateArn;
            }

            @Override
            public final java.lang.String getSourceEmailAddressDisplayName() {
                return this.sourceEmailAddressDisplayName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectSourceEmailAddress", om.valueToTree(this.getConnectSourceEmailAddress()));
                data.set("wisdomTemplateArn", om.valueToTree(this.getWisdomTemplateArn()));
                if (this.getSourceEmailAddressDisplayName() != null) {
                    data.set("sourceEmailAddressDisplayName", om.valueToTree(this.getSourceEmailAddressDisplayName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailOutboundConfigProperty.Jsii$Proxy that = (EmailOutboundConfigProperty.Jsii$Proxy) o;

                if (!connectSourceEmailAddress.equals(that.connectSourceEmailAddress)) return false;
                if (!wisdomTemplateArn.equals(that.wisdomTemplateArn)) return false;
                return this.sourceEmailAddressDisplayName != null ? this.sourceEmailAddressDisplayName.equals(that.sourceEmailAddressDisplayName) : that.sourceEmailAddressDisplayName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectSourceEmailAddress.hashCode();
                result = 31 * result + (this.wisdomTemplateArn.hashCode());
                result = 31 * result + (this.sourceEmailAddressDisplayName != null ? this.sourceEmailAddressDisplayName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Email Outbound Mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * EmailOutboundModeProperty emailOutboundModeProperty = EmailOutboundModeProperty.builder()
     *         .agentlessConfig(agentlessConfig)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundModeProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailOutboundModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailOutboundModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Agentless config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html#cfn-connectcampaignsv2-campaign-emailoutboundmode-agentlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-emailoutboundmode.html#cfn-connectcampaignsv2-campaign-emailoutboundmode-agentlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailOutboundModeProperty> {
            java.lang.Object agentlessConfig;

            /**
             * Sets the value of {@link EmailOutboundModeProperty#getAgentlessConfig}
             * @param agentlessConfig Agentless config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessConfig(java.lang.Object agentlessConfig) {
                this.agentlessConfig = agentlessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailOutboundModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailOutboundModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailOutboundModeProperty {
            private final java.lang.Object agentlessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessConfig = software.amazon.jsii.Kernel.get(this, "agentlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessConfig = builder.agentlessConfig;
            }

            @Override
            public final java.lang.Object getAgentlessConfig() {
                return this.agentlessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessConfig() != null) {
                    data.set("agentlessConfig", om.valueToTree(this.getAgentlessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.EmailOutboundModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailOutboundModeProperty.Jsii$Proxy that = (EmailOutboundModeProperty.Jsii$Proxy) o;

                return this.agentlessConfig != null ? this.agentlessConfig.equals(that.agentlessConfig) : that.agentlessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessConfig != null ? this.agentlessConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Local time zone config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * LocalTimeZoneConfigProperty localTimeZoneConfigProperty = LocalTimeZoneConfigProperty.builder()
     *         .defaultTimeZone("defaultTimeZone")
     *         .localTimeZoneDetection(List.of("localTimeZoneDetection"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.LocalTimeZoneConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalTimeZoneConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalTimeZoneConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Time Zone Id in the IANA format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-defaulttimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-defaulttimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultTimeZone() {
            return null;
        }

        /**
         * Local TimeZone Detection method list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-localtimezonedetection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-localtimezoneconfig.html#cfn-connectcampaignsv2-campaign-localtimezoneconfig-localtimezonedetection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalTimeZoneDetection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocalTimeZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalTimeZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalTimeZoneConfigProperty> {
            java.lang.String defaultTimeZone;
            java.util.List<java.lang.String> localTimeZoneDetection;

            /**
             * Sets the value of {@link LocalTimeZoneConfigProperty#getDefaultTimeZone}
             * @param defaultTimeZone Time Zone Id in the IANA format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTimeZone(java.lang.String defaultTimeZone) {
                this.defaultTimeZone = defaultTimeZone;
                return this;
            }

            /**
             * Sets the value of {@link LocalTimeZoneConfigProperty#getLocalTimeZoneDetection}
             * @param localTimeZoneDetection Local TimeZone Detection method list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localTimeZoneDetection(java.util.List<java.lang.String> localTimeZoneDetection) {
                this.localTimeZoneDetection = localTimeZoneDetection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalTimeZoneConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalTimeZoneConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalTimeZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalTimeZoneConfigProperty {
            private final java.lang.String defaultTimeZone;
            private final java.util.List<java.lang.String> localTimeZoneDetection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultTimeZone = software.amazon.jsii.Kernel.get(this, "defaultTimeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localTimeZoneDetection = software.amazon.jsii.Kernel.get(this, "localTimeZoneDetection", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultTimeZone = builder.defaultTimeZone;
                this.localTimeZoneDetection = builder.localTimeZoneDetection;
            }

            @Override
            public final java.lang.String getDefaultTimeZone() {
                return this.defaultTimeZone;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalTimeZoneDetection() {
                return this.localTimeZoneDetection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultTimeZone() != null) {
                    data.set("defaultTimeZone", om.valueToTree(this.getDefaultTimeZone()));
                }
                if (this.getLocalTimeZoneDetection() != null) {
                    data.set("localTimeZoneDetection", om.valueToTree(this.getLocalTimeZoneDetection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.LocalTimeZoneConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalTimeZoneConfigProperty.Jsii$Proxy that = (LocalTimeZoneConfigProperty.Jsii$Proxy) o;

                if (this.defaultTimeZone != null ? !this.defaultTimeZone.equals(that.defaultTimeZone) : that.defaultTimeZone != null) return false;
                return this.localTimeZoneDetection != null ? this.localTimeZoneDetection.equals(that.localTimeZoneDetection) : that.localTimeZoneDetection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultTimeZone != null ? this.defaultTimeZone.hashCode() : 0;
                result = 31 * result + (this.localTimeZoneDetection != null ? this.localTimeZoneDetection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Open Hours config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * OpenHoursProperty openHoursProperty = OpenHoursProperty.builder()
     *         .dailyHours(List.of(DailyHourProperty.builder()
     *                 .key("key")
     *                 .value(List.of(TimeRangeProperty.builder()
     *                         .endTime("endTime")
     *                         .startTime("startTime")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.OpenHoursProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenHoursProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenHoursProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Daily Hours map.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html#cfn-connectcampaignsv2-campaign-openhours-dailyhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-openhours.html#cfn-connectcampaignsv2-campaign-openhours-dailyhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDailyHours();

        /**
         * @return a {@link Builder} of {@link OpenHoursProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenHoursProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenHoursProperty> {
            java.lang.Object dailyHours;

            /**
             * Sets the value of {@link OpenHoursProperty#getDailyHours}
             * @param dailyHours Daily Hours map. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyHours(software.amazon.awscdk.IResolvable dailyHours) {
                this.dailyHours = dailyHours;
                return this;
            }

            /**
             * Sets the value of {@link OpenHoursProperty#getDailyHours}
             * @param dailyHours Daily Hours map. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dailyHours(java.util.List<? extends java.lang.Object> dailyHours) {
                this.dailyHours = dailyHours;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenHoursProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenHoursProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenHoursProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenHoursProperty {
            private final java.lang.Object dailyHours;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dailyHours = software.amazon.jsii.Kernel.get(this, "dailyHours", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dailyHours = java.util.Objects.requireNonNull(builder.dailyHours, "dailyHours is required");
            }

            @Override
            public final java.lang.Object getDailyHours() {
                return this.dailyHours;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dailyHours", om.valueToTree(this.getDailyHours()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.OpenHoursProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenHoursProperty.Jsii$Proxy that = (OpenHoursProperty.Jsii$Proxy) o;

                return this.dailyHours.equals(that.dailyHours);
            }

            @Override
            public final int hashCode() {
                int result = this.dailyHours.hashCode();
                return result;
            }
        }
    }
    /**
     * Predictive config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * PredictiveConfigProperty predictiveConfigProperty = PredictiveConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.PredictiveConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The bandwidth allocation of a queue resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html#cfn-connectcampaignsv2-campaign-predictiveconfig-bandwidthallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-predictiveconfig.html#cfn-connectcampaignsv2-campaign-predictiveconfig-bandwidthallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * @return a {@link Builder} of {@link PredictiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveConfigProperty> {
            java.lang.Number bandwidthAllocation;

            /**
             * Sets the value of {@link PredictiveConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation The bandwidth allocation of a queue resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveConfigProperty {
            private final java.lang.Number bandwidthAllocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.PredictiveConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveConfigProperty.Jsii$Proxy that = (PredictiveConfigProperty.Jsii$Proxy) o;

                return this.bandwidthAllocation.equals(that.bandwidthAllocation);
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                return result;
            }
        }
    }
    /**
     * Progressive config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * ProgressiveConfigProperty progressiveConfigProperty = ProgressiveConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ProgressiveConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProgressiveConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProgressiveConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The bandwidth allocation of a queue resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html#cfn-connectcampaignsv2-campaign-progressiveconfig-bandwidthallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-progressiveconfig.html#cfn-connectcampaignsv2-campaign-progressiveconfig-bandwidthallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * @return a {@link Builder} of {@link ProgressiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProgressiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProgressiveConfigProperty> {
            java.lang.Number bandwidthAllocation;

            /**
             * Sets the value of {@link ProgressiveConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation The bandwidth allocation of a queue resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProgressiveConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProgressiveConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProgressiveConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProgressiveConfigProperty {
            private final java.lang.Number bandwidthAllocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ProgressiveConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProgressiveConfigProperty.Jsii$Proxy that = (ProgressiveConfigProperty.Jsii$Proxy) o;

                return this.bandwidthAllocation.equals(that.bandwidthAllocation);
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                return result;
            }
        }
    }
    /**
     * Restricted period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * RestrictedPeriodProperty restrictedPeriodProperty = RestrictedPeriodProperty.builder()
     *         .endDate("endDate")
     *         .startDate("startDate")
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictedPeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictedPeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Date in ISO 8601 format, e.g. 2024-01-01.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-enddate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-enddate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndDate();

        /**
         * Date in ISO 8601 format, e.g. 2024-01-01.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-startdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-startdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartDate();

        /**
         * The name of a restricted period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiod.html#cfn-connectcampaignsv2-campaign-restrictedperiod-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RestrictedPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictedPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictedPeriodProperty> {
            java.lang.String endDate;
            java.lang.String startDate;
            java.lang.String name;

            /**
             * Sets the value of {@link RestrictedPeriodProperty#getEndDate}
             * @param endDate Date in ISO 8601 format, e.g. 2024-01-01. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endDate(java.lang.String endDate) {
                this.endDate = endDate;
                return this;
            }

            /**
             * Sets the value of {@link RestrictedPeriodProperty#getStartDate}
             * @param startDate Date in ISO 8601 format, e.g. 2024-01-01. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startDate(java.lang.String startDate) {
                this.startDate = startDate;
                return this;
            }

            /**
             * Sets the value of {@link RestrictedPeriodProperty#getName}
             * @param name The name of a restricted period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictedPeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictedPeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictedPeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictedPeriodProperty {
            private final java.lang.String endDate;
            private final java.lang.String startDate;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startDate = software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endDate = java.util.Objects.requireNonNull(builder.endDate, "endDate is required");
                this.startDate = java.util.Objects.requireNonNull(builder.startDate, "startDate is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getEndDate() {
                return this.endDate;
            }

            @Override
            public final java.lang.String getStartDate() {
                return this.startDate;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endDate", om.valueToTree(this.getEndDate()));
                data.set("startDate", om.valueToTree(this.getStartDate()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictedPeriodProperty.Jsii$Proxy that = (RestrictedPeriodProperty.Jsii$Proxy) o;

                if (!endDate.equals(that.endDate)) return false;
                if (!startDate.equals(that.startDate)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endDate.hashCode();
                result = 31 * result + (this.startDate.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Restricted period config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * RestrictedPeriodsProperty restrictedPeriodsProperty = RestrictedPeriodsProperty.builder()
     *         .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                 .endDate("endDate")
     *                 .startDate("startDate")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodsProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictedPeriodsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictedPeriodsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of restricted period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html#cfn-connectcampaignsv2-campaign-restrictedperiods-restrictedperiodlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-restrictedperiods.html#cfn-connectcampaignsv2-campaign-restrictedperiods-restrictedperiodlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRestrictedPeriodList();

        /**
         * @return a {@link Builder} of {@link RestrictedPeriodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictedPeriodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictedPeriodsProperty> {
            java.lang.Object restrictedPeriodList;

            /**
             * Sets the value of {@link RestrictedPeriodsProperty#getRestrictedPeriodList}
             * @param restrictedPeriodList List of restricted period. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriodList(software.amazon.awscdk.IResolvable restrictedPeriodList) {
                this.restrictedPeriodList = restrictedPeriodList;
                return this;
            }

            /**
             * Sets the value of {@link RestrictedPeriodsProperty#getRestrictedPeriodList}
             * @param restrictedPeriodList List of restricted period. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriodList(java.util.List<? extends java.lang.Object> restrictedPeriodList) {
                this.restrictedPeriodList = restrictedPeriodList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictedPeriodsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictedPeriodsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictedPeriodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictedPeriodsProperty {
            private final java.lang.Object restrictedPeriodList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictedPeriodList = software.amazon.jsii.Kernel.get(this, "restrictedPeriodList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictedPeriodList = java.util.Objects.requireNonNull(builder.restrictedPeriodList, "restrictedPeriodList is required");
            }

            @Override
            public final java.lang.Object getRestrictedPeriodList() {
                return this.restrictedPeriodList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictedPeriodList", om.valueToTree(this.getRestrictedPeriodList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.RestrictedPeriodsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictedPeriodsProperty.Jsii$Proxy that = (RestrictedPeriodsProperty.Jsii$Proxy) o;

                return this.restrictedPeriodList.equals(that.restrictedPeriodList);
            }

            @Override
            public final int hashCode() {
                int result = this.restrictedPeriodList.hashCode();
                return result;
            }
        }
    }
    /**
     * Campaign schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .endTime("endTime")
     *         .startTime("startTime")
     *         // the properties below are optional
     *         .refreshFrequency("refreshFrequency")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Timestamp with no UTC offset or timezone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-endtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndTime();

        /**
         * Timestamp with no UTC offset or timezone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * Time duration in ISO 8601 format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-refreshfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-schedule.html#cfn-connectcampaignsv2-campaign-schedule-refreshfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshFrequency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String endTime;
            java.lang.String startTime;
            java.lang.String refreshFrequency;

            /**
             * Sets the value of {@link ScheduleProperty#getEndTime}
             * @param endTime Timestamp with no UTC offset or timezone. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getStartTime}
             * @param startTime Timestamp with no UTC offset or timezone. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRefreshFrequency}
             * @param refreshFrequency Time duration in ISO 8601 format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshFrequency(java.lang.String refreshFrequency) {
                this.refreshFrequency = refreshFrequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String endTime;
            private final java.lang.String startTime;
            private final java.lang.String refreshFrequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshFrequency = software.amazon.jsii.Kernel.get(this, "refreshFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = java.util.Objects.requireNonNull(builder.endTime, "endTime is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
                this.refreshFrequency = builder.refreshFrequency;
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            public final java.lang.String getRefreshFrequency() {
                return this.refreshFrequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTime", om.valueToTree(this.getEndTime()));
                data.set("startTime", om.valueToTree(this.getStartTime()));
                if (this.getRefreshFrequency() != null) {
                    data.set("refreshFrequency", om.valueToTree(this.getRefreshFrequency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (!endTime.equals(that.endTime)) return false;
                if (!startTime.equals(that.startTime)) return false;
                return this.refreshFrequency != null ? this.refreshFrequency.equals(that.refreshFrequency) : that.refreshFrequency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endTime.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                result = 31 * result + (this.refreshFrequency != null ? this.refreshFrequency.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * SMS Channel Subtype config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * SmsChannelSubtypeConfigProperty smsChannelSubtypeConfigProperty = SmsChannelSubtypeConfigProperty.builder()
     *         .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
     *                 .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
     *                 .wisdomTemplateArn("wisdomTemplateArn")
     *                 .build())
     *         .outboundMode(SmsOutboundModeProperty.builder()
     *                 .agentlessConfig(agentlessConfig)
     *                 .build())
     *         // the properties below are optional
     *         .capacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Default SMS outbound config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-defaultoutboundconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-defaultoutboundconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultOutboundConfig();

        /**
         * SMS Outbound Mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-outboundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-outboundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundMode();

        /**
         * Allocates outbound capacity for the specific channel of this campaign between multiple active campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smschannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-smschannelsubtypeconfig-capacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmsChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsChannelSubtypeConfigProperty> {
            java.lang.Object defaultOutboundConfig;
            java.lang.Object outboundMode;
            java.lang.Number capacity;

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig Default SMS outbound config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.IResolvable defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig Default SMS outbound config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SmsOutboundConfigProperty defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode SMS Outbound Mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.IResolvable outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode SMS Outbound Mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SmsOutboundModeProperty outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link SmsChannelSubtypeConfigProperty#getCapacity}
             * @param capacity Allocates outbound capacity for the specific channel of this campaign between multiple active campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacity(java.lang.Number capacity) {
                this.capacity = capacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsChannelSubtypeConfigProperty {
            private final java.lang.Object defaultOutboundConfig;
            private final java.lang.Object outboundMode;
            private final java.lang.Number capacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultOutboundConfig = software.amazon.jsii.Kernel.get(this, "defaultOutboundConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundMode = software.amazon.jsii.Kernel.get(this, "outboundMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultOutboundConfig = java.util.Objects.requireNonNull(builder.defaultOutboundConfig, "defaultOutboundConfig is required");
                this.outboundMode = java.util.Objects.requireNonNull(builder.outboundMode, "outboundMode is required");
                this.capacity = builder.capacity;
            }

            @Override
            public final java.lang.Object getDefaultOutboundConfig() {
                return this.defaultOutboundConfig;
            }

            @Override
            public final java.lang.Object getOutboundMode() {
                return this.outboundMode;
            }

            @Override
            public final java.lang.Number getCapacity() {
                return this.capacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultOutboundConfig", om.valueToTree(this.getDefaultOutboundConfig()));
                data.set("outboundMode", om.valueToTree(this.getOutboundMode()));
                if (this.getCapacity() != null) {
                    data.set("capacity", om.valueToTree(this.getCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsChannelSubtypeConfigProperty.Jsii$Proxy that = (SmsChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (!defaultOutboundConfig.equals(that.defaultOutboundConfig)) return false;
                if (!outboundMode.equals(that.outboundMode)) return false;
                return this.capacity != null ? this.capacity.equals(that.capacity) : that.capacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultOutboundConfig.hashCode();
                result = 31 * result + (this.outboundMode.hashCode());
                result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Default SMS outbound config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * SmsOutboundConfigProperty smsOutboundConfigProperty = SmsOutboundConfigProperty.builder()
     *         .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
     *         .wisdomTemplateArn("wisdomTemplateArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsOutboundConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsOutboundConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Arn.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-connectsourcephonenumberarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-connectsourcephonenumberarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectSourcePhoneNumberArn();

        /**
         * Arn.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-wisdomtemplatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundconfig.html#cfn-connectcampaignsv2-campaign-smsoutboundconfig-wisdomtemplatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWisdomTemplateArn();

        /**
         * @return a {@link Builder} of {@link SmsOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsOutboundConfigProperty> {
            java.lang.String connectSourcePhoneNumberArn;
            java.lang.String wisdomTemplateArn;

            /**
             * Sets the value of {@link SmsOutboundConfigProperty#getConnectSourcePhoneNumberArn}
             * @param connectSourcePhoneNumberArn Arn. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourcePhoneNumberArn(java.lang.String connectSourcePhoneNumberArn) {
                this.connectSourcePhoneNumberArn = connectSourcePhoneNumberArn;
                return this;
            }

            /**
             * Sets the value of {@link SmsOutboundConfigProperty#getWisdomTemplateArn}
             * @param wisdomTemplateArn Arn. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wisdomTemplateArn(java.lang.String wisdomTemplateArn) {
                this.wisdomTemplateArn = wisdomTemplateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsOutboundConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsOutboundConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsOutboundConfigProperty {
            private final java.lang.String connectSourcePhoneNumberArn;
            private final java.lang.String wisdomTemplateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectSourcePhoneNumberArn = software.amazon.jsii.Kernel.get(this, "connectSourcePhoneNumberArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.wisdomTemplateArn = software.amazon.jsii.Kernel.get(this, "wisdomTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectSourcePhoneNumberArn = java.util.Objects.requireNonNull(builder.connectSourcePhoneNumberArn, "connectSourcePhoneNumberArn is required");
                this.wisdomTemplateArn = java.util.Objects.requireNonNull(builder.wisdomTemplateArn, "wisdomTemplateArn is required");
            }

            @Override
            public final java.lang.String getConnectSourcePhoneNumberArn() {
                return this.connectSourcePhoneNumberArn;
            }

            @Override
            public final java.lang.String getWisdomTemplateArn() {
                return this.wisdomTemplateArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectSourcePhoneNumberArn", om.valueToTree(this.getConnectSourcePhoneNumberArn()));
                data.set("wisdomTemplateArn", om.valueToTree(this.getWisdomTemplateArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsOutboundConfigProperty.Jsii$Proxy that = (SmsOutboundConfigProperty.Jsii$Proxy) o;

                if (!connectSourcePhoneNumberArn.equals(that.connectSourcePhoneNumberArn)) return false;
                return this.wisdomTemplateArn.equals(that.wisdomTemplateArn);
            }

            @Override
            public final int hashCode() {
                int result = this.connectSourcePhoneNumberArn.hashCode();
                result = 31 * result + (this.wisdomTemplateArn.hashCode());
                return result;
            }
        }
    }
    /**
     * SMS Outbound Mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * SmsOutboundModeProperty smsOutboundModeProperty = SmsOutboundModeProperty.builder()
     *         .agentlessConfig(agentlessConfig)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundModeProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsOutboundModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsOutboundModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Agentless config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html#cfn-connectcampaignsv2-campaign-smsoutboundmode-agentlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-smsoutboundmode.html#cfn-connectcampaignsv2-campaign-smsoutboundmode-agentlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmsOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsOutboundModeProperty> {
            java.lang.Object agentlessConfig;

            /**
             * Sets the value of {@link SmsOutboundModeProperty#getAgentlessConfig}
             * @param agentlessConfig Agentless config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessConfig(java.lang.Object agentlessConfig) {
                this.agentlessConfig = agentlessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsOutboundModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsOutboundModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsOutboundModeProperty {
            private final java.lang.Object agentlessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessConfig = software.amazon.jsii.Kernel.get(this, "agentlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessConfig = builder.agentlessConfig;
            }

            @Override
            public final java.lang.Object getAgentlessConfig() {
                return this.agentlessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessConfig() != null) {
                    data.set("agentlessConfig", om.valueToTree(this.getAgentlessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SmsOutboundModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsOutboundModeProperty.Jsii$Proxy that = (SmsOutboundModeProperty.Jsii$Proxy) o;

                return this.agentlessConfig != null ? this.agentlessConfig.equals(that.agentlessConfig) : that.agentlessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessConfig != null ? this.agentlessConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The possible types of channel config parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .customerProfilesSegmentArn("customerProfilesSegmentArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Arn.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-customerprofilessegmentarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-source.html#cfn-connectcampaignsv2-campaign-source-customerprofilessegmentarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCustomerProfilesSegmentArn();

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.String customerProfilesSegmentArn;

            /**
             * Sets the value of {@link SourceProperty#getCustomerProfilesSegmentArn}
             * @param customerProfilesSegmentArn Arn. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerProfilesSegmentArn(java.lang.String customerProfilesSegmentArn) {
                this.customerProfilesSegmentArn = customerProfilesSegmentArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String customerProfilesSegmentArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerProfilesSegmentArn = software.amazon.jsii.Kernel.get(this, "customerProfilesSegmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerProfilesSegmentArn = java.util.Objects.requireNonNull(builder.customerProfilesSegmentArn, "customerProfilesSegmentArn is required");
            }

            @Override
            public final java.lang.String getCustomerProfilesSegmentArn() {
                return this.customerProfilesSegmentArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customerProfilesSegmentArn", om.valueToTree(this.getCustomerProfilesSegmentArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                return this.customerProfilesSegmentArn.equals(that.customerProfilesSegmentArn);
            }

            @Override
            public final int hashCode() {
                int result = this.customerProfilesSegmentArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Telephony Channel Subtype config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * TelephonyChannelSubtypeConfigProperty telephonyChannelSubtypeConfigProperty = TelephonyChannelSubtypeConfigProperty.builder()
     *         .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
     *                 .connectContactFlowId("connectContactFlowId")
     *                 // the properties below are optional
     *                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                         .enableAnswerMachineDetection(false)
     *                         // the properties below are optional
     *                         .awaitAnswerMachinePrompt(false)
     *                         .build())
     *                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *                 .build())
     *         .outboundMode(TelephonyOutboundModeProperty.builder()
     *                 .agentlessConfig(agentlessConfig)
     *                 .predictiveConfig(PredictiveConfigProperty.builder()
     *                         .bandwidthAllocation(123)
     *                         .build())
     *                 .progressiveConfig(ProgressiveConfigProperty.builder()
     *                         .bandwidthAllocation(123)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .capacity(123)
     *         .connectQueueId("connectQueueId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyChannelSubtypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TelephonyChannelSubtypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelephonyChannelSubtypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Default Telephone Outbound config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-defaultoutboundconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-defaultoutboundconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultOutboundConfig();

        /**
         * Telephony Outbound Mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-outboundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-outboundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundMode();

        /**
         * Allocates outbound capacity for the specific channel of this campaign between multiple active campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-capacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCapacity() {
            return null;
        }

        /**
         * The queue for the call.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-connectqueueid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonychannelsubtypeconfig.html#cfn-connectcampaignsv2-campaign-telephonychannelsubtypeconfig-connectqueueid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectQueueId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelephonyChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelephonyChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelephonyChannelSubtypeConfigProperty> {
            java.lang.Object defaultOutboundConfig;
            java.lang.Object outboundMode;
            java.lang.Number capacity;
            java.lang.String connectQueueId;

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig Default Telephone Outbound config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.IResolvable defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getDefaultOutboundConfig}
             * @param defaultOutboundConfig Default Telephone Outbound config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOutboundConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TelephonyOutboundConfigProperty defaultOutboundConfig) {
                this.defaultOutboundConfig = defaultOutboundConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode Telephony Outbound Mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.IResolvable outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getOutboundMode}
             * @param outboundMode Telephony Outbound Mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundMode(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.TelephonyOutboundModeProperty outboundMode) {
                this.outboundMode = outboundMode;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getCapacity}
             * @param capacity Allocates outbound capacity for the specific channel of this campaign between multiple active campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacity(java.lang.Number capacity) {
                this.capacity = capacity;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyChannelSubtypeConfigProperty#getConnectQueueId}
             * @param connectQueueId The queue for the call.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectQueueId(java.lang.String connectQueueId) {
                this.connectQueueId = connectQueueId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelephonyChannelSubtypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelephonyChannelSubtypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelephonyChannelSubtypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelephonyChannelSubtypeConfigProperty {
            private final java.lang.Object defaultOutboundConfig;
            private final java.lang.Object outboundMode;
            private final java.lang.Number capacity;
            private final java.lang.String connectQueueId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultOutboundConfig = software.amazon.jsii.Kernel.get(this, "defaultOutboundConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundMode = software.amazon.jsii.Kernel.get(this, "outboundMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.connectQueueId = software.amazon.jsii.Kernel.get(this, "connectQueueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultOutboundConfig = java.util.Objects.requireNonNull(builder.defaultOutboundConfig, "defaultOutboundConfig is required");
                this.outboundMode = java.util.Objects.requireNonNull(builder.outboundMode, "outboundMode is required");
                this.capacity = builder.capacity;
                this.connectQueueId = builder.connectQueueId;
            }

            @Override
            public final java.lang.Object getDefaultOutboundConfig() {
                return this.defaultOutboundConfig;
            }

            @Override
            public final java.lang.Object getOutboundMode() {
                return this.outboundMode;
            }

            @Override
            public final java.lang.Number getCapacity() {
                return this.capacity;
            }

            @Override
            public final java.lang.String getConnectQueueId() {
                return this.connectQueueId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultOutboundConfig", om.valueToTree(this.getDefaultOutboundConfig()));
                data.set("outboundMode", om.valueToTree(this.getOutboundMode()));
                if (this.getCapacity() != null) {
                    data.set("capacity", om.valueToTree(this.getCapacity()));
                }
                if (this.getConnectQueueId() != null) {
                    data.set("connectQueueId", om.valueToTree(this.getConnectQueueId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyChannelSubtypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelephonyChannelSubtypeConfigProperty.Jsii$Proxy that = (TelephonyChannelSubtypeConfigProperty.Jsii$Proxy) o;

                if (!defaultOutboundConfig.equals(that.defaultOutboundConfig)) return false;
                if (!outboundMode.equals(that.outboundMode)) return false;
                if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) return false;
                return this.connectQueueId != null ? this.connectQueueId.equals(that.connectQueueId) : that.connectQueueId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultOutboundConfig.hashCode();
                result = 31 * result + (this.outboundMode.hashCode());
                result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
                result = 31 * result + (this.connectQueueId != null ? this.connectQueueId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Default Telephone Outbound config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * TelephonyOutboundConfigProperty telephonyOutboundConfigProperty = TelephonyOutboundConfigProperty.builder()
     *         .connectContactFlowId("connectContactFlowId")
     *         // the properties below are optional
     *         .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                 .enableAnswerMachineDetection(false)
     *                 // the properties below are optional
     *                 .awaitAnswerMachinePrompt(false)
     *                 .build())
     *         .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TelephonyOutboundConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelephonyOutboundConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the contact flow for the outbound call.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectcontactflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectcontactflowid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectContactFlowId();

        /**
         * The configuration used for answering machine detection during outbound calls.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-answermachinedetectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-answermachinedetectionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerMachineDetectionConfig() {
            return null;
        }

        /**
         * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectsourcephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundconfig.html#cfn-connectcampaignsv2-campaign-telephonyoutboundconfig-connectsourcephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectSourcePhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelephonyOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelephonyOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelephonyOutboundConfigProperty> {
            java.lang.String connectContactFlowId;
            java.lang.Object answerMachineDetectionConfig;
            java.lang.String connectSourcePhoneNumber;

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getConnectContactFlowId}
             * @param connectContactFlowId The identifier of the contact flow for the outbound call. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectContactFlowId(java.lang.String connectContactFlowId) {
                this.connectContactFlowId = connectContactFlowId;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getAnswerMachineDetectionConfig}
             * @param answerMachineDetectionConfig The configuration used for answering machine detection during outbound calls.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerMachineDetectionConfig(software.amazon.awscdk.IResolvable answerMachineDetectionConfig) {
                this.answerMachineDetectionConfig = answerMachineDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getAnswerMachineDetectionConfig}
             * @param answerMachineDetectionConfig The configuration used for answering machine detection during outbound calls.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerMachineDetectionConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.AnswerMachineDetectionConfigProperty answerMachineDetectionConfig) {
                this.answerMachineDetectionConfig = answerMachineDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundConfigProperty#getConnectSourcePhoneNumber}
             * @param connectSourcePhoneNumber The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourcePhoneNumber(java.lang.String connectSourcePhoneNumber) {
                this.connectSourcePhoneNumber = connectSourcePhoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelephonyOutboundConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelephonyOutboundConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelephonyOutboundConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelephonyOutboundConfigProperty {
            private final java.lang.String connectContactFlowId;
            private final java.lang.Object answerMachineDetectionConfig;
            private final java.lang.String connectSourcePhoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectContactFlowId = software.amazon.jsii.Kernel.get(this, "connectContactFlowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.answerMachineDetectionConfig = software.amazon.jsii.Kernel.get(this, "answerMachineDetectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectSourcePhoneNumber = software.amazon.jsii.Kernel.get(this, "connectSourcePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectContactFlowId = java.util.Objects.requireNonNull(builder.connectContactFlowId, "connectContactFlowId is required");
                this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
                this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
            }

            @Override
            public final java.lang.String getConnectContactFlowId() {
                return this.connectContactFlowId;
            }

            @Override
            public final java.lang.Object getAnswerMachineDetectionConfig() {
                return this.answerMachineDetectionConfig;
            }

            @Override
            public final java.lang.String getConnectSourcePhoneNumber() {
                return this.connectSourcePhoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectContactFlowId", om.valueToTree(this.getConnectContactFlowId()));
                if (this.getAnswerMachineDetectionConfig() != null) {
                    data.set("answerMachineDetectionConfig", om.valueToTree(this.getAnswerMachineDetectionConfig()));
                }
                if (this.getConnectSourcePhoneNumber() != null) {
                    data.set("connectSourcePhoneNumber", om.valueToTree(this.getConnectSourcePhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelephonyOutboundConfigProperty.Jsii$Proxy that = (TelephonyOutboundConfigProperty.Jsii$Proxy) o;

                if (!connectContactFlowId.equals(that.connectContactFlowId)) return false;
                if (this.answerMachineDetectionConfig != null ? !this.answerMachineDetectionConfig.equals(that.answerMachineDetectionConfig) : that.answerMachineDetectionConfig != null) return false;
                return this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.equals(that.connectSourcePhoneNumber) : that.connectSourcePhoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectContactFlowId.hashCode();
                result = 31 * result + (this.answerMachineDetectionConfig != null ? this.answerMachineDetectionConfig.hashCode() : 0);
                result = 31 * result + (this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Telephony Outbound Mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * Object agentlessConfig;
     * TelephonyOutboundModeProperty telephonyOutboundModeProperty = TelephonyOutboundModeProperty.builder()
     *         .agentlessConfig(agentlessConfig)
     *         .predictiveConfig(PredictiveConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 .build())
     *         .progressiveConfig(ProgressiveConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundModeProperty")
    @software.amazon.jsii.Jsii.Proxy(TelephonyOutboundModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TelephonyOutboundModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Agentless config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-agentlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-agentlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessConfig() {
            return null;
        }

        /**
         * Predictive config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-predictiveconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-predictiveconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveConfig() {
            return null;
        }

        /**
         * Progressive config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-progressiveconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-telephonyoutboundmode.html#cfn-connectcampaignsv2-campaign-telephonyoutboundmode-progressiveconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProgressiveConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TelephonyOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TelephonyOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TelephonyOutboundModeProperty> {
            java.lang.Object agentlessConfig;
            java.lang.Object predictiveConfig;
            java.lang.Object progressiveConfig;

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getAgentlessConfig}
             * @param agentlessConfig Agentless config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessConfig(java.lang.Object agentlessConfig) {
                this.agentlessConfig = agentlessConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getPredictiveConfig}
             * @param predictiveConfig Predictive config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveConfig(software.amazon.awscdk.IResolvable predictiveConfig) {
                this.predictiveConfig = predictiveConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getPredictiveConfig}
             * @param predictiveConfig Predictive config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.PredictiveConfigProperty predictiveConfig) {
                this.predictiveConfig = predictiveConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getProgressiveConfig}
             * @param progressiveConfig Progressive config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveConfig(software.amazon.awscdk.IResolvable progressiveConfig) {
                this.progressiveConfig = progressiveConfig;
                return this;
            }

            /**
             * Sets the value of {@link TelephonyOutboundModeProperty#getProgressiveConfig}
             * @param progressiveConfig Progressive config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ProgressiveConfigProperty progressiveConfig) {
                this.progressiveConfig = progressiveConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TelephonyOutboundModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TelephonyOutboundModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TelephonyOutboundModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TelephonyOutboundModeProperty {
            private final java.lang.Object agentlessConfig;
            private final java.lang.Object predictiveConfig;
            private final java.lang.Object progressiveConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessConfig = software.amazon.jsii.Kernel.get(this, "agentlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predictiveConfig = software.amazon.jsii.Kernel.get(this, "predictiveConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.progressiveConfig = software.amazon.jsii.Kernel.get(this, "progressiveConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessConfig = builder.agentlessConfig;
                this.predictiveConfig = builder.predictiveConfig;
                this.progressiveConfig = builder.progressiveConfig;
            }

            @Override
            public final java.lang.Object getAgentlessConfig() {
                return this.agentlessConfig;
            }

            @Override
            public final java.lang.Object getPredictiveConfig() {
                return this.predictiveConfig;
            }

            @Override
            public final java.lang.Object getProgressiveConfig() {
                return this.progressiveConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessConfig() != null) {
                    data.set("agentlessConfig", om.valueToTree(this.getAgentlessConfig()));
                }
                if (this.getPredictiveConfig() != null) {
                    data.set("predictiveConfig", om.valueToTree(this.getPredictiveConfig()));
                }
                if (this.getProgressiveConfig() != null) {
                    data.set("progressiveConfig", om.valueToTree(this.getProgressiveConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TelephonyOutboundModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TelephonyOutboundModeProperty.Jsii$Proxy that = (TelephonyOutboundModeProperty.Jsii$Proxy) o;

                if (this.agentlessConfig != null ? !this.agentlessConfig.equals(that.agentlessConfig) : that.agentlessConfig != null) return false;
                if (this.predictiveConfig != null ? !this.predictiveConfig.equals(that.predictiveConfig) : that.predictiveConfig != null) return false;
                return this.progressiveConfig != null ? this.progressiveConfig.equals(that.progressiveConfig) : that.progressiveConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessConfig != null ? this.agentlessConfig.hashCode() : 0;
                result = 31 * result + (this.predictiveConfig != null ? this.predictiveConfig.hashCode() : 0);
                result = 31 * result + (this.progressiveConfig != null ? this.progressiveConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Time range in 24 hour format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * TimeRangeProperty timeRangeProperty = TimeRangeProperty.builder()
     *         .endTime("endTime")
     *         .startTime("startTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Time in ISO 8601 format, e.g. T23:11.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-endtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndTime();

        /**
         * Time in ISO 8601 format, e.g. T23:11.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timerange.html#cfn-connectcampaignsv2-campaign-timerange-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * @return a {@link Builder} of {@link TimeRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeRangeProperty> {
            java.lang.String endTime;
            java.lang.String startTime;

            /**
             * Sets the value of {@link TimeRangeProperty#getEndTime}
             * @param endTime Time in ISO 8601 format, e.g. T23:11. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link TimeRangeProperty#getStartTime}
             * @param startTime Time in ISO 8601 format, e.g. T23:11. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeRangeProperty {
            private final java.lang.String endTime;
            private final java.lang.String startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = java.util.Objects.requireNonNull(builder.endTime, "endTime is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endTime", om.valueToTree(this.getEndTime()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeRangeProperty.Jsii$Proxy that = (TimeRangeProperty.Jsii$Proxy) o;

                if (!endTime.equals(that.endTime)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.endTime.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }
    /**
     * Time window config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaignsv2.*;
     * TimeWindowProperty timeWindowProperty = TimeWindowProperty.builder()
     *         .openHours(OpenHoursProperty.builder()
     *                 .dailyHours(List.of(DailyHourProperty.builder()
     *                         .key("key")
     *                         .value(List.of(TimeRangeProperty.builder()
     *                                 .endTime("endTime")
     *                                 .startTime("startTime")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .restrictedPeriods(RestrictedPeriodsProperty.builder()
     *                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
     *                         .endDate("endDate")
     *                         .startDate("startDate")
     *                         // the properties below are optional
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Open Hours config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-openhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-openhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOpenHours();

        /**
         * Restricted period config.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-restrictedperiods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaignsv2-campaign-timewindow.html#cfn-connectcampaignsv2-campaign-timewindow-restrictedperiods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictedPeriods() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeWindowProperty> {
            java.lang.Object openHours;
            java.lang.Object restrictedPeriods;

            /**
             * Sets the value of {@link TimeWindowProperty#getOpenHours}
             * @param openHours Open Hours config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openHours(software.amazon.awscdk.IResolvable openHours) {
                this.openHours = openHours;
                return this;
            }

            /**
             * Sets the value of {@link TimeWindowProperty#getOpenHours}
             * @param openHours Open Hours config. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openHours(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.OpenHoursProperty openHours) {
                this.openHours = openHours;
                return this;
            }

            /**
             * Sets the value of {@link TimeWindowProperty#getRestrictedPeriods}
             * @param restrictedPeriods Restricted period config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriods(software.amazon.awscdk.IResolvable restrictedPeriods) {
                this.restrictedPeriods = restrictedPeriods;
                return this;
            }

            /**
             * Sets the value of {@link TimeWindowProperty#getRestrictedPeriods}
             * @param restrictedPeriods Restricted period config.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictedPeriods(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.RestrictedPeriodsProperty restrictedPeriods) {
                this.restrictedPeriods = restrictedPeriods;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeWindowProperty {
            private final java.lang.Object openHours;
            private final java.lang.Object restrictedPeriods;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.openHours = software.amazon.jsii.Kernel.get(this, "openHours", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restrictedPeriods = software.amazon.jsii.Kernel.get(this, "restrictedPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.openHours = java.util.Objects.requireNonNull(builder.openHours, "openHours is required");
                this.restrictedPeriods = builder.restrictedPeriods;
            }

            @Override
            public final java.lang.Object getOpenHours() {
                return this.openHours;
            }

            @Override
            public final java.lang.Object getRestrictedPeriods() {
                return this.restrictedPeriods;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("openHours", om.valueToTree(this.getOpenHours()));
                if (this.getRestrictedPeriods() != null) {
                    data.set("restrictedPeriods", om.valueToTree(this.getRestrictedPeriods()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaign.TimeWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeWindowProperty.Jsii$Proxy that = (TimeWindowProperty.Jsii$Proxy) o;

                if (!openHours.equals(that.openHours)) return false;
                return this.restrictedPeriods != null ? this.restrictedPeriods.equals(that.restrictedPeriods) : that.restrictedPeriods == null;
            }

            @Override
            public final int hashCode() {
                int result = this.openHours.hashCode();
                result = 31 * result + (this.restrictedPeriods != null ? this.restrictedPeriods.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaignProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connectcampaignsv2.CfnCampaignProps.Builder();
        }

        /**
         * The possible types of channel subtype config parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig</a>
         * @param channelSubtypeConfig The possible types of channel subtype config parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtypeConfig(final software.amazon.awscdk.IResolvable channelSubtypeConfig) {
            this.props.channelSubtypeConfig(channelSubtypeConfig);
            return this;
        }
        /**
         * The possible types of channel subtype config parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig</a>
         * @param channelSubtypeConfig The possible types of channel subtype config parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtypeConfig(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty channelSubtypeConfig) {
            this.props.channelSubtypeConfig(channelSubtypeConfig);
            return this;
        }

        /**
         * Amazon Connect Instance Id.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid</a>
         * @param connectInstanceId Amazon Connect Instance Id. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectInstanceId(final java.lang.String connectInstanceId) {
            this.props.connectInstanceId(connectInstanceId);
            return this;
        }

        /**
         * Campaign name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name</a>
         * @param name Campaign name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Communication limits config.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride</a>
         * @param communicationLimitsOverride Communication limits config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationLimitsOverride(final software.amazon.awscdk.IResolvable communicationLimitsOverride) {
            this.props.communicationLimitsOverride(communicationLimitsOverride);
            return this;
        }
        /**
         * Communication limits config.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride</a>
         * @param communicationLimitsOverride Communication limits config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationLimitsOverride(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty communicationLimitsOverride) {
            this.props.communicationLimitsOverride(communicationLimitsOverride);
            return this;
        }

        /**
         * Campaign communication time config.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig</a>
         * @param communicationTimeConfig Campaign communication time config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationTimeConfig(final software.amazon.awscdk.IResolvable communicationTimeConfig) {
            this.props.communicationTimeConfig(communicationTimeConfig);
            return this;
        }
        /**
         * Campaign communication time config.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig</a>
         * @param communicationTimeConfig Campaign communication time config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationTimeConfig(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty communicationTimeConfig) {
            this.props.communicationTimeConfig(communicationTimeConfig);
            return this;
        }

        /**
         * Arn.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn</a>
         * @param connectCampaignFlowArn Arn. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectCampaignFlowArn(final java.lang.String connectCampaignFlowArn) {
            this.props.connectCampaignFlowArn(connectCampaignFlowArn);
            return this;
        }

        /**
         * Campaign schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule</a>
         * @param schedule Campaign schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * Campaign schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule</a>
         * @param schedule Campaign schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The possible types of channel config parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source</a>
         * @param source The possible types of channel config parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.IResolvable source) {
            this.props.source(source);
            return this;
        }
        /**
         * The possible types of channel config parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source</a>
         * @param source The possible types of channel config parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SourceProperty source) {
            this.props.source(source);
            return this;
        }

        /**
         * One or more tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags</a>
         * @param tags One or more tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign build() {
            return new software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
