package software.amazon.awscdk.services.ec2;

/**
 * Configuration for AwsIpam.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.IpAddresses;
 * CfnIPAMPool pool;
 * Vpc.Builder.create(this, "TheVPC")
 *         .ipAddresses(IpAddresses.awsIpamAllocation(AwsIpamProps.builder()
 *                 .ipv4IpamPoolId(pool.getRef())
 *                 .ipv4NetmaskLength(18)
 *                 .defaultSubnetIpv4NetmaskLength(24)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:17.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AwsIpamProps")
@software.amazon.jsii.Jsii.Proxy(AwsIpamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsIpamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Ipam Pool Id for ipv4 allocation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpv4IpamPoolId();

    /**
     * Netmask length for Vpc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getIpv4NetmaskLength();

    /**
     * Default length for Subnet ipv4 Network mask.
     * <p>
     * Specify this option only if you do not specify all Subnets using SubnetConfiguration with a cidrMask
     * <p>
     * Default: - Default ipv4 Subnet Mask for subnets in Vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultSubnetIpv4NetmaskLength() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsIpamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsIpamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsIpamProps> {
        java.lang.String ipv4IpamPoolId;
        java.lang.Number ipv4NetmaskLength;
        java.lang.Number defaultSubnetIpv4NetmaskLength;

        /**
         * Sets the value of {@link AwsIpamProps#getIpv4IpamPoolId}
         * @param ipv4IpamPoolId Ipam Pool Id for ipv4 allocation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4IpamPoolId(java.lang.String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link AwsIpamProps#getIpv4NetmaskLength}
         * @param ipv4NetmaskLength Netmask length for Vpc. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4NetmaskLength(java.lang.Number ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link AwsIpamProps#getDefaultSubnetIpv4NetmaskLength}
         * @param defaultSubnetIpv4NetmaskLength Default length for Subnet ipv4 Network mask.
         *                                       Specify this option only if you do not specify all Subnets using SubnetConfiguration with a cidrMask
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubnetIpv4NetmaskLength(java.lang.Number defaultSubnetIpv4NetmaskLength) {
            this.defaultSubnetIpv4NetmaskLength = defaultSubnetIpv4NetmaskLength;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIpamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsIpamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsIpamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIpamProps {
        private final java.lang.String ipv4IpamPoolId;
        private final java.lang.Number ipv4NetmaskLength;
        private final java.lang.Number defaultSubnetIpv4NetmaskLength;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipv4IpamPoolId = software.amazon.jsii.Kernel.get(this, "ipv4IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv4NetmaskLength = software.amazon.jsii.Kernel.get(this, "ipv4NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.defaultSubnetIpv4NetmaskLength = software.amazon.jsii.Kernel.get(this, "defaultSubnetIpv4NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipv4IpamPoolId = java.util.Objects.requireNonNull(builder.ipv4IpamPoolId, "ipv4IpamPoolId is required");
            this.ipv4NetmaskLength = java.util.Objects.requireNonNull(builder.ipv4NetmaskLength, "ipv4NetmaskLength is required");
            this.defaultSubnetIpv4NetmaskLength = builder.defaultSubnetIpv4NetmaskLength;
        }

        @Override
        public final java.lang.String getIpv4IpamPoolId() {
            return this.ipv4IpamPoolId;
        }

        @Override
        public final java.lang.Number getIpv4NetmaskLength() {
            return this.ipv4NetmaskLength;
        }

        @Override
        public final java.lang.Number getDefaultSubnetIpv4NetmaskLength() {
            return this.defaultSubnetIpv4NetmaskLength;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipv4IpamPoolId", om.valueToTree(this.getIpv4IpamPoolId()));
            data.set("ipv4NetmaskLength", om.valueToTree(this.getIpv4NetmaskLength()));
            if (this.getDefaultSubnetIpv4NetmaskLength() != null) {
                data.set("defaultSubnetIpv4NetmaskLength", om.valueToTree(this.getDefaultSubnetIpv4NetmaskLength()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AwsIpamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsIpamProps.Jsii$Proxy that = (AwsIpamProps.Jsii$Proxy) o;

            if (!ipv4IpamPoolId.equals(that.ipv4IpamPoolId)) return false;
            if (!ipv4NetmaskLength.equals(that.ipv4NetmaskLength)) return false;
            return this.defaultSubnetIpv4NetmaskLength != null ? this.defaultSubnetIpv4NetmaskLength.equals(that.defaultSubnetIpv4NetmaskLength) : that.defaultSubnetIpv4NetmaskLength == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ipv4IpamPoolId.hashCode();
            result = 31 * result + (this.ipv4NetmaskLength.hashCode());
            result = 31 * result + (this.defaultSubnetIpv4NetmaskLength != null ? this.defaultSubnetIpv4NetmaskLength.hashCode() : 0);
            return result;
        }
    }
}
