package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnDHCPOptions</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnDHCPOptionsProps cfnDHCPOptionsProps = CfnDHCPOptionsProps.builder()
 *         .domainName("domainName")
 *         .domainNameServers(List.of("domainNameServers"))
 *         .ipv6AddressPreferredLeaseTime(123)
 *         .netbiosNameServers(List.of("netbiosNameServers"))
 *         .netbiosNodeType(123)
 *         .ntpServers(List.of("ntpServers"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:17.458Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnDHCPOptionsProps")
@software.amazon.jsii.Jsii.Proxy(CfnDHCPOptionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDHCPOptionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * This value is used to complete unqualified DNS hostnames.
     * <p>
     * If you're using AmazonProvidedDNS in <code>us-east-1</code> , specify <code>ec2.internal</code> . If you're using AmazonProvidedDNS in another Region, specify <em>region</em> . <code>compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code> ). Otherwise, specify a domain name (for example, <em>MyCompany.com</em> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The IPv4 addresses of up to four domain name servers, or <code>AmazonProvidedDNS</code> .
     * <p>
     * The default is <code>AmazonProvidedDNS</code> . To have your instance receive a custom DNS hostname as specified in <code>DomainName</code> , you must set this property to a custom DNS server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainnameservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-domainnameservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainNameServers() {
        return null;
    }

    /**
     * A value (in seconds, minutes, hours, or years) for how frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal.
     * <p>
     * Acceptable values are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-ipv6addresspreferredleasetime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-ipv6addresspreferredleasetime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressPreferredLeaseTime() {
        return null;
    }

    /**
     * The IPv4 addresses of up to four NetBIOS name servers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnameservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnameservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNetbiosNameServers() {
        return null;
    }

    /**
     * The NetBIOS node type (1, 2, 4, or 8).
     * <p>
     * We recommend that you specify 2 (broadcast and multicast are not currently supported).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-netbiosnodetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNetbiosNodeType() {
        return null;
    }

    /**
     * The IPv4 addresses of up to four Network Time Protocol (NTP) servers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-ntpservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-ntpservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNtpServers() {
        return null;
    }

    /**
     * Any tags assigned to the DHCP options set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcpoptions.html#cfn-ec2-dhcpoptions-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDHCPOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDHCPOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDHCPOptionsProps> {
        java.lang.String domainName;
        java.util.List<java.lang.String> domainNameServers;
        java.lang.Number ipv6AddressPreferredLeaseTime;
        java.util.List<java.lang.String> netbiosNameServers;
        java.lang.Number netbiosNodeType;
        java.util.List<java.lang.String> ntpServers;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getDomainName}
         * @param domainName This value is used to complete unqualified DNS hostnames.
         *                   If you're using AmazonProvidedDNS in <code>us-east-1</code> , specify <code>ec2.internal</code> . If you're using AmazonProvidedDNS in another Region, specify <em>region</em> . <code>compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code> ). Otherwise, specify a domain name (for example, <em>MyCompany.com</em> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getDomainNameServers}
         * @param domainNameServers The IPv4 addresses of up to four domain name servers, or <code>AmazonProvidedDNS</code> .
         *                          The default is <code>AmazonProvidedDNS</code> . To have your instance receive a custom DNS hostname as specified in <code>DomainName</code> , you must set this property to a custom DNS server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameServers(java.util.List<java.lang.String> domainNameServers) {
            this.domainNameServers = domainNameServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getIpv6AddressPreferredLeaseTime}
         * @param ipv6AddressPreferredLeaseTime A value (in seconds, minutes, hours, or years) for how frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal.
         *                                      Acceptable values are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6AddressPreferredLeaseTime(java.lang.Number ipv6AddressPreferredLeaseTime) {
            this.ipv6AddressPreferredLeaseTime = ipv6AddressPreferredLeaseTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getNetbiosNameServers}
         * @param netbiosNameServers The IPv4 addresses of up to four NetBIOS name servers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder netbiosNameServers(java.util.List<java.lang.String> netbiosNameServers) {
            this.netbiosNameServers = netbiosNameServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getNetbiosNodeType}
         * @param netbiosNodeType The NetBIOS node type (1, 2, 4, or 8).
         *                        We recommend that you specify 2 (broadcast and multicast are not currently supported).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder netbiosNodeType(java.lang.Number netbiosNodeType) {
            this.netbiosNodeType = netbiosNodeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getNtpServers}
         * @param ntpServers The IPv4 addresses of up to four Network Time Protocol (NTP) servers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ntpServers(java.util.List<java.lang.String> ntpServers) {
            this.ntpServers = ntpServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnDHCPOptionsProps#getTags}
         * @param tags Any tags assigned to the DHCP options set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDHCPOptionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDHCPOptionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDHCPOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDHCPOptionsProps {
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> domainNameServers;
        private final java.lang.Number ipv6AddressPreferredLeaseTime;
        private final java.util.List<java.lang.String> netbiosNameServers;
        private final java.lang.Number netbiosNodeType;
        private final java.util.List<java.lang.String> ntpServers;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainNameServers = software.amazon.jsii.Kernel.get(this, "domainNameServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ipv6AddressPreferredLeaseTime = software.amazon.jsii.Kernel.get(this, "ipv6AddressPreferredLeaseTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.netbiosNameServers = software.amazon.jsii.Kernel.get(this, "netbiosNameServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.netbiosNodeType = software.amazon.jsii.Kernel.get(this, "netbiosNodeType", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ntpServers = software.amazon.jsii.Kernel.get(this, "ntpServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = builder.domainName;
            this.domainNameServers = builder.domainNameServers;
            this.ipv6AddressPreferredLeaseTime = builder.ipv6AddressPreferredLeaseTime;
            this.netbiosNameServers = builder.netbiosNameServers;
            this.netbiosNodeType = builder.netbiosNodeType;
            this.ntpServers = builder.ntpServers;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.List<java.lang.String> getDomainNameServers() {
            return this.domainNameServers;
        }

        @Override
        public final java.lang.Number getIpv6AddressPreferredLeaseTime() {
            return this.ipv6AddressPreferredLeaseTime;
        }

        @Override
        public final java.util.List<java.lang.String> getNetbiosNameServers() {
            return this.netbiosNameServers;
        }

        @Override
        public final java.lang.Number getNetbiosNodeType() {
            return this.netbiosNodeType;
        }

        @Override
        public final java.util.List<java.lang.String> getNtpServers() {
            return this.ntpServers;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainNameServers() != null) {
                data.set("domainNameServers", om.valueToTree(this.getDomainNameServers()));
            }
            if (this.getIpv6AddressPreferredLeaseTime() != null) {
                data.set("ipv6AddressPreferredLeaseTime", om.valueToTree(this.getIpv6AddressPreferredLeaseTime()));
            }
            if (this.getNetbiosNameServers() != null) {
                data.set("netbiosNameServers", om.valueToTree(this.getNetbiosNameServers()));
            }
            if (this.getNetbiosNodeType() != null) {
                data.set("netbiosNodeType", om.valueToTree(this.getNetbiosNodeType()));
            }
            if (this.getNtpServers() != null) {
                data.set("ntpServers", om.valueToTree(this.getNtpServers()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnDHCPOptionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDHCPOptionsProps.Jsii$Proxy that = (CfnDHCPOptionsProps.Jsii$Proxy) o;

            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainNameServers != null ? !this.domainNameServers.equals(that.domainNameServers) : that.domainNameServers != null) return false;
            if (this.ipv6AddressPreferredLeaseTime != null ? !this.ipv6AddressPreferredLeaseTime.equals(that.ipv6AddressPreferredLeaseTime) : that.ipv6AddressPreferredLeaseTime != null) return false;
            if (this.netbiosNameServers != null ? !this.netbiosNameServers.equals(that.netbiosNameServers) : that.netbiosNameServers != null) return false;
            if (this.netbiosNodeType != null ? !this.netbiosNodeType.equals(that.netbiosNodeType) : that.netbiosNodeType != null) return false;
            if (this.ntpServers != null ? !this.ntpServers.equals(that.ntpServers) : that.ntpServers != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName != null ? this.domainName.hashCode() : 0;
            result = 31 * result + (this.domainNameServers != null ? this.domainNameServers.hashCode() : 0);
            result = 31 * result + (this.ipv6AddressPreferredLeaseTime != null ? this.ipv6AddressPreferredLeaseTime.hashCode() : 0);
            result = 31 * result + (this.netbiosNameServers != null ? this.netbiosNameServers.hashCode() : 0);
            result = 31 * result + (this.netbiosNodeType != null ? this.netbiosNodeType.hashCode() : 0);
            result = 31 * result + (this.ntpServers != null ? this.ntpServers.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
