package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVerifiedAccessInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVerifiedAccessInstanceProps cfnVerifiedAccessInstanceProps = CfnVerifiedAccessInstanceProps.builder()
 *         .description("description")
 *         .fipsEnabled(false)
 *         .loggingConfigurations(VerifiedAccessLogsProperty.builder()
 *                 .cloudWatchLogs(CloudWatchLogsProperty.builder()
 *                         .enabled(false)
 *                         .logGroup("logGroup")
 *                         .build())
 *                 .includeTrustContext(false)
 *                 .kinesisDataFirehose(KinesisDataFirehoseProperty.builder()
 *                         .deliveryStream("deliveryStream")
 *                         .enabled(false)
 *                         .build())
 *                 .logVersion("logVersion")
 *                 .s3(S3Property.builder()
 *                         .bucketName("bucketName")
 *                         .bucketOwner("bucketOwner")
 *                         .enabled(false)
 *                         .prefix("prefix")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .verifiedAccessTrustProviderIds(List.of("verifiedAccessTrustProviderIds"))
 *         .verifiedAccessTrustProviders(List.of(VerifiedAccessTrustProviderProperty.builder()
 *                 .description("description")
 *                 .deviceTrustProviderType("deviceTrustProviderType")
 *                 .trustProviderType("trustProviderType")
 *                 .userTrustProviderType("userTrustProviderType")
 *                 .verifiedAccessTrustProviderId("verifiedAccessTrustProviderId")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:17.877Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVerifiedAccessInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnVerifiedAccessInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVerifiedAccessInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description for the AWS Verified Access instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-fipsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-fipsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFipsEnabled() {
        return null;
    }

    /**
     * The logging configuration for the Verified Access instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-loggingconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-loggingconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfigurations() {
        return null;
    }

    /**
     * The tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The IDs of the AWS Verified Access trust providers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-verifiedaccesstrustproviderids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-verifiedaccesstrustproviderids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVerifiedAccessTrustProviderIds() {
        return null;
    }

    /**
     * The IDs of the AWS Verified Access trust providers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-verifiedaccesstrustproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessinstance.html#cfn-ec2-verifiedaccessinstance-verifiedaccesstrustproviders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVerifiedAccessTrustProviders() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVerifiedAccessInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVerifiedAccessInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVerifiedAccessInstanceProps> {
        java.lang.String description;
        java.lang.Object fipsEnabled;
        java.lang.Object loggingConfigurations;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> verifiedAccessTrustProviderIds;
        java.lang.Object verifiedAccessTrustProviders;

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getDescription}
         * @param description A description for the AWS Verified Access instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getFipsEnabled}
         * @param fipsEnabled Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fipsEnabled(java.lang.Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getFipsEnabled}
         * @param fipsEnabled Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fipsEnabled(software.amazon.awscdk.IResolvable fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getLoggingConfigurations}
         * @param loggingConfigurations The logging configuration for the Verified Access instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfigurations(software.amazon.awscdk.IResolvable loggingConfigurations) {
            this.loggingConfigurations = loggingConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getLoggingConfigurations}
         * @param loggingConfigurations The logging configuration for the Verified Access instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfigurations(software.amazon.awscdk.services.ec2.CfnVerifiedAccessInstance.VerifiedAccessLogsProperty loggingConfigurations) {
            this.loggingConfigurations = loggingConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getVerifiedAccessTrustProviderIds}
         * @param verifiedAccessTrustProviderIds The IDs of the AWS Verified Access trust providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessTrustProviderIds(java.util.List<java.lang.String> verifiedAccessTrustProviderIds) {
            this.verifiedAccessTrustProviderIds = verifiedAccessTrustProviderIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getVerifiedAccessTrustProviders}
         * @param verifiedAccessTrustProviders The IDs of the AWS Verified Access trust providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessTrustProviders(software.amazon.awscdk.IResolvable verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = verifiedAccessTrustProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessInstanceProps#getVerifiedAccessTrustProviders}
         * @param verifiedAccessTrustProviders The IDs of the AWS Verified Access trust providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessTrustProviders(java.util.List<? extends java.lang.Object> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = verifiedAccessTrustProviders;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVerifiedAccessInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVerifiedAccessInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVerifiedAccessInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVerifiedAccessInstanceProps {
        private final java.lang.String description;
        private final java.lang.Object fipsEnabled;
        private final java.lang.Object loggingConfigurations;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> verifiedAccessTrustProviderIds;
        private final java.lang.Object verifiedAccessTrustProviders;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fipsEnabled = software.amazon.jsii.Kernel.get(this, "fipsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loggingConfigurations = software.amazon.jsii.Kernel.get(this, "loggingConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.verifiedAccessTrustProviderIds = software.amazon.jsii.Kernel.get(this, "verifiedAccessTrustProviderIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.verifiedAccessTrustProviders = software.amazon.jsii.Kernel.get(this, "verifiedAccessTrustProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.fipsEnabled = builder.fipsEnabled;
            this.loggingConfigurations = builder.loggingConfigurations;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.verifiedAccessTrustProviderIds = builder.verifiedAccessTrustProviderIds;
            this.verifiedAccessTrustProviders = builder.verifiedAccessTrustProviders;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getFipsEnabled() {
            return this.fipsEnabled;
        }

        @Override
        public final java.lang.Object getLoggingConfigurations() {
            return this.loggingConfigurations;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getVerifiedAccessTrustProviderIds() {
            return this.verifiedAccessTrustProviderIds;
        }

        @Override
        public final java.lang.Object getVerifiedAccessTrustProviders() {
            return this.verifiedAccessTrustProviders;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFipsEnabled() != null) {
                data.set("fipsEnabled", om.valueToTree(this.getFipsEnabled()));
            }
            if (this.getLoggingConfigurations() != null) {
                data.set("loggingConfigurations", om.valueToTree(this.getLoggingConfigurations()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVerifiedAccessTrustProviderIds() != null) {
                data.set("verifiedAccessTrustProviderIds", om.valueToTree(this.getVerifiedAccessTrustProviderIds()));
            }
            if (this.getVerifiedAccessTrustProviders() != null) {
                data.set("verifiedAccessTrustProviders", om.valueToTree(this.getVerifiedAccessTrustProviders()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVerifiedAccessInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVerifiedAccessInstanceProps.Jsii$Proxy that = (CfnVerifiedAccessInstanceProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.fipsEnabled != null ? !this.fipsEnabled.equals(that.fipsEnabled) : that.fipsEnabled != null) return false;
            if (this.loggingConfigurations != null ? !this.loggingConfigurations.equals(that.loggingConfigurations) : that.loggingConfigurations != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.verifiedAccessTrustProviderIds != null ? !this.verifiedAccessTrustProviderIds.equals(that.verifiedAccessTrustProviderIds) : that.verifiedAccessTrustProviderIds != null) return false;
            return this.verifiedAccessTrustProviders != null ? this.verifiedAccessTrustProviders.equals(that.verifiedAccessTrustProviders) : that.verifiedAccessTrustProviders == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.fipsEnabled != null ? this.fipsEnabled.hashCode() : 0);
            result = 31 * result + (this.loggingConfigurations != null ? this.loggingConfigurations.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.verifiedAccessTrustProviderIds != null ? this.verifiedAccessTrustProviderIds.hashCode() : 0);
            result = 31 * result + (this.verifiedAccessTrustProviders != null ? this.verifiedAccessTrustProviders.hashCode() : 0);
            return result;
        }
    }
}
