package software.amazon.awscdk.services.ecs;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * BaseLogDriverProps baseLogDriverProps = BaseLogDriverProps.builder()
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .labels(List.of("labels"))
 *         .tag("tag")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:18.191Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.BaseLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(BaseLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseLogDriverProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The env option takes an array of keys.
     * <p>
     * If there is collision between
     * label and env keys, the value of the env takes precedence. Adds additional fields
     * to the extra attributes of a logging message.
     * <p>
     * Default: - No env
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnv() {
        return null;
    }

    /**
     * The env-regex option is similar to and compatible with env.
     * <p>
     * Its value is a regular
     * expression to match logging-related environment variables. It is used for advanced
     * log tag options.
     * <p>
     * Default: - No envRegex
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvRegex() {
        return null;
    }

    /**
     * The labels option takes an array of keys.
     * <p>
     * If there is collision
     * between label and env keys, the value of the env takes precedence. Adds additional
     * fields to the extra attributes of a logging message.
     * <p>
     * Default: - No labels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLabels() {
        return null;
    }

    /**
     * By default, Docker uses the first 12 characters of the container ID to tag log messages.
     * <p>
     * Refer to the log tag option documentation for customizing the
     * log tag format.
     * <p>
     * Default: - The first 12 characters of the container ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTag() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseLogDriverProps> {
        java.util.List<java.lang.String> env;
        java.lang.String envRegex;
        java.util.List<java.lang.String> labels;
        java.lang.String tag;

        /**
         * Sets the value of {@link BaseLogDriverProps#getEnv}
         * @param env The env option takes an array of keys.
         *            If there is collision between
         *            label and env keys, the value of the env takes precedence. Adds additional fields
         *            to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.List<java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link BaseLogDriverProps#getEnvRegex}
         * @param envRegex The env-regex option is similar to and compatible with env.
         *                 Its value is a regular
         *                 expression to match logging-related environment variables. It is used for advanced
         *                 log tag options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(java.lang.String envRegex) {
            this.envRegex = envRegex;
            return this;
        }

        /**
         * Sets the value of {@link BaseLogDriverProps#getLabels}
         * @param labels The labels option takes an array of keys.
         *               If there is collision
         *               between label and env keys, the value of the env takes precedence. Adds additional
         *               fields to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.List<java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link BaseLogDriverProps#getTag}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages.
         *            Refer to the log tag option documentation for customizing the
         *            log tag format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseLogDriverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseLogDriverProps {
        private final java.util.List<java.lang.String> env;
        private final java.lang.String envRegex;
        private final java.util.List<java.lang.String> labels;
        private final java.lang.String tag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envRegex = software.amazon.jsii.Kernel.get(this, "envRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.env = builder.env;
            this.envRegex = builder.envRegex;
            this.labels = builder.labels;
            this.tag = builder.tag;
        }

        @Override
        public final java.util.List<java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getEnvRegex() {
            return this.envRegex;
        }

        @Override
        public final java.util.List<java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvRegex() != null) {
                data.set("envRegex", om.valueToTree(this.getEnvRegex()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.BaseLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseLogDriverProps.Jsii$Proxy that = (BaseLogDriverProps.Jsii$Proxy) o;

            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envRegex != null ? !this.envRegex.equals(that.envRegex) : that.envRegex != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.env != null ? this.env.hashCode() : 0;
            result = 31 * result + (this.envRegex != null ? this.envRegex.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            return result;
        }
    }
}
