package software.amazon.awscdk.services.ecs;

/**
 * The properties for an image hosted in a public or private repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Secret secret;
 * RepositoryImageProps repositoryImageProps = RepositoryImageProps.builder()
 *         .credentials(secret)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:18.438Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.RepositoryImageProps")
@software.amazon.jsii.Jsii.Proxy(RepositoryImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RepositoryImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The secret to expose to the container that contains the credentials for the image repository.
     * <p>
     * The supported value is the full ARN of an AWS Secrets Manager secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getCredentials() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RepositoryImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RepositoryImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RepositoryImageProps> {
        software.amazon.awscdk.services.secretsmanager.ISecret credentials;

        /**
         * Sets the value of {@link RepositoryImageProps#getCredentials}
         * @param credentials The secret to expose to the container that contains the credentials for the image repository.
         *                    The supported value is the full ARN of an AWS Secrets Manager secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.secretsmanager.ISecret credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RepositoryImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RepositoryImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RepositoryImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryImageProps {
        private final software.amazon.awscdk.services.secretsmanager.ISecret credentials;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.credentials = builder.credentials;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getCredentials() {
            return this.credentials;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.RepositoryImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RepositoryImageProps.Jsii$Proxy that = (RepositoryImageProps.Jsii$Proxy) o;

            return this.credentials != null ? this.credentials.equals(that.credentials) : that.credentials == null;
        }

        @Override
        public final int hashCode() {
            int result = this.credentials != null ? this.credentials.hashCode() : 0;
            return result;
        }
    }
}
