package software.amazon.awscdk.services.ecs;

/**
 * Represents a service-managed volume and always configured at launch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition = new FargateTaskDefinition(this, "TaskDef");
 * ContainerDefinition container = taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .portMappings(List.of(PortMapping.builder()
 *                 .containerPort(80)
 *                 .protocol(Protocol.TCP)
 *                 .build()))
 *         .build());
 * ServiceManagedVolume volume = ServiceManagedVolume.Builder.create(this, "EBSVolume")
 *         .name("ebs1")
 *         .managedEBSVolume(ServiceManagedEBSVolumeConfiguration.builder()
 *                 .size(Size.gibibytes(15))
 *                 .volumeType(EbsDeviceVolumeType.GP3)
 *                 .fileSystemType(FileSystemType.XFS)
 *                 .tagSpecifications(List.of(EBSTagSpecification.builder()
 *                         .tags(Map.of(
 *                                 "purpose", "production"))
 *                         .propagateTags(EbsPropagatedTagSource.SERVICE)
 *                         .build()))
 *                 .build())
 *         .build();
 * volume.mountIn(container, ContainerMountPoint.builder()
 *         .containerPath("/var/lib")
 *         .readOnly(false)
 *         .build());
 * taskDefinition.addVolume(volume);
 * FargateService service = FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .build();
 * service.addVolume(volume);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:18.462Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ServiceManagedVolume")
public class ServiceManagedVolume extends software.constructs.Construct {

    protected ServiceManagedVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceManagedVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServiceManagedVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ServiceManagedVolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Mounts the service managed volume to a specified container at a defined mount point.
     * <p>
     * @param container The container to mount the volume on. This parameter is required.
     * @param mountPoint The mounting point details within the container. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mountIn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition container, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerMountPoint mountPoint) {
        software.amazon.jsii.Kernel.call(this, "mountIn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(container, "container is required"), java.util.Objects.requireNonNull(mountPoint, "mountPoint is required") });
    }

    /**
     * configuredAtLaunch indicates volume at launch time, referenced by taskdefinition volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getConfiguredAtLaunch() {
        return software.amazon.jsii.Kernel.get(this, "configuredAtLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Name of the volume, referenced by taskdefintion and mount point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An IAM role that allows ECS to make calls to EBS APIs.
     * <p>
     * If not provided, a new role with appropriate permissions will be created by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Volume configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ServiceManagedEBSVolumeConfiguration getConfig() {
        return software.amazon.jsii.Kernel.get(this, "config", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ServiceManagedEBSVolumeConfiguration.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.ServiceManagedVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.ServiceManagedVolume> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.ServiceManagedVolumeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.ServiceManagedVolumeProps.Builder();
        }

        /**
         * The name of the volume.
         * <p>
         * This corresponds to the name provided in the ECS TaskDefinition.
         * <p>
         * @return {@code this}
         * @param name The name of the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Configuration for an Amazon Elastic Block Store (EBS) volume managed by ECS.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param managedEbsVolume Configuration for an Amazon Elastic Block Store (EBS) volume managed by ECS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedEbsVolume(final software.amazon.awscdk.services.ecs.ServiceManagedEBSVolumeConfiguration managedEbsVolume) {
            this.props.managedEbsVolume(managedEbsVolume);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.ServiceManagedVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.ServiceManagedVolume build() {
            return new software.amazon.awscdk.services.ecs.ServiceManagedVolume(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
