package software.amazon.awscdk.services.eks;

/**
 * Represents the properties required to create an Amazon EKS access entry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AccessPolicy accessPolicy;
 * Cluster cluster;
 * AccessEntryProps accessEntryProps = AccessEntryProps.builder()
 *         .accessPolicies(List.of(accessPolicy))
 *         .cluster(cluster)
 *         .principal("principal")
 *         // the properties below are optional
 *         .accessEntryName("accessEntryName")
 *         .accessEntryType(AccessEntryType.STANDARD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:18.665Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessEntryProps")
@software.amazon.jsii.Jsii.Proxy(AccessEntryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessEntryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The access policies that define the permissions and scope for the access entry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy> getAccessPolicies();

    /**
     * The Amazon EKS cluster to which the access entry applies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * The Amazon Resource Name (ARN) of the principal (user or role) to associate the access entry with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

    /**
     * The name of the AccessEntry.
     * <p>
     * Default: - No access entry name is provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessEntryName() {
        return null;
    }

    /**
     * The type of the AccessEntry.
     * <p>
     * Default: STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.AccessEntryType getAccessEntryType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AccessEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessEntryProps> {
        java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy> accessPolicies;
        software.amazon.awscdk.services.eks.ICluster cluster;
        java.lang.String principal;
        java.lang.String accessEntryName;
        software.amazon.awscdk.services.eks.AccessEntryType accessEntryType;

        /**
         * Sets the value of {@link AccessEntryProps#getAccessPolicies}
         * @param accessPolicies The access policies that define the permissions and scope for the access entry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder accessPolicies(java.util.List<? extends software.amazon.awscdk.services.eks.IAccessPolicy> accessPolicies) {
            this.accessPolicies = (java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy>)accessPolicies;
            return this;
        }

        /**
         * Sets the value of {@link AccessEntryProps#getCluster}
         * @param cluster The Amazon EKS cluster to which the access entry applies. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link AccessEntryProps#getPrincipal}
         * @param principal The Amazon Resource Name (ARN) of the principal (user or role) to associate the access entry with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link AccessEntryProps#getAccessEntryName}
         * @param accessEntryName The name of the AccessEntry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEntryName(java.lang.String accessEntryName) {
            this.accessEntryName = accessEntryName;
            return this;
        }

        /**
         * Sets the value of {@link AccessEntryProps#getAccessEntryType}
         * @param accessEntryType The type of the AccessEntry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEntryType(software.amazon.awscdk.services.eks.AccessEntryType accessEntryType) {
            this.accessEntryType = accessEntryType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessEntryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessEntryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessEntryProps {
        private final java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy> accessPolicies;
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final java.lang.String principal;
        private final java.lang.String accessEntryName;
        private final software.amazon.awscdk.services.eks.AccessEntryType accessEntryType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPolicies = software.amazon.jsii.Kernel.get(this, "accessPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IAccessPolicy.class)));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessEntryName = software.amazon.jsii.Kernel.get(this, "accessEntryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessEntryType = software.amazon.jsii.Kernel.get(this, "accessEntryType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessEntryType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPolicies = (java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy>)java.util.Objects.requireNonNull(builder.accessPolicies, "accessPolicies is required");
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.accessEntryName = builder.accessEntryName;
            this.accessEntryType = builder.accessEntryType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eks.IAccessPolicy> getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getAccessEntryName() {
            return this.accessEntryName;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AccessEntryType getAccessEntryType() {
            return this.accessEntryType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessPolicies", om.valueToTree(this.getAccessPolicies()));
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getAccessEntryName() != null) {
                data.set("accessEntryName", om.valueToTree(this.getAccessEntryName()));
            }
            if (this.getAccessEntryType() != null) {
                data.set("accessEntryType", om.valueToTree(this.getAccessEntryType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AccessEntryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessEntryProps.Jsii$Proxy that = (AccessEntryProps.Jsii$Proxy) o;

            if (!accessPolicies.equals(that.accessPolicies)) return false;
            if (!cluster.equals(that.cluster)) return false;
            if (!principal.equals(that.principal)) return false;
            if (this.accessEntryName != null ? !this.accessEntryName.equals(that.accessEntryName) : that.accessEntryName != null) return false;
            return this.accessEntryType != null ? this.accessEntryType.equals(that.accessEntryType) : that.accessEntryType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessPolicies.hashCode();
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.principal.hashCode());
            result = 31 * result + (this.accessEntryName != null ? this.accessEntryName.hashCode() : 0);
            result = 31 * result + (this.accessEntryType != null ? this.accessEntryType.hashCode() : 0);
            return result;
        }
    }
}
