package software.amazon.awscdk.services.eks;

/**
 * Enum representing the different identity types that can be used for a Kubernetes service account.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ServiceAccount.Builder.create(this, "ServiceAccount")
 *         .cluster(cluster)
 *         .name("test-sa")
 *         .namespace("default")
 *         .identityType(IdentityType.POD_IDENTITY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:18.774Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.IdentityType")
public enum IdentityType {
    /**
     * Use the IAM Roles for Service Accounts (IRSA) identity type.
     * <p>
     * IRSA allows you to associate an IAM role with a Kubernetes service account.
     * This provides a way to grant permissions to Kubernetes pods by associating an IAM role with a Kubernetes service account.
     * The IAM role can then be used to provide AWS credentials to the pods, allowing them to access other AWS resources.
     * <p>
     * When enabled, the openIdConnectProvider of the cluster would be created when you create the ServiceAccount.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts.html">https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IRSA,
    /**
     * Use the EKS Pod Identities identity type.
     * <p>
     * EKS Pod Identities provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles
     * provide credentials to Amazon EC2 instances. Instead of creating and distributing your AWS credentials to the containers or using the
     * Amazon EC2 instance's role, you associate an IAM role with a Kubernetes service account and configure your Pods to use the service account.
     * <p>
     * When enabled, the Pod Identity Agent AddOn of the cluster would be created when you create the ServiceAccount.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-identities.html">https://docs.aws.amazon.com/eks/latest/userguide/pod-identities.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POD_IDENTITY,
}
