package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Load Balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
 * AutoScalingGroup asg;
 * Vpc vpc;
 * // Create the load balancer in a VPC. 'internetFacing' is 'false'
 * // by default, which creates an internal load balancer.
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * // Add a listener and open up the load balancer's security group
 * // to the world.
 * ApplicationListener listener = lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(80)
 *         // 'open: true' is the default, you can leave it out if you want. Set it
 *         // to 'false' and use `listener.connections` if you want to be selective
 *         // about who can access the load balancer.
 *         .open(true)
 *         .build());
 * // Create an AutoScaling group and add it as a load balancing
 * // target to the listener.
 * listener.addTargets("ApplicationFleet", AddApplicationTargetsProps.builder()
 *         .port(8080)
 *         .targets(List.of(asg))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:18.938Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {

    /**
     * The client keep alive duration.
     * <p>
     * The valid range is 60 to 604800 seconds (1 minute to 7 days).
     * <p>
     * Default: - Duration.seconds(3600)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getClientKeepAlive() {
        return null;
    }

    /**
     * Determines how the load balancer handles requests that might pose a security risk to your application.
     * <p>
     * Default: DesyncMitigationMode.DEFENSIVE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode getDesyncMitigationMode() {
        return null;
    }

    /**
     * Indicates whether HTTP headers with invalid header fields are removed by the load balancer (true) or routed to targets (false).
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDropInvalidHeaderFields() {
        return null;
    }

    /**
     * Indicates whether HTTP/2 is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHttp2Enabled() {
        return null;
    }

    /**
     * The load balancer idle timeout, in seconds.
     * <p>
     * Default: 60
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getIdleTimeout() {
        return null;
    }

    /**
     * The type of IP addresses to use.
     * <p>
     * Default: IpAddressType.IPV4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
        return null;
    }

    /**
     * Indicates whether the Application Load Balancer should preserve the host header in the HTTP request and send it to the target without any change.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveHostHeader() {
        return null;
    }

    /**
     * Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveXffClientPort() {
        return null;
    }

    /**
     * Security group to associate with this load balancer.
     * <p>
     * Default: A security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWafFailOpen() {
        return null;
    }

    /**
     * Indicates whether the two headers (x-amzn-tls-version and x-amzn-tls-cipher-suite), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target.
     * <p>
     * The x-amzn-tls-version header has information about the TLS protocol version negotiated with the client,
     * and the x-amzn-tls-cipher-suite header has information about the cipher suite negotiated with the client.
     * <p>
     * Both headers are in OpenSSL format.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getXAmznTlsVersionAndCipherSuiteHeaders() {
        return null;
    }

    /**
     * Enables you to modify, preserve, or remove the X-Forwarded-For header in the HTTP request before the Application Load Balancer sends the request to the target.
     * <p>
     * Default: XffHeaderProcessingMode.APPEND
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode getXffHeaderProcessingMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationLoadBalancerProps> {
        software.amazon.awscdk.Duration clientKeepAlive;
        software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode desyncMitigationMode;
        java.lang.Boolean dropInvalidHeaderFields;
        java.lang.Boolean http2Enabled;
        software.amazon.awscdk.Duration idleTimeout;
        software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType;
        java.lang.Boolean preserveHostHeader;
        java.lang.Boolean preserveXffClientPort;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.Boolean wafFailOpen;
        java.lang.Boolean xAmznTlsVersionAndCipherSuiteHeaders;
        software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode xffHeaderProcessingMode;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean crossZoneEnabled;
        java.lang.Boolean deletionProtection;
        java.lang.Boolean denyAllIgwTraffic;
        java.lang.Boolean internetFacing;
        java.lang.String loadBalancerName;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getClientKeepAlive}
         * @param clientKeepAlive The client keep alive duration.
         *                        The valid range is 60 to 604800 seconds (1 minute to 7 days).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientKeepAlive(software.amazon.awscdk.Duration clientKeepAlive) {
            this.clientKeepAlive = clientKeepAlive;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDesyncMitigationMode}
         * @param desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to your application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desyncMitigationMode(software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode desyncMitigationMode) {
            this.desyncMitigationMode = desyncMitigationMode;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDropInvalidHeaderFields}
         * @param dropInvalidHeaderFields Indicates whether HTTP headers with invalid header fields are removed by the load balancer (true) or routed to targets (false).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dropInvalidHeaderFields(java.lang.Boolean dropInvalidHeaderFields) {
            this.dropInvalidHeaderFields = dropInvalidHeaderFields;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getHttp2Enabled}
         * @param http2Enabled Indicates whether HTTP/2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2Enabled(java.lang.Boolean http2Enabled) {
            this.http2Enabled = http2Enabled;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getIdleTimeout}
         * @param idleTimeout The load balancer idle timeout, in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(software.amazon.awscdk.Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getIpAddressType}
         * @param ipAddressType The type of IP addresses to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getPreserveHostHeader}
         * @param preserveHostHeader Indicates whether the Application Load Balancer should preserve the host header in the HTTP request and send it to the target without any change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveHostHeader(java.lang.Boolean preserveHostHeader) {
            this.preserveHostHeader = preserveHostHeader;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getPreserveXffClientPort}
         * @param preserveXffClientPort Indicates whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveXffClientPort(java.lang.Boolean preserveXffClientPort) {
            this.preserveXffClientPort = preserveXffClientPort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getSecurityGroup}
         * @param securityGroup Security group to associate with this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getWafFailOpen}
         * @param wafFailOpen Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wafFailOpen(java.lang.Boolean wafFailOpen) {
            this.wafFailOpen = wafFailOpen;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getXAmznTlsVersionAndCipherSuiteHeaders}
         * @param xAmznTlsVersionAndCipherSuiteHeaders Indicates whether the two headers (x-amzn-tls-version and x-amzn-tls-cipher-suite), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target.
         *                                             The x-amzn-tls-version header has information about the TLS protocol version negotiated with the client,
         *                                             and the x-amzn-tls-cipher-suite header has information about the cipher suite negotiated with the client.
         *                                             <p>
         *                                             Both headers are in OpenSSL format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xAmznTlsVersionAndCipherSuiteHeaders(java.lang.Boolean xAmznTlsVersionAndCipherSuiteHeaders) {
            this.xAmznTlsVersionAndCipherSuiteHeaders = xAmznTlsVersionAndCipherSuiteHeaders;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getXffHeaderProcessingMode}
         * @param xffHeaderProcessingMode Enables you to modify, preserve, or remove the X-Forwarded-For header in the HTTP request before the Application Load Balancer sends the request to the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xffHeaderProcessingMode(software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode xffHeaderProcessingMode) {
            this.xffHeaderProcessingMode = xffHeaderProcessingMode;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getVpc}
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getCrossZoneEnabled}
         * @param crossZoneEnabled Indicates whether cross-zone load balancing is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZoneEnabled(java.lang.Boolean crossZoneEnabled) {
            this.crossZoneEnabled = crossZoneEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDeletionProtection}
         * @param deletionProtection Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDenyAllIgwTraffic}
         * @param denyAllIgwTraffic Indicates whether the load balancer blocks traffic through the Internet Gateway (IGW).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder denyAllIgwTraffic(java.lang.Boolean denyAllIgwTraffic) {
            this.denyAllIgwTraffic = denyAllIgwTraffic;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getInternetFacing}
         * @param internetFacing Whether the load balancer has an internet-routable address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(java.lang.Boolean internetFacing) {
            this.internetFacing = internetFacing;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getLoadBalancerName}
         * @param loadBalancerName Name of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getVpcSubnets}
         * @param vpcSubnets Which subnets place the load balancer in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationLoadBalancerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerProps {
        private final software.amazon.awscdk.Duration clientKeepAlive;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode desyncMitigationMode;
        private final java.lang.Boolean dropInvalidHeaderFields;
        private final java.lang.Boolean http2Enabled;
        private final software.amazon.awscdk.Duration idleTimeout;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType;
        private final java.lang.Boolean preserveHostHeader;
        private final java.lang.Boolean preserveXffClientPort;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Boolean wafFailOpen;
        private final java.lang.Boolean xAmznTlsVersionAndCipherSuiteHeaders;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode xffHeaderProcessingMode;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean crossZoneEnabled;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.Boolean denyAllIgwTraffic;
        private final java.lang.Boolean internetFacing;
        private final java.lang.String loadBalancerName;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientKeepAlive = software.amazon.jsii.Kernel.get(this, "clientKeepAlive", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.desyncMitigationMode = software.amazon.jsii.Kernel.get(this, "desyncMitigationMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode.class));
            this.dropInvalidHeaderFields = software.amazon.jsii.Kernel.get(this, "dropInvalidHeaderFields", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.http2Enabled = software.amazon.jsii.Kernel.get(this, "http2Enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.idleTimeout = software.amazon.jsii.Kernel.get(this, "idleTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class));
            this.preserveHostHeader = software.amazon.jsii.Kernel.get(this, "preserveHostHeader", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.preserveXffClientPort = software.amazon.jsii.Kernel.get(this, "preserveXffClientPort", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.wafFailOpen = software.amazon.jsii.Kernel.get(this, "wafFailOpen", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.xAmznTlsVersionAndCipherSuiteHeaders = software.amazon.jsii.Kernel.get(this, "xAmznTlsVersionAndCipherSuiteHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.xffHeaderProcessingMode = software.amazon.jsii.Kernel.get(this, "xffHeaderProcessingMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.crossZoneEnabled = software.amazon.jsii.Kernel.get(this, "crossZoneEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.denyAllIgwTraffic = software.amazon.jsii.Kernel.get(this, "denyAllIgwTraffic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.internetFacing = software.amazon.jsii.Kernel.get(this, "internetFacing", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientKeepAlive = builder.clientKeepAlive;
            this.desyncMitigationMode = builder.desyncMitigationMode;
            this.dropInvalidHeaderFields = builder.dropInvalidHeaderFields;
            this.http2Enabled = builder.http2Enabled;
            this.idleTimeout = builder.idleTimeout;
            this.ipAddressType = builder.ipAddressType;
            this.preserveHostHeader = builder.preserveHostHeader;
            this.preserveXffClientPort = builder.preserveXffClientPort;
            this.securityGroup = builder.securityGroup;
            this.wafFailOpen = builder.wafFailOpen;
            this.xAmznTlsVersionAndCipherSuiteHeaders = builder.xAmznTlsVersionAndCipherSuiteHeaders;
            this.xffHeaderProcessingMode = builder.xffHeaderProcessingMode;
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.crossZoneEnabled = builder.crossZoneEnabled;
            this.deletionProtection = builder.deletionProtection;
            this.denyAllIgwTraffic = builder.denyAllIgwTraffic;
            this.internetFacing = builder.internetFacing;
            this.loadBalancerName = builder.loadBalancerName;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.Duration getClientKeepAlive() {
            return this.clientKeepAlive;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.DesyncMitigationMode getDesyncMitigationMode() {
            return this.desyncMitigationMode;
        }

        @Override
        public final java.lang.Boolean getDropInvalidHeaderFields() {
            return this.dropInvalidHeaderFields;
        }

        @Override
        public final java.lang.Boolean getHttp2Enabled() {
            return this.http2Enabled;
        }

        @Override
        public final software.amazon.awscdk.Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Boolean getPreserveHostHeader() {
            return this.preserveHostHeader;
        }

        @Override
        public final java.lang.Boolean getPreserveXffClientPort() {
            return this.preserveXffClientPort;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.Boolean getWafFailOpen() {
            return this.wafFailOpen;
        }

        @Override
        public final java.lang.Boolean getXAmznTlsVersionAndCipherSuiteHeaders() {
            return this.xAmznTlsVersionAndCipherSuiteHeaders;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.XffHeaderProcessingMode getXffHeaderProcessingMode() {
            return this.xffHeaderProcessingMode;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getCrossZoneEnabled() {
            return this.crossZoneEnabled;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.Boolean getDenyAllIgwTraffic() {
            return this.denyAllIgwTraffic;
        }

        @Override
        public final java.lang.Boolean getInternetFacing() {
            return this.internetFacing;
        }

        @Override
        public final java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClientKeepAlive() != null) {
                data.set("clientKeepAlive", om.valueToTree(this.getClientKeepAlive()));
            }
            if (this.getDesyncMitigationMode() != null) {
                data.set("desyncMitigationMode", om.valueToTree(this.getDesyncMitigationMode()));
            }
            if (this.getDropInvalidHeaderFields() != null) {
                data.set("dropInvalidHeaderFields", om.valueToTree(this.getDropInvalidHeaderFields()));
            }
            if (this.getHttp2Enabled() != null) {
                data.set("http2Enabled", om.valueToTree(this.getHttp2Enabled()));
            }
            if (this.getIdleTimeout() != null) {
                data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getPreserveHostHeader() != null) {
                data.set("preserveHostHeader", om.valueToTree(this.getPreserveHostHeader()));
            }
            if (this.getPreserveXffClientPort() != null) {
                data.set("preserveXffClientPort", om.valueToTree(this.getPreserveXffClientPort()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getWafFailOpen() != null) {
                data.set("wafFailOpen", om.valueToTree(this.getWafFailOpen()));
            }
            if (this.getXAmznTlsVersionAndCipherSuiteHeaders() != null) {
                data.set("xAmznTlsVersionAndCipherSuiteHeaders", om.valueToTree(this.getXAmznTlsVersionAndCipherSuiteHeaders()));
            }
            if (this.getXffHeaderProcessingMode() != null) {
                data.set("xffHeaderProcessingMode", om.valueToTree(this.getXffHeaderProcessingMode()));
            }
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getCrossZoneEnabled() != null) {
                data.set("crossZoneEnabled", om.valueToTree(this.getCrossZoneEnabled()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getDenyAllIgwTraffic() != null) {
                data.set("denyAllIgwTraffic", om.valueToTree(this.getDenyAllIgwTraffic()));
            }
            if (this.getInternetFacing() != null) {
                data.set("internetFacing", om.valueToTree(this.getInternetFacing()));
            }
            if (this.getLoadBalancerName() != null) {
                data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerProps.Jsii$Proxy that = (ApplicationLoadBalancerProps.Jsii$Proxy) o;

            if (this.clientKeepAlive != null ? !this.clientKeepAlive.equals(that.clientKeepAlive) : that.clientKeepAlive != null) return false;
            if (this.desyncMitigationMode != null ? !this.desyncMitigationMode.equals(that.desyncMitigationMode) : that.desyncMitigationMode != null) return false;
            if (this.dropInvalidHeaderFields != null ? !this.dropInvalidHeaderFields.equals(that.dropInvalidHeaderFields) : that.dropInvalidHeaderFields != null) return false;
            if (this.http2Enabled != null ? !this.http2Enabled.equals(that.http2Enabled) : that.http2Enabled != null) return false;
            if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.preserveHostHeader != null ? !this.preserveHostHeader.equals(that.preserveHostHeader) : that.preserveHostHeader != null) return false;
            if (this.preserveXffClientPort != null ? !this.preserveXffClientPort.equals(that.preserveXffClientPort) : that.preserveXffClientPort != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.wafFailOpen != null ? !this.wafFailOpen.equals(that.wafFailOpen) : that.wafFailOpen != null) return false;
            if (this.xAmznTlsVersionAndCipherSuiteHeaders != null ? !this.xAmznTlsVersionAndCipherSuiteHeaders.equals(that.xAmznTlsVersionAndCipherSuiteHeaders) : that.xAmznTlsVersionAndCipherSuiteHeaders != null) return false;
            if (this.xffHeaderProcessingMode != null ? !this.xffHeaderProcessingMode.equals(that.xffHeaderProcessingMode) : that.xffHeaderProcessingMode != null) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.crossZoneEnabled != null ? !this.crossZoneEnabled.equals(that.crossZoneEnabled) : that.crossZoneEnabled != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.denyAllIgwTraffic != null ? !this.denyAllIgwTraffic.equals(that.denyAllIgwTraffic) : that.denyAllIgwTraffic != null) return false;
            if (this.internetFacing != null ? !this.internetFacing.equals(that.internetFacing) : that.internetFacing != null) return false;
            if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientKeepAlive != null ? this.clientKeepAlive.hashCode() : 0;
            result = 31 * result + (this.desyncMitigationMode != null ? this.desyncMitigationMode.hashCode() : 0);
            result = 31 * result + (this.dropInvalidHeaderFields != null ? this.dropInvalidHeaderFields.hashCode() : 0);
            result = 31 * result + (this.http2Enabled != null ? this.http2Enabled.hashCode() : 0);
            result = 31 * result + (this.idleTimeout != null ? this.idleTimeout.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.preserveHostHeader != null ? this.preserveHostHeader.hashCode() : 0);
            result = 31 * result + (this.preserveXffClientPort != null ? this.preserveXffClientPort.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.wafFailOpen != null ? this.wafFailOpen.hashCode() : 0);
            result = 31 * result + (this.xAmznTlsVersionAndCipherSuiteHeaders != null ? this.xAmznTlsVersionAndCipherSuiteHeaders.hashCode() : 0);
            result = 31 * result + (this.xffHeaderProcessingMode != null ? this.xffHeaderProcessingMode.hashCode() : 0);
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.crossZoneEnabled != null ? this.crossZoneEnabled.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.denyAllIgwTraffic != null ? this.denyAllIgwTraffic.hashCode() : 0);
            result = 31 * result + (this.internetFacing != null ? this.internetFacing.hashCode() : 0);
            result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
