package software.amazon.awscdk.services.evidently;

/**
 * Creates or updates an Evidently <em>experiment</em> .
 * <p>
 * Before you create an experiment, you must create the feature to use for the experiment.
 * <p>
 * An experiment helps you make feature design decisions based on evidence and data. An experiment can test as many as five variations at once. Evidently collects experiment data and analyzes it by statistical methods, and provides clear recommendations about which variations perform better.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnExperiment cfnExperiment = CfnExperiment.Builder.create(this, "MyCfnExperiment")
 *         .metricGoals(List.of(MetricGoalObjectProperty.builder()
 *                 .desiredChange("desiredChange")
 *                 .entityIdKey("entityIdKey")
 *                 .metricName("metricName")
 *                 .valueKey("valueKey")
 *                 // the properties below are optional
 *                 .eventPattern("eventPattern")
 *                 .unitLabel("unitLabel")
 *                 .build()))
 *         .name("name")
 *         .onlineAbConfig(OnlineAbConfigObjectProperty.builder()
 *                 .controlTreatmentName("controlTreatmentName")
 *                 .treatmentWeights(List.of(TreatmentToWeightProperty.builder()
 *                         .splitWeight(123)
 *                         .treatment("treatment")
 *                         .build()))
 *                 .build())
 *         .project("project")
 *         .treatments(List.of(TreatmentObjectProperty.builder()
 *                 .feature("feature")
 *                 .treatmentName("treatmentName")
 *                 .variation("variation")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .randomizationSalt("randomizationSalt")
 *         .removeSegment(false)
 *         .runningStatus(RunningStatusObjectProperty.builder()
 *                 .status("status")
 *                 // the properties below are optional
 *                 .analysisCompleteTime("analysisCompleteTime")
 *                 .desiredState("desiredState")
 *                 .reason("reason")
 *                 .build())
 *         .samplingRate(123)
 *         .segment("segment")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:19.410Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperiment")
public class CfnExperiment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnExperiment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnExperiment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.evidently.CfnExperiment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnExperiment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evidently.CfnExperimentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the experiment.
     * <p>
     * For example, <code>arn:aws:evidently:us-west-2:0123455678912:project/myProject/experiment/myExperiment</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMetricGoals() {
        return software.amazon.jsii.Kernel.get(this, "metricGoals", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricGoals(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricGoals", java.util.Objects.requireNonNull(value, "metricGoals is required"));
    }

    /**
     * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricGoals(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.evidently.CfnExperiment.MetricGoalObjectProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.evidently.CfnExperiment.MetricGoalObjectProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "metricGoals", java.util.Objects.requireNonNull(value, "metricGoals is required"));
    }

    /**
     * A name for the new experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the new experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A structure that contains the configuration of which variation to use as the "control" version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOnlineAbConfig() {
        return software.amazon.jsii.Kernel.get(this, "onlineAbConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the configuration of which variation to use as the "control" version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnlineAbConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onlineAbConfig", java.util.Objects.requireNonNull(value, "onlineAbConfig is required"));
    }

    /**
     * A structure that contains the configuration of which variation to use as the "control" version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnlineAbConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evidently.CfnExperiment.OnlineAbConfigObjectProperty value) {
        software.amazon.jsii.Kernel.set(this, "onlineAbConfig", java.util.Objects.requireNonNull(value, "onlineAbConfig is required"));
    }

    /**
     * The name or the ARN of the project where this experiment is to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProject() {
        return software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or the ARN of the project where this experiment is to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProject(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "project", java.util.Objects.requireNonNull(value, "project is required"));
    }

    /**
     * An array of structures that describe the configuration of each feature variation used in the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTreatments() {
        return software.amazon.jsii.Kernel.get(this, "treatments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of structures that describe the configuration of each feature variation used in the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTreatments(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "treatments", java.util.Objects.requireNonNull(value, "treatments is required"));
    }

    /**
     * An array of structures that describe the configuration of each feature variation used in the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTreatments(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.evidently.CfnExperiment.TreatmentObjectProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.evidently.CfnExperiment.TreatmentObjectProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "treatments", java.util.Objects.requireNonNull(value, "treatments is required"));
    }

    /**
     * An optional description of the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description of the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRandomizationSalt() {
        return software.amazon.jsii.Kernel.get(this, "randomizationSalt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRandomizationSalt(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "randomizationSalt", value);
    }

    /**
     * Set this to <code>true</code> to remove the segment that is associated with this experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRemoveSegment() {
        return software.amazon.jsii.Kernel.get(this, "removeSegment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Set this to <code>true</code> to remove the segment that is associated with this experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveSegment(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "removeSegment", value);
    }

    /**
     * Set this to <code>true</code> to remove the segment that is associated with this experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveSegment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "removeSegment", value);
    }

    /**
     * A structure that you can use to start and stop the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRunningStatus() {
        return software.amazon.jsii.Kernel.get(this, "runningStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that you can use to start and stop the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunningStatus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runningStatus", value);
    }

    /**
     * A structure that you can use to start and stop the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunningStatus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.evidently.CfnExperiment.RunningStatusObjectProperty value) {
        software.amazon.jsii.Kernel.set(this, "runningStatus", value);
    }

    /**
     * The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSamplingRate() {
        return software.amazon.jsii.Kernel.get(this, "samplingRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamplingRate(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "samplingRate", value);
    }

    /**
     * Specifies an audience <em>segment</em> to use in the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSegment() {
        return software.amazon.jsii.Kernel.get(this, "segment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies an audience <em>segment</em> to use in the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegment(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "segment", value);
    }

    /**
     * Assigns one or more tags (key-value pairs) to the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Assigns one or more tags (key-value pairs) to the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Use this structure to tell Evidently whether higher or lower values are desired for a metric that is used in an experiment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * MetricGoalObjectProperty metricGoalObjectProperty = MetricGoalObjectProperty.builder()
     *         .desiredChange("desiredChange")
     *         .entityIdKey("entityIdKey")
     *         .metricName("metricName")
     *         .valueKey("valueKey")
     *         // the properties below are optional
     *         .eventPattern("eventPattern")
     *         .unitLabel("unitLabel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperiment.MetricGoalObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricGoalObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricGoalObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.
         * <p>
         * <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-desiredchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-desiredchange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDesiredChange();

        /**
         * The entity, such as a user or session, that does an action that causes a metric value to be recorded.
         * <p>
         * An example is <code>userDetails.userID</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-entityidkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-entityidkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityIdKey();

        /**
         * A name for the metric.
         * <p>
         * It can include up to 255 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The JSON path to reference the numerical metric value in the event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-valuekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-valuekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueKey();

        /**
         * The EventBridge event pattern that defines how the metric is recorded.
         * <p>
         * For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-eventpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-eventpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventPattern() {
            return null;
        }

        /**
         * A label for the units that the metric is measuring.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-unitlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-metricgoalobject.html#cfn-evidently-experiment-metricgoalobject-unitlabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnitLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricGoalObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricGoalObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricGoalObjectProperty> {
            java.lang.String desiredChange;
            java.lang.String entityIdKey;
            java.lang.String metricName;
            java.lang.String valueKey;
            java.lang.String eventPattern;
            java.lang.String unitLabel;

            /**
             * Sets the value of {@link MetricGoalObjectProperty#getDesiredChange}
             * @param desiredChange <code>INCREASE</code> means that a variation with a higher number for this metric is performing better. This parameter is required.
             *                      <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredChange(java.lang.String desiredChange) {
                this.desiredChange = desiredChange;
                return this;
            }

            /**
             * Sets the value of {@link MetricGoalObjectProperty#getEntityIdKey}
             * @param entityIdKey The entity, such as a user or session, that does an action that causes a metric value to be recorded. This parameter is required.
             *                    An example is <code>userDetails.userID</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityIdKey(java.lang.String entityIdKey) {
                this.entityIdKey = entityIdKey;
                return this;
            }

            /**
             * Sets the value of {@link MetricGoalObjectProperty#getMetricName}
             * @param metricName A name for the metric. This parameter is required.
             *                   It can include up to 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricGoalObjectProperty#getValueKey}
             * @param valueKey The JSON path to reference the numerical metric value in the event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueKey(java.lang.String valueKey) {
                this.valueKey = valueKey;
                return this;
            }

            /**
             * Sets the value of {@link MetricGoalObjectProperty#getEventPattern}
             * @param eventPattern The EventBridge event pattern that defines how the metric is recorded.
             *                     For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventPattern(java.lang.String eventPattern) {
                this.eventPattern = eventPattern;
                return this;
            }

            /**
             * Sets the value of {@link MetricGoalObjectProperty#getUnitLabel}
             * @param unitLabel A label for the units that the metric is measuring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitLabel(java.lang.String unitLabel) {
                this.unitLabel = unitLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricGoalObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricGoalObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricGoalObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricGoalObjectProperty {
            private final java.lang.String desiredChange;
            private final java.lang.String entityIdKey;
            private final java.lang.String metricName;
            private final java.lang.String valueKey;
            private final java.lang.String eventPattern;
            private final java.lang.String unitLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.desiredChange = software.amazon.jsii.Kernel.get(this, "desiredChange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entityIdKey = software.amazon.jsii.Kernel.get(this, "entityIdKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueKey = software.amazon.jsii.Kernel.get(this, "valueKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unitLabel = software.amazon.jsii.Kernel.get(this, "unitLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.desiredChange = java.util.Objects.requireNonNull(builder.desiredChange, "desiredChange is required");
                this.entityIdKey = java.util.Objects.requireNonNull(builder.entityIdKey, "entityIdKey is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.valueKey = java.util.Objects.requireNonNull(builder.valueKey, "valueKey is required");
                this.eventPattern = builder.eventPattern;
                this.unitLabel = builder.unitLabel;
            }

            @Override
            public final java.lang.String getDesiredChange() {
                return this.desiredChange;
            }

            @Override
            public final java.lang.String getEntityIdKey() {
                return this.entityIdKey;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getValueKey() {
                return this.valueKey;
            }

            @Override
            public final java.lang.String getEventPattern() {
                return this.eventPattern;
            }

            @Override
            public final java.lang.String getUnitLabel() {
                return this.unitLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("desiredChange", om.valueToTree(this.getDesiredChange()));
                data.set("entityIdKey", om.valueToTree(this.getEntityIdKey()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("valueKey", om.valueToTree(this.getValueKey()));
                if (this.getEventPattern() != null) {
                    data.set("eventPattern", om.valueToTree(this.getEventPattern()));
                }
                if (this.getUnitLabel() != null) {
                    data.set("unitLabel", om.valueToTree(this.getUnitLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnExperiment.MetricGoalObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricGoalObjectProperty.Jsii$Proxy that = (MetricGoalObjectProperty.Jsii$Proxy) o;

                if (!desiredChange.equals(that.desiredChange)) return false;
                if (!entityIdKey.equals(that.entityIdKey)) return false;
                if (!metricName.equals(that.metricName)) return false;
                if (!valueKey.equals(that.valueKey)) return false;
                if (this.eventPattern != null ? !this.eventPattern.equals(that.eventPattern) : that.eventPattern != null) return false;
                return this.unitLabel != null ? this.unitLabel.equals(that.unitLabel) : that.unitLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.desiredChange.hashCode();
                result = 31 * result + (this.entityIdKey.hashCode());
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.valueKey.hashCode());
                result = 31 * result + (this.eventPattern != null ? this.eventPattern.hashCode() : 0);
                result = 31 * result + (this.unitLabel != null ? this.unitLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains the configuration of which variation to use as the "control" version.
     * <p>
     * The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * OnlineAbConfigObjectProperty onlineAbConfigObjectProperty = OnlineAbConfigObjectProperty.builder()
     *         .controlTreatmentName("controlTreatmentName")
     *         .treatmentWeights(List.of(TreatmentToWeightProperty.builder()
     *                 .splitWeight(123)
     *                 .treatment("treatment")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-onlineabconfigobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-onlineabconfigobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperiment.OnlineAbConfigObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(OnlineAbConfigObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnlineAbConfigObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the variation that is to be the default variation that the other variations are compared to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-onlineabconfigobject.html#cfn-evidently-experiment-onlineabconfigobject-controltreatmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-onlineabconfigobject.html#cfn-evidently-experiment-onlineabconfigobject-controltreatmentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getControlTreatmentName() {
            return null;
        }

        /**
         * A set of key-value pairs.
         * <p>
         * The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-onlineabconfigobject.html#cfn-evidently-experiment-onlineabconfigobject-treatmentweights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-onlineabconfigobject.html#cfn-evidently-experiment-onlineabconfigobject-treatmentweights</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTreatmentWeights() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnlineAbConfigObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnlineAbConfigObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnlineAbConfigObjectProperty> {
            java.lang.String controlTreatmentName;
            java.lang.Object treatmentWeights;

            /**
             * Sets the value of {@link OnlineAbConfigObjectProperty#getControlTreatmentName}
             * @param controlTreatmentName The name of the variation that is to be the default variation that the other variations are compared to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder controlTreatmentName(java.lang.String controlTreatmentName) {
                this.controlTreatmentName = controlTreatmentName;
                return this;
            }

            /**
             * Sets the value of {@link OnlineAbConfigObjectProperty#getTreatmentWeights}
             * @param treatmentWeights A set of key-value pairs.
             *                         The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatmentWeights(software.amazon.awscdk.IResolvable treatmentWeights) {
                this.treatmentWeights = treatmentWeights;
                return this;
            }

            /**
             * Sets the value of {@link OnlineAbConfigObjectProperty#getTreatmentWeights}
             * @param treatmentWeights A set of key-value pairs.
             *                         The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatmentWeights(java.util.List<? extends java.lang.Object> treatmentWeights) {
                this.treatmentWeights = treatmentWeights;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnlineAbConfigObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnlineAbConfigObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnlineAbConfigObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnlineAbConfigObjectProperty {
            private final java.lang.String controlTreatmentName;
            private final java.lang.Object treatmentWeights;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.controlTreatmentName = software.amazon.jsii.Kernel.get(this, "controlTreatmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.treatmentWeights = software.amazon.jsii.Kernel.get(this, "treatmentWeights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.controlTreatmentName = builder.controlTreatmentName;
                this.treatmentWeights = builder.treatmentWeights;
            }

            @Override
            public final java.lang.String getControlTreatmentName() {
                return this.controlTreatmentName;
            }

            @Override
            public final java.lang.Object getTreatmentWeights() {
                return this.treatmentWeights;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getControlTreatmentName() != null) {
                    data.set("controlTreatmentName", om.valueToTree(this.getControlTreatmentName()));
                }
                if (this.getTreatmentWeights() != null) {
                    data.set("treatmentWeights", om.valueToTree(this.getTreatmentWeights()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnExperiment.OnlineAbConfigObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnlineAbConfigObjectProperty.Jsii$Proxy that = (OnlineAbConfigObjectProperty.Jsii$Proxy) o;

                if (this.controlTreatmentName != null ? !this.controlTreatmentName.equals(that.controlTreatmentName) : that.controlTreatmentName != null) return false;
                return this.treatmentWeights != null ? this.treatmentWeights.equals(that.treatmentWeights) : that.treatmentWeights == null;
            }

            @Override
            public final int hashCode() {
                int result = this.controlTreatmentName != null ? this.controlTreatmentName.hashCode() : 0;
                result = 31 * result + (this.treatmentWeights != null ? this.treatmentWeights.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this structure to start and stop the experiment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * RunningStatusObjectProperty runningStatusObjectProperty = RunningStatusObjectProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .analysisCompleteTime("analysisCompleteTime")
     *         .desiredState("desiredState")
     *         .reason("reason")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperiment.RunningStatusObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(RunningStatusObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunningStatusObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To start the experiment now, specify <code>START</code> for this parameter.
         * <p>
         * If this experiment is currently running and you want to stop it now, specify <code>STOP</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * If you are using AWS CloudFormation to start the experiment, use this field to specify when the experiment is to end.
         * <p>
         * The format is as a UNIX timestamp. For more information about this format, see <a href="https://docs.aws.amazon.com/https://www.unixtimestamp.com/index.php">The Current Epoch Unix Timestamp</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-analysiscompletetime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-analysiscompletetime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnalysisCompleteTime() {
            return null;
        }

        /**
         * If you are using AWS CloudFormation to stop this experiment, specify either <code>COMPLETED</code> or <code>CANCELLED</code> here to indicate how to classify this experiment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-desiredstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-desiredstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDesiredState() {
            return null;
        }

        /**
         * If you are using AWS CloudFormation to stop this experiment, this is an optional field that you can use to record why the experiment is being stopped or cancelled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-reason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-runningstatusobject.html#cfn-evidently-experiment-runningstatusobject-reason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReason() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RunningStatusObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunningStatusObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunningStatusObjectProperty> {
            java.lang.String status;
            java.lang.String analysisCompleteTime;
            java.lang.String desiredState;
            java.lang.String reason;

            /**
             * Sets the value of {@link RunningStatusObjectProperty#getStatus}
             * @param status To start the experiment now, specify <code>START</code> for this parameter. This parameter is required.
             *               If this experiment is currently running and you want to stop it now, specify <code>STOP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RunningStatusObjectProperty#getAnalysisCompleteTime}
             * @param analysisCompleteTime If you are using AWS CloudFormation to start the experiment, use this field to specify when the experiment is to end.
             *                             The format is as a UNIX timestamp. For more information about this format, see <a href="https://docs.aws.amazon.com/https://www.unixtimestamp.com/index.php">The Current Epoch Unix Timestamp</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder analysisCompleteTime(java.lang.String analysisCompleteTime) {
                this.analysisCompleteTime = analysisCompleteTime;
                return this;
            }

            /**
             * Sets the value of {@link RunningStatusObjectProperty#getDesiredState}
             * @param desiredState If you are using AWS CloudFormation to stop this experiment, specify either <code>COMPLETED</code> or <code>CANCELLED</code> here to indicate how to classify this experiment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredState(java.lang.String desiredState) {
                this.desiredState = desiredState;
                return this;
            }

            /**
             * Sets the value of {@link RunningStatusObjectProperty#getReason}
             * @param reason If you are using AWS CloudFormation to stop this experiment, this is an optional field that you can use to record why the experiment is being stopped or cancelled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reason(java.lang.String reason) {
                this.reason = reason;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunningStatusObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunningStatusObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunningStatusObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunningStatusObjectProperty {
            private final java.lang.String status;
            private final java.lang.String analysisCompleteTime;
            private final java.lang.String desiredState;
            private final java.lang.String reason;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.analysisCompleteTime = software.amazon.jsii.Kernel.get(this, "analysisCompleteTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.desiredState = software.amazon.jsii.Kernel.get(this, "desiredState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.analysisCompleteTime = builder.analysisCompleteTime;
                this.desiredState = builder.desiredState;
                this.reason = builder.reason;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getAnalysisCompleteTime() {
                return this.analysisCompleteTime;
            }

            @Override
            public final java.lang.String getDesiredState() {
                return this.desiredState;
            }

            @Override
            public final java.lang.String getReason() {
                return this.reason;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getAnalysisCompleteTime() != null) {
                    data.set("analysisCompleteTime", om.valueToTree(this.getAnalysisCompleteTime()));
                }
                if (this.getDesiredState() != null) {
                    data.set("desiredState", om.valueToTree(this.getDesiredState()));
                }
                if (this.getReason() != null) {
                    data.set("reason", om.valueToTree(this.getReason()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnExperiment.RunningStatusObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunningStatusObjectProperty.Jsii$Proxy that = (RunningStatusObjectProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.analysisCompleteTime != null ? !this.analysisCompleteTime.equals(that.analysisCompleteTime) : that.analysisCompleteTime != null) return false;
                if (this.desiredState != null ? !this.desiredState.equals(that.desiredState) : that.desiredState != null) return false;
                return this.reason != null ? this.reason.equals(that.reason) : that.reason == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.analysisCompleteTime != null ? this.analysisCompleteTime.hashCode() : 0);
                result = 31 * result + (this.desiredState != null ? this.desiredState.hashCode() : 0);
                result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that defines one treatment in an experiment.
     * <p>
     * A treatment is a variation of the feature that you are including in the experiment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * TreatmentObjectProperty treatmentObjectProperty = TreatmentObjectProperty.builder()
     *         .feature("feature")
     *         .treatmentName("treatmentName")
     *         .variation("variation")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperiment.TreatmentObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(TreatmentObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TreatmentObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the feature for this experiment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-feature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-feature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeature();

        /**
         * A name for this treatment.
         * <p>
         * It can include up to 127 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-treatmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-treatmentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTreatmentName();

        /**
         * The name of the variation to use for this treatment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-variation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-variation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariation();

        /**
         * The description of the treatment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmentobject.html#cfn-evidently-experiment-treatmentobject-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TreatmentObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TreatmentObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TreatmentObjectProperty> {
            java.lang.String feature;
            java.lang.String treatmentName;
            java.lang.String variation;
            java.lang.String description;

            /**
             * Sets the value of {@link TreatmentObjectProperty#getFeature}
             * @param feature The name of the feature for this experiment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder feature(java.lang.String feature) {
                this.feature = feature;
                return this;
            }

            /**
             * Sets the value of {@link TreatmentObjectProperty#getTreatmentName}
             * @param treatmentName A name for this treatment. This parameter is required.
             *                      It can include up to 127 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatmentName(java.lang.String treatmentName) {
                this.treatmentName = treatmentName;
                return this;
            }

            /**
             * Sets the value of {@link TreatmentObjectProperty#getVariation}
             * @param variation The name of the variation to use for this treatment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variation(java.lang.String variation) {
                this.variation = variation;
                return this;
            }

            /**
             * Sets the value of {@link TreatmentObjectProperty#getDescription}
             * @param description The description of the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TreatmentObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TreatmentObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TreatmentObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TreatmentObjectProperty {
            private final java.lang.String feature;
            private final java.lang.String treatmentName;
            private final java.lang.String variation;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.feature = software.amazon.jsii.Kernel.get(this, "feature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.treatmentName = software.amazon.jsii.Kernel.get(this, "treatmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variation = software.amazon.jsii.Kernel.get(this, "variation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.feature = java.util.Objects.requireNonNull(builder.feature, "feature is required");
                this.treatmentName = java.util.Objects.requireNonNull(builder.treatmentName, "treatmentName is required");
                this.variation = java.util.Objects.requireNonNull(builder.variation, "variation is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getFeature() {
                return this.feature;
            }

            @Override
            public final java.lang.String getTreatmentName() {
                return this.treatmentName;
            }

            @Override
            public final java.lang.String getVariation() {
                return this.variation;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("feature", om.valueToTree(this.getFeature()));
                data.set("treatmentName", om.valueToTree(this.getTreatmentName()));
                data.set("variation", om.valueToTree(this.getVariation()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnExperiment.TreatmentObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TreatmentObjectProperty.Jsii$Proxy that = (TreatmentObjectProperty.Jsii$Proxy) o;

                if (!feature.equals(that.feature)) return false;
                if (!treatmentName.equals(that.treatmentName)) return false;
                if (!variation.equals(that.variation)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.feature.hashCode();
                result = 31 * result + (this.treatmentName.hashCode());
                result = 31 * result + (this.variation.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines how much experiment traffic to allocate to one treatment used in the experiment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * TreatmentToWeightProperty treatmentToWeightProperty = TreatmentToWeightProperty.builder()
     *         .splitWeight(123)
     *         .treatment("treatment")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmenttoweight.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmenttoweight.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnExperiment.TreatmentToWeightProperty")
    @software.amazon.jsii.Jsii.Proxy(TreatmentToWeightProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TreatmentToWeightProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The portion of experiment traffic to allocate to this treatment.
         * <p>
         * Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmenttoweight.html#cfn-evidently-experiment-treatmenttoweight-splitweight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmenttoweight.html#cfn-evidently-experiment-treatmenttoweight-splitweight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSplitWeight();

        /**
         * The name of the treatment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmenttoweight.html#cfn-evidently-experiment-treatmenttoweight-treatment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-evidently-experiment-treatmenttoweight.html#cfn-evidently-experiment-treatmenttoweight-treatment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTreatment();

        /**
         * @return a {@link Builder} of {@link TreatmentToWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TreatmentToWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TreatmentToWeightProperty> {
            java.lang.Number splitWeight;
            java.lang.String treatment;

            /**
             * Sets the value of {@link TreatmentToWeightProperty#getSplitWeight}
             * @param splitWeight The portion of experiment traffic to allocate to this treatment. This parameter is required.
             *                    Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitWeight(java.lang.Number splitWeight) {
                this.splitWeight = splitWeight;
                return this;
            }

            /**
             * Sets the value of {@link TreatmentToWeightProperty#getTreatment}
             * @param treatment The name of the treatment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatment(java.lang.String treatment) {
                this.treatment = treatment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TreatmentToWeightProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TreatmentToWeightProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TreatmentToWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TreatmentToWeightProperty {
            private final java.lang.Number splitWeight;
            private final java.lang.String treatment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.splitWeight = software.amazon.jsii.Kernel.get(this, "splitWeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.treatment = software.amazon.jsii.Kernel.get(this, "treatment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.splitWeight = java.util.Objects.requireNonNull(builder.splitWeight, "splitWeight is required");
                this.treatment = java.util.Objects.requireNonNull(builder.treatment, "treatment is required");
            }

            @Override
            public final java.lang.Number getSplitWeight() {
                return this.splitWeight;
            }

            @Override
            public final java.lang.String getTreatment() {
                return this.treatment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("splitWeight", om.valueToTree(this.getSplitWeight()));
                data.set("treatment", om.valueToTree(this.getTreatment()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnExperiment.TreatmentToWeightProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TreatmentToWeightProperty.Jsii$Proxy that = (TreatmentToWeightProperty.Jsii$Proxy) o;

                if (!splitWeight.equals(that.splitWeight)) return false;
                return this.treatment.equals(that.treatment);
            }

            @Override
            public final int hashCode() {
                int result = this.splitWeight.hashCode();
                result = 31 * result + (this.treatment.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.evidently.CfnExperiment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.evidently.CfnExperiment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.evidently.CfnExperimentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.evidently.CfnExperimentProps.Builder();
        }

        /**
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.
         * <p>
         * You can use up to three metrics in an experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-metricgoals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-metricgoals</a>
         * @param metricGoals An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGoals(final software.amazon.awscdk.IResolvable metricGoals) {
            this.props.metricGoals(metricGoals);
            return this;
        }
        /**
         * An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.
         * <p>
         * You can use up to three metrics in an experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-metricgoals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-metricgoals</a>
         * @param metricGoals An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGoals(final java.util.List<? extends java.lang.Object> metricGoals) {
            this.props.metricGoals(metricGoals);
            return this;
        }

        /**
         * A name for the new experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-name</a>
         * @param name A name for the new experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A structure that contains the configuration of which variation to use as the "control" version.
         * <p>
         * The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-onlineabconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-onlineabconfig</a>
         * @param onlineAbConfig A structure that contains the configuration of which variation to use as the "control" version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineAbConfig(final software.amazon.awscdk.IResolvable onlineAbConfig) {
            this.props.onlineAbConfig(onlineAbConfig);
            return this;
        }
        /**
         * A structure that contains the configuration of which variation to use as the "control" version.
         * <p>
         * The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-onlineabconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-onlineabconfig</a>
         * @param onlineAbConfig A structure that contains the configuration of which variation to use as the "control" version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineAbConfig(final software.amazon.awscdk.services.evidently.CfnExperiment.OnlineAbConfigObjectProperty onlineAbConfig) {
            this.props.onlineAbConfig(onlineAbConfig);
            return this;
        }

        /**
         * The name or the ARN of the project where this experiment is to be created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-project">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-project</a>
         * @param project The name or the ARN of the project where this experiment is to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(final java.lang.String project) {
            this.props.project(project);
            return this;
        }

        /**
         * An array of structures that describe the configuration of each feature variation used in the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-treatments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-treatments</a>
         * @param treatments An array of structures that describe the configuration of each feature variation used in the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatments(final software.amazon.awscdk.IResolvable treatments) {
            this.props.treatments(treatments);
            return this;
        }
        /**
         * An array of structures that describe the configuration of each feature variation used in the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-treatments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-treatments</a>
         * @param treatments An array of structures that describe the configuration of each feature variation used in the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatments(final java.util.List<? extends java.lang.Object> treatments) {
            this.props.treatments(treatments);
            return this;
        }

        /**
         * An optional description of the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-description</a>
         * @param description An optional description of the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served.
         * <p>
         * This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the experiment name as the <code>randomizationSalt</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-randomizationsalt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-randomizationsalt</a>
         * @param randomizationSalt When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder randomizationSalt(final java.lang.String randomizationSalt) {
            this.props.randomizationSalt(randomizationSalt);
            return this;
        }

        /**
         * Set this to <code>true</code> to remove the segment that is associated with this experiment.
         * <p>
         * You can't use this parameter if the experiment is currently running.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-removesegment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-removesegment</a>
         * @param removeSegment Set this to <code>true</code> to remove the segment that is associated with this experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeSegment(final java.lang.Boolean removeSegment) {
            this.props.removeSegment(removeSegment);
            return this;
        }
        /**
         * Set this to <code>true</code> to remove the segment that is associated with this experiment.
         * <p>
         * You can't use this parameter if the experiment is currently running.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-removesegment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-removesegment</a>
         * @param removeSegment Set this to <code>true</code> to remove the segment that is associated with this experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeSegment(final software.amazon.awscdk.IResolvable removeSegment) {
            this.props.removeSegment(removeSegment);
            return this;
        }

        /**
         * A structure that you can use to start and stop the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-runningstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-runningstatus</a>
         * @param runningStatus A structure that you can use to start and stop the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runningStatus(final software.amazon.awscdk.IResolvable runningStatus) {
            this.props.runningStatus(runningStatus);
            return this;
        }
        /**
         * A structure that you can use to start and stop the experiment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-runningstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-runningstatus</a>
         * @param runningStatus A structure that you can use to start and stop the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runningStatus(final software.amazon.awscdk.services.evidently.CfnExperiment.RunningStatusObjectProperty runningStatus) {
            this.props.runningStatus(runningStatus);
            return this;
        }

        /**
         * The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent.
         * <p>
         * The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.
         * <p>
         * This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-samplingrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-samplingrate</a>
         * @param samplingRate The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplingRate(final java.lang.Number samplingRate) {
            this.props.samplingRate(samplingRate);
            return this;
        }

        /**
         * Specifies an audience <em>segment</em> to use in the experiment.
         * <p>
         * When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax">Segment rule pattern syntax</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-segment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-segment</a>
         * @param segment Specifies an audience <em>segment</em> to use in the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segment(final java.lang.String segment) {
            this.props.segment(segment);
            return this;
        }

        /**
         * Assigns one or more tags (key-value pairs) to the experiment.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         * <p>
         * You can associate as many as 50 tags with an experiment.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-experiment.html#cfn-evidently-experiment-tags</a>
         * @param tags Assigns one or more tags (key-value pairs) to the experiment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.evidently.CfnExperiment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.evidently.CfnExperiment build() {
            return new software.amazon.awscdk.services.evidently.CfnExperiment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
