package software.amazon.awscdk.services.fms;

/**
 * Properties for defining a <code>CfnPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fms.*;
 * CfnPolicyProps cfnPolicyProps = CfnPolicyProps.builder()
 *         .excludeResourceTags(false)
 *         .policyName("policyName")
 *         .remediationEnabled(false)
 *         .securityServicePolicyData(SecurityServicePolicyDataProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .managedServiceData("managedServiceData")
 *                 .policyOption(PolicyOptionProperty.builder()
 *                         .networkAclCommonPolicy(NetworkAclCommonPolicyProperty.builder()
 *                                 .networkAclEntrySet(NetworkAclEntrySetProperty.builder()
 *                                         .forceRemediateForFirstEntries(false)
 *                                         .forceRemediateForLastEntries(false)
 *                                         // the properties below are optional
 *                                         .firstEntries(List.of(NetworkAclEntryProperty.builder()
 *                                                 .egress(false)
 *                                                 .protocol("protocol")
 *                                                 .ruleAction("ruleAction")
 *                                                 // the properties below are optional
 *                                                 .cidrBlock("cidrBlock")
 *                                                 .icmpTypeCode(IcmpTypeCodeProperty.builder()
 *                                                         .code(123)
 *                                                         .type(123)
 *                                                         .build())
 *                                                 .ipv6CidrBlock("ipv6CidrBlock")
 *                                                 .portRange(PortRangeProperty.builder()
 *                                                         .from(123)
 *                                                         .to(123)
 *                                                         .build())
 *                                                 .build()))
 *                                         .lastEntries(List.of(NetworkAclEntryProperty.builder()
 *                                                 .egress(false)
 *                                                 .protocol("protocol")
 *                                                 .ruleAction("ruleAction")
 *                                                 // the properties below are optional
 *                                                 .cidrBlock("cidrBlock")
 *                                                 .icmpTypeCode(IcmpTypeCodeProperty.builder()
 *                                                         .code(123)
 *                                                         .type(123)
 *                                                         .build())
 *                                                 .ipv6CidrBlock("ipv6CidrBlock")
 *                                                 .portRange(PortRangeProperty.builder()
 *                                                         .from(123)
 *                                                         .to(123)
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .networkFirewallPolicy(NetworkFirewallPolicyProperty.builder()
 *                                 .firewallDeploymentModel("firewallDeploymentModel")
 *                                 .build())
 *                         .thirdPartyFirewallPolicy(ThirdPartyFirewallPolicyProperty.builder()
 *                                 .firewallDeploymentModel("firewallDeploymentModel")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .deleteAllPolicyResources(false)
 *         .excludeMap(Map.of(
 *                 "account", List.of("account"),
 *                 "orgunit", List.of("orgunit")))
 *         .includeMap(Map.of(
 *                 "account", List.of("account"),
 *                 "orgunit", List.of("orgunit")))
 *         .policyDescription("policyDescription")
 *         .resourcesCleanUp(false)
 *         .resourceSetIds(List.of("resourceSetIds"))
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .resourceType("resourceType")
 *         .resourceTypeList(List.of("resourceTypeList"))
 *         .tags(List.of(PolicyTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-12-06T14:43:19.486Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Used only when tags are specified in the <code>ResourceTags</code> property.
     * <p>
     * If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excluderesourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excluderesourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getExcludeResourceTags();

    /**
     * The name of the AWS Firewall Manager policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-policyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-policyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

    /**
     * Indicates if the policy should be automatically applied to new resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-remediationenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-remediationenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRemediationEnabled();

    /**
     * Details about the security service that is being used to protect the resources.
     * <p>
     * This contains the following settings:
     * <p>
     * <ul>
     * <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
     * </ul>
     * <p>
     * Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>THIRD_PARTY_FIREWALL</code> | <code>WAFV2</code> | <code>WAF</code>
     * <p>
     * <ul>
     * <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
     * <li>Example: <code>DNS_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code>
     * <p>
     * <blockquote>
     * <p>
     * Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code> - Centralized deployment model</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}},\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"</code>
     * <p>
     * To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"OFF\"},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"</code>
     * <p>
     * With automatic Availbility Zone configuration, Firewall Manager chooses which Availability Zones to create the endpoints in. To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration and route management</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"]},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\": \"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"</code>
     * <p>
     * To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\", \"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{ \"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[ \"10.0.0.0/28\"]}]} },\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"OFF\",\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"</code>
     * <p>
     * With custom Availability Zone configuration, you define which specific Availability Zones to create endpoints in by configuring <code>firewallCreationConfig</code> . To configure the Availability Zones in <code>firewallCreationConfig</code> , specify either the <code>availabilityZoneName</code> or <code>availabilityZoneId</code> parameter, not both parameters.
     * <p>
     * To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration and route management</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"],\"routeManagementConfig\":{\"allowCrossAZTrafficIfNoEndpoint\":true}},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"</code>
     * <p>
     * To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
     * <p>
     * <ul>
     * <li>Example: <code>THIRD_PARTY_FIREWALL</code> - Palo Alto Networks Cloud Next-Generation Firewall centralized deployment model</li>
     * </ul>
     * <p>
     * <code>"{ \"type\":\"THIRD_PARTY_FIREWALL\", \"thirdPartyFirewall\":\"PALO_ALTO_NETWORKS_CLOUD_NGFW\", \"thirdPartyFirewallConfig\":{ \"thirdPartyFirewallPolicyList\":[\"global-1\"] },\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"</code>
     * <p>
     * To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-thirdpartyfirewallpolicy.html">FirewallDeploymentModel</a> to <code>CENTRALIZED</code> .
     * <p>
     * <ul>
     * <li>Example: <code>THIRD_PARTY_FIREWALL</code> - Palo Alto Networks Cloud Next-Generation Firewall distributed deployment model</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"THIRD_PARTY_FIREWALL\",\"thirdPartyFirewall\":\"PALO_ALTO_NETWORKS_CLOUD_NGFW\",\"thirdPartyFirewallConfig\":{\"thirdPartyFirewallPolicyList\":[\"global-1\"] },\"firewallDeploymentModel\":{ \"distributedFirewallDeploymentModel\":{ \"distributedFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{ \"availabilityZoneConfigList\":[ {\"availabilityZoneName\":\"${AvailabilityZone}\" } ] } }, \"allowedIPV4CidrList\":[ ] } } } }"</code>
     * <p>
     * To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-thirdpartyfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
     * <p>
     * <ul>
     * <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
     * <p>
     * For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
     * <p>
     * The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
     * <p>
     * For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
     * <p>
     * <ul>
     * <li>Example: <code>WAFV2</code></li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
     * <p>
     * In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
     * <p>
     * <ul>
     * <li>Example: <code>AWS WAF Classic</code></li>
     * </ul>
     * <p>
     * <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>WAFV2</code> - AWS Firewall Manager support for AWS WAF managed rule group versioning</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":true,\"version\":\"Version_2.0\",\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesCommonRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
     * <p>
     * To use a specific version of a AWS WAF managed rule group in your Firewall Manager policy, you must set <code>versionEnabled</code> to <code>true</code> , and set <code>version</code> to the version you'd like to use. If you don't set <code>versionEnabled</code> to <code>true</code> , or if you omit <code>versionEnabled</code> , then Firewall Manager uses the default version of the AWS WAF managed rule group.
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code>
     * <p>
     * <ul>
     * <li>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns</li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code>
     * <p>
     * The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-securityservicepolicydata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-securityservicepolicydata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSecurityServicePolicyData();

    /**
     * Used when deleting a policy. If <code>true</code> , Firewall Manager performs cleanup according to the policy type.
     * <p>
     * For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
     * <p>
     * <ul>
     * <li>Deletes rule groups created by Firewall Manager</li>
     * <li>Removes web ACLs from in-scope resources</li>
     * <li>Deletes web ACLs that contain no rules or rule groups</li>
     * </ul>
     * <p>
     * For security group policies, Firewall Manager does the following for each security group in the policy:
     * <p>
     * <ul>
     * <li>Disassociates the security group from in-scope resources</li>
     * <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
     * </ul>
     * <p>
     * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-deleteallpolicyresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-deleteallpolicyresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAllPolicyResources() {
        return null;
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excludemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excludemap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeMap() {
        return null;
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-includemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-includemap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeMap() {
        return null;
    }

    /**
     * Your description of the AWS Firewall Manager policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-policydescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-policydescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyDescription() {
        return null;
    }

    /**
     * Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
     * <p>
     * For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
     * <p>
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     * <p>
     * This option is not available for Shield Advanced or AWS WAF Classic policies.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcescleanup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcescleanup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourcesCleanUp() {
        return null;
    }

    /**
     * The unique identifiers of the resource sets used by the policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcesetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcesetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceSetIds() {
        return null;
    }

    /**
     * An array of <code>ResourceTag</code> objects, used to explicitly include resources in the policy scope or explicitly exclude them.
     * <p>
     * If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return null;
    }

    /**
     * The type of resource protected by or in scope of the policy.
     * <p>
     * This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS Resource Types Reference</a> . To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code> .
     * <p>
     * The following are valid resource types for each Firewall Manager policy type:
     * <p>
     * <ul>
     * <li>AWS WAF Classic - <code>AWS::ApiGateway::Stage</code> , <code>AWS::CloudFront::Distribution</code> , and <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> .</li>
     * <li>AWS WAF - <code>AWS::ApiGateway::Stage</code> , <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> , and <code>AWS::CloudFront::Distribution</code> .</li>
     * <li>Shield Advanced - <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> , <code>AWS::ElasticLoadBalancing::LoadBalancer</code> , <code>AWS::EC2::EIP</code> , and <code>AWS::CloudFront::Distribution</code> .</li>
     * <li>Network ACL - <code>AWS::EC2::Subnet</code> .</li>
     * <li>Security group usage audit - <code>AWS::EC2::SecurityGroup</code> .</li>
     * <li>Security group content audit - <code>AWS::EC2::SecurityGroup</code> , <code>AWS::EC2::NetworkInterface</code> , and <code>AWS::EC2::Instance</code> .</li>
     * <li>DNS Firewall, AWS Network Firewall , and third-party firewall - <code>AWS::EC2::VPC</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * An array of <code>ResourceType</code> objects.
     * <p>
     * Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetypelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetypelist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypeList() {
        return null;
    }

    /**
     * A collection of key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPolicyProps> {
        java.lang.Object excludeResourceTags;
        java.lang.String policyName;
        java.lang.Object remediationEnabled;
        java.lang.Object securityServicePolicyData;
        java.lang.Object deleteAllPolicyResources;
        java.lang.Object excludeMap;
        java.lang.Object includeMap;
        java.lang.String policyDescription;
        java.lang.Object resourcesCleanUp;
        java.util.List<java.lang.String> resourceSetIds;
        java.lang.Object resourceTags;
        java.lang.String resourceType;
        java.util.List<java.lang.String> resourceTypeList;
        java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> tags;

        /**
         * Sets the value of {@link CfnPolicyProps#getExcludeResourceTags}
         * @param excludeResourceTags Used only when tags are specified in the <code>ResourceTags</code> property. This parameter is required.
         *                            If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTags(java.lang.Boolean excludeResourceTags) {
            this.excludeResourceTags = excludeResourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getExcludeResourceTags}
         * @param excludeResourceTags Used only when tags are specified in the <code>ResourceTags</code> property. This parameter is required.
         *                            If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTags(software.amazon.awscdk.IResolvable excludeResourceTags) {
            this.excludeResourceTags = excludeResourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getPolicyName}
         * @param policyName The name of the AWS Firewall Manager policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getRemediationEnabled}
         * @param remediationEnabled Indicates if the policy should be automatically applied to new resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remediationEnabled(java.lang.Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getRemediationEnabled}
         * @param remediationEnabled Indicates if the policy should be automatically applied to new resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remediationEnabled(software.amazon.awscdk.IResolvable remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getSecurityServicePolicyData}
         * @param securityServicePolicyData Details about the security service that is being used to protect the resources. This parameter is required.
         *                                  This contains the following settings:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
         *                                  </ul>
         *                                  <p>
         *                                  Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>THIRD_PARTY_FIREWALL</code> | <code>WAFV2</code> | <code>WAF</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
         *                                  <li>Example: <code>DNS_FIREWALL</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code>
         *                                  <p>
         *                                  <blockquote>
         *                                  <p>
         *                                  Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.
         *                                  <p>
         *                                  </blockquote>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Centralized deployment model</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}},\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"OFF\"},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"</code>
         *                                  <p>
         *                                  With automatic Availbility Zone configuration, Firewall Manager chooses which Availability Zones to create the endpoints in. To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration and route management</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"]},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\": \"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\", \"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{ \"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[ \"10.0.0.0/28\"]}]} },\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"OFF\",\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"</code>
         *                                  <p>
         *                                  With custom Availability Zone configuration, you define which specific Availability Zones to create endpoints in by configuring <code>firewallCreationConfig</code> . To configure the Availability Zones in <code>firewallCreationConfig</code> , specify either the <code>availabilityZoneName</code> or <code>availabilityZoneId</code> parameter, not both parameters.
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration and route management</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"],\"routeManagementConfig\":{\"allowCrossAZTrafficIfNoEndpoint\":true}},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>THIRD_PARTY_FIREWALL</code> - Palo Alto Networks Cloud Next-Generation Firewall centralized deployment model</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{ \"type\":\"THIRD_PARTY_FIREWALL\", \"thirdPartyFirewall\":\"PALO_ALTO_NETWORKS_CLOUD_NGFW\", \"thirdPartyFirewallConfig\":{ \"thirdPartyFirewallPolicyList\":[\"global-1\"] },\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-thirdpartyfirewallpolicy.html">FirewallDeploymentModel</a> to <code>CENTRALIZED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>THIRD_PARTY_FIREWALL</code> - Palo Alto Networks Cloud Next-Generation Firewall distributed deployment model</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"THIRD_PARTY_FIREWALL\",\"thirdPartyFirewall\":\"PALO_ALTO_NETWORKS_CLOUD_NGFW\",\"thirdPartyFirewallConfig\":{\"thirdPartyFirewallPolicyList\":[\"global-1\"] },\"firewallDeploymentModel\":{ \"distributedFirewallDeploymentModel\":{ \"distributedFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{ \"availabilityZoneConfigList\":[ {\"availabilityZoneName\":\"${AvailabilityZone}\" } ] } }, \"allowedIPV4CidrList\":[ ] } } } }"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-thirdpartyfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
         *                                  <p>
         *                                  For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
         *                                  <p>
         *                                  The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
         *                                  <p>
         *                                  For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>WAFV2</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
         *                                  <p>
         *                                  In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>AWS WAF Classic</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>WAFV2</code> - AWS Firewall Manager support for AWS WAF managed rule group versioning</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":true,\"version\":\"Version_2.0\",\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesCommonRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
         *                                  <p>
         *                                  To use a specific version of a AWS WAF managed rule group in your Firewall Manager policy, you must set <code>versionEnabled</code> to <code>true</code> , and set <code>version</code> to the version you'd like to use. If you don't set <code>versionEnabled</code> to <code>true</code> , or if you omit <code>versionEnabled</code> , then Firewall Manager uses the default version of the AWS WAF managed rule group.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code>
         *                                  <p>
         *                                  The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityServicePolicyData(software.amazon.awscdk.IResolvable securityServicePolicyData) {
            this.securityServicePolicyData = securityServicePolicyData;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getSecurityServicePolicyData}
         * @param securityServicePolicyData Details about the security service that is being used to protect the resources. This parameter is required.
         *                                  This contains the following settings:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
         *                                  </ul>
         *                                  <p>
         *                                  Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>THIRD_PARTY_FIREWALL</code> | <code>WAFV2</code> | <code>WAF</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
         *                                  <li>Example: <code>DNS_FIREWALL</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"DNS_FIREWALL\",\"preProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-1\",\"priority\":10}],\"postProcessRuleGroups\":[{\"ruleGroupId\":\"rslvr-frg-2\",\"priority\":9911}]}"</code>
         *                                  <p>
         *                                  <blockquote>
         *                                  <p>
         *                                  Valid values for <code>preProcessRuleGroups</code> are between 1 and 99. Valid values for <code>postProcessRuleGroups</code> are between 9901 and 10000.
         *                                  <p>
         *                                  </blockquote>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Centralized deployment model</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"awsNetworkFirewallConfig\":{\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}},\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"OFF\"},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"</code>
         *                                  <p>
         *                                  With automatic Availbility Zone configuration, Firewall Manager chooses which Availability Zones to create the endpoints in. To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with automatic Availability Zone configuration and route management</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[\"10.0.0.0/28\",\"192.168.0.0/28\"],\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"]},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\": \"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":true}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\", \"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{ \"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[ \"10.0.0.0/28\"]}]} },\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"OFF\",\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"</code>
         *                                  <p>
         *                                  With custom Availability Zone configuration, you define which specific Availability Zones to create endpoints in by configuring <code>firewallCreationConfig</code> . To configure the Availability Zones in <code>firewallCreationConfig</code> , specify either the <code>availabilityZoneName</code> or <code>availabilityZoneId</code> parameter, not both parameters.
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>NETWORK_FIREWALL</code> - Distributed deployment model with custom Availability Zone configuration and route management</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateless-rulegroup/test\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:forward_to_sfe\",\"customActionName\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:forward_to_sfe\",\"fragmentcustomactionname\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"customActionName\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"metricdimensionvalue\"}]}}},{\"actionName\":\"fragmentcustomactionname\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"fragmentmetricdimensionvalue\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:123456789011:stateful-rulegroup/test\"}],\"networkFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]},{\"availabilityZoneName\":\"us-east-1b\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":null,\"routeManagementAction\":\"MONITOR\",\"routeManagementTargetTypes\":[\"InternetGateway\"],\"routeManagementConfig\":{\"allowCrossAZTrafficIfNoEndpoint\":true}},\"networkFirewallLoggingConfiguration\":{\"logDestinationConfigs\":[{\"logDestinationType\":\"S3\",\"logType\":\"ALERT\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}},{\"logDestinationType\":\"S3\",\"logType\":\"FLOW\",\"logDestination\":{\"bucketName\":\"s3-bucket-name\"}}],\"overrideExistingConfig\":boolean}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-networkfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>THIRD_PARTY_FIREWALL</code> - Palo Alto Networks Cloud Next-Generation Firewall centralized deployment model</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{ \"type\":\"THIRD_PARTY_FIREWALL\", \"thirdPartyFirewall\":\"PALO_ALTO_NETWORKS_CLOUD_NGFW\", \"thirdPartyFirewallConfig\":{ \"thirdPartyFirewallPolicyList\":[\"global-1\"] },\"firewallDeploymentModel\":{\"centralizedFirewallDeploymentModel\":{\"centralizedFirewallOrchestrationConfig\":{\"inspectionVpcIds\":[{\"resourceId\":\"vpc-1234\",\"accountId\":\"123456789011\"}],\"firewallCreationConfig\":{\"endpointLocation\":{\"availabilityZoneConfigList\":[{\"availabilityZoneId\":null,\"availabilityZoneName\":\"us-east-1a\",\"allowedIPV4CidrList\":[\"10.0.0.0/28\"]}]}},\"allowedIPV4CidrList\":[]}}}}"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-thirdpartyfirewallpolicy.html">FirewallDeploymentModel</a> to <code>CENTRALIZED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>THIRD_PARTY_FIREWALL</code> - Palo Alto Networks Cloud Next-Generation Firewall distributed deployment model</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"THIRD_PARTY_FIREWALL\",\"thirdPartyFirewall\":\"PALO_ALTO_NETWORKS_CLOUD_NGFW\",\"thirdPartyFirewallConfig\":{\"thirdPartyFirewallPolicyList\":[\"global-1\"] },\"firewallDeploymentModel\":{ \"distributedFirewallDeploymentModel\":{ \"distributedFirewallOrchestrationConfig\":{\"firewallCreationConfig\":{\"endpointLocation\":{ \"availabilityZoneConfigList\":[ {\"availabilityZoneName\":\"${AvailabilityZone}\" } ] } }, \"allowedIPV4CidrList\":[ ] } } } }"</code>
         *                                  <p>
         *                                  To use the distributed deployment model, you must set <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-thirdpartyfirewallpolicy.html">FirewallDeploymentModel</a> to <code>DISTRIBUTED</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
         *                                  <p>
         *                                  For example: <code>"{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
         *                                  <p>
         *                                  The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
         *                                  <p>
         *                                  For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>WAFV2</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
         *                                  <p>
         *                                  In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>AWS WAF Classic</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}"</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>WAFV2</code> - AWS Firewall Manager support for AWS WAF managed rule group versioning</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"versionEnabled\":true,\"version\":\"Version_2.0\",\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesCommonRuleSet\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[{\"name\":\"NoUserAgent_HEADER\"}]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
         *                                  <p>
         *                                  To use a specific version of a AWS WAF managed rule group in your Firewall Manager policy, you must set <code>versionEnabled</code> to <code>true</code> , and set <code>version</code> to the version you'd like to use. If you don't set <code>versionEnabled</code> to <code>true</code> , or if you omit <code>versionEnabled</code> , then Firewall Manager uses the default version of the AWS WAF managed rule group.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: Shared VPCs. Apply the preceding policy to resources in shared VPCs as well as to those in VPCs that the account owns</li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false, \"applyToAllEC2InstanceENIs\":false,\"includeSharedVPC\":true,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"</code>
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\"sg-000e55995d61a06bd\"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"</code>
         *                                  <p>
         *                                  The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
         *                                  </ul>
         *                                  <p>
         *                                  <code>"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityServicePolicyData(software.amazon.awscdk.services.fms.CfnPolicy.SecurityServicePolicyDataProperty securityServicePolicyData) {
            this.securityServicePolicyData = securityServicePolicyData;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getDeleteAllPolicyResources}
         * @param deleteAllPolicyResources Used when deleting a policy. If <code>true</code> , Firewall Manager performs cleanup according to the policy type.
         *                                 For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Deletes rule groups created by Firewall Manager</li>
         *                                 <li>Removes web ACLs from in-scope resources</li>
         *                                 <li>Deletes web ACLs that contain no rules or rule groups</li>
         *                                 </ul>
         *                                 <p>
         *                                 For security group policies, Firewall Manager does the following for each security group in the policy:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Disassociates the security group from in-scope resources</li>
         *                                 <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
         *                                 </ul>
         *                                 <p>
         *                                 After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAllPolicyResources(java.lang.Boolean deleteAllPolicyResources) {
            this.deleteAllPolicyResources = deleteAllPolicyResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getDeleteAllPolicyResources}
         * @param deleteAllPolicyResources Used when deleting a policy. If <code>true</code> , Firewall Manager performs cleanup according to the policy type.
         *                                 For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Deletes rule groups created by Firewall Manager</li>
         *                                 <li>Removes web ACLs from in-scope resources</li>
         *                                 <li>Deletes web ACLs that contain no rules or rule groups</li>
         *                                 </ul>
         *                                 <p>
         *                                 For security group policies, Firewall Manager does the following for each security group in the policy:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Disassociates the security group from in-scope resources</li>
         *                                 <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
         *                                 </ul>
         *                                 <p>
         *                                 After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAllPolicyResources(software.amazon.awscdk.IResolvable deleteAllPolicyResources) {
            this.deleteAllPolicyResources = deleteAllPolicyResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getExcludeMap}
         * @param excludeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
         *                   Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         *                   <p>
         *                   You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         *                   <p>
         *                   You can specify account IDs, OUs, or a combination:
         *                   <p>
         *                   <ul>
         *                   <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         *                   <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeMap(software.amazon.awscdk.IResolvable excludeMap) {
            this.excludeMap = excludeMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getExcludeMap}
         * @param excludeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
         *                   Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         *                   <p>
         *                   You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         *                   <p>
         *                   You can specify account IDs, OUs, or a combination:
         *                   <p>
         *                   <ul>
         *                   <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         *                   <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeMap(software.amazon.awscdk.services.fms.CfnPolicy.IEMapProperty excludeMap) {
            this.excludeMap = excludeMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getIncludeMap}
         * @param includeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
         *                   Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         *                   <p>
         *                   You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         *                   <p>
         *                   You can specify account IDs, OUs, or a combination:
         *                   <p>
         *                   <ul>
         *                   <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         *                   <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeMap(software.amazon.awscdk.IResolvable includeMap) {
            this.includeMap = includeMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getIncludeMap}
         * @param includeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
         *                   Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         *                   <p>
         *                   You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         *                   <p>
         *                   You can specify account IDs, OUs, or a combination:
         *                   <p>
         *                   <ul>
         *                   <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         *                   <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeMap(software.amazon.awscdk.services.fms.CfnPolicy.IEMapProperty includeMap) {
            this.includeMap = includeMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getPolicyDescription}
         * @param policyDescription Your description of the AWS Firewall Manager policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDescription(java.lang.String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourcesCleanUp}
         * @param resourcesCleanUp Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
         *                         For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         *                         <p>
         *                         By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         *                         <p>
         *                         This option is not available for Shield Advanced or AWS WAF Classic policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesCleanUp(java.lang.Boolean resourcesCleanUp) {
            this.resourcesCleanUp = resourcesCleanUp;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourcesCleanUp}
         * @param resourcesCleanUp Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
         *                         For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         *                         <p>
         *                         By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         *                         <p>
         *                         This option is not available for Shield Advanced or AWS WAF Classic policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesCleanUp(software.amazon.awscdk.IResolvable resourcesCleanUp) {
            this.resourcesCleanUp = resourcesCleanUp;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourceSetIds}
         * @param resourceSetIds The unique identifiers of the resource sets used by the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSetIds(java.util.List<java.lang.String> resourceSetIds) {
            this.resourceSetIds = resourceSetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourceTags}
         * @param resourceTags An array of <code>ResourceTag</code> objects, used to explicitly include resources in the policy scope or explicitly exclude them.
         *                     If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourceTags}
         * @param resourceTags An array of <code>ResourceTag</code> objects, used to explicitly include resources in the policy scope or explicitly exclude them.
         *                     If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourceType}
         * @param resourceType The type of resource protected by or in scope of the policy.
         *                     This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS Resource Types Reference</a> . To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code> .
         *                     <p>
         *                     The following are valid resource types for each Firewall Manager policy type:
         *                     <p>
         *                     <ul>
         *                     <li>AWS WAF Classic - <code>AWS::ApiGateway::Stage</code> , <code>AWS::CloudFront::Distribution</code> , and <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> .</li>
         *                     <li>AWS WAF - <code>AWS::ApiGateway::Stage</code> , <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> , and <code>AWS::CloudFront::Distribution</code> .</li>
         *                     <li>Shield Advanced - <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> , <code>AWS::ElasticLoadBalancing::LoadBalancer</code> , <code>AWS::EC2::EIP</code> , and <code>AWS::CloudFront::Distribution</code> .</li>
         *                     <li>Network ACL - <code>AWS::EC2::Subnet</code> .</li>
         *                     <li>Security group usage audit - <code>AWS::EC2::SecurityGroup</code> .</li>
         *                     <li>Security group content audit - <code>AWS::EC2::SecurityGroup</code> , <code>AWS::EC2::NetworkInterface</code> , and <code>AWS::EC2::Instance</code> .</li>
         *                     <li>DNS Firewall, AWS Network Firewall , and third-party firewall - <code>AWS::EC2::VPC</code> .</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getResourceTypeList}
         * @param resourceTypeList An array of <code>ResourceType</code> objects.
         *                         Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTypeList(java.util.List<java.lang.String> resourceTypeList) {
            this.resourceTypeList = resourceTypeList;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyProps#getTags}
         * @param tags A collection of key:value pairs associated with an AWS resource.
         *             The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPolicyProps {
        private final java.lang.Object excludeResourceTags;
        private final java.lang.String policyName;
        private final java.lang.Object remediationEnabled;
        private final java.lang.Object securityServicePolicyData;
        private final java.lang.Object deleteAllPolicyResources;
        private final java.lang.Object excludeMap;
        private final java.lang.Object includeMap;
        private final java.lang.String policyDescription;
        private final java.lang.Object resourcesCleanUp;
        private final java.util.List<java.lang.String> resourceSetIds;
        private final java.lang.Object resourceTags;
        private final java.lang.String resourceType;
        private final java.util.List<java.lang.String> resourceTypeList;
        private final java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.excludeResourceTags = software.amazon.jsii.Kernel.get(this, "excludeResourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.remediationEnabled = software.amazon.jsii.Kernel.get(this, "remediationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityServicePolicyData = software.amazon.jsii.Kernel.get(this, "securityServicePolicyData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deleteAllPolicyResources = software.amazon.jsii.Kernel.get(this, "deleteAllPolicyResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.excludeMap = software.amazon.jsii.Kernel.get(this, "excludeMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includeMap = software.amazon.jsii.Kernel.get(this, "includeMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyDescription = software.amazon.jsii.Kernel.get(this, "policyDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourcesCleanUp = software.amazon.jsii.Kernel.get(this, "resourcesCleanUp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceSetIds = software.amazon.jsii.Kernel.get(this, "resourceSetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceTypeList = software.amazon.jsii.Kernel.get(this, "resourceTypeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.excludeResourceTags = java.util.Objects.requireNonNull(builder.excludeResourceTags, "excludeResourceTags is required");
            this.policyName = java.util.Objects.requireNonNull(builder.policyName, "policyName is required");
            this.remediationEnabled = java.util.Objects.requireNonNull(builder.remediationEnabled, "remediationEnabled is required");
            this.securityServicePolicyData = java.util.Objects.requireNonNull(builder.securityServicePolicyData, "securityServicePolicyData is required");
            this.deleteAllPolicyResources = builder.deleteAllPolicyResources;
            this.excludeMap = builder.excludeMap;
            this.includeMap = builder.includeMap;
            this.policyDescription = builder.policyDescription;
            this.resourcesCleanUp = builder.resourcesCleanUp;
            this.resourceSetIds = builder.resourceSetIds;
            this.resourceTags = builder.resourceTags;
            this.resourceType = builder.resourceType;
            this.resourceTypeList = builder.resourceTypeList;
            this.tags = (java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty>)builder.tags;
        }

        @Override
        public final java.lang.Object getExcludeResourceTags() {
            return this.excludeResourceTags;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final java.lang.Object getRemediationEnabled() {
            return this.remediationEnabled;
        }

        @Override
        public final java.lang.Object getSecurityServicePolicyData() {
            return this.securityServicePolicyData;
        }

        @Override
        public final java.lang.Object getDeleteAllPolicyResources() {
            return this.deleteAllPolicyResources;
        }

        @Override
        public final java.lang.Object getExcludeMap() {
            return this.excludeMap;
        }

        @Override
        public final java.lang.Object getIncludeMap() {
            return this.includeMap;
        }

        @Override
        public final java.lang.String getPolicyDescription() {
            return this.policyDescription;
        }

        @Override
        public final java.lang.Object getResourcesCleanUp() {
            return this.resourcesCleanUp;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceSetIds() {
            return this.resourceSetIds;
        }

        @Override
        public final java.lang.Object getResourceTags() {
            return this.resourceTags;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceTypeList() {
            return this.resourceTypeList;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("excludeResourceTags", om.valueToTree(this.getExcludeResourceTags()));
            data.set("policyName", om.valueToTree(this.getPolicyName()));
            data.set("remediationEnabled", om.valueToTree(this.getRemediationEnabled()));
            data.set("securityServicePolicyData", om.valueToTree(this.getSecurityServicePolicyData()));
            if (this.getDeleteAllPolicyResources() != null) {
                data.set("deleteAllPolicyResources", om.valueToTree(this.getDeleteAllPolicyResources()));
            }
            if (this.getExcludeMap() != null) {
                data.set("excludeMap", om.valueToTree(this.getExcludeMap()));
            }
            if (this.getIncludeMap() != null) {
                data.set("includeMap", om.valueToTree(this.getIncludeMap()));
            }
            if (this.getPolicyDescription() != null) {
                data.set("policyDescription", om.valueToTree(this.getPolicyDescription()));
            }
            if (this.getResourcesCleanUp() != null) {
                data.set("resourcesCleanUp", om.valueToTree(this.getResourcesCleanUp()));
            }
            if (this.getResourceSetIds() != null) {
                data.set("resourceSetIds", om.valueToTree(this.getResourceSetIds()));
            }
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }
            if (this.getResourceTypeList() != null) {
                data.set("resourceTypeList", om.valueToTree(this.getResourceTypeList()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPolicyProps.Jsii$Proxy that = (CfnPolicyProps.Jsii$Proxy) o;

            if (!excludeResourceTags.equals(that.excludeResourceTags)) return false;
            if (!policyName.equals(that.policyName)) return false;
            if (!remediationEnabled.equals(that.remediationEnabled)) return false;
            if (!securityServicePolicyData.equals(that.securityServicePolicyData)) return false;
            if (this.deleteAllPolicyResources != null ? !this.deleteAllPolicyResources.equals(that.deleteAllPolicyResources) : that.deleteAllPolicyResources != null) return false;
            if (this.excludeMap != null ? !this.excludeMap.equals(that.excludeMap) : that.excludeMap != null) return false;
            if (this.includeMap != null ? !this.includeMap.equals(that.includeMap) : that.includeMap != null) return false;
            if (this.policyDescription != null ? !this.policyDescription.equals(that.policyDescription) : that.policyDescription != null) return false;
            if (this.resourcesCleanUp != null ? !this.resourcesCleanUp.equals(that.resourcesCleanUp) : that.resourcesCleanUp != null) return false;
            if (this.resourceSetIds != null ? !this.resourceSetIds.equals(that.resourceSetIds) : that.resourceSetIds != null) return false;
            if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) return false;
            if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
            if (this.resourceTypeList != null ? !this.resourceTypeList.equals(that.resourceTypeList) : that.resourceTypeList != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.excludeResourceTags.hashCode();
            result = 31 * result + (this.policyName.hashCode());
            result = 31 * result + (this.remediationEnabled.hashCode());
            result = 31 * result + (this.securityServicePolicyData.hashCode());
            result = 31 * result + (this.deleteAllPolicyResources != null ? this.deleteAllPolicyResources.hashCode() : 0);
            result = 31 * result + (this.excludeMap != null ? this.excludeMap.hashCode() : 0);
            result = 31 * result + (this.includeMap != null ? this.includeMap.hashCode() : 0);
            result = 31 * result + (this.policyDescription != null ? this.policyDescription.hashCode() : 0);
            result = 31 * result + (this.resourcesCleanUp != null ? this.resourcesCleanUp.hashCode() : 0);
            result = 31 * result + (this.resourceSetIds != null ? this.resourceSetIds.hashCode() : 0);
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            result = 31 * result + (this.resourceTypeList != null ? this.resourceTypeList.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
